/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Worker
extends Thread {
    private final LinkedBlockingQueue<Runnable> jobList = new LinkedBlockingQueue();
    private volatile boolean stopRunning = false;
    private static final Logger logger = Logger.getLogger(Worker.class.getName());

    public Worker() {
        super("FreeColClient:Worker");
    }

    public void run() {
        while (!this.stopRunning) {
            try {
                Runnable job = this.jobList.take();
                try {
                    job.run();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Worker task failed!", e);
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Worker interrupted, aborting!");
            }
        }
    }

    public void schedule(Runnable job) {
        this.jobList.add(job);
    }

    public void askToStop() {
        this.stopRunning = true;
        this.interrupt();
    }
}

