/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.Worker;
import net.sf.freecol.client.control.ConnectController;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InGameInputHandler;
import net.sf.freecol.client.control.MapEditorController;
import net.sf.freecol.client.control.PreGameController;
import net.sf.freecol.client.control.PreGameInputHandler;
import net.sf.freecol.client.gui.Canvas;
import net.sf.freecol.client.gui.FreeColMenuBar;
import net.sf.freecol.client.gui.FullScreenFrame;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.WindowedFrame;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.i18n.Messages;
import net.sf.freecol.client.gui.plaf.FreeColLookAndFeel;
import net.sf.freecol.client.gui.sound.SoundPlayer;
import net.sf.freecol.client.networking.Client;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.io.FreeColTcFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.LanguageOption;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.ResourceMapping;
import net.sf.freecol.server.FreeColServer;
import org.w3c.dom.Element;

public final class FreeColClient {
    private static final Logger logger = Logger.getLogger(FreeColClient.class.getName());
    private static FreeColClient instance;
    private static final int DEFAULT_WINDOW_SPACE = 100;
    private ConnectController connectController;
    private PreGameController preGameController;
    private PreGameInputHandler preGameInputHandler;
    private InGameController inGameController;
    private InGameInputHandler inGameInputHandler;
    private MapEditorController mapEditorController;
    private GraphicsDevice gd;
    private JFrame frame;
    private Canvas canvas;
    private GUI gui;
    private ImageLibrary imageLibrary;
    private SoundPlayer soundPlayer;
    private Client client;
    private Game game;
    private Player player;
    private boolean isRetired = false;
    private boolean inGame = false;
    private FreeColServer freeColServer = null;
    private boolean windowed;
    private boolean mapEditor;
    private boolean singleplayer;
    private final ActionManager actionManager;
    private ClientOptions clientOptions;
    public final Worker worker;
    private boolean loggedIn = false;
    private Rectangle windowBounds;
    private boolean headless = "true".equals(System.getProperty("java.awt.headless", "false"));

    public static FreeColClient get() {
        return instance;
    }

    public FreeColClient(final File savegameFile, Dimension size, final boolean sound, String splashFilename, final boolean showOpeningVideo, String fontName) {
        File baseDirectory = new File(FreeCol.getDataDirectory(), "base");
        if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
            System.err.println("Could not find base data directory: " + baseDirectory.getName());
            System.exit(1);
        }
        JWindow splash = null;
        if (splashFilename != null) {
            splash = FreeColClient.displaySplash(splashFilename);
        }
        FreeColDataFile baseData = new FreeColDataFile(baseDirectory);
        ResourceManager.setBaseMapping(baseData.getResourceMapping());
        FreeColTcFile tcData = new FreeColTcFile("classic");
        ResourceManager.setTcMapping(tcData.getResourceMapping());
        this.imageLibrary = new ImageLibrary();
        boolean bl = this.windowed = size != null;
        if (size != null && size.width < 0) {
            Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            size = new Dimension(bounds.width - 100, bounds.height - 100);
        }
        final Dimension windowSize = size;
        logger.info("Window size is " + windowSize);
        Font font = null;
        if (fontName != null && (font = Font.decode(fontName)) == null) {
            System.err.println("Font not found: " + fontName);
        }
        if (font == null) {
            font = ResourceManager.getFont("NormalFont");
        }
        try {
            FreeColLookAndFeel fclaf = new FreeColLookAndFeel(FreeCol.getDataDirectory(), windowSize);
            try {
                FreeColLookAndFeel.install(fclaf, font);
            }
            catch (FreeColException e) {
                e.printStackTrace();
                System.err.println("Unable to install FreeCol look-and-feel.");
                System.exit(1);
            }
        }
        catch (FreeColException e) {
            FreeColClient.removeSplash(splash);
            e.printStackTrace();
            System.err.println("\nThe data files could not be found by FreeCol. Please make sure");
            System.err.println("they are present. If FreeCol is looking in the wrong directory");
            System.err.println("then run the game with a command-line parameter:\n");
            System.exit(1);
        }
        logger.info("Now starting to load images.");
        this.mapEditor = false;
        this.clientOptions = new ClientOptions();
        logger.info("Loaded default client options.");
        try {
            FreeColSavegameFile savegame = new FreeColSavegameFile(savegameFile);
            this.clientOptions.load(savegame.getInputStream("client-options.xml"), false);
            logger.info("Loaded client options from savegame file.");
        }
        catch (Exception e) {
            logger.warning("Failed to read client options from savegame file.");
        }
        this.actionManager = new ActionManager(this);
        File preferences = FreeCol.getClientOptionsFile();
        if (preferences != null && preferences.exists()) {
            this.clientOptions.load(preferences);
            logger.info("Loaded client options from file " + preferences.getPath());
        } else {
            logger.warning("Unable to load client options.");
        }
        ArrayList<ResourceMapping> modMappings = new ArrayList<ResourceMapping>();
        for (FreeColModFile f : this.clientOptions.getActiveMods()) {
            modMappings.add(f.getResourceMapping());
        }
        ResourceManager.setModMappings(modMappings);
        ResourceManager.preload(size);
        this.connectController = new ConnectController(this);
        this.preGameController = new PreGameController(this);
        this.preGameInputHandler = new PreGameInputHandler(this);
        this.inGameController = new InGameController(this);
        this.inGameInputHandler = new InGameInputHandler(this);
        this.mapEditorController = new MapEditorController(this);
        FreeColClient.removeSplash(splash);
        if (!this.headless) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.startGUI(windowSize, sound, showOpeningVideo, savegameFile != null);
                }
            });
        }
        this.worker = new Worker();
        this.worker.start();
        if (savegameFile != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.connectController.loadGame(savegameFile);
                }
            });
        }
        if (FreeCol.getClientOptionsFile() != null && FreeCol.getClientOptionsFile().exists() && !this.headless) {
            Option o = this.clientOptions.getOption("model.option.languageOption");
            o.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (((LanguageOption.Language)e.getNewValue()).getKey().equals("automatic")) {
                        FreeColClient.this.canvas.showInformationMessage("autodetectLanguageSelected");
                    } else {
                        Locale l = ((LanguageOption.Language)e.getNewValue()).getLocale();
                        Messages.setMessageBundle(l);
                        FreeColClient.this.canvas.showInformationMessage(StringTemplate.template("newLanguageSelected").addName("%language%", l.getDisplayName()));
                    }
                }
            });
        }
        if (instance == null) {
            instance = this;
        }
    }

    private static JWindow displaySplash(String filename) {
        try {
            Image im = Toolkit.getDefaultToolkit().getImage(filename);
            JWindow f = new JWindow();
            f.getContentPane().add(new JLabel(new ImageIcon(im)));
            f.pack();
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            f.setLocation(center.x - f.getWidth() / 2, center.y - f.getHeight() / 2);
            f.setVisible(true);
            return f;
        }
        catch (Exception e) {
            logger.warning(e.toString());
            return null;
        }
    }

    private static void removeSplash(JWindow splash) {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    private void startGUI(Dimension innerWindowSize, boolean sound, boolean showOpeningVideo, boolean loadGame) {
        if (sound) {
            ClientOptions opts = this.getClientOptions();
            AudioMixerOption amo = (AudioMixerOption)opts.getOption("model.option.audioMixer");
            PercentageOption volume = (PercentageOption)opts.getOption("model.option.audioVolume");
            try {
                this.soundPlayer = new SoundPlayer(amo, volume);
            }
            catch (Exception e) {
                this.soundPlayer = null;
                logger.log(Level.WARNING, "Unexpected sound failure", e);
            }
        } else {
            this.soundPlayer = null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            logger.info("It seems that the GraphicsEnvironment is headless!");
        }
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (!this.windowed) {
            if (!this.gd.isFullScreenSupported()) {
                String fullscreenNotSupported = "\nIt seems that full screen mode is not fully supported for this\nGraphicsDevice. Please try the \"--windowed\" option if you\nexperienceany graphical problems while running FreeCol.";
                logger.info(fullscreenNotSupported);
                System.out.println(fullscreenNotSupported);
            }
            Rectangle bounds = this.gd.getDefaultConfiguration().getBounds();
            innerWindowSize = new Dimension(bounds.width - bounds.x, bounds.height - bounds.y);
        }
        this.gui = new GUI(this, innerWindowSize, this.imageLibrary);
        this.canvas = new Canvas(this, innerWindowSize, this.gui);
        this.changeWindowedMode(this.windowed);
        this.frame.setIconImage(ResourceManager.getImage("FrameIcon.image"));
        if (showOpeningVideo && !loadGame) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FreeColClient.this.canvas.showOpeningVideoPanel();
                }
            });
        } else {
            if (!loadGame) {
                this.canvas.showMainPanel();
            }
            this.playSound("sound.intro.general");
        }
        this.gui.startCursorBlinking();
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public void setHeadless(boolean newHeadless) {
        this.headless = newHeadless;
    }

    public boolean canSaveCurrentGame() {
        if (this.getFreeColServer() == null) {
            return false;
        }
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getFreeColServer().getGameState() != FreeColServer.GameState.IN_GAME || this.getMyPlayer().isAdmin();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void updateMenuBar() {
        if (this.frame != null && this.frame.getJMenuBar() != null) {
            ((FreeColMenuBar)this.frame.getJMenuBar()).update();
        }
    }

    public void changeWindowedMode(boolean windowed) {
        JMenuBar menuBar = null;
        if (this.frame != null) {
            menuBar = this.frame.getJMenuBar();
            if (this.frame instanceof WindowedFrame) {
                this.windowBounds = this.frame.getBounds();
            }
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        this.windowed = windowed;
        this.frame = windowed ? new WindowedFrame() : new FullScreenFrame(this.gd);
        this.frame.setJMenuBar(menuBar);
        if (this.frame instanceof WindowedFrame) {
            ((WindowedFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
            if (this.windowBounds != null) {
                this.frame.setBounds(this.windowBounds);
            } else {
                this.frame.pack();
            }
        } else if (this.frame instanceof FullScreenFrame) {
            ((FullScreenFrame)this.frame).setCanvas(this.canvas);
            this.frame.getContentPane().add(this.canvas);
        }
        this.gui.forceReposition();
        this.canvas.updateSizes();
        this.frame.setVisible(true);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void saveClientOptions() throws FileNotFoundException {
        this.saveClientOptions(FreeCol.getClientOptionsFile());
    }

    public void setMapEditor(boolean mapEditor) {
        this.mapEditor = mapEditor;
    }

    public boolean isMapEditor() {
        return this.mapEditor;
    }

    public void saveClientOptions(File saveFile) throws FileNotFoundException {
        this.getClientOptions().save(saveFile);
    }

    public ImageLibrary getImageLibrary() {
        return this.imageLibrary;
    }

    public void loadClientOptions() {
        this.loadClientOptions(FreeCol.getClientOptionsFile());
    }

    public void loadClientOptions(File loadFile) {
        this.getClientOptions().load(loadFile);
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public MapEditorController getMapEditorController() {
        return this.mapEditorController;
    }

    public Player getMyPlayer() {
        return this.player;
    }

    public void setMyPlayer(Player player) {
        this.player = player;
    }

    public void setFreeColServer(FreeColServer freeColServer) {
        this.freeColServer = freeColServer;
    }

    public FreeColServer getFreeColServer() {
        return this.freeColServer;
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public Game getGame() {
        return this.game;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GUI getGUI() {
        return this.gui;
    }

    private void exitActions() {
        try {
            int validDays = this.getClientOptions().getInteger("model.option.autosaveValidity");
            long validPeriod = (long)validDays * 86400L * 1000L;
            long timeNow = System.currentTimeMillis();
            File autosaveDir = FreeCol.getAutosaveDirectory();
            if (validPeriod != 0L) {
                String[] flist = autosaveDir.list();
                for (int i = 0; flist != null && i < flist.length; ++i) {
                    File saveGameFile;
                    String filename = flist[i];
                    if (!filename.endsWith(".fsg") || (saveGameFile = new File(autosaveDir, filename)).lastModified() + validPeriod >= timeNow) continue;
                    saveGameFile.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void quit() {
        this.getConnectController().quitGame(this.isSingleplayer());
        this.exitActions();
        if (!this.windowed) {
            try {
                this.gd.setFullScreenWindow(null);
            }
            catch (Exception e) {
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public boolean retire() {
        Element retireElement = Message.createNewRootElement("retire");
        Element reply = this.client.ask(retireElement);
        boolean result = reply != null && "true".equals(reply.getAttribute("highScore"));
        return result;
    }

    public void continuePlaying() {
        this.client.send(Message.createNewRootElement("continuePlaying"));
    }

    public boolean isAdmin() {
        if (this.getMyPlayer() == null) {
            return false;
        }
        return this.getMyPlayer().isAdmin();
    }

    public void setSingleplayer(boolean singleplayer) {
        this.singleplayer = singleplayer;
    }

    public boolean isSingleplayer() {
        return this.singleplayer;
    }

    public void setIsRetired(boolean isRetired) {
        this.isRetired = isRetired;
    }

    public boolean isRetired() {
        return this.isRetired;
    }

    public ConnectController getConnectController() {
        return this.connectController;
    }

    public PreGameController getPreGameController() {
        return this.preGameController;
    }

    public PreGameInputHandler getPreGameInputHandler() {
        return this.preGameInputHandler;
    }

    public InGameController getInGameController() {
        return this.inGameController;
    }

    public InGameInputHandler getInGameInputHandler() {
        return this.inGameInputHandler;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public Client getClient() {
        return this.client;
    }

    public SoundPlayer getSoundPlayer() {
        return this.soundPlayer;
    }

    public void playSound(String sound) {
        if (this.canPlaySound()) {
            if (sound == null) {
                this.soundPlayer.fade();
            } else {
                File file = ResourceManager.getAudio(sound);
                if (file != null) {
                    this.soundPlayer.playOnce(file);
                }
                logger.finest((file == null ? "Could not load" : "Playing") + " sound: " + sound);
            }
        }
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public void setActiveUnit(String unitId) {
        Unit active;
        if (unitId != null && this.getGame() != null && (active = (Unit)this.getGame().getFreeColGameObject(unitId)) != null) {
            active.getOwner().resetIterators();
            active.getOwner().setNextActiveUnit(active);
            this.getGUI().setActiveUnit(active);
        }
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void skipTurns(int turns) {
        if (this.freeColServer == null) {
            return;
        }
        this.freeColServer.getInGameController().setSkippedTurns(turns);
        this.getCanvas().closeMenus();
        this.inGameController.endTurn();
    }
}

