////////////////////////////////////////////////////////////////////////////////
//
// ADOBE SYSTEMS INCORPORATED
// Copyright 2007-2010 Adobe Systems Incorporated
// All Rights Reserved.
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file 
// in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////
package flashx.textLayout.compose
{
	import flash.display.DisplayObject;
	import flash.display.DisplayObjectContainer;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	
	/** Contains information about the float that was generated by composition, and is used for composing and updating */
	[ExcludeClass]
	public class FloatCompositionData
	{
		public var graphic:DisplayObject;		// display object used for float
		public var columnIndex:int;				// parcel index float was composed into
		public var floatType:String;			// float type @see flashx.textLayout.formats.Float)
		public var x:Number;					// x position of DisplayObject origin, in parent object coords
		public var y:Number;					// y position of DisplayObject origin, in parent object coords
		public var alpha:Number; 				// alpha value from fte-inline placeholder
		public var matrix:Matrix;				// matrix value from fte-inline placeholder
		public var absolutePosition:int;		// location of the float in the text flow
		public var depth:Number;
		public var knockOutWidth:Number;
		public var parent:DisplayObjectContainer;
		CONFIG::debug { public var displacedVertically:Boolean; }
		
		public function FloatCompositionData(absolutePosition:int, graphic:DisplayObject, floatType:String, x:Number, y:Number, alpha:Number, matrix:Matrix, depth:Number, 
			knockOutWidth:Number, columnIndex:int, parent:DisplayObjectContainer)
		{
			this.absolutePosition = absolutePosition;
			this.graphic = graphic;
			this.floatType = floatType;
			this.x = x;
			this.y = y;
			this.alpha = alpha;
			this.matrix = matrix;
			this.depth = depth;
			this.knockOutWidth = knockOutWidth;
			this.columnIndex = columnIndex;
			this.parent = parent;
		}
	}
}
