////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2010 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package spark.components
{
    
    /**
     *  The IconPlacement class defines the constants for the allowed values 
     *  of the <code>iconPlacement</code>
     *  style of a Button, CheckBox, RadioButton or ToggleButton.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 2.5 
     *  @productversion Flex 4.5
     */
    public final class IconPlacement
    {
        include "../core/Version.as";
        
        //--------------------------------------------------------------------------
        //
        //  Class constants
        //
        //--------------------------------------------------------------------------
        
        /**
         *  Specifies that the icon appears below the label.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 10
         *  @playerversion AIR 2.5 
         *  @productversion Flex 4.5
         */
        public static const BOTTOM:String = "bottom";
        
        /**
         *  Specifies that the icon appears to the left of the label.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 10
         *  @playerversion AIR 2.5 
         *  @productversion Flex 4.5
         */
        public static const LEFT:String = "left";
        
        /**
         *  Specifies that the icon appears to the right of the label.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 10
         *  @playerversion AIR 2.5 
         *  @productversion Flex 4.5
         */
        public static const RIGHT:String = "right";
        
        /**
         *  Specifies that the icon appears above the label.
         *  
         *  @langversion 3.0
         *  @playerversion Flash 10
         *  @playerversion AIR 2.5 
         *  @productversion Flex 4.5
         */
        public static const TOP:String = "top";
    }
    
}
