////////////////////////////////////////////////////////////////////////////////
//
//  ADOBE SYSTEMS INCORPORATED
//  Copyright 2010 Adobe Systems Incorporated
//  All Rights Reserved.
//
//  NOTICE: Adobe permits you to use, modify, and distribute this file
//  in accordance with the terms of the license agreement accompanying it.
//
////////////////////////////////////////////////////////////////////////////////

package spark.components
{

/**
 *  The ActionBarDefaultButtonAppearance class defines the constants for the allowed values 
 *  of the <code>defaultButtonAppearance</code> style of ActionBar.
 *  
 *  @langversion 3.0
 *  @playerversion AIR 2.5 
 *  @productversion Flex 4.5
 */
public final class ActionBarDefaultButtonAppearance
{
    //--------------------------------------------------------------------------
    //
    //  Class constants
    //
    //--------------------------------------------------------------------------
    
    /**
     *  Specifies transparent button skins be used for Buttons in
     *  navigation and action content groups.
     *  
     *  @langversion 3.0
     *  @playerversion AIR 2.5 
     *  @productversion Flex 4.5
     */
    public static const NORMAL:String = "normal";
    
    /**
     *  Specifies beveled and opaque button skins be used for Buttons in
     *  navigation and action content groups.
     *  
     *  @langversion 3.0
     *  @playerversion AIR 2.5 
     *  @productversion Flex 4.5
     */
    public static const BEVELED:String = "beveled";
}
}