/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.List;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.ReadOnlyArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeListItem
extends Item<TypeListItem> {
    private int hashCode = 0;
    private TypeIdItem[] typeList;

    protected TypeListItem(DexFile dexFile) {
        super(dexFile);
    }

    private TypeListItem(DexFile dexFile, TypeIdItem[] typeList) {
        super(dexFile);
        this.typeList = typeList;
    }

    public static TypeListItem internTypeListItem(DexFile dexFile, List<TypeIdItem> typeList) {
        TypeIdItem[] typeArray = new TypeIdItem[typeList.size()];
        typeList.toArray(typeArray);
        TypeListItem typeListItem = new TypeListItem(dexFile, typeArray);
        return dexFile.TypeListsSection.intern(typeListItem);
    }

    public static TypeListItem lookupTypeListItem(DexFile dexFile, List<TypeIdItem> typeList) {
        TypeIdItem[] typeArray = new TypeIdItem[typeList.size()];
        typeList.toArray(typeArray);
        TypeListItem typeListItem = new TypeListItem(dexFile, typeArray);
        return dexFile.TypeListsSection.getInternedItem(typeListItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int size = in.readInt();
        this.typeList = new TypeIdItem[size];
        for (int i = 0; i < size; ++i) {
            int typeIndex = in.readShort();
            this.typeList[i] = this.dexFile.TypeIdsSection.getItemByIndex(typeIndex);
        }
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 4 + this.typeList.length * 2;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, "size: 0x" + Integer.toHexString(this.typeList.length) + " (" + this.typeList.length + ")");
            for (TypeIdItem typeIdItem : this.typeList) {
                out.annotate(2, "type_id_item: " + typeIdItem.getTypeDescriptor());
            }
        }
        out.writeInt(this.typeList.length);
        for (TypeIdItem typeIdItem : this.typeList) {
            out.writeShort(typeIdItem.getIndex());
        }
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_TYPE_LIST;
    }

    @Override
    public String getConciseIdentity() {
        return "type_list: " + this.getTypeListString("");
    }

    @Override
    public int compareTo(TypeListItem o) {
        if (o == null) {
            return 1;
        }
        int thisSize = this.typeList.length;
        int otherSize = o.typeList.length;
        int size = Math.min(thisSize, otherSize);
        for (int i = 0; i < size; ++i) {
            int result = this.typeList[i].compareTo(o.typeList[i]);
            if (result == 0) continue;
            return result;
        }
        if (thisSize < otherSize) {
            return -1;
        }
        if (thisSize > otherSize) {
            return 1;
        }
        return 0;
    }

    public int getRegisterCount() {
        int wordCount = 0;
        for (TypeIdItem typeIdItem : this.typeList) {
            wordCount += typeIdItem.getRegisterCount();
        }
        return wordCount;
    }

    public String getTypeListString(String separator) {
        int size = 0;
        for (TypeIdItem typeIdItem : this.typeList) {
            size += typeIdItem.getTypeDescriptor().length();
            size += separator.length();
        }
        StringBuilder sb = new StringBuilder(size);
        for (TypeIdItem typeIdItem : this.typeList) {
            sb.append(typeIdItem.getTypeDescriptor());
            sb.append(separator);
        }
        if (this.typeList.length > 0) {
            sb.delete(sb.length() - separator.length(), sb.length());
        }
        return sb.toString();
    }

    public String getShortyString() {
        StringBuilder sb = new StringBuilder();
        for (TypeIdItem typeIdItem : this.typeList) {
            sb.append(typeIdItem.toShorty());
        }
        return sb.toString();
    }

    public TypeIdItem getTypeIdItem(int index) {
        return this.typeList[index];
    }

    public int getTypeCount() {
        return this.typeList.length;
    }

    public List<TypeIdItem> getTypes() {
        return new ReadOnlyArrayList<TypeIdItem>(this.typeList);
    }

    public static List<TypeIdItem> getTypes(TypeListItem typeListItem) {
        return typeListItem == null ? null : typeListItem.getTypes();
    }

    private void calcHashCode() {
        int hashCode = 1;
        for (TypeIdItem typeIdItem : this.typeList) {
            hashCode = 31 * hashCode + typeIdItem.hashCode();
        }
        this.hashCode = hashCode;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        TypeListItem other = (TypeListItem)o;
        if (this.typeList.length != other.typeList.length) {
            return false;
        }
        for (int i = 0; i < this.typeList.length; ++i) {
            if (this.typeList[i] == other.typeList[i]) continue;
            return false;
        }
        return true;
    }
}

