/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class LongEncodedValue
extends EncodedValue {
    public final long value;

    protected LongEncodedValue(Input in, byte valueArg) {
        this.value = EncodedValueUtils.decodeSignedIntegralValue(in.readBytes(valueArg + 1));
    }

    public LongEncodedValue(long value) {
        this.value = value;
    }

    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeSignedIntegralValue(this.value);
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_LONG.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: 0x" + Long.toHexString(this.value) + " (" + this.value + ")");
        }
        out.writeByte(ValueType.VALUE_LONG.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForSignedIntegralValue(this.value) + 1;
    }

    protected int compareValue(EncodedValue o) {
        LongEncodedValue other = (LongEncodedValue)o;
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    public ValueType getValueType() {
        return ValueType.VALUE_LONG;
    }

    public int hashCode() {
        return (int)this.value;
    }
}

