/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jf.dexlib.Code.Analysis.ClassPath;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.OdexHeader;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;

public class DeodexUtil {
    public static final int Virtual = 0;
    public static final int Direct = 1;
    public static final int Static = 2;
    private final InlineMethod[] inlineMethods;
    private final InlineMethod[] inlineMethods_35 = new InlineMethod[]{new InlineMethod(2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), new InlineMethod(0, "Ljava/lang/String;", "charAt", "I", "C"), new InlineMethod(0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), new InlineMethod(0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), new InlineMethod(0, "Ljava/lang/String;", "length", "", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "I", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "J", "J"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "F", "F"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "min", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "max", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "sqrt", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "cos", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "sin", "D", "D")};
    private final InlineMethod[] inlineMethods_36 = new InlineMethod[]{new InlineMethod(2, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), new InlineMethod(0, "Ljava/lang/String;", "charAt", "I", "C"), new InlineMethod(0, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), new InlineMethod(0, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), new InlineMethod(0, "Ljava/lang/String;", "indexOf", "I", "I"), new InlineMethod(0, "Ljava/lang/String;", "indexOf", "II", "I"), new InlineMethod(0, "Ljava/lang/String;", "length", "", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "I", "I"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "J", "J"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "F", "F"), new InlineMethod(2, "Ljava/lang/Math;", "abs", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "min", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "max", "II", "I"), new InlineMethod(2, "Ljava/lang/Math;", "sqrt", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "cos", "D", "D"), new InlineMethod(2, "Ljava/lang/Math;", "sin", "D", "D")};
    public final DexFile dexFile;
    private static final Pattern shortMethodPattern = Pattern.compile("([^(]+)\\(([^)]*)\\)(.+)");

    public DeodexUtil(DexFile dexFile) {
        this.dexFile = dexFile;
        OdexHeader odexHeader = dexFile.getOdexHeader();
        if (odexHeader == null) {
            assert (false);
            throw new RuntimeException("Cannot create a DeodexUtil object for a dex file without an odex header");
        }
        if (odexHeader.version == 35) {
            this.inlineMethods = this.inlineMethods_35;
        } else if (odexHeader.version == 36) {
            this.inlineMethods = this.inlineMethods_36;
        } else {
            assert (false);
            throw new RuntimeException(String.format("odex version %d isn't supported yet", odexHeader.version));
        }
    }

    public InlineMethod lookupInlineMethod(int inlineMethodIndex) {
        if (inlineMethodIndex >= this.inlineMethods.length) {
            throw new RuntimeException("Invalid inline method index " + inlineMethodIndex + ".");
        }
        return this.inlineMethods[inlineMethodIndex];
    }

    public FieldIdItem lookupField(ClassPath.ClassDef classDef, int fieldOffset) {
        String field = classDef.getInstanceField(fieldOffset);
        if (field == null) {
            return null;
        }
        return this.parseAndResolveField(classDef, field);
    }

    public MethodIdItem lookupVirtualMethod(ClassPath.ClassDef classDef, int methodIndex) {
        String method = classDef.getVirtualMethod(methodIndex);
        if (method == null) {
            return null;
        }
        Matcher m = shortMethodPattern.matcher(method);
        if (!m.matches()) {
            assert (false);
            throw new RuntimeException("Invalid method descriptor: " + method);
        }
        String methodName = m.group(1);
        String methodParams = m.group(2);
        String methodRet = m.group(3);
        if (classDef.isInterface()) {
            classDef = classDef.getSuperclass();
            assert (classDef != null);
        }
        return this.parseAndResolveMethod(classDef, methodName, methodParams, methodRet);
    }

    private MethodIdItem parseAndResolveMethod(ClassPath.ClassDef classDef, String methodName, String methodParams, String methodRet) {
        StringIdItem methodNameItem = StringIdItem.lookupStringIdItem(this.dexFile, methodName);
        if (methodNameItem == null) {
            return null;
        }
        LinkedList<TypeIdItem> paramList = new LinkedList<TypeIdItem>();
        for (int i = 0; i < methodParams.length(); ++i) {
            TypeIdItem typeIdItem;
            switch (methodParams.charAt(i)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, i + 1));
                    break;
                }
                case 'L': {
                    int end = methodParams.indexOf(59, i);
                    if (end == -1) {
                        throw new RuntimeException("invalid parameter in the method");
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, end + 1));
                    i = end;
                    break;
                }
                case '[': {
                    int typeStart;
                    int end;
                    for (typeStart = i + 1; typeStart < methodParams.length() && methodParams.charAt(typeStart) == '['; ++typeStart) {
                    }
                    switch (methodParams.charAt(typeStart)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            end = typeStart;
                            break;
                        }
                        case 'L': {
                            end = methodParams.indexOf(59, typeStart);
                            if (end != -1) break;
                            throw new RuntimeException("invalid parameter in the method");
                        }
                        default: {
                            throw new RuntimeException("invalid parameter in the method");
                        }
                    }
                    typeIdItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodParams.substring(i, end + 1));
                    i = end;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid parameter in the method");
                }
            }
            if (typeIdItem == null) {
                return null;
            }
            paramList.add(typeIdItem);
        }
        TypeListItem paramListItem = null;
        if (paramList.size() > 0 && (paramListItem = TypeListItem.lookupTypeListItem(this.dexFile, paramList)) == null) {
            return null;
        }
        TypeIdItem retType = TypeIdItem.lookupTypeIdItem(this.dexFile, methodRet);
        if (retType == null) {
            return null;
        }
        ProtoIdItem protoItem = ProtoIdItem.lookupProtoIdItem(this.dexFile, retType, paramListItem);
        if (protoItem == null) {
            return null;
        }
        ClassPath.ClassDef methodClassDef = classDef;
        do {
            MethodIdItem methodIdItem;
            TypeIdItem classTypeItem;
            if ((classTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, methodClassDef.getClassType())) == null || (methodIdItem = MethodIdItem.lookupMethodIdItem(this.dexFile, classTypeItem, protoItem, methodNameItem)) == null) continue;
            return methodIdItem;
        } while ((methodClassDef = methodClassDef.getSuperclass()) != null);
        return null;
    }

    private FieldIdItem parseAndResolveField(ClassPath.ClassDef classDef, String field) {
        String[] parts = field.split(":");
        if (parts.length != 2) {
            throw new RuntimeException("Invalid field descriptor " + field);
        }
        String fieldName = parts[0];
        String fieldType = parts[1];
        StringIdItem fieldNameItem = StringIdItem.lookupStringIdItem(this.dexFile, fieldName);
        if (fieldNameItem == null) {
            return null;
        }
        TypeIdItem fieldTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, fieldType);
        if (fieldTypeItem == null) {
            return null;
        }
        ClassPath.ClassDef fieldClass = classDef;
        do {
            TypeIdItem classTypeItem;
            if ((classTypeItem = TypeIdItem.lookupTypeIdItem(this.dexFile, fieldClass.getClassType())) == null) continue;
            FieldIdItem fieldIdItem = FieldIdItem.lookupFieldIdItem(this.dexFile, classTypeItem, fieldTypeItem, fieldNameItem);
            if (fieldIdItem != null) {
                return fieldIdItem;
            }
            fieldClass = fieldClass.getSuperclass();
        } while (fieldClass != null);
        return null;
    }

    protected void checkInlineMethods(String[] inlineMethods) {
        if (inlineMethods.length > this.inlineMethods.length) {
            throw new ValidationException("Inline method count mismatch");
        }
        for (int i = 0; i < inlineMethods.length; ++i) {
            int methodType;
            String inlineMethod = inlineMethods[i];
            if (inlineMethod.startsWith("static")) {
                methodType = 2;
                inlineMethod = inlineMethod.substring(7);
            } else if (inlineMethod.startsWith("direct")) {
                methodType = 1;
                inlineMethod = inlineMethod.substring(7);
            } else if (inlineMethod.startsWith("virtual")) {
                methodType = 0;
                inlineMethod = inlineMethod.substring(8);
            } else {
                throw new ValidationException("Could not parse inline method");
            }
            if (!inlineMethod.equals(this.inlineMethods[i].getMethodString())) {
                throw new ValidationException(String.format("Inline method mismatch. %s vs. %s", inlineMethod, this.inlineMethods[i].getMethodString()));
            }
            if (methodType == this.inlineMethods[i].methodType) continue;
            throw new ValidationException(String.format("Inline method type mismatch. %d vs. %d", methodType, this.inlineMethods[i].methodType));
        }
    }

    public class InlineMethod {
        public final int methodType;
        public final String classType;
        public final String methodName;
        public final String parameters;
        public final String returnType;
        private MethodIdItem methodIdItem = null;

        protected InlineMethod(int methodType, String classType, String methodName, String parameters, String returnType) {
            this.methodType = methodType;
            this.classType = classType;
            this.methodName = methodName;
            this.parameters = parameters;
            this.returnType = returnType;
        }

        public MethodIdItem getMethodIdItem() {
            if (this.methodIdItem == null) {
                this.loadMethod();
            }
            return this.methodIdItem;
        }

        private void loadMethod() {
            ClassPath.ClassDef classDef = ClassPath.getClassDef(this.classType);
            this.methodIdItem = DeodexUtil.this.parseAndResolveMethod(classDef, this.methodName, this.parameters, this.returnType);
        }

        public String getMethodString() {
            return String.format("%s->%s(%s)%s", this.classType, this.methodName, this.parameters, this.returnType);
        }
    }
}

