/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.Renderers.IntegerRenderer;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.CodeItem;
import org.jf.util.IndentingWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseSwitchMethodItem
extends InstructionMethodItem<SparseSwitchDataPseudoInstruction>
implements Iterable<LabelMethodItem> {
    private final List<SparseSwitchTarget> targets;

    public SparseSwitchMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int codeAddress, SparseSwitchDataPseudoInstruction instruction) {
        super(codeItem, codeAddress, instruction);
        int baseCodeAddress = methodDefinition.getSparseSwitchBaseAddress(codeAddress);
        this.targets = new ArrayList<SparseSwitchTarget>();
        Iterator<SparseSwitchDataPseudoInstruction.SparseSwitchTarget> iterator = instruction.iterateKeysAndTargets();
        while (iterator.hasNext()) {
            SparseSwitchDataPseudoInstruction.SparseSwitchTarget target = iterator.next();
            SparseSwitchTarget sparseSwitchTarget = new SparseSwitchTarget();
            sparseSwitchTarget.Key = target.key;
            LabelMethodItem label = new LabelMethodItem(baseCodeAddress + target.targetAddressOffset, "sswitch_");
            sparseSwitchTarget.Target = label = methodDefinition.getLabelCache().internLabel(label);
            this.targets.add(sparseSwitchTarget);
        }
    }

    @Override
    public boolean writeTo(IndentingWriter writer) throws IOException {
        writer.write(".sparse-switch\n");
        writer.indent(4);
        for (SparseSwitchTarget target : this.targets) {
            IntegerRenderer.writeTo(writer, target.Key);
            writer.write(" -> ");
            target.Target.writeTo(writer);
            writer.write(10);
        }
        writer.deindent(4);
        writer.write(".end sparse-switch");
        return true;
    }

    @Override
    public Iterator<LabelMethodItem> iterator() {
        return new Iterator<LabelMethodItem>(){
            private Iterator<SparseSwitchTarget> iterator;
            {
                this.iterator = SparseSwitchMethodItem.this.targets.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public LabelMethodItem next() {
                return this.iterator.next().Target;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    private static class SparseSwitchTarget {
        public int Key;
        public LabelMethodItem Target;

        private SparseSwitchTarget() {
        }
    }
}

