/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.abc.Optimizer;
import macromedia.asc.embedding.Compiler;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.embedding.Main;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.embedding.avmplus.Features;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.BinaryProgramNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.MetaDataEvaluator;
import macromedia.asc.parser.Parser;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.CodeGenerator;
import macromedia.asc.semantics.ConfigurationEvaluator;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.semantics.UnresolvedNamespace;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.IntList;
import macromedia.asc.util.Names;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;
import macromedia.asc.util.graph.Algorithms;
import macromedia.asc.util.graph.DependencyGraph;
import macromedia.asc.util.graph.Vertex;
import macromedia.asc.util.graph.Visitor;

public class ScriptCompiler {
    private static List<File> file;
    private static List<Context> cx;
    private static List<ActionBlockEmitter> emitter;
    private static List<ProgramNode> node;
    private static List<FlowAnalyzer> fa;
    private static Set<Pair> inheritance;
    private static Set<Pair> type;
    private static Set<Pair> expr;
    private static ContextStatics s;
    private static ActionBlockEmitter mainEmitter;
    private static Context mainContext;
    private static File mainFile;
    private static String outputFile;
    private static String outputDir;
    private static boolean builtinFlag;
    private static boolean apiVersioningFlag;
    private static boolean debugFlag;
    private static boolean optimize;
    private static boolean check_version;
    private static boolean debug;
    static ObjectList<ConfigVar> config_vars;
    static ObjectList<String> use_namespaces;
    static String swfOptions;

    public static void main(String[] args) throws Throwable {
        long startTime = System.currentTimeMillis();
        ScriptCompiler.init(args);
        int start = 0;
        int end = file.size();
        while (start < end) {
            ScriptCompiler.parse(start, end);
            ScriptCompiler.fa_part1(start, end);
            ScriptCompiler.resolveInheritance(start, end);
            start = end;
            end = file.size();
            if (start < end) continue;
            ScriptCompiler.sortInheritance();
            ScriptCompiler.fa_part2();
            ScriptCompiler.resolveType();
            start = end;
            end = file.size();
            if (start < end) continue;
            ScriptCompiler.importType();
            ScriptCompiler.resolveExpression();
            ScriptCompiler.importExpr();
            ScriptCompiler.s.check_version = check_version;
            ScriptCompiler.md();
            ScriptCompiler.ce();
            ScriptCompiler.s.check_version = false;
            ScriptCompiler.cg();
            start = end;
            end = file.size();
        }
        ScriptCompiler.clear();
        System.err.println("Files: " + file.size() + " Time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void init(String[] args) throws Throwable {
        int i;
        ObjectList<String> filespecs = new ObjectList<String>();
        ObjectList<Boolean> imported = new ObjectList<Boolean>();
        boolean use_static_semantics = false;
        boolean decimalFlag = false;
        boolean useas3 = false;
        int apiVersion = -1;
        int target = 1;
        args = ScriptCompiler.expandArguments(args);
        if (debug) {
            System.out.print("Running with expanded args '");
            for (i = 0; i < args.length; ++i) {
                System.out.print(args[i] + " ");
            }
            System.out.println("'");
        }
        int length = args.length;
        for (i = 0; i < length; ++i) {
            if (args[i].equals("-builtin")) {
                builtinFlag = true;
                continue;
            }
            if (args[i].equals("-apiversioning")) {
                apiVersioningFlag = true;
                continue;
            }
            if (args[i].equals("-abcfuture")) {
                Features.FUTURE_ABC = true;
                continue;
            }
            if (args[i].equals("-optimize")) {
                optimize = true;
                continue;
            }
            if (args[i].equals("-strict")) {
                use_static_semantics = true;
                continue;
            }
            if (args[i].equals("-d")) {
                debugFlag = true;
                continue;
            }
            if (args[i].equals("-m")) {
                decimalFlag = true;
                continue;
            }
            if (args[i].equals("-out")) {
                outputFile = args[++i];
                continue;
            }
            if (args[i].equals("-outdir")) {
                outputDir = args[++i];
                continue;
            }
            if (args[i].equals("-import")) {
                filespecs.add(args[++i]);
                imported.add(new Boolean(true));
                continue;
            }
            if (args[i].equals("-config")) {
                String temp;
                ConfigVar cv;
                if ((cv = Main.parseConfigVar(temp = args[++i])) != null) {
                    config_vars.push_back(cv);
                    continue;
                }
                System.err.println("ERROR: couldn't parse config var " + temp);
                continue;
            }
            if (args[i].equals("-AS3")) {
                useas3 = true;
                continue;
            }
            if (args[i].equals("-use")) {
                if (use_namespaces == null) {
                    use_namespaces = new ObjectList();
                }
                use_namespaces.add(args[++i]);
                continue;
            }
            if (args[i].equals("-avmtarget")) {
                ++i;
                try {
                    String vm_target = args[i].trim();
                    int v = Integer.parseInt(vm_target);
                    switch (v) {
                        case 1: {
                            target = 0;
                            break;
                        }
                        case 2: {
                            target = 1;
                            break;
                        }
                    }
                }
                catch (Exception e) {}
                continue;
            }
            if (args[i].equals("-versioncheck")) {
                check_version = true;
                continue;
            }
            if (args[i].equals("-swf")) {
                swfOptions = args[++i];
                continue;
            }
            filespecs.add(args[i]);
            imported.add(new Boolean(false));
        }
        if (apiVersioningFlag && !builtinFlag) {
            System.err.println("API Versioning only available on builtins");
            System.exit(1);
        }
        TypeValue.init();
        ObjectValue.init();
        s = new ContextStatics();
        s.setAbcVersion(target);
        ScriptCompiler.s.use_static_semantics = use_static_semantics;
        if (useas3) {
            ScriptCompiler.s.dialect = 10;
        }
        ScriptCompiler.s.es4_numerics = decimalFlag;
        if (use_namespaces != null) {
            ScriptCompiler.s.use_namespaces.addAll(use_namespaces);
        }
        file = new ArrayList<File>(filespecs.size());
        cx = new ArrayList<Context>(filespecs.size());
        emitter = new ArrayList<ActionBlockEmitter>(filespecs.size());
        length = filespecs.size();
        for (i = 0; i < length; ++i) {
            boolean importFlag = (Boolean)imported.get(i);
            File f = new File((String)filespecs.get(i));
            if (f.exists() && f.isFile()) {
                f = f.getCanonicalFile();
                file.add(f);
                Context cxFile = new Context(s);
                cx.add(cxFile);
                cxFile.config_vars.addAll(config_vars);
                if (!importFlag) {
                    mainFile = f;
                    mainContext = cxFile;
                }
                if (importFlag) {
                    emitter.add(new ActionBlockEmitter(cxFile, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag));
                    continue;
                }
                if (mainEmitter == null) {
                    mainEmitter = new ActionBlockEmitter(cxFile, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag);
                }
                emitter.add(mainEmitter);
                continue;
            }
            System.err.println("Warning, unable to open file " + f.getPath());
        }
        node = new ArrayList<ProgramNode>(file.size());
        fa = new ArrayList<FlowAnalyzer>(file.size());
        inheritance = new HashSet<Pair>();
        type = new HashSet<Pair>();
        expr = new HashSet<Pair>();
    }

    public static String[] expandArguments(String[] args) throws IOException {
        boolean has_expanded_args = false;
        ObjectList<String> exp_args = new ObjectList<String>(args.length);
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            if (args[i].startsWith("@")) {
                String filename = args[i].substring(1);
                BufferedReader bf = new BufferedReader(new FileReader(filename));
                String s = null;
                String expanded_args = "";
                while ((s = bf.readLine()) != null) {
                    if (s.startsWith("#")) continue;
                    expanded_args = expanded_args + s + " ";
                }
                String[] a = expanded_args.split("\\s+", -1);
                for (int q = 0; q < a.length; ++q) {
                    String arg = a[q].trim();
                    if (arg.length() == 0) continue;
                    exp_args.add(a[q]);
                }
                has_expanded_args = true;
                continue;
            }
            exp_args.add(args[i]);
        }
        if (has_expanded_args) {
            args = exp_args.toArray(args);
        }
        return args;
    }

    private static void parse(int start, int end) throws Throwable {
        for (int i = start; i < end; ++i) {
            Context cxi = cx.get(i);
            cxi.setEmitter(emitter.get(i));
            cxi.setScriptName(file.get(i).getName());
            cxi.setPath(file.get(i).getParent());
            ProgramNode program = file.get(i).getName().endsWith(".as") ? new Parser(cxi, new FileInputStream(file.get(i)), file.get(i).getPath(), null).parseProgram() : new AbcParser(cxi, file.get(i).getPath()).parseAbc();
            node.add(program);
            cxi.getNodeFactory().pkg_defs.clear();
            cxi.getNodeFactory().compound_names.clear();
            ConfigurationEvaluator ce = new ConfigurationEvaluator();
            program.evaluate(cxi, ce);
        }
    }

    private static void fa_part1(int start, int end) {
        for (int i = start; i < end; ++i) {
            if (cx.get(i).errorCount() != 0 || ScriptCompiler.node.get((int)i).state != 1) continue;
            cx.get(i).pushScope(new ObjectValue(cx.get(i), new GlobalBuilder(), null));
            FlowGraphEmitter fgEmitter = new FlowGraphEmitter(cx.get(i), file.get(i).getPath(), false);
            fa.add(new FlowAnalyzer(fgEmitter));
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveInheritance(int start, int end) throws Throwable {
        IntList prev_imports = new IntList();
        for (int i = start; i < end; ++i) {
            ProgramNode cur_node = node.get(i);
            for (ReferenceValue ref : cur_node.fa_unresolved) {
                int size;
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    Pair p;
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    int where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !inheritance.contains(p = new Pair(i, where))) {
                        inheritance.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " on line " + cx.get(i).getInputLine(ref.getPosition()) + " of file " + file.get(i) + " not resolved");
            }
            cur_node.fa_unresolved.clear();
            if (cur_node.statements == null || !(cur_node.statements.first() instanceof BinaryProgramNode)) continue;
            int e = prev_imports.size();
            for (int r = 0; r < e; ++r) {
                Pair p = new Pair(i, prev_imports.at(r));
                if (inheritance.contains(p)) continue;
                inheritance.add(p);
            }
            prev_imports.add(i);
        }
    }

    private static void sortInheritance() throws Throwable {
        for (Pair p : inheritance) {
            if (p.processed) continue;
            fa.get(p.i);
            FlowAnalyzer.inheritSlots(ScriptCompiler.node.get((int)p.where).frame, ScriptCompiler.node.get((int)p.i).frame, ScriptCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            p.processed = true;
        }
        final DependencyGraph<Integer> g = new DependencyGraph<Integer>();
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            String path = file.get(i).getPath();
            g.put(path, i);
            if (!g.containsVertex(path)) {
                g.addVertex(new Vertex<String>(path));
            }
            for (Pair p : inheritance) {
                if (p.i != i) continue;
                g.addDependency(path, file.get(p.where).getPath());
            }
        }
        final ArrayList tsort = new ArrayList(node.size());
        Algorithms.topologicalSort(g, new Visitor<String>(){

            @Override
            public void visit(Vertex<String> v) {
                String name = v.getWeight();
                tsort.add(g.get(name));
            }
        });
        if (node.size() > tsort.size()) {
            int length2 = node.size();
            for (int i = 0; i < length2; ++i) {
                int j;
                for (j = 0; j < tsort.size() && (Integer)tsort.get(j) != i; ++j) {
                }
                if (j != tsort.size()) continue;
                String path = file.get(i).getPath();
                System.out.println(path + " in circular reference");
            }
        } else {
            int j;
            int length3;
            ArrayList<File> tempFile = new ArrayList<File>(file.size());
            ArrayList<Context> tempCX = new ArrayList<Context>(cx.size());
            ArrayList<ActionBlockEmitter> tempEmitter = new ArrayList<ActionBlockEmitter>(emitter.size());
            ArrayList<ProgramNode> tempNode = new ArrayList<ProgramNode>(node.size());
            ArrayList<FlowAnalyzer> tempFA = new ArrayList<FlowAnalyzer>(fa.size());
            int length4 = tsort.size();
            for (int i = 0; i < length4; ++i) {
                int loc = (Integer)tsort.get(i);
                tempFile.add(file.get(loc));
                tempCX.add(cx.get(loc));
                tempEmitter.add(emitter.get(loc));
                tempNode.add(node.get(loc));
                tempFA.add(fa.get(loc));
            }
            file = tempFile;
            cx = tempCX;
            emitter = tempEmitter;
            node = tempNode;
            fa = tempFA;
            block6: for (Pair p : type) {
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block6;
                }
            }
            block9: for (Pair p : inheritance) {
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.i) continue;
                    p.i = j;
                    break;
                }
                length3 = tsort.size();
                for (j = 0; j < length3; ++j) {
                    if ((Integer)tsort.get(j) != p.where) continue;
                    p.where = j;
                    continue block9;
                }
            }
        }
    }

    private static void fa_part2() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || ScriptCompiler.node.get((int)i).state != 2) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            node.get(i).evaluate(cx.get(i), fa.get(i));
            cx.get(i).popScope();
        }
    }

    private static void resolveType() throws Throwable {
        Pair p;
        int where;
        QName qname;
        int j;
        int size;
        boolean found;
        int i;
        int length = node.size();
        for (i = 0; i < length; ++i) {
            for (ReferenceValue ref : ScriptCompiler.node.get((int)i).ce_unresolved) {
                if (ref.isAttributeIdentifier()) continue;
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " on line " + cx.get(i).getInputLine(ref.getPosition()) + " of file " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).ce_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            for (ReferenceValue ref : ScriptCompiler.node.get((int)i).body_unresolved) {
                if (ref.isAttributeIdentifier()) continue;
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findClass(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " on line " + cx.get(i).getInputLine(ref.getPosition()) + " of file " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).body_unresolved.clear();
        }
        length = node.size();
        for (i = 0; i < length; ++i) {
            for (ReferenceValue ref : ScriptCompiler.node.get((int)i).ns_unresolved) {
                if (ref.isAttributeIdentifier()) continue;
                found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (j = 0; j < size; ++j) {
                    qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    where = ScriptCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    if (i != where && !type.contains(p = new Pair(i, where))) {
                        type.add(p);
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                System.err.println(ref.toMultiName() + " on line " + cx.get(i).getInputLine(ref.getPosition()) + " of file " + file.get(i) + " not resolved");
            }
            ScriptCompiler.node.get((int)i).ns_unresolved.clear();
        }
    }

    private static void importType() throws Throwable {
        for (Pair p : type) {
            if (p.processed) continue;
            if (!inheritance.contains(p)) {
                fa.get(p.i);
                FlowAnalyzer.inheritSlots(ScriptCompiler.node.get((int)p.where).frame, ScriptCompiler.node.get((int)p.i).frame, ScriptCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            }
            p.processed = true;
        }
    }

    private static void importExpr() throws Throwable {
        for (Pair p : expr) {
            if (p.processed) continue;
            if (!inheritance.contains(p)) {
                fa.get(p.i);
                FlowAnalyzer.inheritSlots(ScriptCompiler.node.get((int)p.where).frame, ScriptCompiler.node.get((int)p.i).frame, ScriptCompiler.node.get((int)p.i).frame.builder, cx.get(p.i));
            }
            p.processed = true;
        }
    }

    private static void md() {
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0 || !file.get(i).getName().endsWith(".as") || emitter.get(i) == null) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            MetaDataEvaluator analyzer = new MetaDataEvaluator();
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void ce() {
        int i;
        ArrayList<ConstantEvaluator> ces = new ArrayList<ConstantEvaluator>();
        int length = file.size();
        for (i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            ces.add(new ConstantEvaluator(cx.get(i)));
            ((ConstantEvaluator)ces.get(i)).PreprocessDefinitionTypeInfo(cx.get(i), node.get(i));
            cx.get(i).popScope();
        }
        length = file.size();
        for (i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() != 0) continue;
            cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
            ConstantEvaluator analyzer = (ConstantEvaluator)ces.get(i);
            node.get(i).evaluate(cx.get(i), analyzer);
            cx.get(i).popScope();
        }
    }

    private static void cg() throws Throwable {
        boolean errorsFound = false;
        int length = file.size();
        for (int i = 0; i < length; ++i) {
            if (cx.get(i).errorCount() == 0 && file.get(i).getName().endsWith(".as") && emitter.get(i) != null) {
                if (apiVersioningFlag) {
                    emitter.get(i).apiVersioning();
                }
                cx.get(i).setEmitter(emitter.get(i));
                cx.get(i).pushScope(ScriptCompiler.node.get((int)i).frame);
                CodeGenerator generator = new CodeGenerator(cx.get(i).getEmitter());
                generator.emitScriptNames = true;
                node.get(i).evaluate(cx.get(i), generator);
                cx.get(i).popScope();
            }
            if (cx.get(i).errorCount() <= 0) continue;
            errorsFound = true;
        }
        if (errorsFound) {
            return;
        }
        if (builtinFlag) {
            mainEmitter.reorderMainScript();
        }
        ByteList bytes = new ByteList();
        mainEmitter.emit(bytes);
        if (outputFile == null) {
            outputFile = mainFile.getName().substring(0, mainFile.getName().length() - ".as".length());
        }
        File out_dir = null;
        out_dir = outputDir == null ? mainFile.getParentFile() : new File(outputDir);
        if (optimize) {
            bytes = Optimizer.optimize(bytes);
        }
        byte[] abc = bytes.toByteArray(false);
        if (swfOptions != null) {
            Compiler.makeSwf(mainContext, bytes, swfOptions, out_dir.getCanonicalPath(), outputFile);
        } else {
            FileOutputStream out = new FileOutputStream(new File(out_dir, outputFile + ".abc"));
            System.err.println(outputFile + ": " + abc.length);
            out.write(abc);
            out.close();
        }
        mainContext.setPath(out_dir.getPath());
        Compiler.printNative(mainContext, outputFile, mainEmitter, abc);
    }

    private static void resolveExpression() throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            block1: for (ReferenceValue ref : ScriptCompiler.node.get((int)i).rt_unresolved) {
                int size;
                if (ref.isAttributeIdentifier()) continue;
                boolean found = false;
                int n = size = ref.getImmutableNamespaces() != null ? ref.getImmutableNamespaces().size() : 0;
                for (int j = 0; j < size; ++j) {
                    QName qname = new QName((ObjectValue)ref.getImmutableNamespaces().get(j), ref.name);
                    if (qname.ns instanceof UnresolvedNamespace && ((UnresolvedNamespace)qname.ns).resolved) {
                        found = true;
                        continue block1;
                    }
                    int where = ScriptCompiler.findDefinition(qname);
                    if (where == -1) continue;
                    Pair p = new Pair(i, where);
                    if (!expr.contains(p)) {
                        expr.add(p);
                    }
                    found = true;
                    continue block1;
                }
            }
            ScriptCompiler.node.get((int)i).rt_unresolved.clear();
        }
    }

    private static void clear() {
        s.clear();
        ObjectValue.clear();
        TypeValue.clear();
    }

    private static int findDefinition(QName defName) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            Names names = ScriptCompiler.node.get((int)i).frame.builder.getNames();
            for (int j = 0; j < 4; ++j) {
                if (names == null || !names.containsKey(defName.name, defName.ns, j)) continue;
                return i;
            }
        }
        return ScriptCompiler.searchClasspath(defName);
    }

    private static int findClass(QName className) throws Throwable {
        int length = node.size();
        for (int i = 0; i < length; ++i) {
            int size;
            int n = size = ScriptCompiler.node.get((int)i).clsdefs != null ? ScriptCompiler.node.get((int)i).clsdefs.size() : 0;
            for (int j = 0; j < size; ++j) {
                ClassDefinitionNode clsdef = (ClassDefinitionNode)ScriptCompiler.node.get((int)i).clsdefs.get(j);
                if (!clsdef.cframe.builder.classname.equals(className)) continue;
                return i;
            }
        }
        return ScriptCompiler.searchClasspath(className);
    }

    private static int searchClasspath(QName qname) throws Throwable {
        String path = qname.ns.name.replace('.', File.separatorChar) + File.separatorChar + qname.name;
        File f = new File(path + ".as");
        if (f.exists() && f.isFile()) {
            f = f.getCanonicalFile();
            Context context = new Context(s);
            int where = file.indexOf(f);
            if (where == -1) {
                file.add(f);
                cx.add(context);
                emitter.add(new ActionBlockEmitter(context, f.getPath(), new StringPrintWriter(), new StringPrintWriter(), false, false, false, debugFlag));
                where = file.size() - 1;
            }
            return where;
        }
        return -1;
    }

    static {
        debug = false;
        config_vars = new ObjectList();
        swfOptions = null;
    }

    static class Pair {
        int i;
        int where;
        boolean processed;

        Pair(int i, int where) {
            this.i = i;
            this.where = where;
            this.processed = false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Pair) {
                return this.i == ((Pair)obj).i && this.where == ((Pair)obj).where;
            }
            return false;
        }

        public int hashCode() {
            return (17 + this.i) * 17 + this.where;
        }
    }
}

