/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.images;

import flash.util.Trace;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;

public class ImageUtil {
    public static Image getImage(byte[] bytes) {
        Image image;
        try {
            image = Toolkit.getDefaultToolkit().createImage(bytes);
        }
        catch (InternalError ie) {
            if (Trace.error) {
                ie.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the Flex configuration file to true.");
        }
        catch (NoClassDefFoundError ce) {
            if (Trace.error) {
                ce.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the Flex configuration file to true.");
        }
        return image;
    }

    public static PixelGrabber getPixelGrabber(Image image, String location) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            if (Trace.error) {
                interruptedException.printStackTrace();
            }
            throw new RuntimeException("Failed to grab pixels for image " + location);
        }
        if ((pixelGrabber.getStatus() & 1) == 0 || (pixelGrabber.getStatus() & 2) == 0) {
            throw new RuntimeException("Failed to grab pixels for image " + location);
        }
        return pixelGrabber;
    }
}

