/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.ColorManager;
import org.apache.batik.css.engine.value.svg.ICCColor;
import org.apache.batik.css.engine.value.svg.SVGValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGColorManager
extends ColorManager {
    protected String property;
    protected Value defaultValue;

    public SVGColorManager(String string) {
        this(string, SVGValueConstants.BLACK_RGB_VALUE);
    }

    public SVGColorManager(String string, Value value) {
        this.property = string;
        this.defaultValue = value;
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public String getPropertyName() {
        return this.property;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 35 && lexicalUnit.getStringValue().equalsIgnoreCase("currentcolor")) {
            return SVGValueConstants.CURRENTCOLOR_VALUE;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
            return value;
        }
        if (lexicalUnit.getLexicalUnitType() != 41 || !lexicalUnit.getFunctionName().equalsIgnoreCase("icc-color")) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        if ((lexicalUnit = lexicalUnit.getParameters()).getLexicalUnitType() != 35) {
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(value);
        ICCColor iCCColor = new ICCColor(lexicalUnit.getStringValue());
        listValue.append(iCCColor);
        for (lexicalUnit = lexicalUnit.getNextLexicalUnit(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
            if (lexicalUnit.getLexicalUnitType() != 0) {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                throw this.createInvalidLexicalUnitDOMException((short)-1);
            }
            iCCColor.append(this.getColorValue(lexicalUnit));
        }
        return listValue;
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value == SVGValueConstants.CURRENTCOLOR_VALUE) {
            styleMap.putColorRelative(n, true);
            int n2 = cSSEngine.getColorIndex();
            return cSSEngine.getComputedStyle(cSSStylableElement, string, n2);
        }
        if (value.getCssValueType() == 2) {
            ListValue listValue = (ListValue)value;
            Value value2 = listValue.item(0);
            Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue2 = new ListValue(' ');
                listValue2.append(value3);
                listValue2.append(listValue.item(1));
                return listValue2;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    protected float getColorValue(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 13: {
                return lexicalUnit.getIntegerValue();
            }
            case 14: {
                return lexicalUnit.getFloatValue();
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }
}

