/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    public static String FLEX_MAJOR_VERSION = "4";
    public static String FLEX_MINOR_VERSION = "6";
    public static String FLEX_NANO_VERSION = "0";
    public static String LIB_VERSION_1_0 = "1.0";
    public static String LIB_VERSION_1_1 = "1.1";
    public static String LIB_VERSION_1_2 = "1.2";
    public static String LIB_MAJOR_VERSION = "1";
    public static String LIB_MINOR_VERSION = "2";
    static String BUILD_MESSAGE;
    static String BUILD_NUMBER_STRING;
    static String FLEX_VERSION_NUMBER;
    static String LIB_VERSION_NUMBER;

    public static String buildMessage() {
        if (BUILD_MESSAGE == null) {
            try {
                VersionInfo.getBuild();
                String buildNum = BUILD_NUMBER_STRING;
                if (buildNum == null || buildNum.equals("")) {
                    buildNum = "development";
                }
                BUILD_MESSAGE = "Version " + FLEX_MAJOR_VERSION + "." + FLEX_MINOR_VERSION + "." + FLEX_NANO_VERSION + " build " + buildNum;
            }
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
                BUILD_MESSAGE = "build information unavailable";
            }
        }
        return BUILD_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBuild() {
        InputStream in;
        block10: {
            if (BUILD_NUMBER_STRING != null) return BUILD_NUMBER_STRING;
            BUILD_NUMBER_STRING = "";
            in = null;
            Properties p = new Properties();
            in = VersionInfo.class.getResourceAsStream("version.properties");
            if (in == null) break block10;
            p.load(in);
            String build = p.getProperty("build");
            if (build == null || build.equals("")) break block10;
            int dot_index = build.lastIndexOf(".");
            if (dot_index != -1) {
                build = build.substring(dot_index + 1);
            }
            BUILD_NUMBER_STRING = build;
        }
        Object var5_5 = null;
        if (in == null) return BUILD_NUMBER_STRING;
        try {
            in.close();
            return BUILD_NUMBER_STRING;
        }
        catch (IOException ex) {}
        return BUILD_NUMBER_STRING;
        {
            catch (Throwable t) {
                if (Trace.error) {
                    t.printStackTrace();
                }
                Object var5_6 = null;
                if (in == null) return BUILD_NUMBER_STRING;
                try {
                    in.close();
                    return BUILD_NUMBER_STRING;
                }
                catch (IOException ex) {}
                return BUILD_NUMBER_STRING;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String getFlexVersion() {
        if (FLEX_VERSION_NUMBER == null) {
            FLEX_VERSION_NUMBER = FLEX_MAJOR_VERSION + "." + FLEX_MINOR_VERSION + "." + FLEX_NANO_VERSION;
        }
        return FLEX_VERSION_NUMBER;
    }

    public static String getLibVersion() {
        if (LIB_VERSION_NUMBER == null) {
            LIB_VERSION_NUMBER = LIB_MAJOR_VERSION + "." + LIB_MINOR_VERSION;
        }
        return LIB_VERSION_NUMBER;
    }

    public static boolean IsNewerLibVersion(String swcLibVersion, boolean compareMajorVersion) {
        return VersionInfo.compareVersions(swcLibVersion, VersionInfo.getLibVersion(), compareMajorVersion) > 0;
    }

    public static int compareVersions(String version1, String version2, boolean compareMajorVersion) {
        double v2;
        double v1;
        block8: {
            block7: {
                v1 = 0.0;
                v2 = 0.0;
                try {
                    v1 = Double.parseDouble(version1);
                }
                catch (NumberFormatException ex) {
                    if (!Trace.error) break block7;
                    ex.printStackTrace();
                }
            }
            try {
                v2 = Double.parseDouble(version2);
            }
            catch (NumberFormatException ex) {
                if (!Trace.error) break block8;
                ex.printStackTrace();
            }
        }
        if (compareMajorVersion) {
            v1 = Math.floor(v1);
            v2 = Math.floor(v2);
        }
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }
}

