/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.Source;
import flex2.compiler.config.ConfigurationBuffer;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.QName;
import flex2.tools.ToolsConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwcChecksums {
    int[] checksums;
    private Map<QName, Long> swcDefSignatureChecksums = new HashMap<QName, Long>();
    private Map<String, Long> swcFileChecksums = new HashMap<String, Long>();
    private Map<String, Long> archiveFileChecksums = new HashMap<String, Long>();
    private CompilerSwcContext swcContext;
    private ConfigurationBuffer cfgbuf;
    private boolean isSwcChecksumEnabled;

    protected SwcChecksums(CompilerSwcContext swcContext, ConfigurationBuffer cfgbuf, ToolsConfiguration configuration) {
        this.swcContext = swcContext;
        this.cfgbuf = cfgbuf;
        this.isSwcChecksumEnabled = configuration.isSwcChecksumEnabled();
        this.checksums = new int[4];
        this.checksums[0] = 0;
        this.checksums[1] = cfgbuf.checksum_ts();
        this.checksums[2] = cfgbuf.link_checksum_ts();
        this.checksums[3] = swcContext.checksum();
    }

    protected void saveSignatureChecksums(List<CompilationUnit> units) {
        if (!this.isSwcChecksumEnabled) {
            this.swcDefSignatureChecksums = null;
            return;
        }
        if (units != null) {
            this.swcDefSignatureChecksums = new HashMap<QName, Long>();
            for (CompilationUnit unit : units) {
                Source source = unit == null ? null : unit.getSource();
                if (source == null || !source.isSwcScriptOwner() || source.isInternal()) continue;
                this.addSignatureChecksumToData(unit);
            }
        }
    }

    protected void saveSwcFileChecksums() {
        if (!this.isSwcChecksumEnabled) {
            this.swcFileChecksums = null;
            return;
        }
        for (Map.Entry<String, VirtualFile> entry : this.swcContext.getFiles().entrySet()) {
            String filename = entry.getKey();
            VirtualFile file = entry.getValue();
            this.swcFileChecksums.put(filename, new Long(file.getLastModified()));
        }
        for (VirtualFile themeStyleSheet : this.swcContext.getThemeStyleSheets()) {
            this.swcFileChecksums.put(themeStyleSheet.getName(), new Long(themeStyleSheet.getLastModified()));
        }
    }

    protected void saveArchiveFilesChecksums(Map<String, VirtualFile> m) {
        if (!this.isSwcChecksumEnabled) {
            this.swcFileChecksums = null;
            return;
        }
        for (Map.Entry<String, VirtualFile> entry : m.entrySet()) {
            VirtualFile file = entry.getValue();
            this.archiveFileChecksums.put(file.getName(), new Long(file.getLastModified()));
        }
    }

    protected void saveChecksums(List<CompilationUnit> units) {
        this.saveSwcFileChecksums();
        this.saveSignatureChecksums(units);
        this.updateChecksum();
    }

    protected boolean isRecompilationNeeded(int[] loadedChecksums) {
        boolean result;
        this.checksums[0] = this.calculateChecksum();
        if (this.checksums[0] != loadedChecksums[0]) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: calculated checksum differs from last checksum, recompile");
            }
            return true;
        }
        if (!this.isSwcChecksumEnabled) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, swc-checksum disabled, incremental compile");
            }
            return false;
        }
        Map<QName, Long> signatureChecksums = this.swcDefSignatureChecksums;
        if (signatureChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: checksums equal, signatureChecksums is null, incremental compile");
            }
        } else {
            for (Map.Entry<QName, Long> entry : signatureChecksums.entrySet()) {
                Source source;
                QName qName = entry.getKey();
                Long dataSignatureChecksum = entry.getValue();
                Long swcSignatureChecksum = this.swcContext.getChecksum(qName);
                if (swcSignatureChecksum == null && qName != null && (source = this.swcContext.getSource(qName.getNamespace(), qName.getLocalPart())) != null) {
                    swcSignatureChecksum = new Long(source.getLastModified());
                }
                if (Trace.swcChecksum && dataSignatureChecksum == null) {
                    throw new IllegalStateException("dataSignatureChecksum should never be null");
                }
                if (dataSignatureChecksum != null && swcSignatureChecksum == null) {
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                if (dataSignatureChecksum != null) {
                    if (dataSignatureChecksum.longValue() == swcSignatureChecksum.longValue()) continue;
                    if (Trace.swcChecksum) {
                        Trace.trace((String)"isRecompilationNeeded: signature checksums not equal, recompile");
                        Trace.trace((String)("compare " + entry.getKey()));
                        Trace.trace((String)("data =  " + dataSignatureChecksum));
                        Trace.trace((String)("swc  =  " + swcSignatureChecksum));
                    }
                    return true;
                }
                return true;
            }
        }
        boolean bl = result = !this.areSwcFileChecksumsEqual();
        if (Trace.swcChecksum) {
            Trace.trace((String)("isRecompilationNeeded: " + (result ? "recompile" : "incremental compile")));
        }
        return result;
    }

    protected boolean isRelinkNeeded(int[] loadedChecksums) {
        boolean result;
        if (this.checksums[2] != loadedChecksums[2]) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"isRecompilationNeeded: calculated checksum differs from last checksum, relink");
            }
            return true;
        }
        boolean bl = result = !this.areArchiveFileChecksumsEqual();
        if (Trace.swcChecksum) {
            Trace.trace((String)("isRelinkNeeded: " + result));
        }
        return result;
    }

    private void addSignatureChecksumToData(CompilationUnit unit) {
        Long signatureChecksum = unit.getSignatureChecksum();
        if (signatureChecksum == null) {
            SwcScript script = (SwcScript)unit.getSource().getOwner();
            signatureChecksum = new Long(script.getLastModified());
        }
        if (this.swcDefSignatureChecksums != null) {
            for (QName qname : unit.topLevelDefinitions) {
                this.swcDefSignatureChecksums.put(qname, signatureChecksum);
            }
        }
    }

    private boolean areSwcFileChecksumsEqual() {
        if (this.swcFileChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: no file checksum map, not equal");
            }
            return false;
        }
        Map<String, VirtualFile> swcFiles = this.swcContext.getFiles();
        for (VirtualFile themeStyleSheet : this.swcContext.getThemeStyleSheets()) {
            swcFiles.put(themeStyleSheet.getName(), themeStyleSheet);
        }
        Set<Map.Entry<String, Long>> dataSet = this.swcFileChecksums.entrySet();
        if (swcFiles.size() < dataSet.size()) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: less files than before, not equal");
            }
            return false;
        }
        for (Map.Entry<String, Long> entry : dataSet) {
            String filename = entry.getKey();
            Long dataFileLastModified = entry.getValue();
            Long swcFileLastModified = null;
            VirtualFile swcFile = swcFiles.get(filename);
            if (swcFile != null) {
                swcFileLastModified = new Long(swcFile.getLastModified());
            }
            if (dataFileLastModified.equals(swcFileLastModified)) continue;
            if (Trace.swcChecksum) {
                Trace.trace((String)"areSwcFileChecksumsEqual: not equal");
                Trace.trace((String)("filename = " + filename));
                Trace.trace((String)("last modified1 = " + dataFileLastModified));
                Trace.trace((String)("last modified2 = " + swcFileLastModified));
            }
            return false;
        }
        if (Trace.swcChecksum) {
            Trace.trace((String)"areSwcFileChecksumsEqual: equal");
        }
        return true;
    }

    private boolean areArchiveFileChecksumsEqual() {
        if (this.swcFileChecksums == null) {
            if (Trace.swcChecksum) {
                Trace.trace((String)"areArchiveFileChecksumsEqual: no file checksum map, not equal");
            }
            return false;
        }
        Set<Map.Entry<String, Long>> dataSet = this.archiveFileChecksums.entrySet();
        for (Map.Entry<String, Long> entry : dataSet) {
            String filename = entry.getKey();
            Long dataFileLastModified = entry.getValue();
            Long localFileLastModified = null;
            LocalFile localFile = new LocalFile(new File(filename));
            localFileLastModified = new Long(localFile.getLastModified());
            if (dataFileLastModified.equals(localFileLastModified)) continue;
            if (Trace.swcChecksum) {
                Trace.trace((String)"areArchiveFileChecksumsEqual: not equal");
                Trace.trace((String)("filename = " + filename));
                Trace.trace((String)("last modified1 = " + dataFileLastModified));
                Trace.trace((String)("last modified2 = " + localFileLastModified));
            }
            return false;
        }
        if (Trace.swcChecksum) {
            Trace.trace((String)"areArchiveFileChecksumsEqual: equal");
        }
        return true;
    }

    protected int calculateChecksum() {
        int checksum = this.cfgbuf.checksum_ts();
        if (!this.isSwcChecksumEnabled || this.swcDefSignatureChecksums == null || this.swcDefSignatureChecksums.size() == 0) {
            checksum += this.swcContext.checksum();
        }
        return checksum;
    }

    protected void updateChecksum() {
        this.checksums[0] = this.calculateChecksum();
    }

    protected int[] copy() {
        int[] copy = (int[])this.checksums.clone();
        return copy;
    }

    protected int[] getChecksums() {
        return this.checksums;
    }

    protected Map<QName, Long> getSwcDefSignatureChecksums() {
        return this.swcDefSignatureChecksums;
    }

    protected Map<String, Long> getSwcFileChecksums() {
        return this.swcFileChecksums;
    }

    protected Map<String, Long> getArchiveFileChecksums() {
        return this.archiveFileChecksums;
    }
}

