/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flash.util.FileUtils;
import flash.util.StringUtils;
import flex.messaging.config.ServicesDependencies;
import flex2.compiler.as3.As3Configuration;
import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.common.FontsConfiguration;
import flex2.compiler.common.MxmlConfiguration;
import flex2.compiler.common.NamespacesConfiguration;
import flex2.compiler.config.AdvancedConfigurationInfo;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.extensions.ExtensionsConfiguration;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.asc.embedding.ConfigVar;
import macromedia.asc.util.ObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerConfiguration
implements As3Configuration,
flex2.compiler.mxml.MxmlConfiguration,
Cloneable {
    public static final String LOCALE_TOKEN = "{locale}";
    public static final String TARGET_PLAYER_MAJOR_VERSION_TOKEN = "{targetPlayerMajorVersion}";
    public static final String TARGET_PLAYER_MINOR_VERSION_TOKEN = "{targetPlayerMinorVersion}";
    private static final String[] PATH_TOKENS = new String[]{"locale"};
    public static final String STRICT = "compiler.strict";
    public static final String AS3 = "compiler.as3";
    public static final String ES = "compiler.es";
    private final Configuration parentConfiguration;
    private ConfigurationPathResolver configResolver;
    private Set<String> externs = new HashSet<String>();
    private boolean accessible;
    private String actionscriptFileEncoding = null;
    private boolean adjustOpDebugLine = true;
    private boolean allowSourcePathOverlap = false;
    public static final int AS3Dialect = 10;
    public static final int ESDialect = 9;
    private int dialect = 10;
    private ObjectList<ConfigVar> configVars = new ObjectList();
    private boolean useConservativeAlgorithm = false;
    private String contextRoot;
    private boolean debug;
    private boolean useCompression = true;
    private VirtualFile defaultsCssUrl;
    private boolean doc;
    private VirtualFile[] externalLibraryPath;
    private boolean compilingForAIR = false;
    private FontsConfiguration fontsConfig;
    private String generatedDir = null;
    private boolean headlessServer;
    private VirtualFile[] includeLibraries;
    private boolean incremental = false;
    private boolean keepAllTypeSelectors;
    private String[] as3metadata = null;
    private boolean keepGeneratedActionScript = true;
    private boolean keepGeneratedSignatures;
    private boolean enableRuntimeDesignLayers = true;
    private boolean enableSwcVersionFiltering = true;
    private VirtualFile[] libraryPath;
    private String[] locales = new String[0];
    private int factor = 1000;
    private boolean metadataExport;
    private boolean mobile = false;
    private MxmlConfiguration mxmlConfig;
    private NamespacesConfiguration namespaces;
    private boolean omitTraceStatements = true;
    private boolean optimize = false;
    private String preloader = null;
    private boolean resourceHack = false;
    private VirtualFile servicesConfigFile;
    protected ServicesDependencies servicesDependencies;
    private boolean ascWarnings;
    private boolean showBindingWarnings = true;
    private boolean showDependencyWarnings = false;
    private boolean reportInvalidStylesAsWarnings = false;
    private boolean reportMissingRequiredSkinPartsAsWarnings = false;
    private boolean showInvalidCssPropertyWarnings = true;
    private boolean showDeprecationWarnings = false;
    private boolean showShadowedDeviceFontWarnings = true;
    private boolean showUnusedTypeSelectorWarnings = true;
    private boolean disableIncrementalOptimizations = false;
    private String signatureDirectory;
    private File[] unexpandedSourcePath;
    private VirtualFile[] sourcePath;
    private Map<String, VirtualFile[]> resourceBundlePaths = new HashMap<String, VirtualFile[]>();
    private boolean strict;
    private boolean suppressWarningsInIncremental = false;
    private VirtualFile[] themeFiles;
    private Set<String> themeNames = new HashSet<String>();
    private List<VirtualFile> defaultsCssFiles = new LinkedList<VirtualFile>();
    private List<VirtualFile> themeCssFiles = new LinkedList<VirtualFile>();
    private String translationFormat;
    private boolean useResourceBundleMetadata = false;
    private boolean verboseStacktraces;
    private boolean warn_array_tostring_changes = false;
    private boolean warn_assignment_within_conditional = true;
    private boolean warn_bad_array_cast = true;
    private boolean warn_bad_bool_assignment = true;
    private boolean warn_bad_date_cast = true;
    private boolean warn_bad_es3_type_method = true;
    private boolean warn_bad_es3_type_prop = true;
    private boolean warn_bad_nan_comparison = true;
    private boolean warn_bad_null_assignment = true;
    private boolean warn_bad_null_comparison = true;
    private boolean warn_bad_undefined_comparison = true;
    private boolean warn_boolean_constructor_with_no_args = false;
    private boolean warn_changes_in_resolve = false;
    private boolean warn_class_is_sealed = false;
    private boolean warn_const_not_initialized = true;
    private boolean warn_constructor_returns_value = false;
    private boolean warn_deprecated_event_handler_error = false;
    private boolean warn_deprecated_function_error = false;
    private boolean warn_deprecated_property_error = false;
    private boolean warn_duplicate_argument_names = true;
    private boolean warn_duplicate_variable_def = true;
    private boolean warn_for_var_in_changes = false;
    private boolean warn_import_hides_class = true;
    private boolean warn_instance_of_changes = true;
    private boolean warn_internal_error = true;
    private boolean warn_level_not_supported = false;
    private boolean warn_missing_namespace_decl = true;
    private boolean warn_negative_uint_literal = true;
    private boolean warn_no_constructor = true;
    private boolean warn_no_explicit_super_call_in_constructor = false;
    private boolean warn_no_type_decl = true;
    private boolean warn_number_from_string_changes = false;
    private boolean warn_scoping_change_in_this = false;
    private boolean warn_slow_text_field_addition = true;
    private boolean warn_unlikely_function_value = true;
    private boolean warn_xml_class_has_changed = false;
    private boolean archiveClassesAndAssets = false;
    private boolean generateAbstractSyntaxTree = true;
    private ExtensionsConfiguration extensionsConfig;
    private boolean isolateStyles = true;
    private boolean allowDuplicateDefaultStyleDeclarations = false;
    private String javaProfilerClass = null;

    public CompilerConfiguration(Configuration parentConfiguration) {
        assert (parentConfiguration != null);
        this.parentConfiguration = parentConfiguration;
        this.namespaces = new NamespacesConfiguration();
        this.fontsConfig = new FontsConfiguration();
        this.fontsConfig.setCompilerConfiguration(this);
        this.mxmlConfig = new MxmlConfiguration();
        this.extensionsConfig = new ExtensionsConfiguration();
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
        this.fontsConfig.setConfigPathResolver(this.configResolver);
        this.namespaces.setConfigPathResolver(this.configResolver);
        this.mxmlConfig.setConfigPathResolver(this.configResolver);
        this.extensionsConfig.setConfigPathResolver(this.configResolver);
    }

    public static <T> Object[] merge(Object[] a, Object[] b, Class<T> klass) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Object[] arrrrray = (Object[])Array.newInstance(klass, a.length + b.length);
        System.arraycopy(a, 0, arrrrray, 0, a.length);
        System.arraycopy(b, 0, arrrrray, a.length, b.length);
        return arrrrray;
    }

    public VirtualFile[] expandTokens(String[] pathlist, String[] locales, ConfigurationValue cv) throws ConfigurationException {
        pathlist = CompilerConfiguration.expandTargetPlayerToken(pathlist, this.parentConfiguration);
        return this.expandLocaleToken(pathlist, locales, cv);
    }

    private static String[] expandTargetPlayerToken(String[] pathlist, Configuration configuration) {
        String[] processed = new String[pathlist.length];
        String targetPlayerMajorVersion = String.valueOf(configuration.getTargetPlayerMajorVersion());
        String targetPlayerMinorVersion = String.valueOf(configuration.getTargetPlayerMinorVersion());
        for (int i = 0; i < pathlist.length; ++i) {
            processed[i] = StringUtils.substitute((String)pathlist[i], (String)TARGET_PLAYER_MAJOR_VERSION_TOKEN, (String)targetPlayerMajorVersion);
            processed[i] = StringUtils.substitute((String)processed[i], (String)TARGET_PLAYER_MINOR_VERSION_TOKEN, (String)targetPlayerMinorVersion);
        }
        return processed;
    }

    private VirtualFile[] expandLocaleToken(String[] pathlist, String[] locales, ConfigurationValue cv) throws ConfigurationException {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>(pathlist.length);
        for (int i = 0; i < pathlist.length; ++i) {
            String pathElement = pathlist[i];
            int localeTokenIndex = pathElement.indexOf(LOCALE_TOKEN);
            if (localeTokenIndex != -1) {
                for (int j = 0; j < locales.length; ++j) {
                    String pathElementWithSubstitution = StringUtils.substitute((String)pathElement, (String)LOCALE_TOKEN, (String)locales[j]);
                    this.addPathElementToListAsVirtualFile(pathElementWithSubstitution, list, cv);
                }
                continue;
            }
            this.addPathElementToListAsVirtualFile(pathElement, list, cv);
        }
        VirtualFile[] vfa = new VirtualFile[list.size()];
        list.toArray(vfa);
        return vfa;
    }

    private void addPathElementToListAsVirtualFile(String pathElement, ArrayList<VirtualFile> list, ConfigurationValue cv) throws ConfigurationException {
        try {
            VirtualFile vf = this.getVirtualFile(pathElement, cv);
            list.add(vf);
        }
        catch (ConfigurationException e) {
            if (cv == null) {
                throw new ConfigurationException.CannotOpen(pathElement, null, null, -1);
            }
            throw new ConfigurationException.CannotOpen(pathElement, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    private VirtualFile[] toVirtualFileArray(String[] files, ConfigurationValue cv) throws ConfigurationException {
        VirtualFile[] vfiles = new VirtualFile[files != null ? files.length : 0];
        int length = vfiles.length;
        for (int i = 0; i < length; ++i) {
            vfiles[i] = this.getVirtualFile(files[i], cv);
        }
        return vfiles;
    }

    private VirtualFile getVirtualFile(String file, ConfigurationValue cv) throws ConfigurationException {
        return ConfigurationPathResolver.getVirtualFile(file, this.configResolver, cv);
    }

    private File[] toFileArray(String[] files) {
        File[] fileArray = new File[files != null ? files.length : 0];
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            fileArray[i] = new File(files[i]);
        }
        return fileArray;
    }

    Set<String> getExterns() {
        return this.externs;
    }

    public void addExtern(String extern) {
        this.externs.add(extern);
    }

    @Override
    public boolean accessible() {
        return this.accessible;
    }

    public void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public void cfgAccessible(ConfigurationValue cv, boolean accessible) {
        this.accessible = accessible;
    }

    public String getActionscriptFileEncoding() {
        return this.actionscriptFileEncoding;
    }

    @Override
    public String getEncoding() {
        return this.getActionscriptFileEncoding();
    }

    public void cfgActionscriptFileEncoding(ConfigurationValue cv, String encoding) {
        this.actionscriptFileEncoding = encoding;
    }

    @Override
    public boolean adjustOpDebugLine() {
        return this.adjustOpDebugLine;
    }

    public void cfgAdjustOpdebugline(ConfigurationValue cv, boolean b) {
        this.adjustOpDebugLine = b;
    }

    public static ConfigurationInfo getAdjustOpdebuglineInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public boolean allowSourcePathOverlap() {
        return this.allowSourcePathOverlap;
    }

    public void cfgAllowSourcePathOverlap(ConfigurationValue cv, boolean b) {
        this.allowSourcePathOverlap = b;
    }

    public static ConfigurationInfo getAllowSourcePathOverlapInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public int dialect() {
        return this.dialect;
    }

    public void cfgAs3(ConfigurationValue cv, boolean b) {
        this.dialect = b ? 10 : 9;
    }

    public static ConfigurationInfo getAs3Info() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public ObjectList<ConfigVar> getDefine() {
        return this.configVars;
    }

    public void cfgDefine(ConfigurationValue _cv, String _name, String _value) throws ConfigurationException {
        assert (_name != null);
        assert (_value != null);
        assert (_cv != null);
        int ns_end = _name.indexOf("::");
        if (ns_end == -1 || ns_end == 0 || ns_end == _name.length() - 2) {
            throw new ConfigurationException.BadDefinition(_name + " " + _value, _cv.getVar(), _cv.getSource(), _cv.getLine());
        }
        String ns = _name.substring(0, ns_end);
        String name = _name.substring(ns_end + 2);
        if (this.configVars == null) {
            this.configVars = new ObjectList();
        }
        Iterator iter = this.configVars.iterator();
        while (iter.hasNext()) {
            ConfigVar other = (ConfigVar)iter.next();
            if (!ns.equals(other.ns) || !name.equals(other.name)) continue;
            iter.remove();
            break;
        }
        this.configVars.add(new ConfigVar(ns, name, _value));
    }

    public static ConfigurationInfo getDefineInfo() {
        return new ConfigurationInfo(new String[]{"name", "value"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public boolean useConservativeAlgorithm() {
        return this.useConservativeAlgorithm;
    }

    public void cfgConservative(ConfigurationValue cv, boolean c) {
        this.useConservativeAlgorithm = c;
    }

    public static ConfigurationInfo getConservativeInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void cfgContextRoot(ConfigurationValue cv, String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public static ConfigurationInfo getContextRootInfo() {
        return new ConfigurationInfo(1, "context-path"){};
    }

    @Override
    public boolean debug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void cfgDebug(ConfigurationValue cv, boolean debug) {
        this.debug = debug;
    }

    public void cfgCompress(ConfigurationValue cv, boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    @Override
    public VirtualFile getDefaultsCssUrl() {
        return this.defaultsCssUrl;
    }

    public void cfgDefaultsCssUrl(ConfigurationValue cv, String defaultsCssUrlPath) throws ConfigurationException {
        this.defaultsCssUrl = ConfigurationPathResolver.getVirtualFile(defaultsCssUrlPath, this.configResolver, cv);
    }

    public static ConfigurationInfo getDefaultsCssUrlInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean doc() {
        return this.doc;
    }

    public void cfgDoc(ConfigurationValue cv, boolean doc) {
        this.doc = doc;
    }

    public static ConfigurationInfo getDocInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgEs(ConfigurationValue cv, boolean b) {
        this.dialect = b ? 9 : 10;
    }

    public static ConfigurationInfo getEsInfo() {
        return new AdvancedConfigurationInfo();
    }

    public VirtualFile[] getExternalLibraryPath() {
        return this.externalLibraryPath;
    }

    @Override
    public boolean getCompilingForAIR() {
        return this.compilingForAIR;
    }

    public void cfgExternalLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        for (int i = 0; i < pathlist.length; ++i) {
            String path = pathlist[i];
            if (!path.equals("airglobal.swc") && !path.endsWith("/airglobal.swc") && !path.endsWith("\\airglobal.swc")) continue;
            this.compilingForAIR = true;
            break;
        }
        String[] locales = this.getLocales();
        Object[] newPathElements = this.expandTokens(pathlist, locales, cv);
        this.externalLibraryPath = (VirtualFile[])CompilerConfiguration.merge(this.externalLibraryPath, newPathElements, VirtualFile.class);
    }

    public static ConfigurationInfo getExternalLibraryPathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return PATH_TOKENS;
            }

            public boolean isPath() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    @Override
    public FontsConfiguration getFontsConfiguration() {
        return this.fontsConfig;
    }

    @Override
    public void setFontsConfiguration(FontsConfiguration fc) {
        this.fontsConfig = fc;
        this.fontsConfig.setCompilerConfiguration(this);
    }

    @Override
    public String getGeneratedDirectory() {
        return this.generatedDir;
    }

    public void setGeneratedDirectory(String gd) {
        this.generatedDir = gd;
    }

    public boolean headlessServer() {
        return this.headlessServer;
    }

    public void cfgHeadlessServer(ConfigurationValue cv, boolean headlessServer) {
        this.headlessServer = headlessServer;
    }

    public static ConfigurationInfo getHeadlessServerInfo() {
        return new AdvancedConfigurationInfo();
    }

    public VirtualFile[] getIncludeLibraries() {
        return this.includeLibraries;
    }

    public void cfgIncludeLibraries(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        String[] locales = this.getLocales();
        Object[] newPathElements = this.expandTokens(pathlist, locales, cv);
        this.includeLibraries = (VirtualFile[])CompilerConfiguration.merge(this.includeLibraries, newPathElements, VirtualFile.class);
    }

    public static ConfigurationInfo getIncludeLibrariesInfo() {
        return new ConfigurationInfo(-1, new String[]{"library"}){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return PATH_TOKENS;
            }

            public boolean isPath() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    public void cfgIncremental(ConfigurationValue cv, boolean b) {
        this.incremental = b;
    }

    @Override
    public boolean keepAllTypeSelectors() {
        return this.keepAllTypeSelectors;
    }

    public void setKeepAllTypeSelectors(boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    public void cfgKeepAllTypeSelectors(ConfigurationValue cv, boolean keepAllTypeSelectors) {
        this.keepAllTypeSelectors = keepAllTypeSelectors;
    }

    public static ConfigurationInfo getKeepAllTypeSelectorsInfo() {
        return new AdvancedConfigurationInfo();
    }

    public String[] getKeepAs3Metadata() {
        return this.as3metadata;
    }

    public void cfgKeepAs3Metadata(ConfigurationValue cv, String[] md) {
        if (this.as3metadata == null) {
            this.as3metadata = md;
        } else if (md != null) {
            HashSet<String> s = new HashSet<String>(Arrays.asList(this.as3metadata));
            s.addAll(Arrays.asList(md));
            this.as3metadata = new String[s.size()];
            int k = 0;
            Iterator i = s.iterator();
            while (i.hasNext()) {
                this.as3metadata[k] = (String)i.next();
                ++k;
            }
        }
    }

    @Override
    public boolean keepEmbedMetadata() {
        if (this.as3metadata != null) {
            for (int i = 0; i < this.as3metadata.length; ++i) {
                if (!"Embed".equals(this.as3metadata[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static ConfigurationInfo getKeepAs3MetadataInfo() {
        return new ConfigurationInfo(-1, new String[]{"name"}){

            public boolean isAdvanced() {
                return true;
            }

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    @Override
    public boolean keepGeneratedActionScript() {
        return this.keepGeneratedActionScript;
    }

    public void setKeepGeneratedActionScript(boolean keepGeneratedActionScript) {
        this.keepGeneratedActionScript = keepGeneratedActionScript;
        if (keepGeneratedActionScript) {
            this.generateAbstractSyntaxTree = false;
        }
    }

    public void cfgKeepGeneratedActionscript(ConfigurationValue cv, boolean keep) {
        this.setKeepGeneratedActionScript(keep);
    }

    public static ConfigurationInfo getKeepGeneratedActionscriptInfo() {
        return new AdvancedConfigurationInfo();
    }

    public boolean getKeepGeneratedSignatures() {
        return this.keepGeneratedSignatures;
    }

    public void setKeepGeneratedSignatures(boolean keepGeneratedSignatures) {
        this.keepGeneratedSignatures = keepGeneratedSignatures;
    }

    public void cfgKeepGeneratedSignatures(ConfigurationValue cv, boolean keep) {
        this.keepGeneratedSignatures = keep;
    }

    public static ConfigurationInfo getKeepGeneratedSignaturesInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public boolean enableRuntimeDesignLayers() {
        return this.enableRuntimeDesignLayers;
    }

    public void setEnableRuntimeDesignLayers(boolean enableDesignLayers) {
        this.enableRuntimeDesignLayers = enableDesignLayers;
    }

    public void cfgEnableRuntimeDesignLayers(ConfigurationValue cv, boolean enable) {
        this.setEnableRuntimeDesignLayers(enable);
    }

    @Override
    public boolean enableSwcVersionFiltering() {
        return this.enableSwcVersionFiltering;
    }

    public void setEnableSwcVersionFiltering(boolean enableSwcFiltering) {
        this.enableSwcVersionFiltering = enableSwcFiltering;
    }

    public void cfgEnableSwcVersionFiltering(ConfigurationValue cv, boolean enable) {
        this.setEnableSwcVersionFiltering(enable);
    }

    public static ConfigurationInfo getEnableSwcVersionFilteringInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public VirtualFile[] getLibraryPath() {
        return this.libraryPath;
    }

    public void cfgLibraryPath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        String[] locales = this.getLocales();
        Object[] newPathElements = this.expandTokens(pathlist, locales, cv);
        this.libraryPath = (VirtualFile[])CompilerConfiguration.merge(this.libraryPath, newPathElements, VirtualFile.class);
    }

    public static ConfigurationInfo getLibraryPathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return PATH_TOKENS;
            }

            public boolean isPath() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public String[] getLocales() {
        return this.locales;
    }

    public String locale() {
        return this.locales.length > 0 ? this.locales[0] : null;
    }

    public void cfgLocale(ConfigurationValue cv, String[] newLocales) {
        this.locales = (String[])CompilerConfiguration.merge(newLocales, this.locales, String.class);
    }

    public static ConfigurationInfo getLocaleInfo() {
        return new ConfigurationInfo(-1, new String[]{"locale-element"}){

            public boolean allowMultiple() {
                return true;
            }
        };
    }

    public int factor() {
        return this.factor;
    }

    public void cfgMemoryUsageFactor(ConfigurationValue cv, int f) {
        this.factor = f;
    }

    public static ConfigurationInfo getMemoryUsageFactorInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public boolean metadataExport() {
        return this.metadataExport;
    }

    public void setMetadataExport(boolean metadataExport) {
        this.metadataExport = metadataExport;
    }

    public boolean getMobile() {
        return this.mobile;
    }

    public void setMobile(boolean value) {
        this.mobile = value;
    }

    public void cfgMobile(ConfigurationValue cv, boolean b) {
        this.mobile = b;
    }

    public MxmlConfiguration getMxmlConfiguration() {
        return this.mxmlConfig;
    }

    @Override
    public String getCompatibilityVersionString() {
        return this.mxmlConfig.getCompatibilityVersionString();
    }

    @Override
    public int getCompatibilityVersion() {
        return this.mxmlConfig.getCompatibilityVersion();
    }

    public String getMinimumSupportedVersionString() {
        return this.mxmlConfig.getMinimumSupportedVersionString();
    }

    public int getMinimumSupportedVersion() {
        return this.mxmlConfig.getMinimumSupportedVersion();
    }

    public void cfgMinimumSupportedVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        this.mxmlConfig.cfgMinimumSupportedVersion(cv, version);
    }

    @Override
    public boolean getQualifiedTypeSelectors() {
        return this.mxmlConfig.getQualifiedTypeSelectors();
    }

    public NamespacesConfiguration getNamespacesConfiguration() {
        return this.namespaces;
    }

    public boolean omitTraceStatements() {
        return this.omitTraceStatements;
    }

    public void cfgOmitTraceStatements(ConfigurationValue cv, boolean b) {
        this.omitTraceStatements = b;
    }

    @Override
    public boolean optimize() {
        return this.optimize;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void cfgOptimize(ConfigurationValue cv, boolean b) {
        this.optimize = b;
    }

    public String getPreloader() {
        return this.preloader;
    }

    public void cfgPreloader(ConfigurationValue cv, String value) {
        this.preloader = value;
    }

    public boolean getResourceHack() {
        return this.resourceHack;
    }

    public void cfgResourceHack(ConfigurationValue cv, boolean b) {
        this.resourceHack = b;
    }

    public static ConfigurationInfo getResourceHackInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public VirtualFile getServices() {
        return this.servicesConfigFile;
    }

    @Override
    public ServicesDependencies getServicesDependencies() {
        if (this.servicesDependencies == null && this.servicesConfigFile != null) {
            String servicesPath = this.servicesConfigFile.getName();
            this.servicesDependencies = new ServicesDependencies(servicesPath, null, this.getContextRoot());
        }
        return this.servicesDependencies;
    }

    public void setServicesDependencies(ServicesDependencies deps) {
        this.servicesDependencies = deps;
    }

    public void cfgServices(ConfigurationValue cv, String servicesPath) throws ConfigurationException {
        try {
            this.servicesConfigFile = ConfigurationPathResolver.getVirtualFile(servicesPath, this.configResolver, cv);
        }
        catch (Throwable t) {
            throw new ConfigurationException.CannotOpen(servicesPath, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public static ConfigurationInfo getServicesInfo() {
        return new ConfigurationInfo(1, "filename"){};
    }

    @Override
    public boolean warnings() {
        return this.ascWarnings;
    }

    public void cfgShowActionscriptWarnings(ConfigurationValue cv, boolean ascWarnings) {
        this.ascWarnings = ascWarnings;
    }

    @Override
    public boolean showBindingWarnings() {
        return this.showBindingWarnings;
    }

    public void cfgShowBindingWarnings(ConfigurationValue cv, boolean show) {
        this.showBindingWarnings = show;
    }

    public boolean showDependencyWarnings() {
        return this.showDependencyWarnings;
    }

    public void cfgShowDependencyWarnings(ConfigurationValue cv, boolean show) {
        this.showDependencyWarnings = show;
    }

    public static ConfigurationInfo getShowDependencyWarningsInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public boolean reportInvalidStylesAsWarnings() {
        return this.reportInvalidStylesAsWarnings;
    }

    public void setReportInvalidStylesAsWarnings(boolean reportInvalidStylesAsWarnings) {
        this.reportInvalidStylesAsWarnings = reportInvalidStylesAsWarnings;
    }

    public void cfgReportInvalidStylesAsWarnings(ConfigurationValue cv, boolean show) {
        this.reportInvalidStylesAsWarnings = show;
    }

    @Override
    public boolean reportMissingRequiredSkinPartsAsWarnings() {
        return this.reportMissingRequiredSkinPartsAsWarnings;
    }

    public void cfgReportMissingRequiredSkinPartsAsWarnings(ConfigurationValue cv, boolean b) {
        this.reportMissingRequiredSkinPartsAsWarnings = b;
    }

    public static ConfigurationInfo getReportMissingRequiredSkinPartsAsWarningsInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean showInvalidCssPropertyWarnings() {
        return this.showInvalidCssPropertyWarnings;
    }

    public void setShowInvalidCssPropertyWarnings(boolean showInvalidCssPropertyWarnings) {
        this.showInvalidCssPropertyWarnings = showInvalidCssPropertyWarnings;
    }

    public void cfgShowInvalidCssPropertyWarnings(ConfigurationValue cv, boolean show) {
        this.showInvalidCssPropertyWarnings = show;
    }

    @Override
    public boolean showDeprecationWarnings() {
        return this.showDeprecationWarnings;
    }

    public void setShowDeprecationWarnings(boolean showDeprecationWarnings) {
        this.showDeprecationWarnings = showDeprecationWarnings;
    }

    public void cfgShowDeprecationWarnings(ConfigurationValue cv, boolean show) {
        this.showDeprecationWarnings = show;
    }

    public static ConfigurationInfo getShowDeprecationWarningsInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    @Override
    public boolean showShadowedDeviceFontWarnings() {
        return this.showShadowedDeviceFontWarnings;
    }

    public void setShowShadowedDeviceFontWarnings(boolean showShadowedDeviceFontWarnings) {
        this.showShadowedDeviceFontWarnings = showShadowedDeviceFontWarnings;
    }

    public void cfgShowShadowedDeviceFontWarnings(ConfigurationValue cv, boolean show) {
        this.showShadowedDeviceFontWarnings = show;
    }

    @Override
    public boolean showUnusedTypeSelectorWarnings() {
        return this.showUnusedTypeSelectorWarnings;
    }

    public void setShowUnusedTypeSelectorWarnings(boolean showUnusedTypeSelectorWarnings) {
        this.showUnusedTypeSelectorWarnings = showUnusedTypeSelectorWarnings;
    }

    public void cfgShowUnusedTypeSelectorWarnings(ConfigurationValue cv, boolean show) {
        this.showUnusedTypeSelectorWarnings = show;
    }

    public boolean getDisableIncrementalOptimizations() {
        return this.disableIncrementalOptimizations;
    }

    public void setDisableIncrementalOptimizations(boolean disable) {
        this.disableIncrementalOptimizations = disable;
    }

    public void cfgDisableIncrementalOptimizations(ConfigurationValue cv, boolean disable) {
        this.disableIncrementalOptimizations = disable;
    }

    public static ConfigurationInfo getDisableIncrementalOptimizationsInfo() {
        return new ConfigurationInfo(){

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public String getSignatureDirectory() {
        return this.signatureDirectory;
    }

    public void setSignatureDirectory(String signatureDirectory) throws ConfigurationException {
        this.signatureDirectory = signatureDirectory;
    }

    public void cfgSignatureDirectory(ConfigurationValue cv, String path) throws ConfigurationException {
        String parent = null;
        if (cv != null) {
            parent = cv.getBuffer().getToken("com.adobe.flex.default.output.directory");
        }
        if (parent == null) {
            parent = this.configResolver.resolve(".").getNameForReporting();
        }
        File dir = !new File(path).isAbsolute() ? new File(FileUtils.addPathComponents((String)parent, (String)path, (char)File.separatorChar)) : new File(path);
        this.signatureDirectory = FileUtils.canonicalPath((File)dir);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            if (cv == null) {
                throw new ConfigurationException.NotDirectory(path, null, null, -1);
            }
            throw new ConfigurationException.NotDirectory(path, cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public static ConfigurationInfo getSignatureDirectoryInfo() {
        return new ConfigurationInfo(new String[]{"relative-directory"}){

            public boolean isPath() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void setSourcePath(VirtualFile[] sourcePath) {
        this.sourcePath = sourcePath;
    }

    public File[] getUnexpandedSourcePath() {
        return this.unexpandedSourcePath;
    }

    @Override
    public VirtualFile[] getSourcePath() {
        return this.sourcePath;
    }

    public VirtualFile[] getResourceBundlePathForLocale(String locale) {
        VirtualFile[] path = this.resourceBundlePaths.get(locale);
        return path;
    }

    public void cfgSourcePath(ConfigurationValue cv, String[] pathlist) throws ConfigurationException {
        this.unexpandedSourcePath = (File[])CompilerConfiguration.merge(this.unexpandedSourcePath, this.toFileArray(pathlist), File.class);
        String[] locales = this.getLocales();
        Object[] newPathElements = this.expandTokens(pathlist, locales, cv);
        this.checkNewSourcePathElements((VirtualFile[])newPathElements, cv);
        this.sourcePath = (VirtualFile[])CompilerConfiguration.merge(this.sourcePath, newPathElements, VirtualFile.class);
        for (int i = 0; i < locales.length; ++i) {
            String locale = locales[i];
            newPathElements = this.expandTokens(pathlist, new String[]{locale}, cv);
            this.checkNewSourcePathElements((VirtualFile[])newPathElements, cv);
            Object[] bundlePath = this.resourceBundlePaths.get(locale);
            bundlePath = (VirtualFile[])CompilerConfiguration.merge(bundlePath, newPathElements, VirtualFile.class);
            this.resourceBundlePaths.put(locale, (VirtualFile[])bundlePath);
        }
    }

    private void checkNewSourcePathElements(VirtualFile[] newPathElements, ConfigurationValue cv) throws ConfigurationException {
        for (int i = 0; i < newPathElements.length; ++i) {
            VirtualFile pathElement = newPathElements[i];
            if (pathElement.isDirectory()) continue;
            if (cv == null) {
                throw new ConfigurationException.NotDirectory(pathElement.getName(), null, null, -1);
            }
            throw new ConfigurationException.NotDirectory(pathElement.getName(), cv.getVar(), cv.getSource(), cv.getLine());
        }
    }

    public static ConfigurationInfo getSourcePathInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public String[] getSoftPrerequisites() {
                return PATH_TOKENS;
            }

            public boolean isPath() {
                return true;
            }
        };
    }

    @Override
    public boolean strict() {
        return this.strict;
    }

    public void cfgStrict(ConfigurationValue cv, boolean strict) {
        this.strict = strict;
    }

    public boolean suppressWarningsInIncremental() {
        return this.suppressWarningsInIncremental;
    }

    public void setSuppressWarningsInIncremental(boolean b) {
        this.suppressWarningsInIncremental = b;
    }

    public VirtualFile[] getThemeFiles() {
        if (this.mxmlConfig.getCompatibilityVersion() <= 0x3000000 && this.themeFiles != null && this.themeFiles.length == 1) {
            File file = new File("/themes/Spark/spark.css");
            if (this.themeFiles[0].getName().endsWith(file.getPath())) {
                String name = this.themeFiles[0].getName();
                int index = name.indexOf(file.getPath());
                this.themeFiles[0] = new LocalFile(new File(name.substring(0, index) + "/themes/Halo/halo.swc"));
                this.themeNames.remove("spark");
                this.themeNames.add("halo");
            }
        }
        return this.themeFiles;
    }

    public void cfgTheme(ConfigurationValue cv, List paths) throws ConfigurationException {
        Object[] vfa = new VirtualFile[paths.size()];
        int i = 0;
        for (String path : paths) {
            this.addThemeName(path);
            VirtualFile theme = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cv);
            if (theme == null) {
                throw new ConfigurationException.ConfigurationIOError(path, cv.getVar(), cv.getSource(), cv.getLine());
            }
            vfa[i++] = theme;
        }
        this.themeFiles = (VirtualFile[])CompilerConfiguration.merge(this.themeFiles, vfa, VirtualFile.class);
    }

    public static ConfigurationInfo getThemeInfo() {
        return new ConfigurationInfo(-1, new String[]{"filename"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    private void addThemeName(String path) {
        File file = new File(path);
        String fileName = file.getName();
        int end = fileName.indexOf("-");
        if (end == -1) {
            end = fileName.lastIndexOf(".");
        }
        if (end != -1) {
            String themeName = fileName.substring(0, end);
            this.themeNames.add(themeName);
        }
    }

    @Override
    public Set<String> getThemeNames() {
        return this.themeNames;
    }

    @Override
    public List<VirtualFile> getDefaultsCssFiles() {
        return this.defaultsCssFiles;
    }

    public void addDefaultsCssFiles(Collection<VirtualFile> files) {
        this.defaultsCssFiles.addAll(0, files);
    }

    public void cfgDefaultsCssFiles(ConfigurationValue cv, List paths) throws ConfigurationException {
        int defaultsCssFilesLastIndex = this.defaultsCssFiles.size();
        for (String path : paths) {
            VirtualFile css = ConfigurationPathResolver.getVirtualFile(path, this.configResolver, cv);
            if (css == null) {
                throw new ConfigurationException.ConfigurationIOError(path, cv.getVar(), cv.getSource(), cv.getLine());
            }
            this.defaultsCssFiles.add(defaultsCssFilesLastIndex, css);
        }
    }

    public static ConfigurationInfo getDefaultsCssFilesInfo() {
        return new ConfigurationInfo(-1, new String[]{"filename"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    @Override
    public List<VirtualFile> getThemeCssFiles() {
        return this.themeCssFiles;
    }

    public void addThemeCssFiles(List<VirtualFile> files) {
        this.themeCssFiles.addAll(files);
    }

    public String getTranslationFormat() {
        return this.translationFormat;
    }

    public void cfgTranslationFormat(ConfigurationValue cv, String t) {
        this.translationFormat = t;
    }

    public static ConfigurationInfo getTranslationFormatInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public boolean useResourceBundleMetadata() {
        return this.useResourceBundleMetadata;
    }

    public void cfgUseResourceBundleMetadata(ConfigurationValue cv, boolean b) {
        this.useResourceBundleMetadata = b;
    }

    public static ConfigurationInfo getuseResourceBundleMetadataInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean verboseStacktraces() {
        return this.verboseStacktraces;
    }

    public void setVerboseStacktraces(boolean verboseStacktraces) {
        this.verboseStacktraces = verboseStacktraces;
    }

    public void cfgVerboseStacktraces(ConfigurationValue cv, boolean verboseStacktraces) {
        this.verboseStacktraces = verboseStacktraces;
    }

    @Override
    public boolean warn_array_tostring_changes() {
        return this.warn_array_tostring_changes;
    }

    public void cfgWarnArrayTostringChanges(ConfigurationValue cv, boolean b) {
        this.warn_array_tostring_changes = b;
    }

    public static ConfigurationInfo getWarnArrayTostringChangesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_assignment_within_conditional() {
        return this.warn_assignment_within_conditional;
    }

    public void cfgWarnAssignmentWithinConditional(ConfigurationValue cv, boolean b) {
        this.warn_assignment_within_conditional = b;
    }

    public static ConfigurationInfo getWarnAssignmentWithinConditionalInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_array_cast() {
        return this.warn_bad_array_cast;
    }

    public void cfgWarnBadArrayCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_array_cast = b;
    }

    public static ConfigurationInfo getWarnBadArrayCastInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_bool_assignment() {
        return this.warn_bad_bool_assignment;
    }

    public void cfgWarnBadBoolAssignment(ConfigurationValue cv, boolean b) {
        this.warn_bad_bool_assignment = b;
    }

    public static ConfigurationInfo getWarnBadBoolAssignmentInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_date_cast() {
        return this.warn_bad_date_cast;
    }

    public void cfgWarnBadDateCast(ConfigurationValue cv, boolean b) {
        this.warn_bad_date_cast = b;
    }

    public static ConfigurationInfo getWarnBadDateCastInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_es3_type_method() {
        return this.warn_bad_es3_type_method;
    }

    public void cfgWarnBadEs3TypeMethod(ConfigurationValue cv, boolean b) {
        this.warn_bad_es3_type_method = b;
    }

    public static ConfigurationInfo getWarnBadEs3TypeMethodInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_es3_type_prop() {
        return this.warn_bad_es3_type_prop;
    }

    public void cfgWarnBadEs3TypeProp(ConfigurationValue cv, boolean b) {
        this.warn_bad_es3_type_prop = b;
    }

    public static ConfigurationInfo getWarnBadEs3TypePropInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_nan_comparison() {
        return this.warn_bad_nan_comparison;
    }

    public void cfgWarnBadNanComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_nan_comparison = b;
    }

    public static ConfigurationInfo getWarnBadNanComparisonInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_null_assignment() {
        return this.warn_bad_null_assignment;
    }

    public void cfgWarnBadNullAssignment(ConfigurationValue cv, boolean b) {
        this.warn_bad_null_assignment = b;
    }

    public static ConfigurationInfo getWarnBadNullAssignmentInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_null_comparison() {
        return this.warn_bad_null_comparison;
    }

    public void cfgWarnBadNullComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_null_comparison = b;
    }

    public static ConfigurationInfo getWarnBadNullComparisonInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_bad_undefined_comparison() {
        return this.warn_bad_undefined_comparison;
    }

    public void cfgWarnBadUndefinedComparison(ConfigurationValue cv, boolean b) {
        this.warn_bad_undefined_comparison = b;
    }

    public static ConfigurationInfo getWarnBadUndefinedComparisonInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_boolean_constructor_with_no_args() {
        return this.warn_boolean_constructor_with_no_args;
    }

    public void cfgWarnBooleanConstructorWithNoArgs(ConfigurationValue cv, boolean b) {
        this.warn_boolean_constructor_with_no_args = b;
    }

    public static ConfigurationInfo getWarnBooleanConstructorWithNoArgsInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_changes_in_resolve() {
        return this.warn_changes_in_resolve;
    }

    public void cfgWarnChangesInResolve(ConfigurationValue cv, boolean b) {
        this.warn_changes_in_resolve = b;
    }

    public static ConfigurationInfo getWarnChangesInResolveInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_class_is_sealed() {
        return this.warn_class_is_sealed;
    }

    public void cfgWarnClassIsSealed(ConfigurationValue cv, boolean b) {
        this.warn_class_is_sealed = b;
    }

    public static ConfigurationInfo getWarnClassIsSealedInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_const_not_initialized() {
        return this.warn_const_not_initialized;
    }

    public void cfgWarnConstNotInitialized(ConfigurationValue cv, boolean b) {
        this.warn_const_not_initialized = b;
    }

    public static ConfigurationInfo getWarnConstNotInitializedInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_constructor_returns_value() {
        return this.warn_constructor_returns_value;
    }

    public void cfgWarnConstructorReturnsValue(ConfigurationValue cv, boolean b) {
        this.warn_constructor_returns_value = b;
    }

    public static ConfigurationInfo getWarnConstructorReturnsValueInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_deprecated_event_handler_error() {
        return this.warn_deprecated_event_handler_error;
    }

    public void cfgWarnDeprecatedEventHandlerError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_event_handler_error = b;
    }

    public static ConfigurationInfo getWarnDeprecatedEventHandlerErrorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_deprecated_function_error() {
        return this.warn_deprecated_function_error;
    }

    public void cfgWarnDeprecatedFunctionError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_function_error = b;
    }

    public static ConfigurationInfo getWarnDeprecatedFunctionErrorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_deprecated_property_error() {
        return this.warn_deprecated_property_error;
    }

    public void cfgWarnDeprecatedPropertyError(ConfigurationValue cv, boolean b) {
        this.warn_deprecated_property_error = b;
    }

    public static ConfigurationInfo getWarnDeprecatedPropertyErrorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_duplicate_argument_names() {
        return this.warn_duplicate_argument_names;
    }

    public void cfgWarnDuplicateArgumentNames(ConfigurationValue cv, boolean b) {
        this.warn_duplicate_argument_names = b;
    }

    public static ConfigurationInfo getWarnDuplicateArgumentNamesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_duplicate_variable_def() {
        return this.warn_duplicate_variable_def;
    }

    public void cfgWarnDuplicateVariableDef(ConfigurationValue cv, boolean b) {
        this.warn_duplicate_variable_def = b;
    }

    public static ConfigurationInfo getWarnDuplicateVariableDefInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_for_var_in_changes() {
        return this.warn_for_var_in_changes;
    }

    public void cfgWarnForVarInChanges(ConfigurationValue cv, boolean b) {
        this.warn_for_var_in_changes = b;
    }

    public static ConfigurationInfo getWarnForVarInChangesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_import_hides_class() {
        return this.warn_import_hides_class;
    }

    public void cfgWarnImportHidesClass(ConfigurationValue cv, boolean b) {
        this.warn_import_hides_class = b;
    }

    public static ConfigurationInfo getWarnImportHidesClassInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_instance_of_changes() {
        return this.warn_instance_of_changes;
    }

    public void cfgWarnInstanceOfChanges(ConfigurationValue cv, boolean b) {
        this.warn_instance_of_changes = b;
    }

    public static ConfigurationInfo getWarnInstanceOfChangesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_internal_error() {
        return this.warn_internal_error;
    }

    public void cfgWarnInternalError(ConfigurationValue cv, boolean b) {
        this.warn_internal_error = b;
    }

    public static ConfigurationInfo getWarnInternalErrorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_level_not_supported() {
        return this.warn_level_not_supported;
    }

    public void cfgWarnLevelNotSupported(ConfigurationValue cv, boolean b) {
        this.warn_level_not_supported = b;
    }

    public static ConfigurationInfo getWarnLevelNotSupportedInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_missing_namespace_decl() {
        return this.warn_missing_namespace_decl;
    }

    public void cfgWarnMissingNamespaceDecl(ConfigurationValue cv, boolean b) {
        this.warn_missing_namespace_decl = b;
    }

    public static ConfigurationInfo getWarnMissingNamespaceDeclInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_negative_uint_literal() {
        return this.warn_negative_uint_literal;
    }

    public void cfgWarnNegativeUintLiteral(ConfigurationValue cv, boolean b) {
        this.warn_negative_uint_literal = b;
    }

    public static ConfigurationInfo getWarnNegativeUintLiteralInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_no_constructor() {
        return this.warn_no_constructor;
    }

    public void cfgWarnNoConstructor(ConfigurationValue cv, boolean b) {
        this.warn_no_constructor = b;
    }

    public static ConfigurationInfo getWarnNoConstructorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_no_explicit_super_call_in_constructor() {
        return this.warn_no_explicit_super_call_in_constructor;
    }

    public void cfgWarnNoExplicitSuperCallInConstructor(ConfigurationValue cv, boolean b) {
        this.warn_no_explicit_super_call_in_constructor = b;
    }

    public static ConfigurationInfo getWarnNoExplicitSuperCallInConstructorInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_no_type_decl() {
        return this.warn_no_type_decl;
    }

    public void cfgWarnNoTypeDecl(ConfigurationValue cv, boolean b) {
        this.warn_no_type_decl = b;
    }

    public static ConfigurationInfo getWarnNoTypeDeclInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_number_from_string_changes() {
        return this.warn_number_from_string_changes;
    }

    public void cfgWarnNumberFromStringChanges(ConfigurationValue cv, boolean b) {
        this.warn_number_from_string_changes = b;
    }

    public static ConfigurationInfo getWarnNumberFromStringChangesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_scoping_change_in_this() {
        return this.warn_scoping_change_in_this;
    }

    public void cfgWarnScopingChangeInThis(ConfigurationValue cv, boolean b) {
        this.warn_scoping_change_in_this = b;
    }

    public static ConfigurationInfo getWarnScopingChangeInThisInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_slow_text_field_addition() {
        return this.warn_slow_text_field_addition;
    }

    public void cfgWarnSlowTextFieldAddition(ConfigurationValue cv, boolean b) {
        this.warn_slow_text_field_addition = b;
    }

    public static ConfigurationInfo getWarnSlowTextFieldAdditionInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_unlikely_function_value() {
        return this.warn_unlikely_function_value;
    }

    public void cfgWarnUnlikelyFunctionValue(ConfigurationValue cv, boolean b) {
        this.warn_unlikely_function_value = b;
    }

    public static ConfigurationInfo getWarnUnlikelyFunctionValueInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean warn_xml_class_has_changed() {
        return this.warn_xml_class_has_changed;
    }

    public void cfgWarnXmlClassHasChanged(ConfigurationValue cv, boolean b) {
        this.warn_xml_class_has_changed = b;
    }

    public static ConfigurationInfo getWarnXmlClassHasChangedInfo() {
        return new AdvancedConfigurationInfo();
    }

    public boolean archiveClassesAndAssets() {
        return this.archiveClassesAndAssets;
    }

    public void cfgArchiveClassesAndAssets(ConfigurationValue cv, boolean b) {
        this.archiveClassesAndAssets = b;
    }

    public static ConfigurationInfo getArchiveClassesAndAssetsInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public void cfgGenerateAbstractSyntaxTree(ConfigurationValue cv, boolean b) {
        this.generateAbstractSyntaxTree = b;
    }

    @Override
    public boolean getGenerateAbstractSyntaxTree() {
        return this.generateAbstractSyntaxTree;
    }

    public static ConfigurationInfo getGenerateAbstractSyntaxTreeInfo() {
        return new ConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }

            public boolean doChecksum() {
                return false;
            }
        };
    }

    public ExtensionsConfiguration getExtensionsConfiguration() {
        return this.extensionsConfig;
    }

    public boolean getIsolateStyles() {
        return this.isolateStyles && this.getCompatibilityVersion() >= 0x4000000;
    }

    public void cfgIsolateStyles(ConfigurationValue cv, boolean isolateStyles) {
        this.isolateStyles = isolateStyles;
    }

    public static ConfigurationInfo getIsolateStylesInfo() {
        return new AdvancedConfigurationInfo();
    }

    @Override
    public boolean getAllowDuplicateDefaultStyleDeclarations() {
        if (this.getIsolateStyles()) {
            return this.allowDuplicateDefaultStyleDeclarations;
        }
        return true;
    }

    public void cfgAllowDuplicateDefaultStyleDeclarations(ConfigurationValue cv, boolean allowDuplicateDefaultStyleDeclarations) {
        this.allowDuplicateDefaultStyleDeclarations = allowDuplicateDefaultStyleDeclarations;
    }

    public static ConfigurationInfo getAllowDuplicateDefaultStyleDeclarationsInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public void cfgJavaProfilerClass(ConfigurationValue cv, String profilerClass) {
        this.javaProfilerClass = profilerClass;
    }

    public String getJavaProfilerClass() {
        return this.javaProfilerClass;
    }

    public static ConfigurationInfo getJavaProfilerClassInfo() {
        return new AdvancedConfigurationInfo(){

            public boolean isHidden() {
                return true;
            }
        };
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

