/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.abc;

import flash.util.FileUtils;
import flex2.compiler.AbstractSubCompiler;
import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerContext;
import flex2.compiler.Source;
import flex2.compiler.SubCompiler;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.AbcClass;
import flex2.compiler.as3.As3Compiler;
import flex2.compiler.as3.As3Configuration;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.SyntaxTreeEvaluator;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.css.StyleConflictException;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.Name;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbcCompiler
extends AbstractSubCompiler
implements SubCompiler {
    private static final String COMPILER_NAME = "abc";
    private String[] mimeTypes = new String[]{"application/x-actionscript-bytecode"};
    private List<Extension> compilerExtensions = new ArrayList<Extension>();

    public AbcCompiler(As3Configuration as3Configuration) {
    }

    @Override
    public String getName() {
        return COMPILER_NAME;
    }

    @Override
    public boolean isSupported(String mimeType) {
        return this.mimeTypes[0].equals(mimeType);
    }

    @Override
    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public void addCompilerExtension(Extension ext) {
        this.compilerExtensions.add(ext);
    }

    @Override
    public Source preprocess(Source source) {
        return source;
    }

    @Override
    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit;
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(1, source.getNameForReporting());
        }
        if ((unit = source.getCompilationUnit()) != null && unit.hasTypeInfo) {
            if (unit.bytes.isEmpty()) {
                AbcCompiler.copyBytecodes(source, unit);
            }
            return unit;
        }
        if (unit != null && unit.getSyntaxTree() != null) {
            return unit;
        }
        final String path = source.getName();
        ProgramNode node = null;
        CompilerContext context = new CompilerContext();
        Context cx = new Context(symbolTable.perCompileData);
        cx.setScriptName(source.getName());
        cx.setPath(source.getParent());
        cx.setEmitter(symbolTable.emitter);
        cx.setHandler(new As3Compiler.CompilerHandler(){

            public void error2(String filename, int ln, int col, Object msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.log((CompilerMessage)msg, filename);
            }

            public void warning2(String filename, int ln, int col, Object msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.log((CompilerMessage)msg, filename);
            }

            public void error(String filename, int ln, int col, String msg, String source, int errorCode) {
                String string = filename = filename == null || filename.length() == 0 ? path : filename;
                if (errorCode != -1) {
                    ThreadLocalToolkit.logError(filename, msg, errorCode);
                } else {
                    ThreadLocalToolkit.logError(filename, msg);
                }
            }

            public void warning(String filename, int ln, int col, String msg, String source, int errorCode) {
                String string = filename = filename == null || filename.length() == 0 ? path : filename;
                if (errorCode != -1) {
                    ThreadLocalToolkit.logWarning(filename, msg, errorCode);
                } else {
                    ThreadLocalToolkit.logWarning(filename, msg);
                }
            }

            public void error(String filename, int ln, int col, String msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.logError(filename, msg);
            }

            public void warning(String filename, int ln, int col, String msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.logWarning(filename, msg);
            }

            public CompilerHandler.FileInclude findFileInclude(String parentPath, String filespec) {
                return null;
            }
        });
        symbolTable.perCompileData.handler = cx.getHandler();
        context.setAscContext(cx);
        byte[] abc = null;
        try {
            abc = source.toByteArray();
            if (abc == null) {
                abc = FileUtils.toByteArray((InputStream)source.getInputStream());
            }
            if (abc == null || abc.length == 0) {
                ThreadLocalToolkit.log((CompilerMessage)new NoBytecodeIsAvailable(), source);
            } else {
                AbcParser parser = new AbcParser(cx, abc);
                node = parser.parseAbc();
                if (node == null && ThreadLocalToolkit.errorCount() == 0) {
                    ThreadLocalToolkit.log((CompilerMessage)new BytecodeDecodingFailed(), source);
                }
                As3Compiler.cleanNodeFactory(cx.getNodeFactory());
            }
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(source.getNameForReporting(), ex.getLocalizedMessage());
        }
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        if (unit == null) {
            unit = source.newCompilationUnit(node, context);
        } else {
            unit.setSyntaxTree(node);
            unit.getContext().setAttributes(context);
        }
        unit.bytes.set(abc, abc.length);
        SyntaxTreeEvaluator treeEvaluator = new SyntaxTreeEvaluator(unit);
        treeEvaluator.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
        node.evaluate(cx, treeEvaluator);
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).parse1(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return null;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(1);
        }
        return unit;
    }

    @Override
    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(2, unit.getSource().getNameForReporting());
        }
        if (unit.hasTypeInfo) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).parse2(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(2);
        }
    }

    @Override
    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(3, unit.getSource().getNameForReporting());
        }
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        if (node.state != 1) {
            return;
        }
        CompilerContext context = unit.getContext();
        Context cx = context.getAscContext();
        symbolTable.perCompileData.handler = cx.getHandler();
        ObjectValue global = new ObjectValue(cx, new GlobalBuilder(), null);
        cx.pushScope(global);
        FlowGraphEmitter flowem = new FlowGraphEmitter(cx, unit.getSource().getName(), false);
        FlowAnalyzer flower = new FlowAnalyzer(flowem);
        context.setAttribute("FlowAnalyzer", flower);
        node.evaluate(cx, flower);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        unit.typeInfo = node.frame;
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).analyze1(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(3);
        }
    }

    @Override
    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(4, unit.getSource().getNameForReporting());
        }
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        if (node.state != 2) {
            return;
        }
        CompilerContext context = unit.getContext();
        Context cx = context.getAscContext();
        symbolTable.perCompileData.handler = cx.getHandler();
        FlowAnalyzer flower = (FlowAnalyzer)context.getAttribute("FlowAnalyzer");
        context.setAttribute("processed", new HashSet(15));
        this.inheritSlots(unit, unit.inheritance, symbolTable);
        this.inheritSlots(unit, unit.namespaces, symbolTable);
        cx.pushScope(node.frame);
        node.evaluate(cx, flower);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).analyze2(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(4);
        }
    }

    @Override
    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(5, unit.getSource().getNameForReporting());
        }
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        CompilerContext context = unit.getContext();
        Context cx = context.getAscContext();
        symbolTable.perCompileData.handler = cx.getHandler();
        this.inheritSlots(unit, unit.types, symbolTable);
        this.inheritSlots(unit, unit.namespaces, symbolTable);
        cx.pushScope(node.frame);
        ConstantEvaluator analyzer = new ConstantEvaluator(cx);
        analyzer.PreprocessDefinitionTypeInfo(cx, node);
        cx.popScope();
        context.setAttribute("ConstantEvaluator", analyzer);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).analyze3(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(5);
        }
    }

    @Override
    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(6, unit.getSource().getNameForReporting());
        }
        TypeTable typeTable = null;
        if (symbolTable != null && (typeTable = (TypeTable)symbolTable.getContext().getAttribute(As3Compiler.AttrTypeTable)) == null) {
            typeTable = new TypeTable(symbolTable);
            symbolTable.getContext().setAttribute(As3Compiler.AttrTypeTable, typeTable);
        }
        if (unit.hasTypeInfo) {
            for (Map.Entry<String, AbcClass> entry : unit.classTable.entrySet()) {
                AbcClass c = entry.getValue();
                c.setTypeTable(typeTable);
                symbolTable.registerClass(entry.getKey(), c);
            }
            try {
                symbolTable.registerStyles(unit.styles);
            }
            catch (StyleConflictException e) {
                ThreadLocalToolkit.logError(unit.getSource().getNameForReporting(), e.getLocalizedMessage());
            }
            As3Compiler.evaluateLoaderClassBase(unit, typeTable);
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        CompilerContext context = unit.getContext();
        Context cx = context.getAscContext();
        symbolTable.perCompileData.handler = cx.getHandler();
        cx.pushScope(node.frame);
        ConstantEvaluator analyzer = (ConstantEvaluator)context.removeAttribute("ConstantEvaluator");
        node.evaluate(cx, analyzer);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        if (symbolTable != null) {
            Map<String, AbcClass> classMap = typeTable.createClasses(node.clsdefs, unit.topLevelDefinitions);
            for (String className : classMap.keySet()) {
                AbcClass c = classMap.get(className);
                symbolTable.registerClass(className, c);
                unit.classTable.put(className, c);
            }
            try {
                symbolTable.registerStyles(unit.styles);
            }
            catch (StyleConflictException e) {
                ThreadLocalToolkit.logError(unit.getSource().getNameForReporting(), e.getLocalizedMessage());
            }
            As3Compiler.evaluateLoaderClassBase(unit, typeTable);
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).analyze4(unit, typeTable);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(6);
        }
    }

    @Override
    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.startPhase(7, unit.getSource().getNameForReporting());
        }
        if (unit.hasTypeInfo) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            this.compilerExtensions.get(i).generate(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        Context cx = unit.getContext().removeAscContext();
        As3Compiler.cleanSlots(unit.typeInfo, cx, unit.topLevelDefinitions);
        cx.setHandler(null);
        if (this.benchmarkHelper != null) {
            this.benchmarkHelper.endPhase(7);
        }
    }

    @Override
    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    private void inheritSlots(CompilationUnit unit, Set<Name> types, SymbolTable symbolTable) {
        CompilerContext context = unit.getContext();
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        Context cx = context.getAscContext();
        Set processed = (Set)context.getAttribute("processed");
        for (Name name : types) {
            ObjectValue frame;
            QName qName;
            Source s;
            CompilationUnit u;
            if (!(name instanceof QName) || unit == (u = (s = symbolTable.findSourceByQName(qName = (QName)name)).getCompilationUnit()) || (frame = u.typeInfo) == null || processed.contains(s.getName())) continue;
            FlowAnalyzer.inheritContextSlots(frame, node.frame, node.frame.builder, cx);
            processed.add(s.getName());
        }
    }

    public static void copyBytecodes(Source source, CompilationUnit unit) {
        try {
            byte[] abc = source.toByteArray();
            if (abc == null) {
                abc = FileUtils.toByteArray((InputStream)source.getInputStream());
            }
            if (abc == null || abc.length == 0) {
                ThreadLocalToolkit.log((CompilerMessage)new NoBytecodeIsAvailable(), source);
            } else {
                unit.bytes.set(abc, abc.length);
            }
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(source.getNameForReporting(), ex.getLocalizedMessage());
        }
    }

    static {
        TypeValue.init();
        ObjectValue.init();
    }

    public static class BytecodeDecodingFailed
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -4085468421158774443L;
    }

    public static class NoBytecodeIsAvailable
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 2620612567115987550L;
    }
}

