/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeIdItem
extends Item<TypeIdItem> {
    private StringIdItem typeDescriptor;

    protected TypeIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private TypeIdItem(DexFile dexFile, StringIdItem typeDescriptor) {
        super(dexFile);
        this.typeDescriptor = typeDescriptor;
    }

    public static TypeIdItem internTypeIdItem(DexFile dexFile, StringIdItem typeDescriptor) {
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, typeDescriptor);
        return dexFile.TypeIdsSection.intern(typeIdItem);
    }

    public static TypeIdItem internTypeIdItem(DexFile dexFile, String typeDescriptor) {
        StringIdItem stringIdItem = StringIdItem.internStringIdItem(dexFile, typeDescriptor);
        if (stringIdItem == null) {
            return null;
        }
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, stringIdItem);
        return dexFile.TypeIdsSection.intern(typeIdItem);
    }

    public static TypeIdItem lookupTypeIdItem(DexFile dexFile, String typeDescriptor) {
        StringIdItem stringIdItem = StringIdItem.lookupStringIdItem(dexFile, typeDescriptor);
        if (stringIdItem == null) {
            return null;
        }
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, stringIdItem);
        return dexFile.TypeIdsSection.getInternedItem(typeIdItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        int stringIdIndex = in.readInt();
        this.typeDescriptor = this.dexFile.StringIdsSection.getItemByIndex(stringIdIndex);
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, this.typeDescriptor.getConciseIdentity());
        }
        out.writeInt(this.typeDescriptor.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_TYPE_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "type_id_item: " + this.getTypeDescriptor();
    }

    @Override
    public int compareTo(TypeIdItem o) {
        return this.typeDescriptor.compareTo(o.typeDescriptor);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor.getStringValue();
    }

    public String toShorty() {
        String type = this.getTypeDescriptor();
        if (type.length() > 1) {
            return "L";
        }
        return type;
    }

    public int getRegisterCount() {
        String type = this.getTypeDescriptor();
        if (type.charAt(0) == 'J' || type.charAt(0) == 'D') {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        return this.typeDescriptor.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        TypeIdItem other = (TypeIdItem)o;
        return this.typeDescriptor == other.typeDescriptor;
    }
}

