/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.SortedMap;

public class CharsetUtils {
    public static final String LOG_TAG = CharsetUtils.class.toString();
    public static final char[] EMPTY_CARRAY = new char[0];
    public static final byte[] EMPTY_BARRAY = new byte[0];

    public static byte[] utf16ToUtf8(char[] cArray) {
        byte[] byArray;
        try {
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder charsetEncoder = charset.newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(cArray));
            byArray = byteBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_BARRAY;
        }
        if (null == byArray) {
            return EMPTY_BARRAY;
        }
        return byArray;
    }

    public static char[] mbcsToUtf16(byte[] byArray) {
        char[] cArray;
        try {
            Charset charset = Charset.forName("ISO-8859-1");
            CharsetDecoder charsetDecoder = charset.newDecoder();
            CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
            cArray = charBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_CARRAY;
        }
        if (null == cArray) {
            return EMPTY_CARRAY;
        }
        return cArray;
    }

    public static byte[] mbcsToUtf8(byte[] byArray) {
        char[] cArray = CharsetUtils.mbcsToUtf16(byArray);
        byte[] byArray2 = CharsetUtils.utf16ToUtf8(cArray);
        return byArray2;
    }

    public static CharBuffer DecodeBuffer(byte[] byArray, String string) throws CharacterCodingException {
        Charset charset = Charset.forName(string);
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return charsetDecoder.decode(ByteBuffer.wrap(byArray));
    }

    public static byte[] ConvertMBCStoUTF16(byte[] byArray, String string) {
        try {
            CharBuffer charBuffer = CharsetUtils.DecodeBuffer(byArray, string);
            Charset charset = Charset.forName("UTF-16LE");
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            return byteBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_BARRAY;
        }
    }

    public static byte[] ConvertUTF16toMBCS(byte[] byArray, String string) {
        try {
            CharBuffer charBuffer = CharsetUtils.DecodeBuffer(byArray, "UTF-16LE");
            Charset charset = Charset.forName(string);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            return byteBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_BARRAY;
        }
    }

    public static byte[] ConvertUTF8toMBCS(byte[] byArray, String string) {
        byte[] byArray2;
        try {
            CharBuffer charBuffer = CharsetUtils.DecodeBuffer(byArray, "UTF-8");
            Charset charset = Charset.forName(string);
            CharsetEncoder charsetEncoder = charset.newEncoder();
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            byArray2 = byteBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_BARRAY;
        }
        return byArray2;
    }

    public static byte[] ConvertMBCStoUTF8(byte[] byArray, String string) {
        byte[] byArray2;
        try {
            CharBuffer charBuffer = CharsetUtils.DecodeBuffer(byArray, string);
            Charset charset = Charset.forName("UTF-8");
            CharsetEncoder charsetEncoder = charset.newEncoder();
            ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
            byArray2 = byteBuffer.array();
        }
        catch (Exception exception) {
            return EMPTY_BARRAY;
        }
        return byArray2;
    }

    public static String QueryAvailableCharsets() {
        String string = "";
        SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
        for (String string2 : sortedMap.keySet()) {
            string = string + string2 + " ";
        }
        return string;
    }
}

