/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.telephony;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import com.adobe.air.telephony.AndroidPhoneStateListener;

public class AndroidTelephonyManager {
    private static AndroidTelephonyManager sAndroidTelephonyManager = null;
    private Context mContext = null;
    private AndroidPhoneStateListener mPhoneStateListener = null;
    private TelephonyManager mTelephonyMgr = null;
    private boolean mListening = false;

    public static AndroidTelephonyManager CreateAndroidTelephonyManager(Context context) {
        if (sAndroidTelephonyManager == null) {
            sAndroidTelephonyManager = new AndroidTelephonyManager(context);
        }
        return sAndroidTelephonyManager;
    }

    public static AndroidTelephonyManager GetAndroidTelephonyManager() {
        return sAndroidTelephonyManager;
    }

    private AndroidTelephonyManager(Context context) {
        this.mContext = context;
        if (this.mContext != null) {
            this.mTelephonyMgr = (TelephonyManager)this.mContext.getSystemService("phone");
        }
    }

    public void listen(boolean bl) {
        if (this.mTelephonyMgr == null) {
            return;
        }
        try {
            if (bl && !this.mListening) {
                if (this.mPhoneStateListener == null) {
                    this.mPhoneStateListener = new AndroidPhoneStateListener();
                }
                this.mTelephonyMgr.listen((PhoneStateListener)this.mPhoneStateListener, 32);
                this.mListening = true;
                this.mPhoneStateListener.onCallStateChanged(this.mTelephonyMgr.getCallState(), "0");
            } else if (!bl && this.mListening && this.mPhoneStateListener != null) {
                this.mTelephonyMgr.listen((PhoneStateListener)this.mPhoneStateListener, 0);
                this.mPhoneStateListener = null;
                this.mListening = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

