/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.format.Formatter;
import com.adobe.air.net.InterfaceAddress;
import com.adobe.air.net.NetworkInterface;
import java.util.Vector;

class AndroidNetworkInfo {
    private static final String LOG_TAG = "AndroidNetworkInfo";
    private static AndroidNetworkInfo sAndroidNetworkInfo = null;
    private Context mContext;
    private Vector<NetworkInterface> mInterfaces;

    public static AndroidNetworkInfo GetAndroidNetworkInfo(Context context) {
        if (sAndroidNetworkInfo == null) {
            sAndroidNetworkInfo = new AndroidNetworkInfo(context);
        }
        return sAndroidNetworkInfo;
    }

    private AndroidNetworkInfo(Context context) {
        this.mContext = context;
        this.mInterfaces = new Vector();
    }

    public int GetNetworkInterfacesCount() {
        this.mInterfaces.clear();
        this.enumerateNetworkInterfaces();
        return this.mInterfaces.size();
    }

    public void InterfacesReadComplete() {
        this.mInterfaces.clear();
    }

    private void enumerateNetworkInterfaces() {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            NetworkInfo[] networkInfoArray = connectivityManager.getAllNetworkInfo();
            for (int i = 0; i < networkInfoArray.length; ++i) {
                NetworkInterface networkInterface = null;
                NetworkInfo networkInfo = networkInfoArray[i];
                switch (networkInfo.getType()) {
                    case 1: {
                        networkInterface = this.getWifiData(networkInfo);
                        break;
                    }
                    default: {
                        networkInterface = this.getDefaultData(networkInfo);
                    }
                }
                this.mInterfaces.add(networkInterface);
            }
        }
        catch (Exception exception) {
            this.mInterfaces.clear();
        }
    }

    public NetworkInterface GetNetworkInterface(int n) {
        if (n < 0 || n >= this.mInterfaces.size()) {
            return null;
        }
        return this.mInterfaces.elementAt(n);
    }

    NetworkInterface getWifiData(NetworkInfo networkInfo) {
        Object object;
        WifiInfo wifiInfo;
        NetworkInterface networkInterface = new NetworkInterface();
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        if (wifiManager == null) {
            // empty if block
        }
        if ((wifiInfo = wifiManager.getConnectionInfo()) == null) {
            // empty if block
        }
        networkInterface.active = networkInfo.isConnected();
        networkInterface.displayName = networkInfo.getTypeName();
        networkInterface.name = networkInfo.getTypeName();
        if (wifiInfo != null) {
            object = wifiInfo.getMacAddress();
            if (object == null) {
                object = "";
            }
            networkInterface.hardwareAddress = object;
        }
        object = this.getAddress(networkInfo);
        networkInterface.addAddress((InterfaceAddress)object);
        return networkInterface;
    }

    NetworkInterface getDefaultData(NetworkInfo networkInfo) {
        NetworkInterface networkInterface = new NetworkInterface();
        networkInterface.active = networkInfo.isConnected();
        networkInterface.displayName = networkInfo.getTypeName();
        networkInterface.name = networkInfo.getTypeName();
        return networkInterface;
    }

    InterfaceAddress getAddress(NetworkInfo networkInfo) {
        InterfaceAddress interfaceAddress = new InterfaceAddress();
        if (!networkInfo.isConnected()) {
            return null;
        }
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        if (wifiManager == null) {
            return null;
        }
        DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
        if (dhcpInfo != null) {
            interfaceAddress.address = Formatter.formatIpAddress((int)dhcpInfo.ipAddress);
            interfaceAddress.prefixLength = Integer.bitCount(dhcpInfo.netmask);
            interfaceAddress.broadcast = Formatter.formatIpAddress((int)(dhcpInfo.ipAddress | ~dhcpInfo.netmask));
            interfaceAddress.ipVersion = "IPv4";
        } else {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            if (wifiInfo == null) {
                return null;
            }
            interfaceAddress.address = Formatter.formatIpAddress((int)wifiInfo.getIpAddress());
            interfaceAddress.ipVersion = "IPv4";
        }
        return interfaceAddress;
    }
}

