/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.microphone;

import android.media.AudioRecord;
import android.os.Process;

public class AIRMicrophoneRecorder
implements Runnable {
    private byte[] mMicBuffer;
    private int m_audioSource = 0;
    private int m_sampleRate = 0;
    private int m_channelConfiguration = 0;
    private int m_audioFormat = 0;
    private int m_bufferSize = 0;
    private volatile boolean m_isPaused;
    private volatile boolean m_isRecording;
    private AudioRecord m_recorder;
    private final Object mutex = new Object();

    public AIRMicrophoneRecorder(int n, int n2, int n3, int n4, int n5) {
        this.m_audioSource = n;
        this.m_sampleRate = n2;
        this.m_channelConfiguration = n3;
        this.m_audioFormat = n4;
        this.m_bufferSize = n5;
        this.mMicBuffer = new byte[this.m_bufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.mutex;
        synchronized (object) {
            while (!this.isRecording()) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IllegalStateException("Wait interrupted", interruptedException);
                }
            }
        }
        Process.setThreadPriority((int)-19);
        if (this.m_recorder != null) {
            try {
                this.m_recorder.startRecording();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public Boolean Open() {
        int n = AudioRecord.getMinBufferSize((int)this.m_sampleRate, (int)this.m_channelConfiguration, (int)this.m_audioFormat);
        n = this.m_bufferSize > n ? this.m_bufferSize : (n *= 2);
        try {
            this.m_recorder = new AudioRecord(this.m_audioSource, this.m_sampleRate, this.m_channelConfiguration, this.m_audioFormat, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        if (this.m_recorder != null && this.m_recorder.getState() == 1) {
            return true;
        }
        return false;
    }

    public byte[] getBuffer() {
        int n = this.m_recorder.read(this.mMicBuffer, 0, this.m_bufferSize);
        if (n == -3) {
            throw new IllegalStateException("read() returned AudioRecord.ERROR_INVALID_OPERATION");
        }
        if (n == -2) {
            throw new IllegalStateException("read() returned AudioRecord.ERROR_BAD_VALUE");
        }
        if (n == -3) {
            throw new IllegalStateException("read() returned AudioRecord.ERROR_INVALID_OPERATION");
        }
        return this.mMicBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecording(boolean bl) {
        Object object = this.mutex;
        synchronized (object) {
            this.m_isRecording = bl;
            if (this.m_isRecording) {
                this.mutex.notify();
            } else {
                if (this.m_recorder.getState() == 1) {
                    this.m_recorder.stop();
                }
                this.m_recorder.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        Object object = this.mutex;
        synchronized (object) {
            return this.m_isRecording;
        }
    }
}

