/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.text.format.Time;
import com.adobe.air.location.AIRLocationListener;

public class Geolocation {
    private LocationManager mLocationManager;
    private AIRLocationListener mGPSListener;
    private AIRLocationListener mNetworkListener;
    protected double m_latitude;
    protected double m_longitude;
    protected double m_altitude;
    protected float m_horizontalAaccuracy;
    protected float m_verticalAccuracy;
    protected float m_speed;
    protected long m_timestamp;
    protected double m_gpsLatitude;
    protected double m_gpsLongitude;
    protected double m_gpsAltitude;
    protected float m_gpsHorizontalAaccuracy;
    protected float m_gpsVerticalAccuracy;
    protected float m_gpsSpeed;
    protected long m_gpsTimestamp;
    protected double m_networkLatitude;
    protected double m_networkLongitude;
    protected double m_networkAltitude;
    protected float m_networkHorizontalAaccuracy;
    protected float m_networkVerticalAccuracy;
    protected float m_networkSpeed;
    protected long m_networkTimestamp;
    protected boolean m_isGPSProviderEnabled;
    protected boolean m_isNetworkProviderEnabled;
    protected Time m_currentTime;
    protected boolean m_ignoreLastGPSValue;
    protected long m_objectPointer;
    protected boolean m_EventSourceExists;
    private Context m_context;
    private long m_upateInterval;

    public boolean isGeolocationMuted() {
        return !this.m_isGPSProviderEnabled && !this.m_isNetworkProviderEnabled;
    }

    public void setGeolocationEventSource(long l) {
        try {
            this.m_objectPointer = l;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUpdateTimeAndRegister(long l, long l2) {
        try {
            this.m_objectPointer = l2;
            this.m_upateInterval = l;
            this.addLocationListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void releaseAllResources() {
        this.m_EventSourceExists = false;
        this.removeLocationListeners();
    }

    protected void addLocationListeners() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location")) {
            this.addGPSListener();
            this.addNetworkListener();
        }
    }

    protected void removeLocationListeners() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location")) {
            this.removeGPSListener();
            this.removeNetworkListener();
        }
    }

    protected void addGPSListener() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location.gps")) {
            Location location = this.mLocationManager.getLastKnownLocation("gps");
            this.mGPSListener.onLocationChanged(location);
            this.mLocationManager.requestLocationUpdates("gps", this.m_upateInterval, 0.0f, (LocationListener)this.mGPSListener);
        }
    }

    protected void removeGPSListener() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location.gps")) {
            this.mLocationManager.removeUpdates((LocationListener)this.mGPSListener);
        }
    }

    protected void addNetworkListener() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location.network")) {
            this.mLocationManager.requestLocationUpdates("network", this.m_upateInterval, 0.0f, (LocationListener)this.mNetworkListener);
        }
    }

    protected void removeNetworkListener() {
        if (this.m_context.getPackageManager().hasSystemFeature("android.hardware.location.network")) {
            this.mLocationManager.removeUpdates((LocationListener)this.mNetworkListener);
        }
    }

    public Geolocation(Context context) {
        try {
            this.m_context = context;
            this.m_EventSourceExists = true;
            this.mGPSListener = new AIRLocationListener(this);
            this.mNetworkListener = new AIRLocationListener(this);
            this.mLocationManager = (LocationManager)this.m_context.getSystemService("location");
            this.m_isGPSProviderEnabled = this.mLocationManager.isProviderEnabled("gps");
            this.m_isNetworkProviderEnabled = this.mLocationManager.isProviderEnabled("network");
            this.m_currentTime = new Time();
            this.m_currentTime.setToNow();
            this.m_ignoreLastGPSValue = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected native void setGeolocationStatus(boolean var1, long var2);

    protected native void updateGeolocationCache(long var1);
}

