/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air.gestures;

import android.content.Context;
import android.os.Build;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.SystemCapabilities;

public class AIRGestureListener
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final String LOG_TAG = "AIRGestureListener";
    private static final int kGestureUpdate = 1;
    private static final int kGestureBegin = 2;
    private static final int kGestureEnd = 4;
    private static final int kGestureAll = 8;
    private static final int kGestureZoom = 0;
    private static final int kGesturePan = 1;
    private static final int kGestureRotate = 2;
    private static final int kGestureTwoFingerTap = 3;
    private static final int kGestureSwipe = 5;
    private static final int MAX_TOUCH_POINTS = 2;
    private static final float _FP_GESTURE_ROTATION_THRESHOLD_DEGREES = 15.0f;
    private static final float _FP_GESTURE_SWIPE_PRIMARY_AXIS_MIN_MM = 10.0f;
    private static final float _FP_GESTURE_SWIPE_SECONDARY_AXIS_MAX_MM = 5.0f;
    private static final float _FP_GESTURE_ZOOM_THRESHOLD_MM = 8.0f;
    private static final float _FP_GESTURE_ZOOM_PER_AXIS_THRESHOLD_MM = 3.0f;
    private static final float _FP_GESTURE_PAN_THRESHOLD_MM = 3.0f;
    private static final float MM_PER_INCH = 25.4f;
    private static int screenPPI = 0;
    private TouchPoint[] mDownTouchPoints;
    private float mPreviousAbsoluteRotation = 0.0f;
    private boolean mInRotateTransformGesture = false;
    private boolean mInZoomTransformGesture = false;
    private boolean mInZoomTransformGestureX = false;
    private boolean mInZoomTransformGestureY = false;
    private boolean mInPanTransformGesture = false;
    private float mPreviousRotateLocX = 0.0f;
    private float mPreviousRotateLocY = 0.0f;
    private float mPreviousZoomLocX = 0.0f;
    private float mPreviousZoomLocY = 0.0f;
    private float mPreviousPanLocX = 0.0f;
    private float mPreviousPanLocY = 0.0f;
    private AIRWindowSurfaceView mSurfaceView;
    private int mCouldBeTwoFingerTap = 0;
    private TouchPoint mSecondaryPointOfTwoFingerTap;
    private boolean mCheckForSwipe = true;

    private native boolean nativeOnGestureListener(int var1, int var2, boolean var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10);

    public AIRGestureListener(Context context, AIRWindowSurfaceView aIRWindowSurfaceView) {
        this.mSurfaceView = aIRWindowSurfaceView;
        this.mDownTouchPoints = new TouchPoint[2];
        for (int i = 0; i < 2; ++i) {
            this.mDownTouchPoints[i] = new TouchPoint();
        }
        this.mSecondaryPointOfTwoFingerTap = new TouchPoint();
        screenPPI = SystemCapabilities.GetScreenDPI(context);
    }

    public TouchPoint getDownTouchPoint(int n) {
        if (n >= 0 && n < 2) {
            return this.mDownTouchPoints[n];
        }
        return null;
    }

    public void setDownTouchPoint(float f, float f2, int n) {
        if (n >= 0 && n < 2) {
            this.mDownTouchPoints[n].assign(f, f2, n);
        }
    }

    public void setCouldBeTwoFingerTap(int n) {
        this.mCouldBeTwoFingerTap = n;
    }

    public int getCouldBeTwoFingerTap() {
        return this.mCouldBeTwoFingerTap;
    }

    public void setSecondaryPointOfTwoFingerTap(TouchPoint touchPoint) {
        this.mSecondaryPointOfTwoFingerTap = touchPoint;
    }

    public void mayStartNewTransformGesture() {
        this.mInRotateTransformGesture = false;
        this.mInZoomTransformGesture = false;
        this.mInZoomTransformGestureX = false;
        this.mInZoomTransformGestureY = false;
        this.mInPanTransformGesture = false;
    }

    public boolean getCheckForSwipe() {
        return this.mCheckForSwipe;
    }

    public void setCheckForSwipe(boolean bl) {
        this.mCheckForSwipe = bl;
    }

    public boolean endTwoFingerGesture() {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return true;
        }
        this.endRotateGesture();
        this.endPanGesture();
        return true;
    }

    private void endRotateGesture() {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return;
        }
        if (this.mInRotateTransformGesture) {
            int n = 4;
            int n2 = 2;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            f = this.mPreviousRotateLocX;
            f2 = this.mPreviousRotateLocY;
            this.nativeOnGestureListener(n, n2, true, f, f2, f3, f4, f5, f6, f7);
            this.mInRotateTransformGesture = false;
        }
    }

    private void endZoomGesture() {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return;
        }
        if (this.mInZoomTransformGesture) {
            int n = 4;
            int n2 = 0;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            f = this.mPreviousZoomLocX;
            f2 = this.mPreviousZoomLocY;
            this.nativeOnGestureListener(n, n2, true, f, f2, f3, f4, f5, f6, f7);
            this.mInZoomTransformGesture = false;
            this.mInZoomTransformGestureX = false;
            this.mInZoomTransformGestureY = false;
        }
    }

    private void endPanGesture() {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return;
        }
        if (this.mInPanTransformGesture) {
            int n = 4;
            int n2 = 1;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            float f4 = 1.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            f = this.mPreviousPanLocX;
            f2 = this.mPreviousPanLocY;
            this.nativeOnGestureListener(n, n2, true, f, f2, f3, f4, f5, f6, f7);
            this.mInPanTransformGesture = false;
        }
    }

    public boolean onDown(MotionEvent motionEvent) {
        return true;
    }

    public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        return true;
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
        int n;
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return true;
        }
        int n2 = 2;
        int n3 = 2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 1.0f;
        float f6 = 1.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        if (motionEvent2.getPointerCount() == 2) {
            int n4;
            n2 = 1;
            f3 = (motionEvent2.getX(0) + motionEvent2.getX(1)) / 2.0f;
            f4 = (motionEvent2.getY(0) + motionEvent2.getY(1)) / 2.0f;
            TouchPoint[] touchPointArray = new TouchPoint[2];
            for (n4 = 0; n4 < 2; ++n4) {
                touchPointArray[n4] = new TouchPoint(motionEvent2.getX(n4), motionEvent2.getY(n4), motionEvent2.getPointerId(n4));
            }
            n4 = touchPointArray[0].pid;
            int n5 = touchPointArray[1].pid;
            if (n4 >= 0 && n4 < 2 && n5 >= 0 && n5 < 2) {
                if (!this.mInPanTransformGesture) {
                    float f10 = this.getRotation(this.mDownTouchPoints[n4], this.mDownTouchPoints[n5], touchPointArray[0], touchPointArray[1]);
                    if (Math.abs(f10) > 180.0f) {
                        float f11 = f10 = f10 > 0.0f ? (360.0f - f10) * -1.0f : 360.0f + f10;
                    }
                    if (this.mInRotateTransformGesture || Math.abs(f10) > 15.0f) {
                        n3 = 2;
                        if (!this.mInRotateTransformGesture) {
                            n2 = 2;
                            this.mInRotateTransformGesture = true;
                            this.mPreviousAbsoluteRotation = 0.0f;
                        }
                        if (Math.abs(f7 = f10 - this.mPreviousAbsoluteRotation) > 180.0f) {
                            f7 = f7 > 0.0f ? (360.0f - f7) * -1.0f : 360.0f + f7;
                        }
                        this.mPreviousAbsoluteRotation = f10;
                        this.mPreviousRotateLocX = f3;
                        this.mPreviousRotateLocY = f4;
                        this.nativeOnGestureListener(n2, n3, true, f3, f4, f5, f6, f7, f8, f9);
                        f7 = 0.0f;
                    }
                }
                if (!this.mInZoomTransformGesture && !this.mInRotateTransformGesture) {
                    if (this.isPanGesture(this.mDownTouchPoints[n4], this.mDownTouchPoints[n5], touchPointArray[0], touchPointArray[1])) {
                        n3 = 1;
                        if (!this.mInPanTransformGesture) {
                            n2 = 2;
                            this.mInPanTransformGesture = true;
                        }
                        f8 = -1.0f * f;
                        f9 = -1.0f * f2;
                        this.mPreviousPanLocX = f3;
                        this.mPreviousPanLocY = f4;
                        this.nativeOnGestureListener(n2, n3, true, f3, f4, f5, f6, f7, f8, f9);
                        f8 = 0.0f;
                        f9 = 0.0f;
                    } else if (this.mInPanTransformGesture) {
                        this.endPanGesture();
                        this.setDownTouchPoint(touchPointArray[0].x, touchPointArray[0].y, touchPointArray[0].pid);
                        this.setDownTouchPoint(touchPointArray[1].x, touchPointArray[1].y, touchPointArray[1].pid);
                    }
                }
            }
        } else if (motionEvent2.getPointerCount() == 1 && (n = motionEvent2.getPointerId(0)) >= 0 && n < 2 && this.mCheckForSwipe && motionEvent.getPointerCount() == 1) {
            boolean bl = false;
            float f12 = 0.0f;
            float f13 = 0.0f;
            f12 = motionEvent2.getX(0) - this.mDownTouchPoints[n].x;
            f13 = motionEvent2.getY(0) - this.mDownTouchPoints[n].y;
            if (Math.abs(f12) * 25.4f / (float)screenPPI >= 10.0f && Math.abs(f13) * 25.4f / (float)screenPPI <= 5.0f) {
                bl = true;
                f8 = f12 > 0.0f ? 1.0f : -1.0f;
                f9 = 0.0f;
            } else if (Math.abs(f13) * 25.4f / (float)screenPPI >= 10.0f && Math.abs(f12) * 25.4f / (float)screenPPI <= 5.0f) {
                bl = true;
                f8 = 0.0f;
                f9 = f13 > 0.0f ? 1.0f : -1.0f;
            } else {
                bl = false;
            }
            if (bl) {
                n2 = 8;
                n3 = 5;
                f3 = motionEvent.getX(0);
                f4 = motionEvent2.getY(0);
                this.nativeOnGestureListener(n2, n3, true, f3, f4, f5, f6, f7, f8, f9);
                this.mCheckForSwipe = false;
            }
        }
        return true;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
        boolean bl = true;
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return bl;
        }
        int n = 8;
        int n2 = 3;
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.mCouldBeTwoFingerTap == 3 && motionEvent.getPointerCount() == 1 && (motionEvent.getAction() & 0xFF) == 0) {
            f = (this.mSecondaryPointOfTwoFingerTap.x + motionEvent.getX(0)) / 2.0f;
            f2 = (this.mSecondaryPointOfTwoFingerTap.y + motionEvent.getY(0)) / 2.0f;
            bl = bl && this.nativeOnGestureListener(n, n2, false, f, f2, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            this.mCouldBeTwoFingerTap = 0;
        }
        return bl;
    }

    public boolean onSingleTapUp(MotionEvent motionEvent) {
        return true;
    }

    public boolean onDoubleTap(MotionEvent motionEvent) {
        boolean bl = true;
        if (motionEvent.getPointerCount() == 1) {
            bl = bl && this.mSurfaceView.nativeOnDoubleClickListener(motionEvent.getX(0), motionEvent.getY(0));
        }
        return bl;
    }

    public boolean onDoubleTapEvent(MotionEvent motionEvent) {
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
        if (this.mInZoomTransformGesture) {
            this.endZoomGesture();
        }
        return true;
    }

    public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return true;
        }
        int n = 1;
        int n2 = 0;
        float f = scaleGestureDetector.getFocusX();
        float f2 = scaleGestureDetector.getFocusY();
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        double d = scaleGestureDetector.getPreviousSpan();
        double d2 = scaleGestureDetector.getCurrentSpan();
        double d3 = Math.abs(d2 - d);
        double d4 = 0.0;
        double d5 = 0.0;
        if (Build.VERSION.SDK_INT >= 11) {
            d4 = Math.abs(scaleGestureDetector.getCurrentSpanX() - scaleGestureDetector.getPreviousSpanX());
            d5 = Math.abs(scaleGestureDetector.getCurrentSpanY() - scaleGestureDetector.getPreviousSpanY());
        }
        if (d != 0.0) {
            if (this.mInZoomTransformGesture || d3 * (double)25.4f / (double)screenPPI > 8.0) {
                if (!this.mInZoomTransformGesture) {
                    this.mInZoomTransformGesture = true;
                    n = 2;
                }
                if (Build.VERSION.SDK_INT >= 11) {
                    if (scaleGestureDetector.getPreviousSpanX() != 0.0f && scaleGestureDetector.getCurrentSpanX() != 0.0f && (this.mInZoomTransformGestureX || d4 * (double)25.4f / (double)screenPPI > 3.0)) {
                        f3 = Math.abs(scaleGestureDetector.getCurrentSpanX() / scaleGestureDetector.getPreviousSpanX());
                        this.mInZoomTransformGestureX = true;
                    }
                    if (scaleGestureDetector.getPreviousSpanY() != 0.0f && scaleGestureDetector.getCurrentSpanY() != 0.0f && (this.mInZoomTransformGestureY || d5 * (double)25.4f / (double)screenPPI > 3.0)) {
                        f4 = Math.abs(scaleGestureDetector.getCurrentSpanY() / scaleGestureDetector.getPreviousSpanY());
                        this.mInZoomTransformGestureY = true;
                    }
                } else {
                    float f8;
                    f3 = f8 = scaleGestureDetector.getScaleFactor();
                    f4 = f8;
                }
                this.mPreviousZoomLocX = f;
                this.mPreviousZoomLocY = f2;
                this.nativeOnGestureListener(n, n2, true, f, f2, f3, f4, f5, f6, f7);
                return true;
            }
            return false;
        }
        return false;
    }

    public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        if (this.mSurfaceView.getMultitouchMode() != this.mSurfaceView.kMultitouchGesture) {
            return;
        }
        if (this.mInZoomTransformGesture) {
            float f = scaleGestureDetector.getScaleFactor();
            this.nativeOnGestureListener(4, 0, true, this.mPreviousZoomLocX, this.mPreviousZoomLocY, f, f, 0.0f, 0.0f, 0.0f);
        }
    }

    private float getRotation(TouchPoint touchPoint, TouchPoint touchPoint2, TouchPoint touchPoint3, TouchPoint touchPoint4) {
        float f = 0.0f;
        if (touchPoint.pid == touchPoint3.pid && touchPoint2.pid == touchPoint4.pid) {
            double d = Math.atan2(touchPoint2.y - touchPoint.y, touchPoint2.x - touchPoint.x) * 180.0 / Math.PI;
            double d2 = Math.atan2(touchPoint4.y - touchPoint3.y, touchPoint4.x - touchPoint3.x) * 180.0 / Math.PI;
            f = (float)(d2 - d);
        }
        return f;
    }

    private boolean isPanGesture(TouchPoint touchPoint, TouchPoint touchPoint2, TouchPoint touchPoint3, TouchPoint touchPoint4) {
        float f = touchPoint3.x - touchPoint.x;
        float f2 = touchPoint3.y - touchPoint.y;
        float f3 = touchPoint4.x - touchPoint2.x;
        float f4 = touchPoint4.y - touchPoint2.y;
        float f5 = Math.min(Math.abs(f), Math.abs(f3));
        float f6 = Math.min(Math.abs(f2), Math.abs(f4));
        double d = Math.sqrt(f5 * f5 + f6 * f6);
        return (f >= 0.0f && f3 >= 0.0f || f <= 0.0f && f3 <= 0.0f) && (f2 >= 0.0f && f4 >= 0.0f || f2 <= 0.0f && f4 <= 0.0f) && (this.mInPanTransformGesture || d > (double)(3.0f * (float)screenPPI / 25.4f));
    }

    private double distanceBetweenPoints(TouchPoint touchPoint, TouchPoint touchPoint2) {
        return Math.sqrt(Math.pow(touchPoint2.x - touchPoint.x, 2.0) + Math.pow(touchPoint2.y - touchPoint.y, 2.0));
    }

    private class TouchPoint {
        private float x;
        private float y;
        private int pid;

        TouchPoint() {
            this.x = 0.0f;
            this.y = 0.0f;
            this.pid = 0;
        }

        TouchPoint(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.pid = n;
        }

        private void assign(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.pid = n;
        }
    }
}

