/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.Display;
import android.view.OrientationEventListener;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidActivityWrapper;

class OrientationManager {
    private static OrientationManager sMgr = null;
    private boolean mFirstCreate = true;
    private int mOrientation = EOrientation.DEFAULT.ordinal();
    private OrientationEventListener mOrientationEventListner;
    private int mDeviceOrientation = EOrientation.UNKNOWN.ordinal();
    private int mOldDeviceOrientation = EOrientation.UNKNOWN.ordinal();
    private int mFinalOrientation = EOrientation.UNKNOWN.ordinal();
    private int mDeviceDefault = EDefault.PORTRAIT.ordinal();
    private boolean mAutoOrients = false;
    private boolean mSetOrientation = false;
    private int mHardKeyboardHidden = 2;
    private static final String LOG_TAG = "OrientationManager";
    private Activity m_activity = null;
    private AIRWindowSurfaceView mView = null;
    private int mOsDefaultOrientation = 1;
    private int mOsRotatedRightOrientation = 0;
    private int mOsRotatedLeftOrientation = 8;
    private int mOsReversedOrientation = 9;
    public boolean mDispatchOrientationChangePending = false;
    public int mAfterOrientation;
    public int mBeforeOrientation;

    public native boolean nativeOrientationChanging(int var1, int var2);

    public native void nativeOrientationChanged(int var1, int var2);

    private OrientationManager() {
    }

    public static OrientationManager getOrientationManager() {
        if (sMgr == null) {
            sMgr = new OrientationManager();
        }
        return sMgr;
    }

    public void onActivityCreated(Activity activity, AIRWindowSurfaceView aIRWindowSurfaceView) {
        this.m_activity = activity;
        this.mView = aIRWindowSurfaceView;
        this.mHardKeyboardHidden = this.m_activity.getResources().getConfiguration().hardKeyboardHidden;
        if (this.mFirstCreate) {
            this.setDeviceDefault();
            this.setOrientationParamsFromMetaData();
        }
        this.mOrientationEventListner = new OrientationEventListener(this.m_activity.getApplicationContext(), 3){

            public void onOrientationChanged(int n) {
                int n2 = EOrientation.UNKNOWN.ordinal();
                if (n == -1) {
                    OrientationManager.this.mDeviceOrientation = EOrientation.UNKNOWN.ordinal();
                    n2 = EOrientation.UNKNOWN.ordinal();
                } else if (n >= 45 && n < 135) {
                    OrientationManager.this.mDeviceOrientation = EOrientation.ROTATED_RIGHT.ordinal();
                    n2 = EOrientation.ROTATED_LEFT.ordinal();
                } else if (n >= 135 && n < 225) {
                    OrientationManager.this.mDeviceOrientation = EOrientation.UPSIDE_DOWN.ordinal();
                    n2 = EOrientation.UPSIDE_DOWN.ordinal();
                } else if (n >= 225 && n < 315) {
                    OrientationManager.this.mDeviceOrientation = EOrientation.ROTATED_LEFT.ordinal();
                    n2 = EOrientation.ROTATED_RIGHT.ordinal();
                } else if (n >= 0 && n < 45 || n >= 315 && n < 360) {
                    OrientationManager.this.mDeviceOrientation = EOrientation.DEFAULT.ordinal();
                    n2 = EOrientation.DEFAULT.ordinal();
                }
                if (AndroidActivityWrapper.GetAndroidActivityWrapper().isApplicationLaunched() && OrientationManager.this.mAutoOrients && OrientationManager.this.mOldDeviceOrientation != OrientationManager.this.mDeviceOrientation && n2 != EOrientation.UNKNOWN.ordinal() && OrientationManager.this.mOrientation != n2) {
                    int n3 = Settings.System.getInt((ContentResolver)OrientationManager.this.m_activity.getContentResolver(), (String)"accelerometer_rotation", (int)0);
                    if (OrientationManager.this.m_activity != null && n3 != 0) {
                        boolean bl = OrientationManager.this.nativeOrientationChanging(OrientationManager.this.mOrientation, n2);
                        if (bl) {
                            OrientationManager.this.setNearestOrientation(OrientationManager.this.mOrientation);
                            OrientationManager.this.mFinalOrientation = OrientationManager.this.mOrientation;
                        } else {
                            OrientationManager.this.m_activity.setRequestedOrientation(2);
                            OrientationManager.this.mFinalOrientation = n2;
                        }
                    }
                } else if (OrientationManager.this.mAutoOrients && OrientationManager.this.mSetOrientation && OrientationManager.this.mOldDeviceOrientation != OrientationManager.this.mDeviceOrientation && OrientationManager.this.mOldDeviceOrientation != EOrientation.UNKNOWN.ordinal() && OrientationManager.this.mDeviceOrientation != EOrientation.UNKNOWN.ordinal()) {
                    if (OrientationManager.this.m_activity != null) {
                        OrientationManager.this.m_activity.setRequestedOrientation(2);
                    }
                    OrientationManager.this.mSetOrientation = false;
                }
                OrientationManager.this.mOldDeviceOrientation = OrientationManager.this.mDeviceOrientation;
            }
        };
        if (!this.mFirstCreate) {
            this.applyLastOrientation();
        }
        this.mFirstCreate = false;
        this.mOrientation = this.getCurrentOrientation();
    }

    public void onActivityDestroyed() {
        this.m_activity = null;
    }

    public void onActivityResumed() {
        this.enableEventListener(true);
    }

    public void onActivityPaused() {
        this.enableEventListener(false);
    }

    public void enableEventListener(boolean bl) {
        if (bl) {
            this.mOrientationEventListner.enable();
        } else {
            this.mOrientationEventListner.disable();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mAfterOrientation = this.getCurrentOrientation();
        this.mBeforeOrientation = this.mOrientation;
        if (this.mHardKeyboardHidden != configuration.hardKeyboardHidden) {
            this.mHardKeyboardHidden = configuration.hardKeyboardHidden;
            if (this.mAutoOrients && this.mSetOrientation) {
                if (this.m_activity != null) {
                    this.m_activity.setRequestedOrientation(2);
                }
                this.mSetOrientation = false;
            }
        }
        if (this.mBeforeOrientation != this.mAfterOrientation) {
            if (this.mFinalOrientation != EOrientation.UNKNOWN.ordinal() && this.mAfterOrientation != this.mFinalOrientation) {
                return;
            }
            this.mFinalOrientation = EOrientation.UNKNOWN.ordinal();
            this.mOrientation = this.mAfterOrientation;
            if (AndroidActivityWrapper.GetAndroidActivityWrapper().isApplicationLaunched()) {
                if (this.mView.getVisibleBoundHeight() == this.mView.getVisibleBoundWidth()) {
                    this.nativeOrientationChanged(this.mBeforeOrientation, this.mAfterOrientation);
                    this.mDispatchOrientationChangePending = false;
                } else {
                    this.mDispatchOrientationChangePending = true;
                }
            }
        }
    }

    public int getOrientation() {
        this.mOrientation = this.getCurrentOrientation();
        return this.mOrientation;
    }

    public int getDeviceOrientation() {
        if (this.mHardKeyboardHidden == 1) {
            if (this.mOsDefaultOrientation == 1) {
                return EOrientation.ROTATED_LEFT.ordinal();
            }
            return EOrientation.DEFAULT.ordinal();
        }
        return this.mDeviceOrientation;
    }

    public void setOrientation(int n) {
        if (Build.VERSION.SDK_INT > 8) {
            this.setNearestOrientation(n);
            this.mSetOrientation = true;
        } else if (n == EOrientation.DEFAULT.ordinal()) {
            if (this.m_activity != null) {
                if (this.mOsDefaultOrientation == 1) {
                    this.m_activity.setRequestedOrientation(1);
                } else {
                    this.m_activity.setRequestedOrientation(0);
                }
                this.mSetOrientation = true;
            }
        } else if (n == EOrientation.ROTATED_RIGHT.ordinal()) {
            if (this.m_activity != null && this.mOsDefaultOrientation == 1) {
                this.m_activity.setRequestedOrientation(0);
                this.mSetOrientation = true;
            }
        } else if (n == EOrientation.ROTATED_LEFT.ordinal() && this.m_activity != null && this.mOsDefaultOrientation == 0) {
            this.m_activity.setRequestedOrientation(1);
            this.mSetOrientation = true;
        }
    }

    public void setNearestOrientation(int n) {
        if (this.m_activity != null) {
            if (n == EOrientation.DEFAULT.ordinal()) {
                this.m_activity.setRequestedOrientation(this.mOsDefaultOrientation);
            } else if (n == EOrientation.ROTATED_LEFT.ordinal()) {
                this.m_activity.setRequestedOrientation(this.mOsRotatedLeftOrientation);
            } else if (n == EOrientation.ROTATED_RIGHT.ordinal()) {
                this.m_activity.setRequestedOrientation(this.mOsRotatedRightOrientation);
            } else if (n == EOrientation.UPSIDE_DOWN.ordinal()) {
                this.m_activity.setRequestedOrientation(this.mOsReversedOrientation);
            }
        }
    }

    public void setAspectRatio(int n) {
        if (n == EAspectRatio.PORTRAIT.ordinal()) {
            if (this.m_activity != null) {
                this.m_activity.setRequestedOrientation(1);
                this.mSetOrientation = true;
            }
        } else if (n == EAspectRatio.LANDSCAPE.ordinal() && this.m_activity != null) {
            this.m_activity.setRequestedOrientation(0);
            this.mSetOrientation = true;
        }
    }

    public void setAutoOrients(boolean bl) {
        if (this.m_activity == null) {
            return;
        }
        this.mAutoOrients = bl;
        if (this.mAutoOrients) {
            this.m_activity.setRequestedOrientation(2);
        } else {
            this.m_activity.setRequestedOrientation(5);
        }
    }

    public boolean getAutoOrients() {
        return this.mAutoOrients;
    }

    public int[] getSupportedOrientations() {
        int[] nArray = null;
        if (Build.VERSION.SDK_INT <= 8) {
            nArray = new int[2];
            if (this.mOsDefaultOrientation == 1) {
                nArray[0] = EOrientation.DEFAULT.ordinal();
                nArray[1] = EOrientation.ROTATED_RIGHT.ordinal();
            } else {
                nArray[0] = EOrientation.DEFAULT.ordinal();
                nArray[1] = EOrientation.ROTATED_LEFT.ordinal();
            }
        } else {
            nArray = new int[]{EOrientation.DEFAULT.ordinal(), EOrientation.ROTATED_LEFT.ordinal(), EOrientation.ROTATED_RIGHT.ordinal(), EOrientation.UPSIDE_DOWN.ordinal()};
        }
        return nArray;
    }

    private int getCurrentOrientation() {
        int n = EOrientation.DEFAULT.ordinal();
        if (this.m_activity == null) {
            return n;
        }
        int n2 = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        if (n2 == 0) {
            n = EOrientation.DEFAULT.ordinal();
        } else if (n2 == 1) {
            n = EOrientation.ROTATED_RIGHT.ordinal();
        } else if (n2 == 2) {
            n = EOrientation.UPSIDE_DOWN.ordinal();
        } else if (n2 == 3) {
            n = EOrientation.ROTATED_LEFT.ordinal();
        }
        return n;
    }

    private void setDeviceDefault() {
        boolean bl;
        int n;
        Display display = this.m_activity.getWindow().getWindowManager().getDefaultDisplay();
        int n2 = display.getRotation();
        int n3 = display.getHeight();
        boolean bl2 = n3 >= (n = display.getWidth());
        boolean bl3 = bl = n2 == 0 || n2 == 2;
        if (bl2 && bl || !bl2 && !bl) {
            this.mOsDefaultOrientation = 1;
            this.mOsRotatedRightOrientation = 0;
            if (Build.VERSION.SDK_INT <= 8) {
                this.mOsRotatedLeftOrientation = this.mOsRotatedRightOrientation;
                this.mOsReversedOrientation = this.mOsDefaultOrientation;
            } else {
                this.mOsRotatedLeftOrientation = 8;
                this.mOsReversedOrientation = 9;
            }
        } else {
            this.mOsDefaultOrientation = 0;
            this.mOsRotatedLeftOrientation = 1;
            if (Build.VERSION.SDK_INT <= 8) {
                this.mOsRotatedRightOrientation = this.mOsRotatedLeftOrientation;
                this.mOsReversedOrientation = this.mOsDefaultOrientation;
            } else {
                this.mOsRotatedRightOrientation = 9;
                this.mOsReversedOrientation = 8;
            }
        }
    }

    private void setOrientationParamsFromMetaData() {
        try {
            ActivityInfo activityInfo = this.m_activity.getPackageManager().getActivityInfo(this.m_activity.getComponentName(), 128);
            Bundle bundle = activityInfo.metaData;
            if (bundle == null) {
                return;
            }
            Boolean bl = (Boolean)bundle.get("autoOrients");
            String string = (String)bundle.get("aspectRatio");
            if (bl != null && bl.booleanValue()) {
                this.setAutoOrients(true);
            } else if (string == null) {
                this.setAutoOrients(false);
            }
            if (string != null) {
                if (string.equals("portrait")) {
                    this.setAspectRatio(EAspectRatio.PORTRAIT.ordinal());
                } else if (string.equals("landscape")) {
                    this.setAspectRatio(EAspectRatio.LANDSCAPE.ordinal());
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    private void applyLastOrientation() {
        if (!this.mAutoOrients) {
            if (this.mSetOrientation) {
                this.setOrientation(this.mOrientation);
            } else {
                this.setAutoOrients(this.mAutoOrients);
            }
        } else {
            this.setAutoOrients(this.mAutoOrients);
            this.mAfterOrientation = this.getCurrentOrientation();
            this.mBeforeOrientation = this.mOrientation;
            if (this.mBeforeOrientation != this.mAfterOrientation) {
                boolean bl = false;
                if (AndroidActivityWrapper.GetAndroidActivityWrapper().isApplicationLaunched()) {
                    bl = this.nativeOrientationChanging(this.mBeforeOrientation, this.mAfterOrientation);
                }
                if (bl) {
                    this.setNearestOrientation(this.mBeforeOrientation);
                } else {
                    this.mOrientation = this.mAfterOrientation;
                    if (AndroidActivityWrapper.GetAndroidActivityWrapper().isApplicationLaunched()) {
                        if (this.mView.getVisibleBoundHeight() == this.mView.getVisibleBoundWidth()) {
                            this.nativeOrientationChanged(this.mBeforeOrientation, this.mAfterOrientation);
                            this.mDispatchOrientationChangePending = false;
                        } else {
                            this.mDispatchOrientationChangePending = true;
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EAspectRatio {
        UNKNOWN,
        PORTRAIT,
        LANDSCAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EDefault {
        PORTRAIT,
        LANDSCAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EOrientation {
        UNKNOWN,
        DEFAULT,
        ROTATED_LEFT,
        ROTATED_RIGHT,
        UPSIDE_DOWN;

    }
}

