/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class JavaTrustStoreHelper {
    private static final String LOG_TAG = "JavaTrustStoreHelper";

    private static boolean isAirCertBundleStale(String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.exists()) {
            bl = JavaTrustStoreHelper.getTrustStoreTimestamp() > file.lastModified();
        }
        return bl;
    }

    private static long getTrustStoreTimestamp() {
        String string = System.getProperty("javax.net.ssl.trustStore");
        File file = new File(string);
        return file.lastModified();
    }

    private static TrustManagerFactory getX509TrustManagerFactory() {
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance("X509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(new FileInputStream(new File(System.getProperty("javax.net.ssl.trustStore"))), null);
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            trustManagerFactory = null;
        }
        catch (KeyStoreException keyStoreException) {
            trustManagerFactory = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            trustManagerFactory = null;
        }
        catch (IOException iOException) {
            trustManagerFactory = null;
        }
        catch (CertificateException certificateException) {
            trustManagerFactory = null;
        }
        return trustManagerFactory;
    }

    private static X509TrustManager getX509TrustManager() {
        TrustManagerFactory trustManagerFactory = JavaTrustStoreHelper.getX509TrustManagerFactory();
        X509TrustManager x509TrustManager = null;
        if (trustManagerFactory != null) {
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            for (int i = 0; i < trustManagerArray.length; ++i) {
                if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
                x509TrustManager = (X509TrustManager)trustManagerArray[i];
                break;
            }
        }
        return x509TrustManager;
    }

    public static void copyTimestamp(String string, String string2) {
        try {
            File file = new File(string);
            File file2 = new File(string2);
            file2.setLastModified(file.lastModified());
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static int dumpAcceptedIssuersToFile(X509TrustManager x509TrustManager, RandomAccessFile randomAccessFile) throws CertificateEncodingException, IOException, SyncFailedException {
        X509Certificate[] x509CertificateArray = x509TrustManager.getAcceptedIssuers();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            byte[] byArray = x509CertificateArray[i].getEncoded();
            randomAccessFile.writeInt(byArray.length);
            randomAccessFile.write(byArray);
        }
        randomAccessFile.getFD().sync();
        return x509CertificateArray.length;
    }

    public static boolean enumerateRootCAs(String string, String string2) {
        boolean bl = false;
        X509TrustManager x509TrustManager = null;
        if (!JavaTrustStoreHelper.isAirCertBundleStale(string)) {
            return false;
        }
        x509TrustManager = JavaTrustStoreHelper.getX509TrustManager();
        if (x509TrustManager == null) {
            return false;
        }
        try {
            File file = new File(string2);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(0L);
            int n = JavaTrustStoreHelper.dumpAcceptedIssuersToFile(x509TrustManager, randomAccessFile);
            file.setLastModified(JavaTrustStoreHelper.getTrustStoreTimestamp());
            randomAccessFile.close();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (CertificateEncodingException certificateEncodingException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return bl;
    }
}

