/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.net.http.SslCertificate;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class Certificate {
    private SslCertificate m_certificate;
    private CertificateFactory m_factory;
    private SslCertificate.DName m_issuedTo;
    private SslCertificate.DName m_issuedBy;
    private final String TAG = "AIRCertificateWarningDialog";

    public Certificate() {
        try {
            this.m_factory = CertificateFactory.getInstance("X.509");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Certificate(SslCertificate sslCertificate) {
        try {
            this.m_certificate = sslCertificate;
            this.m_issuedBy = this.m_certificate.getIssuedBy();
            this.m_issuedTo = this.m_certificate.getIssuedTo();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean setCertificate(byte[] byArray) {
        if (this.m_factory == null) {
            return false;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            X509Certificate x509Certificate = (X509Certificate)this.m_factory.generateCertificate(byteArrayInputStream);
            this.m_certificate = new SslCertificate(x509Certificate);
            this.m_issuedBy = this.m_certificate.getIssuedBy();
            this.m_issuedTo = this.m_certificate.getIssuedTo();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public String getIssuedToCommonName() {
        return this.m_issuedTo.getCName();
    }

    public String getIssuedToOrganization() {
        return this.m_issuedTo.getOName();
    }

    public String getIssuedToOrganizationalUnit() {
        return this.m_issuedTo.getUName();
    }

    public String getIssuedByCommonName() {
        return this.m_issuedBy.getCName();
    }

    public String getIssuedByOrganization() {
        return this.m_issuedBy.getOName();
    }

    public String getIssuedByOrganizationalUnit() {
        return this.m_issuedBy.getUName();
    }

    public String getIssuedOn() {
        return this.m_certificate.getValidNotBefore();
    }

    public String getExpiresOn() {
        return this.m_certificate.getValidNotAfter();
    }
}

