/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.method.KeyListener;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidActivityWrapper;

public class AndroidStageText
implements AndroidActivityWrapper.StateChangeCallback {
    private static final String LOG_TAG = "AndroidStageText";
    private static final int FOCUS_NONE = 1;
    private static final int FOCUS_UP = 2;
    private static final int FOCUS_DOWN = 3;
    private static final int KEYBOARDTYPE_Default = 0;
    private static final int KEYBOARDTYPE_Punctuation = 1;
    private static final int KEYBOARDTYPE_Url = 2;
    private static final int KEYBOARDTYPE_Number = 3;
    private static final int KEYBOARDTYPE_Contact = 4;
    private static final int KEYBOARDTYPE_Email = 5;
    private static final int RETURN_KEY_Default = 0;
    private static final int RETURN_KEY_Done = 1;
    private static final int RETURN_KEY_Go = 2;
    private static final int RETURN_KEY_Next = 3;
    private static final int RETURN_KEY_Search = 4;
    private static final int AUTO_CAP_None = 0;
    private static final int AUTO_CAP_Word = 1;
    private static final int AUTO_CAP_Sentence = 2;
    private static final int AUTO_CAP_All = 3;
    private static final int ALIGN_Left = 0;
    private static final int ALIGN_Right = 1;
    private static final int ALIGN_Center = 2;
    private static final int ALIGN_Justify = 3;
    private static final int ALIGN_Start = 4;
    private static final int ALIGN_End = 5;
    private boolean enterKeyDispatched = false;
    private long mInternalReference;
    private Context mContext;
    private AndroidStageTextImpl mView;
    private AndroidStageTextEditText mTextView;
    private AIRWindowSurfaceView mAIRSurface;
    private RelativeLayout mLayout;
    private ViewGroup mClip = null;
    private int mKeyboardType = 0;
    private boolean mDisplayAsPassword = false;
    private boolean mMultiline = false;
    private int mAutoCapitalize = 0;
    private int mReturnKeyLabel = 0;
    private boolean mAutoCorrect = false;
    private boolean mBold = false;
    private boolean mItalic = false;
    private boolean mEditable = true;
    private boolean mDisableInteraction = false;
    private String mFont;
    private int mFontSize;
    private int mAlign = 4;
    private int mTextColor = -16777216;
    private int mBackgroundColor = -1;
    private int mBorderColor = -16777216;
    private BackgroundBorderDrawable mBBDrawable;
    private int mMaxChars = 0;
    private String mRestrict = null;
    private String mLocale = null;
    private Rect mBounds = new Rect();
    private Rect mViewBounds = null;
    private Rect mClipBounds = null;
    private Rect mGlobalBounds = new Rect();
    private KeyListener mSavedKeyListener = null;
    private boolean mMenuInvoked = false;
    private boolean mSelectionChanged = false;
    private boolean mInContentMenu = false;
    private boolean mNotifyLayoutComplete = false;
    private double mScaleFactor = 1.0;

    public AndroidStageText(boolean bl) {
        this.mMultiline = bl;
        this.mDisplayAsPassword = false;
        this.mInternalReference = 0L;
        this.mContext = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity();
        this.mView = new AndroidStageTextImpl(this.mContext);
        this.mView.setFillViewport(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mView.setLayerType(1, null);
        }
        this.mTextView = new AndroidStageTextEditText(this.mContext);
        this.mSavedKeyListener = this.mTextView.getKeyListener();
        this.setFontSize(12);
        this.mView.addView((View)this.mTextView, new ViewGroup.LayoutParams(-1, -2));
        if (!bl) {
            this.mTextView.setSingleLine(true);
        } else {
            this.mTextView.setTransformationMethod(null);
            this.mTextView.setHorizontallyScrolling(false);
        }
        this.mTextView.setGravity(3);
    }

    public void onActivityStateChanged(AndroidActivityWrapper.ActivityState activityState) {
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void setInternalReference(long l) {
        this.mInternalReference = l;
    }

    public void destroyInternals() {
        this.removeFromStage();
        this.mInternalReference = 0L;
        this.mView = null;
        this.mClipBounds = null;
        this.mTextView = null;
    }

    public void addToStage(AIRWindowSurfaceView aIRWindowSurfaceView) {
        if (this.mLayout != null) {
            this.removeFromStage();
        }
        this.mAIRSurface = aIRWindowSurfaceView;
        AndroidActivityWrapper androidActivityWrapper = aIRWindowSurfaceView.getActivityWrapper();
        androidActivityWrapper.addActivityStateChangeListner(this);
        this.mLayout = androidActivityWrapper.getOverlaysLayout(true);
        this.mLayout.addView((View)this.mView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.mGlobalBounds.width(), this.mGlobalBounds.height()));
        this.mTextView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                switch (n) {
                    case 5: {
                        boolean bl = AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, 0, 87);
                        AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, 1, 87);
                        return bl;
                    }
                    case 2: 
                    case 3: {
                        AndroidStageText.this.enterKeyDispatched = true;
                        boolean bl = AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, 0, 66);
                        AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, 1, 66);
                        return bl;
                    }
                    case 6: {
                        AndroidStageText.this.mAIRSurface.DispatchSoftKeyboardEventOnBackKey();
                    }
                }
                return false;
            }
        });
    }

    public void removeFromStage() {
        if (this.mLayout != null) {
            this.mLayout.removeView((View)this.mView);
            this.mLayout = null;
        }
        if (this.mAIRSurface != null) {
            AndroidActivityWrapper androidActivityWrapper = this.mAIRSurface.getActivityWrapper();
            androidActivityWrapper.didRemoveOverlay();
            androidActivityWrapper.removeActivityStateChangeListner(this);
            this.mAIRSurface.updateFocusedStageText(this, false);
        }
        this.mAIRSurface = null;
    }

    public void setVisibility(boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 4;
        if (this.mView.getVisibility() != n) {
            this.mView.setVisibility(n);
            if (bl) {
                this.mTextView.invalidate();
            }
        }
    }

    public long updateViewBoundsWithKeyboard(int n) {
        Rect rect;
        int n2 = 0;
        this.mGlobalBounds = this.mBounds;
        if (this.mAIRSurface != null && !(rect = new Rect(0, 0, this.mAIRSurface.getVisibleBoundWidth(), this.mAIRSurface.getVisibleBoundHeight())).contains(this.mBounds)) {
            int n3;
            int n4 = Math.min(Math.max(0, this.mBounds.top), n);
            if (n4 == (n3 = Math.min(Math.max(0, this.mBounds.bottom), n))) {
                return 0L;
            }
            int n5 = n3 - rect.bottom;
            if (n5 <= 0) {
                return 0L;
            }
            if (n5 <= n4) {
                n2 = n5;
            } else {
                n2 = n4;
                this.mGlobalBounds = new Rect(this.mBounds);
                this.mGlobalBounds.bottom = rect.bottom + n2;
            }
        }
        this.refreshGlobalBounds(false);
        return n2;
    }

    public void resetGlobalBounds() {
        this.mGlobalBounds = this.mBounds;
        this.refreshGlobalBounds(false);
    }

    private void refreshGlobalBounds(final boolean bl) {
        if (this.mView == null) {
            return;
        }
        this.mView.post(new Runnable(){

            public void run() {
                if (AndroidStageText.this.mView == null) {
                    return;
                }
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(AndroidStageText.this.mGlobalBounds.width(), AndroidStageText.this.mGlobalBounds.height());
                layoutParams.leftMargin = ((AndroidStageText)AndroidStageText.this).mGlobalBounds.left;
                layoutParams.topMargin = ((AndroidStageText)AndroidStageText.this).mGlobalBounds.top;
                AndroidStageText.this.mView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                AndroidStageText.this.mView.requestLayout();
                if (bl) {
                    AndroidStageText.this.mNotifyLayoutComplete = true;
                }
            }
        });
    }

    public void adjustViewBounds(double d, double d2, double d3, double d4, double d5) {
        this.mViewBounds = new Rect((int)d, (int)d2, (int)(d + d3), (int)(d2 + d4));
        if (d5 != this.mScaleFactor) {
            this.mScaleFactor = d5;
            this.setFontSize(this.mFontSize);
        }
        this.mBounds = this.mViewBounds;
        if (this.mClip != null) {
            this.mBounds.intersect(this.mClipBounds);
        }
        this.mGlobalBounds = this.mBounds;
        this.refreshGlobalBounds(true);
    }

    public void setClipBounds(double d, double d2, double d3, double d4) {
        this.mClipBounds = new Rect((int)d, (int)d2, (int)(d + d3), (int)(d2 + d4));
        this.mBounds = this.mViewBounds;
        this.mTextView.invalidate();
        this.refreshGlobalBounds(true);
    }

    public void removeClip() {
        AIRWindowSurfaceView aIRWindowSurfaceView = this.mAIRSurface;
        this.mBounds = this.mViewBounds;
        this.mClipBounds = null;
        this.mTextView.invalidate();
        this.refreshGlobalBounds(true);
    }

    public void setText(String string) {
        InputFilter[] inputFilterArray = this.mTextView.getFilters();
        this.mTextView.setFilters(new InputFilter[0]);
        this.mTextView.setText(string, this.mEditable && !this.mDisableInteraction ? TextView.BufferType.EDITABLE : TextView.BufferType.NORMAL);
        this.mTextView.setFilters(inputFilterArray);
    }

    public String getText() {
        String string = this.mTextView.getText().toString();
        return string;
    }

    public void setKeyboardType(int n) {
        this.mKeyboardType = n;
        this.setInputType();
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public void setDisplayAsPassword(boolean bl) {
        this.mDisplayAsPassword = bl;
        if (bl) {
            this.mTextView.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        } else if (!this.mMultiline) {
            this.mTextView.setTransformationMethod((TransformationMethod)SingleLineTransformationMethod.getInstance());
        } else {
            this.mTextView.setTransformationMethod(null);
        }
        this.setInputType();
    }

    private void setInputType() {
        int n = 1;
        if (this.mDisplayAsPassword) {
            n = this.mKeyboardType == 3 ? 18 : 145;
        } else {
            switch (this.mKeyboardType) {
                case 1: 
                case 4: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 33;
                    break;
                }
                case 2: {
                    n = 17;
                }
            }
        }
        if ((n & 0xF) == 1) {
            if (this.mAutoCorrect) {
                n |= 0x8000;
            }
            if (this.mAutoCapitalize != 0) {
                switch (this.mAutoCapitalize) {
                    case 1: {
                        n |= 0x2000;
                        break;
                    }
                    case 2: {
                        n |= 0x4000;
                        break;
                    }
                    case 3: {
                        n |= 0x1000;
                    }
                }
            }
        }
        if (this.mMultiline) {
            n |= 0x20000;
        }
        this.mTextView.setRawInputType(n);
        this.mTextView.invalidate();
    }

    public void setEditable(boolean bl) {
        if (bl != this.mEditable) {
            this.mEditable = bl;
            if (!this.mDisableInteraction) {
                this.mTextView.setText((CharSequence)this.mTextView.getText(), this.mEditable ? TextView.BufferType.EDITABLE : TextView.BufferType.NORMAL);
                this.mTextView.setKeyListener(this.mEditable ? this.mSavedKeyListener : null);
            }
        }
    }

    public void setDisableInteraction(boolean bl) {
        this.mDisableInteraction = bl;
        if (bl) {
            this.mTextView.setText((CharSequence)this.mTextView.getText(), TextView.BufferType.NORMAL);
            this.mTextView.setKeyListener(null);
        } else {
            this.mTextView.setText((CharSequence)this.mTextView.getText(), this.mEditable ? TextView.BufferType.EDITABLE : TextView.BufferType.NORMAL);
            this.mTextView.setKeyListener(this.mEditable ? this.mSavedKeyListener : null);
        }
    }

    public void setTextColor(int n, int n2, int n3, int n4) {
        this.mTextColor = Color.argb((int)n4, (int)n, (int)n2, (int)n3);
        this.mTextView.setTextColor(this.mTextColor);
        this.mTextView.invalidate();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    private RectShape getShapeForBounds(Rect rect) {
        RectShape rectShape = new RectShape();
        rectShape.resize((float)rect.width(), (float)rect.height());
        return rectShape;
    }

    public void setBackgroundColor(int n, int n2, int n3, int n4) {
        this.mBBDrawable.setBkgColor(Color.argb((int)n4, (int)n, (int)n2, (int)n3));
        this.mTextView.invalidate();
    }

    public int getBackgroundColor() {
        return this.mBBDrawable.mBkgColor;
    }

    public void setBackground(boolean bl) {
        if (this.mBBDrawable.mHaveBkg != bl) {
            this.mBBDrawable.mHaveBkg = bl;
            this.mTextView.invalidate();
        }
    }

    public void setBorderColor(int n, int n2, int n3, int n4) {
        this.mBBDrawable.setBorderColor(Color.argb((int)n4, (int)n, (int)n2, (int)n3));
        this.mTextView.invalidate();
    }

    public int getBorderColor() {
        return this.mBBDrawable.mBorderColor;
    }

    public void setBorder(boolean bl) {
        if (this.mBBDrawable.mHaveBorder != bl) {
            this.mBBDrawable.mHaveBorder = bl;
            this.mTextView.invalidate();
        }
    }

    public void setAutoCapitalize(int n) {
        if (this.mAutoCapitalize != n) {
            this.mAutoCapitalize = n;
            this.setInputType();
        }
    }

    public int getAutoCapitalize() {
        return this.mAutoCapitalize;
    }

    public void setAutoCorrect(boolean bl) {
        if (this.mAutoCorrect != bl) {
            this.mAutoCorrect = bl;
            this.setInputType();
        }
    }

    public int getReturnKeyLabel() {
        return this.mReturnKeyLabel;
    }

    public void setReturnKeyLabel(int n) {
        int n2 = 0;
        this.mReturnKeyLabel = n;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 6;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 5;
                break;
            }
            case 4: {
                n2 = 3;
            }
        }
        this.mTextView.setImeOptions(n2);
    }

    private void applyFilters() {
        int n = 0;
        if (this.mMaxChars != 0) {
            ++n;
        }
        if (this.mRestrict != null) {
            ++n;
        }
        InputFilter[] inputFilterArray = new InputFilter[n];
        int n2 = 0;
        if (this.mMaxChars != 0) {
            inputFilterArray[n2] = new InputFilter.LengthFilter(this.mMaxChars);
            ++n2;
        }
        if (this.mRestrict != null) {
            inputFilterArray[n2] = new RestrictFilter(this.mRestrict);
            ++n2;
        }
        this.mTextView.setFilters(inputFilterArray);
    }

    public String getRestrict() {
        return this.mRestrict;
    }

    public void clearRestrict() {
        this.mRestrict = null;
        this.applyFilters();
    }

    public void setRestrict(String string) {
        this.mRestrict = string;
        this.applyFilters();
    }

    public int getMaxChars() {
        return this.mMaxChars;
    }

    public void setMaxChars(int n) {
        if (n != this.mMaxChars) {
            this.mMaxChars = n;
            this.applyFilters();
        }
    }

    public String getLocale() {
        return this.mLocale;
    }

    public void setLocale(String string) {
        this.mLocale = string;
    }

    public int getAlign() {
        return this.mAlign;
    }

    public void setAlign(int n) {
        this.mAlign = n;
        switch (n) {
            case 0: 
            case 4: {
                this.mTextView.setGravity(3);
                break;
            }
            case 1: 
            case 5: {
                this.mTextView.setGravity(5);
                break;
            }
            case 2: {
                this.mTextView.setGravity(1);
                break;
            }
        }
        this.mTextView.invalidate();
    }

    public void setFontSize(int n) {
        this.mFontSize = n;
        n = (int)((double)n * this.mScaleFactor + 0.5);
        this.mTextView.setTextSize(0, n);
        this.mTextView.invalidate();
    }

    public int getFontSize() {
        return this.mFontSize;
    }

    public void setBold(boolean bl) {
        this.mBold = bl;
        this.updateTypeface();
    }

    public void setItalic(boolean bl) {
        this.mItalic = bl;
        this.updateTypeface();
    }

    public void setFontFamily(String string) {
        this.mFont = string;
        this.updateTypeface();
    }

    public void updateTypeface() {
        Typeface typeface;
        int n = 0;
        if (this.mBold) {
            n |= 1;
        }
        if (this.mItalic) {
            n |= 2;
        }
        if ((typeface = Typeface.create((String)this.mFont, (int)n)) != null) {
            this.mTextView.setTypeface(typeface, n);
        } else {
            switch (n) {
                case 0: {
                    this.mTextView.setTypeface(Typeface.DEFAULT);
                    break;
                }
                case 1: {
                    this.mTextView.setTypeface(Typeface.DEFAULT_BOLD);
                    break;
                }
            }
        }
        this.mTextView.invalidate();
    }

    public void assignFocus() {
        this.mTextView.requestFocus();
        this.mAIRSurface.showSoftKeyboard(true, (View)this.mTextView);
        this.invokeSoftKeyboard(this.mInternalReference);
    }

    public void clearFocus() {
        if (this.mTextView.hasFocus()) {
            this.mTextView.clearFocus();
            this.mAIRSurface.requestFocus();
        }
        if (this.mMenuInvoked && this.mDisableInteraction) {
            this.mAIRSurface.showSoftKeyboard(false, (View)this.mTextView);
        }
    }

    public void selectRange(int n, int n2) {
        int n3 = this.mTextView.length();
        if (n < 0) {
            n = 0;
        } else if (n > n3) {
            n = n3;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n3) {
            n2 = n3;
        }
        this.mTextView.setSelection(n, n2);
        this.mTextView.invalidate();
    }

    public int getSelectionAnchorIndex() {
        return this.mTextView.getSelectionStart();
    }

    public int getSelectionActiveIndex() {
        return this.mTextView.getSelectionEnd();
    }

    public Bitmap captureSnapshot(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        if (n == 0 && n2 == 0) {
            return null;
        }
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)(-this.mView.getScrollX()), (float)(-this.mView.getScrollY()));
        if (this.mScaleFactor != 0.0) {
            canvas.scale((float)(1.0 / this.mScaleFactor), (float)(1.0 / this.mScaleFactor));
        }
        boolean bl = this.mView.isHorizontalScrollBarEnabled();
        boolean bl2 = this.mView.isVerticalScrollBarEnabled();
        this.mView.setHorizontalScrollBarEnabled(false);
        this.mView.setVerticalScrollBarEnabled(false);
        try {
            this.mView.draw(canvas);
        }
        catch (Exception exception) {
            bitmap = null;
        }
        this.mView.setHorizontalScrollBarEnabled(bl);
        this.mView.setVerticalScrollBarEnabled(bl2);
        canvas = null;
        return bitmap;
    }

    private native void dispatchFocusIn(long var1, int var3);

    private native void dispatchFocusOut(long var1, int var3);

    private native void dispatchChangeEvent(long var1);

    private native void dispatchCompleteEvent(long var1);

    private native void invokeSoftKeyboard(long var1);

    private native boolean handleKeyEvent(long var1, int var3, int var4);

    private class RestrictFilter
    implements InputFilter {
        private String mPattern = null;
        private byte[] m_map = null;
        private static final int kMapSize = 8192;

        public RestrictFilter(String string) {
            this.mPattern = string;
            if (string != null && !"".equals(string)) {
                this.m_map = new byte[8192];
                this.SetAll(false);
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = true;
                char c = '\u0000';
                if (string.charAt(0) == '^') {
                    this.SetAll(true);
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c2 = string.charAt(i);
                    boolean bl4 = false;
                    if (!bl) {
                        switch (c2) {
                            case '-': {
                                bl2 = true;
                                break;
                            }
                            case '^': {
                                bl3 = !bl3;
                                break;
                            }
                            case '\\': {
                                bl = true;
                                break;
                            }
                            default: {
                                bl4 = true;
                                break;
                            }
                        }
                    } else {
                        bl4 = true;
                        bl = false;
                    }
                    if (!bl4) continue;
                    if (bl2) {
                        for (char c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                            this.SetCode(c3, bl3);
                        }
                        bl2 = false;
                        c = '\u0000';
                        continue;
                    }
                    this.SetCode(c2, bl3);
                    c = c2;
                }
            }
        }

        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            String string;
            if (this.mPattern == null) {
                string = null;
            } else if (this.m_map == null) {
                string = "";
            } else {
                StringBuffer stringBuffer = new StringBuffer(n2 - n);
                for (int i = n; i < n2; ++i) {
                    boolean bl = true;
                    char c = charSequence.charAt(i);
                    if (!this.IsCharAvailable(c)) {
                        if (c >= 'A' && c <= 'Z') {
                            c = (char)(c + 32);
                            bl = this.IsCharAvailable(c);
                        } else if (c >= 'a' && c <= 'z') {
                            c = (char)(c - 32);
                            bl = this.IsCharAvailable(c);
                        } else {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    stringBuffer.append(c);
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        boolean IsEmpty() {
            return this.mPattern != null;
        }

        boolean IsCharAvailable(char c) {
            boolean bl = true;
            if (this.mPattern == null) {
                bl = true;
            }
            bl = this.m_map == null ? false : (this.m_map[c >> 3] & 1 << (c & 7)) != 0;
            return bl;
        }

        void SetCode(char c, boolean bl) {
            if (bl) {
                int n = c >> 3;
                this.m_map[n] = (byte)(this.m_map[n] | 1 << (c & 7));
            } else {
                int n = c >> 3;
                this.m_map[n] = (byte)(this.m_map[n] & ~(1 << (c & 7)));
            }
        }

        void SetAll(boolean bl) {
            byte by = (byte)(bl ? 255 : 0);
            for (int i = 0; i < 8192; ++i) {
                this.m_map[i] = by;
            }
        }
    }

    public class AndroidStageTextEditText
    extends EditText {
        private boolean m_inRequestChildFocus;
        private View m_focusedChildView;
        private boolean m_hasFocus;
        private int mLastFocusDirection;

        public AndroidStageTextEditText(Context context) {
            super(context);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
            this.setBackgroundDrawable(null);
            this.setCompoundDrawablePadding(0);
            this.setPadding(0, 0, 0, 0);
        }

        public AndroidStageTextEditText(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
        }

        public AndroidStageTextEditText(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
            this.m_inRequestChildFocus = false;
            this.m_focusedChildView = null;
            this.m_hasFocus = false;
            this.mLastFocusDirection = 0;
        }

        protected void onDraw(Canvas canvas) {
            if (AndroidStageText.this.mClipBounds != null) {
                canvas.save();
                int n = -((AndroidStageText)AndroidStageText.this).mViewBounds.left;
                int n2 = -((AndroidStageText)AndroidStageText.this).mViewBounds.top;
                Rect rect = new Rect(((AndroidStageText)AndroidStageText.this).mClipBounds.left + n, ((AndroidStageText)AndroidStageText.this).mClipBounds.top + n2, ((AndroidStageText)AndroidStageText.this).mClipBounds.right + n, ((AndroidStageText)AndroidStageText.this).mClipBounds.bottom + n2);
                canvas.clipRect(rect);
                super.onDraw(canvas);
                canvas.restore();
            } else {
                super.onDraw(canvas);
            }
        }

        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            if (!this.m_hasFocus) {
                this.requestFocus();
            }
            return super.dispatchTouchEvent(motionEvent);
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            AndroidStageText androidStageText = AndroidStageText.this;
            super.onLayout(bl, n, n2, n3, n4);
            if (androidStageText.mNotifyLayoutComplete) {
                androidStageText.mNotifyLayoutComplete = false;
                androidStageText.dispatchCompleteEvent(androidStageText.mInternalReference);
            }
        }

        private void dispatchFocusEvent(boolean bl, int n) {
            if (this.m_hasFocus == bl) {
                return;
            }
            this.m_hasFocus = bl;
            AndroidStageText androidStageText = AndroidStageText.this;
            if (androidStageText.mInternalReference == 0L) {
                return;
            }
            if (androidStageText.mAIRSurface != null) {
                androidStageText.mAIRSurface.updateFocusedStageText(androidStageText, this.m_hasFocus);
            }
            if (bl) {
                androidStageText.dispatchFocusIn(androidStageText.mInternalReference, n);
            }
        }

        protected void onFocusChanged(boolean bl, int n, Rect rect) {
            super.onFocusChanged(bl, n, rect);
            if (n == 0) {
                n = this.mLastFocusDirection;
            }
            this.mLastFocusDirection = 0;
            this.dispatchFocusEvent(bl, n);
        }

        protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            super.onTextChanged(charSequence, n, n2, n3);
            AndroidStageText androidStageText = AndroidStageText.this;
            if (androidStageText.mInternalReference == 0L) {
                return;
            }
            androidStageText.dispatchChangeEvent(androidStageText.mInternalReference);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            int n;
            boolean bl = true;
            for (n = 0; n < motionEvent.getPointerCount(); ++n) {
                int n2 = motionEvent.getAction();
                int n3 = motionEvent.getPointerId(n);
                if (motionEvent.getPointerCount() != 1 && motionEvent.getPointerId(n) != motionEvent.getPointerId((n2 & 0xFF00) >> 8) || (n2 &= 0xFF) == 6 || n2 == 1) continue;
                bl = false;
                break;
            }
            if (bl) {
                if (Build.VERSION.SDK_INT >= 11 || !AndroidStageText.this.mMenuInvoked) {
                    AndroidStageText.this.invokeSoftKeyboard(AndroidStageText.this.mInternalReference);
                }
                AndroidStageText.this.mMenuInvoked = false;
            }
            n = super.onTouchEvent(motionEvent) ? 1 : 0;
            return n != 0;
        }

        public void onCreateContextMenu(ContextMenu contextMenu) {
            AndroidStageText.this.mMenuInvoked = true;
            AndroidStageText.this.mSelectionChanged = false;
            super.onCreateContextMenu(contextMenu);
        }

        public boolean onTextContextMenuItem(int n) {
            AndroidStageText.this.mInContentMenu = true;
            boolean bl = super.onTextContextMenuItem(n);
            AndroidStageText.this.mInContentMenu = false;
            AndroidStageText.this.mMenuInvoked = false;
            return bl;
        }

        public void onSelectionChanged(int n, int n2) {
            super.onSelectionChanged(n, n2);
            AndroidStageText.this.mSelectionChanged = true;
            if (AndroidStageText.this.mAIRSurface != null && AndroidStageText.this.mInContentMenu) {
                AndroidStageText.this.mAIRSurface.showSoftKeyboard(true, (View)AndroidStageText.this.mTextView);
                AndroidStageText.this.invokeSoftKeyboard(AndroidStageText.this.mInternalReference);
            }
        }

        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            boolean bl = false;
            switch (n) {
                case 4: 
                case 66: 
                case 82: {
                    if (AndroidStageText.this.enterKeyDispatched) break;
                    bl = AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, keyEvent.getAction(), n);
                    break;
                }
            }
            if (!bl) {
                bl = super.onKeyDown(n, keyEvent);
            }
            return bl;
        }

        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            boolean bl = false;
            switch (n) {
                case 4: 
                case 66: 
                case 82: {
                    if (AndroidStageText.this.enterKeyDispatched) break;
                    AndroidStageText.this.handleKeyEvent(AndroidStageText.this.mInternalReference, keyEvent.getAction(), n);
                    break;
                }
            }
            bl = super.onKeyUp(n, keyEvent);
            AndroidStageText.this.enterKeyDispatched = false;
            return bl;
        }

        public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
            if (AndroidStageText.this.mAIRSurface != null && n == 4 && keyEvent.getAction() == 0) {
                AndroidStageText.this.mAIRSurface.DispatchSoftKeyboardEventOnBackKey();
            }
            return super.onKeyPreIme(n, keyEvent);
        }

        public ActionMode startActionMode(ActionMode.Callback callback) {
            if (AndroidStageText.this.mAIRSurface != null && AndroidStageText.this.mSelectionChanged) {
                AndroidStageText.this.mAIRSurface.showSoftKeyboard(true, (View)AndroidStageText.this.mTextView);
                AndroidStageText.this.invokeSoftKeyboard(AndroidStageText.this.mInternalReference);
                AndroidStageText.this.mSelectionChanged = false;
            }
            return super.startActionMode(callback);
        }
    }

    public class AndroidStageTextImpl
    extends ScrollView {
        public AndroidStageTextImpl(Context context) {
            super(context);
        }

        public AndroidStageTextImpl(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public AndroidStageTextImpl(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        protected void onSizeChanged(int n, int n2, int n3, int n4) {
            super.onSizeChanged(n, n2, n3, n4);
        }

        protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
            AndroidStageText androidStageText = AndroidStageText.this;
            super.onLayout(bl, n, n2, n3, n4);
            if (androidStageText.mNotifyLayoutComplete) {
                androidStageText.mNotifyLayoutComplete = false;
                androidStageText.dispatchCompleteEvent(androidStageText.mInternalReference);
            }
        }

        protected void onDraw(Canvas canvas) {
            if (AndroidStageText.this.mClipBounds != null) {
                canvas.save();
                int n = -((AndroidStageText)AndroidStageText.this).mViewBounds.left;
                int n2 = -((AndroidStageText)AndroidStageText.this).mViewBounds.top;
                Rect rect = new Rect(((AndroidStageText)AndroidStageText.this).mClipBounds.left + n, ((AndroidStageText)AndroidStageText.this).mClipBounds.top + n2, ((AndroidStageText)AndroidStageText.this).mClipBounds.right + n, ((AndroidStageText)AndroidStageText.this).mClipBounds.bottom + n2);
                canvas.clipRect(rect);
                super.onDraw(canvas);
                canvas.restore();
            } else {
                super.onDraw(canvas);
            }
        }
    }

    public class BackgroundBorderDrawable
    extends ShapeDrawable {
        public boolean mHaveBorder;
        public boolean mHaveBkg;
        public int mBkgColor;
        public int mBorderColor;
        public Paint mBkgPaint;

        public BackgroundBorderDrawable() {
            this.mHaveBorder = false;
            this.mHaveBkg = false;
            this.mBkgColor = -1;
            this.mBorderColor = -16777216;
            this.init();
        }

        public BackgroundBorderDrawable(Shape shape) {
            super(shape);
            this.mHaveBorder = false;
            this.mHaveBkg = false;
            this.mBkgColor = -1;
            this.mBorderColor = -16777216;
            this.init();
        }

        protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
            if (this.mHaveBkg) {
                canvas.drawRect(this.getBounds(), this.mBkgPaint);
            }
            if (this.mHaveBorder) {
                super.onDraw(shape, canvas, paint);
            }
        }

        private void init() {
            this.mBkgPaint = new Paint(this.getPaint());
            this.mBkgPaint.setStyle(Paint.Style.FILL);
            this.mBkgPaint.setColor(this.mBkgColor);
            this.getPaint().setStyle(Paint.Style.STROKE);
            this.getPaint().setStrokeWidth(3.0f);
            this.getPaint().setColor(this.mBorderColor);
        }

        public void setBkgColor(int n) {
            this.mBkgColor = n;
            this.mBkgPaint.setColor(n);
        }

        public void setBorderColor(int n) {
            this.mBorderColor = n;
            this.getPaint().setColor(n);
        }
    }
}

