/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.provider.MediaStore;
import com.adobe.air.AndroidActivityWrapper;
import java.io.OutputStream;
import java.util.Date;

public class AndroidMediaManager {
    private static final String PHONE_STORAGE = "phoneStorage";
    private static long MediaManagerObjectPointer;
    public static final int ERROR_IMAGE_PICKER_NOT_FOUND = 1;
    public static final int ERROR_ACTIVITY_DESTROYED = 2;
    private boolean mCallbacksRegistered = false;
    private AndroidActivityWrapper.ActivityResultCallback mActivityResultCB = null;

    public native void useImagePickerData(long var1, boolean var3, boolean var4, String var5, String var6, String var7);

    public AndroidMediaManager() {
        MediaManagerObjectPointer = 0L;
    }

    public void registerCallbacks() {
        this.doCallbackRegistration(true);
    }

    public void unregisterCallbacks() {
        this.doCallbackRegistration(false);
    }

    private void doCallbackRegistration(boolean bl) {
        this.mCallbacksRegistered = bl;
        if (bl) {
            if (this.mActivityResultCB == null) {
                this.mActivityResultCB = new AndroidActivityWrapper.ActivityResultCallback(){

                    public void onActivityResult(int n, int n2, Intent intent) {
                        if (n != 2) {
                            return;
                        }
                        if (MediaManagerObjectPointer == 0L) {
                            return;
                        }
                        if (!AndroidMediaManager.this.mCallbacksRegistered) {
                            return;
                        }
                        AndroidMediaManager.this.onBrowseImageResult(n2, intent, AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity());
                        AndroidMediaManager.this.unregisterCallbacks();
                    }
                };
            }
            AndroidActivityWrapper.GetAndroidActivityWrapper().addActivityResultListener(this.mActivityResultCB);
        } else if (this.mActivityResultCB != null) {
            AndroidActivityWrapper.GetAndroidActivityWrapper().removeActivityResultListener(this.mActivityResultCB);
            this.mActivityResultCB = null;
        }
    }

    public static boolean AddImage(Application application, Bitmap bitmap, boolean bl) {
        boolean bl2 = false;
        if (application != null) {
            ContentResolver contentResolver = application.getContentResolver();
            String string = null;
            try {
                string = MediaStore.Images.Media.insertImage((ContentResolver)contentResolver, (Bitmap)bitmap, null, null);
            }
            catch (Exception exception) {
                string = null;
            }
            if (string == null) {
                string = AndroidMediaManager.SaveImage(PHONE_STORAGE, contentResolver, bitmap, bl);
            }
            if (string != null) {
                try {
                    String[] stringArray = new String[]{"_data"};
                    Cursor cursor = contentResolver.query(Uri.parse((String)string), stringArray, null, null, null);
                    if (cursor != null) {
                        int n = cursor.getColumnIndexOrThrow("_data");
                        cursor.moveToFirst();
                        String[] stringArray2 = new String[]{cursor.getString(n)};
                        MediaScannerConnection.scanFile((Context)AndroidActivityWrapper.GetAndroidActivityWrapper().getDefaultContext(), (String[])stringArray2, null, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String SaveImage(String string, ContentResolver contentResolver, Bitmap bitmap, boolean bl) {
        String string2;
        Uri uri;
        block11: {
            uri = null;
            string2 = null;
            try {
                ContentValues contentValues = new ContentValues();
                if (bl) {
                    contentValues.put("mime_type", "image/jpeg");
                } else {
                    contentValues.put("mime_type", "image/png");
                }
                Date date = new Date();
                contentValues.put("datetaken", Long.valueOf(date.getTime()));
                contentValues.put("date_added", Long.valueOf(date.getTime() / 1000L));
                uri = contentResolver.insert(MediaStore.Images.Media.getContentUri((String)string), contentValues);
                if (uri == null) break block11;
                OutputStream outputStream = contentResolver.openOutputStream(uri);
                try {
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 90, outputStream);
                    long l = ContentUris.parseId((Uri)uri);
                    Bitmap bitmap2 = AndroidMediaManager.SaveThumbnail(string, contentResolver, bitmap, l, 320.0f, 240.0f, 1);
                    AndroidMediaManager.SaveThumbnail(string, contentResolver, bitmap2, l, 50.0f, 50.0f, 3);
                }
                catch (Exception exception) {
                    if (uri != null) {
                        contentResolver.delete(uri, null, null);
                        uri = null;
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                if (uri == null) break block11;
                contentResolver.delete(uri, null, null);
                uri = null;
            }
        }
        if (uri != null) {
            string2 = uri.toString();
        }
        return string2;
    }

    private static final Bitmap SaveThumbnail(String string, ContentResolver contentResolver, Bitmap bitmap, long l, float f, float f2, int n) {
        Uri uri;
        Bitmap bitmap2;
        block7: {
            if (bitmap == null) {
                return null;
            }
            Matrix matrix = new Matrix();
            bitmap2 = null;
            try {
                float f3 = f / (float)bitmap.getWidth();
                float f4 = f2 / (float)bitmap.getHeight();
                matrix.setScale(f3, f4);
                bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            catch (Exception exception) {
                return null;
            }
            ContentValues contentValues = new ContentValues(4);
            contentValues.put("kind", Integer.valueOf(n));
            contentValues.put("image_id", Integer.valueOf((int)l));
            contentValues.put("height", Integer.valueOf(bitmap2.getHeight()));
            contentValues.put("width", Integer.valueOf(bitmap2.getWidth()));
            uri = null;
            try {
                uri = contentResolver.insert(MediaStore.Images.Thumbnails.getContentUri((String)string), contentValues);
                if (uri != null) {
                    OutputStream outputStream = contentResolver.openOutputStream(uri);
                    bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                if (uri == null) break block7;
                contentResolver.delete(uri, null, null);
                uri = null;
            }
        }
        if (uri != null) {
            return bitmap2;
        }
        return null;
    }

    public int BrowseImage(long l) {
        int n = 0;
        try {
            AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
            Intent intent = new Intent();
            intent.setType("image/*");
            intent.setAction("android.intent.action.PICK");
            if (androidActivityWrapper.getActivity() != null) {
                androidActivityWrapper.getActivity().startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)""), 2);
            } else {
                n = 2;
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            n = 1;
        }
        if (n == 0) {
            this.registerCallbacks();
            MediaManagerObjectPointer = l;
        }
        return n;
    }

    public void onBrowseImageResult(int n, Intent intent, Activity activity) {
        if (n == 0) {
            this.useImagePickerData(MediaManagerObjectPointer, false, true, "", "", "");
        } else if (n == -1) {
            Cursor cursor;
            Object object;
            int n2 = 0;
            int n3 = 0;
            try {
                object = new String[]{"_data", "mime_type", "_display_name"};
                cursor = activity.managedQuery(intent.getData(), object, null, null, null);
                if (cursor == null) {
                    this.useImagePickerData(MediaManagerObjectPointer, false, false, "", "", "");
                    return;
                }
                n2 = cursor.getColumnIndexOrThrow("_data");
                n3 = cursor.getColumnIndexOrThrow("_display_name");
                cursor.moveToFirst();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.useImagePickerData(MediaManagerObjectPointer, false, false, "", "", "");
                return;
            }
            catch (Exception exception) {
                this.useImagePickerData(MediaManagerObjectPointer, false, false, "", "", "");
                return;
            }
            object = cursor.getString(n2);
            String string = "image";
            String string2 = cursor.getString(n3);
            this.useImagePickerData(MediaManagerObjectPointer, true, true, (String)object, string, string2);
        }
    }
}

