/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.adobe.air.AIRUpdateDialog;
import com.adobe.air.AIRWindowSurfaceView;
import com.adobe.air.AndroidCameraView;
import com.adobe.air.AndroidIdleState;
import com.adobe.air.ApplicationFileManager;
import com.adobe.air.ConfigDownloadListener;
import com.adobe.air.DebuggerSettings;
import com.adobe.air.DeviceProfiling;
import com.adobe.air.Entrypoints;
import com.adobe.air.FlashEGL;
import com.adobe.air.ListenErrorDialog;
import com.adobe.air.OrientationManager;
import com.adobe.air.RemoteDebuggerDialog;
import com.adobe.air.RemoteDebuggerListenerDialog;
import com.adobe.air.ResourceFileManager;
import com.adobe.air.telephony.AndroidTelephonyManager;
import com.adobe.air.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidActivityWrapper {
    private static boolean sApplicationLaunched = false;
    private static Entrypoints sEntryPoint = null;
    private static AndroidIdleState sIdleStateManager = null;
    private static AndroidTelephonyManager sAndroidTelephonyManager = null;
    private static AndroidActivityWrapper sActivityWrapper = null;
    private Activity m_activity = null;
    private ConfigDownloadListener mConfigDownloadListener = null;
    private Application m_application = null;
    private List<ActivityResultCallback> mActivityResultListeners = null;
    private AIRWindowSurfaceView m_mainView = null;
    private AndroidCameraView m_cameraView = null;
    private FrameLayout m_layout = null;
    private FlashEGL m_flashEGL = null;
    private String mXmlPath = null;
    private String mRootDir = null;
    private String mExtraArgs = null;
    private boolean mIsADL = false;
    private boolean mRGB565Override = false;
    private boolean mIsDebuggerMode = false;
    private int mHardKeyboardHidden = 2;
    private int mHardKeyboardType = 0;
    private boolean mShowDebuggerDialog = false;
    private boolean mDisplayWaitingDialog = false;
    private int debuggerPort = -1;
    private boolean mInvokeEventPendingFromOnCreate = false;
    private boolean mActivateEventPending = false;
    private List<StateChangeCallback> mActivityStateListeners = null;
    private static boolean sRuntimeLibrariesLoaded = false;
    private boolean mFullScreenSetFromMetaData = false;
    private boolean mIsFullScreen = false;
    private String mLibCorePath = null;
    private static boolean sHasCaptiveRuntime = false;
    private Context m_runtimeContext = null;
    private RelativeLayout m_overlaysLayout = null;
    private Lock m_newActivityLock = null;
    private Condition m_newActivityCondition = null;
    public static final int IMAGE_PICKER_REQUEST_CODE = 2;
    public static final int STILL_PICTURE_REQUEST_CODE = 3;
    public static final int VIDEO_CAPTURE_REQUEST_CODE = 4;
    public static final int WEBVIEW_UPLOAD_FILE_CHOOSER_CODE = 5;
    private OrientationManager mOrientationManager = null;
    private boolean mScreenOn = true;
    private DebuggerSettings mDebuggerSettings = new DebuggerSettings();
    private ActivityState mActivityState = ActivityState.STARTED;
    private static final String LOG_TAG = "AndroidActivityWrapper";
    private List<SurfaceView> m_planes = null;
    private int m_planeCascadeStep = 0;
    private boolean m_planeBreakCascade = false;
    private boolean m_planeCascadeInit = false;
    private boolean m_skipKickCascade = true;

    private native void nativeSetVisible(boolean var1);

    private native void nativeActivateEvent();

    private native void nativeDeactivateEvent();

    private native void nativeLowMemoryEvent();

    private native void nativeOnFocusListener(boolean var1);

    private native void nativeSendInvokeEventWithData(String var1);

    public static boolean isHoneycomb() {
        int n = Build.VERSION.SDK_INT;
        return n >= 11;
    }

    public static AndroidActivityWrapper CreateAndroidActivityWrapper(Activity activity) {
        return AndroidActivityWrapper.CreateAndroidActivityWrapper(activity, false);
    }

    public static AndroidActivityWrapper CreateAndroidActivityWrapper(Activity activity, Boolean bl) {
        sHasCaptiveRuntime = bl;
        if (bl.booleanValue()) {
            Utils.setRuntimePackageName(activity.getApplicationContext().getPackageName());
        } else {
            Utils.setRuntimePackageName("com.adobe.air");
        }
        if (sActivityWrapper == null) {
            sActivityWrapper = new AndroidActivityWrapper(activity);
        }
        return sActivityWrapper;
    }

    private AndroidActivityWrapper(Activity activity) {
        this.m_activity = activity;
        this.m_newActivityLock = new ReentrantLock();
        this.m_newActivityCondition = this.m_newActivityLock.newCondition();
        this.m_application = activity.getApplication();
        this.LoadRuntimeLibraries();
    }

    public static AndroidActivityWrapper GetAndroidActivityWrapper() {
        return sActivityWrapper;
    }

    public Activity getActivity() {
        return this.m_activity;
    }

    public void setSpeakerphoneOn(boolean bl) {
        ((AudioManager)this.getActivity().getSystemService("audio")).setSpeakerphoneOn(bl);
    }

    public boolean getSpeakerphoneOn() {
        return ((AudioManager)this.getActivity().getSystemService("audio")).isSpeakerphoneOn();
    }

    public void registerPlane(SurfaceView surfaceView, int n) {
        this.m_planes.set(n, surfaceView);
        this.planeBreakCascade();
    }

    public void unregisterPlane(int n) {
        this.m_planes.set(n, null);
        this.planeBreakCascade();
    }

    public void planeCleanCascade() {
        if (!this.m_planeCascadeInit) {
            this.m_planeCascadeInit = true;
            this.planeBreakCascade();
        }
    }

    public void planeBreakCascade() {
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.m_planes.get(i) == null) continue;
            ++n;
        }
        if (n > 1) {
            this.m_planeBreakCascade = true;
        }
    }

    public void planeKickCascade() {
        if (AndroidActivityWrapper.isHoneycomb() && this.m_skipKickCascade) {
            return;
        }
        this.planeCleanCascade();
        if (this.m_layout == null) {
            return;
        }
        if (this.m_planeBreakCascade) {
            int n;
            for (n = 0; n < 8; ++n) {
                if (this.m_planes.get(n) == null || this.m_layout.indexOfChild((View)this.m_planes.get(n)) < 0) continue;
                this.m_layout.removeView((View)this.m_planes.get(n));
            }
            this.m_planeBreakCascade = false;
            for (n = 0; n < 8; ++n) {
                if (this.m_planes.get(n) == null || !this.m_planes.get(n).getHolder().getSurface().isValid()) continue;
                this.m_planeBreakCascade = true;
                break;
            }
            this.m_planeCascadeStep = 0;
        }
        if (this.m_planeCascadeStep == 0) {
            this.planeStepCascade();
            this.m_mainView.requestFocus();
        }
    }

    public void planeStepCascade() {
        this.m_skipKickCascade = false;
        if (!AndroidActivityWrapper.isHoneycomb() && this.mActivityState != ActivityState.RESUMED) {
            return;
        }
        if (this.m_layout == null) {
            return;
        }
        if (!this.m_planeBreakCascade) {
            while (this.m_planeCascadeStep < 8) {
                if (this.m_planes.get(this.m_planeCascadeStep) != null) {
                    if (this.m_layout.indexOfChild((View)this.m_planes.get(this.m_planeCascadeStep)) < 0) {
                        this.m_layout.addView((View)this.m_planes.get(this.m_planeCascadeStep), 0);
                    }
                    ++this.m_planeCascadeStep;
                    return;
                }
                ++this.m_planeCascadeStep;
            }
        }
    }

    public Context getRuntimeContext() {
        return this.m_runtimeContext;
    }

    public Application getApplication() {
        return this.m_application;
    }

    public Context getApplicationContext() {
        return this.m_application;
    }

    public Context getDefaultContext() {
        if (this.m_activity != null) {
            return this.m_activity;
        }
        return this.m_application;
    }

    public int getDefaultIntentFlags() {
        if (this.m_activity != null) {
            return 0;
        }
        return 0x10000000;
    }

    public RelativeLayout getOverlaysLayout(boolean bl) {
        if (bl && this.m_overlaysLayout == null) {
            this.m_overlaysLayout = new RelativeLayout((Context)this.m_activity);
            this.m_layout.addView((View)this.m_overlaysLayout);
        }
        return this.m_overlaysLayout;
    }

    public void didRemoveOverlay() {
        if (this.m_overlaysLayout != null && this.m_overlaysLayout.getChildCount() == 0) {
            this.m_layout.removeView((View)this.m_overlaysLayout);
            this.m_overlaysLayout = null;
        }
    }

    public View getView() {
        return this.m_mainView;
    }

    public AndroidCameraView getCameraView() {
        return this.m_cameraView;
    }

    public boolean isApplicationLaunched() {
        return sApplicationLaunched;
    }

    public FlashEGL getEgl() {
        if (this.m_flashEGL == null) {
            this.m_flashEGL = new FlashEGL();
        }
        return this.m_flashEGL;
    }

    public boolean isSurfaceValid() {
        return this.m_mainView != null && this.m_mainView.isSurfaceValid();
    }

    public void SendIntentToRuntime(Class<?> clazz, String string, String string2) {
        try {
            Intent intent = new Intent(this.m_runtimeContext, clazz);
            intent.setAction(string);
            intent.addCategory(string2);
            this.m_activity.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void SendIntentToRuntime(Class<?> clazz, String string, String string2, String string3, String string4) {
        try {
            Intent intent = new Intent(this.m_runtimeContext, clazz);
            intent.setAction(string);
            intent.addCategory(string2);
            intent.putExtra(string3, string4);
            this.m_activity.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void StartDownloadConfigService() {
        Intent intent = new Intent();
        intent.setPackage(Utils.getRuntimePackageName());
        intent.setAction("com.adobe.air.DownloadConfig");
        try {
            this.getApplicationContext().startService(intent);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public void ShowImmediateUpdateDialog() {
        String string = null;
        try {
            ActivityInfo activityInfo = this.m_activity.getPackageManager().getActivityInfo(this.m_activity.getComponentName(), 128);
            Bundle bundle = activityInfo.metaData;
            if (bundle != null) {
                string = (String)bundle.get("airDownloadURL");
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (string != null) {
            this.SendIntentToRuntime(AIRUpdateDialog.class, "android.intent.action.MAIN", "AIRUpdateDialog", "airDownloadURL", string);
        } else {
            this.SendIntentToRuntime(AIRUpdateDialog.class, "android.intent.action.MAIN", "AIRUpdateDialog");
        }
    }

    private void initializeAndroidAppVars(ApplicationInfo applicationInfo) {
        String string = applicationInfo.packageName;
        ApplicationFileManager.setAndroidPackageName(string);
        ApplicationFileManager.setAndroidAPKPath(applicationInfo.sourceDir);
        String string2 = this.m_application.getCacheDir().getAbsolutePath();
        ApplicationFileManager.processAndroidDataPath(string2);
    }

    private void parseArgs(Activity activity, String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "false";
        String string5 = "false";
        try {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
            string4 = stringArray[3];
            string5 = stringArray[4];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.mExtraArgs = string3;
        this.mIsADL = Boolean.valueOf(string4);
        this.mIsDebuggerMode = Boolean.valueOf(string5);
        ApplicationInfo applicationInfo = this.m_activity.getApplicationInfo();
        this.initializeAndroidAppVars(applicationInfo);
        if (this.mIsADL) {
            this.mXmlPath = string;
            this.mRootDir = string2;
        } else {
            this.mXmlPath = ApplicationFileManager.getAppXMLRoot();
            this.mRootDir = ApplicationFileManager.getAppRoot();
        }
    }

    public void onCreate(Activity activity, String[] stringArray) {
        this.m_activity = activity;
        this.mActivityState = ActivityState.STARTED;
        this.parseArgs(activity, stringArray);
        this.SignalNewActivityCreated();
        try {
            this.m_runtimeContext = this.m_activity.createPackageContext(Utils.getRuntimePackageName(), 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mIsDebuggerMode && !this.mIsADL && !sApplicationLaunched && !DeviceProfiling.checkAndInitiateProfiler(this.m_activity)) {
            this.checkForDebuggerAndLaunchDialog();
        } else {
            this.afterOnCreate();
        }
        this.mInvokeEventPendingFromOnCreate = true;
        this.mConfigDownloadListener = ConfigDownloadListener.GetConfigDownloadListener();
    }

    private void afterOnCreate() {
        try {
            if (this.m_planes == null) {
                this.m_planes = new ArrayList<SurfaceView>(8);
                for (int i = 0; i < 8; ++i) {
                    this.m_planes.add(i, null);
                }
            }
            Context context = this.getApplicationContext();
            this.m_layout = new FrameLayout(context);
            this.m_mainView = new AIRWindowSurfaceView(context, this);
            if (this.m_cameraView == null && this.m_runtimeContext.checkCallingOrSelfPermission("android.permission.CAMERA") == 0) {
                this.m_cameraView = new AndroidCameraView(context, this);
            }
            if (this.m_cameraView != null) {
                this.m_layout.addView((View)this.m_cameraView, 8, 16);
            }
            this.m_layout.addView((View)this.m_mainView);
            if (this.m_overlaysLayout != null) {
                this.m_layout.addView((View)this.m_overlaysLayout);
            }
            this.m_activity.setContentView((View)this.m_layout);
            if ((this.mIsADL || this.mShowDebuggerDialog) && this.m_activity != null && this.m_activity.getCurrentFocus() != this.m_mainView) {
                this.m_mainView.requestFocus();
                this.m_mainView.onWindowFocusChanged(true);
            }
            if (!this.mFullScreenSetFromMetaData) {
                this.setFullScreenFromMetaData();
            }
            this.mFullScreenSetFromMetaData = true;
            if (this.getIsFullScreen()) {
                this.m_mainView.setFullScreen();
            }
            this.mHardKeyboardHidden = this.m_activity.getResources().getConfiguration().hardKeyboardHidden;
            this.mHardKeyboardType = this.m_activity.getResources().getConfiguration().keyboard;
            this.mOrientationManager = OrientationManager.getOrientationManager();
            this.mOrientationManager.onActivityCreated(this.m_activity, this.m_mainView);
            this.callActivityStateListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void LaunchApplication(Activity activity, AIRWindowSurfaceView aIRWindowSurfaceView, String string, String string2, String string3, boolean bl, boolean bl2) {
        if (sApplicationLaunched) {
            return;
        }
        try {
            Object object;
            if (bl) {
                try {
                    object = activity.getIntent().getStringExtra("args");
                    if (object != null) {
                        String[] stringArray = ((String)object).split(" ");
                        string = stringArray[0];
                        string2 = stringArray[1];
                        if (stringArray.length >= 2) {
                            string3 = stringArray[2] + " ";
                        }
                        for (int i = 3; i < stringArray.length; ++i) {
                            string3 = string3 + stringArray[i] + " ";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.getApplicationContext();
            sEntryPoint = new Entrypoints();
            sEntryPoint.EntryMain(string, string2, string3, Utils.getRuntimePackageName(), (Object)aIRWindowSurfaceView, activity.getApplication(), activity.getApplicationInfo(), object, this, bl, bl2);
            sIdleStateManager = AndroidIdleState.GetIdleStateManager((Context)object);
            sApplicationLaunched = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMainView(View view) {
        if (!sApplicationLaunched || sEntryPoint == null) {
            return;
        }
        try {
            sEntryPoint.setMainView(view);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initCallStateListener() {
        if (sAndroidTelephonyManager == null) {
            sAndroidTelephonyManager = AndroidTelephonyManager.CreateAndroidTelephonyManager(this.getApplicationContext());
            sAndroidTelephonyManager.listen(true);
        }
    }

    public void onPause() {
        this.mActivityState = ActivityState.PAUSED;
        this.callActivityStateListeners();
        if (this.m_mainView != null) {
            this.m_mainView.forceSoftKeyboardDown();
        }
        if (this.mOrientationManager != null) {
            this.mOrientationManager.onActivityPaused();
        }
        if (sIdleStateManager != null) {
            sIdleStateManager.releaseLock();
        }
        if (this.isApplicationLaunched()) {
            this.nativeOnFocusListener(false);
            this.nativeDeactivateEvent();
        }
        this.planeBreakCascade();
    }

    public void onResume() {
        this.mActivityState = ActivityState.RESUMED;
        this.callActivityStateListeners();
        if (this.mOrientationManager != null) {
            this.mOrientationManager.onActivityResumed();
        }
        if (sIdleStateManager != null) {
            sIdleStateManager.acquireLock();
        }
        if (this.isApplicationLaunched()) {
            this.nativeActivateEvent();
            this.nativeOnFocusListener(true);
        } else {
            this.mActivateEventPending = true;
        }
        this.m_skipKickCascade = true;
        this.planeBreakCascade();
    }

    public void onRestart() {
        this.mActivityState = ActivityState.RESTARTED;
        this.callActivityStateListeners();
        if (this.m_mainView != null) {
            this.m_mainView.HideSoftKeyboardOnWindowFocusChange();
        }
        this.SetVisible(true);
    }

    public void onStop() {
        this.mActivityState = ActivityState.STOPPED;
        this.callActivityStateListeners();
        this.SetVisible(false);
    }

    public void onDestroy() {
        this.mActivityState = ActivityState.DESTROYED;
        this.callActivityStateListeners();
        if (this.mOrientationManager != null) {
            this.mOrientationManager.onActivityDestroyed();
        }
        for (int i = 0; i < 8; ++i) {
            if (this.m_planes.get(i) == null) continue;
            this.m_layout.removeView((View)this.m_planes.get(i));
        }
        if (this.m_overlaysLayout != null) {
            this.m_layout.removeView((View)this.m_overlaysLayout);
        }
        this.m_activity = null;
        this.m_cameraView = null;
        this.m_mainView = null;
        this.m_layout = null;
        this.setMainView(null);
    }

    public void SendInvokeEvent() {
        Intent intent = this.m_activity.getIntent();
        this.nativeSendInvokeEventWithData(intent.getDataString());
    }

    public void onNewIntent(Intent intent) {
        this.m_activity.setIntent(intent);
        this.SendInvokeEvent();
    }

    public void onSurfaceInitialized() {
        this.setMainView((View)this.m_mainView);
        this.SetVisible(true);
        if (this.mDisplayWaitingDialog) {
            this.showDialogWaitingForConnection(this.debuggerPort);
            this.mDisplayWaitingDialog = false;
        }
        this.LaunchApplication(this.m_activity, this.m_mainView, this.mXmlPath, this.mRootDir, this.mExtraArgs, this.mIsADL, this.mIsDebuggerMode);
        if (this.mInvokeEventPendingFromOnCreate) {
            if (!this.mIsADL) {
                this.SendInvokeEvent();
            }
            this.mInvokeEventPendingFromOnCreate = false;
        }
        if (this.mActivateEventPending) {
            this.nativeActivateEvent();
            this.mActivateEventPending = false;
        }
        this.planeCleanCascade();
    }

    public void finish() {
        if (this.m_activity != null) {
            this.m_activity.finish();
        }
    }

    public void onSurfaceDestroyed() {
        this.SetVisible(false);
    }

    public void onScreenStateChanged(boolean bl) {
        this.mScreenOn = bl;
        this.SetVisible(bl);
        if (bl) {
            this.m_skipKickCascade = false;
            this.planeBreakCascade();
        }
    }

    private void SetVisible(boolean bl) {
        if (bl) {
            if (this.isSurfaceValid() && this.mScreenOn && this.mActivityState != ActivityState.STOPPED && this.mActivityState != ActivityState.DESTROYED) {
                this.nativeSetVisible(true);
            }
        } else if (this.isApplicationLaunched()) {
            this.nativeSetVisible(false);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mHardKeyboardHidden = configuration.hardKeyboardHidden;
        this.mHardKeyboardType = configuration.keyboard;
        this.mOrientationManager.onConfigurationChanged(configuration);
        this.callActivityStateListeners(configuration);
    }

    public void onLowMemory() {
        this.nativeLowMemoryEvent();
    }

    public int getOrientation() {
        return this.mOrientationManager.getOrientation();
    }

    public int getDeviceOrientation() {
        return this.mOrientationManager.getDeviceOrientation();
    }

    public void setOrientation(int n) {
        this.mOrientationManager.setOrientation(n);
    }

    public void setAspectRatio(int n) {
        this.mOrientationManager.setAspectRatio(n);
    }

    public void setAutoOrients(boolean bl) {
        this.mOrientationManager.setAutoOrients(bl);
    }

    public boolean getAutoOrients() {
        return this.mOrientationManager.getAutoOrients();
    }

    public int[] getSupportedOrientations() {
        return this.mOrientationManager.getSupportedOrientations();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        this.callActivityResultListeners(n, n2, intent);
    }

    public boolean isHardKeyboardHidden() {
        return this.mHardKeyboardHidden == 2;
    }

    public int getHardKeyboardType() {
        return this.mHardKeyboardType;
    }

    public void setUseRGB565(Boolean bl) {
        this.mRGB565Override = bl;
    }

    public boolean useRGB565() {
        if (this.mIsADL) {
            return this.mRGB565Override;
        }
        ResourceFileManager resourceFileManager = new ResourceFileManager((Context)this.m_activity);
        return !resourceFileManager.resExists(resourceFileManager.lookupResId("raw.rgba8888"));
    }

    public void BroadcastIntent(String string, String string2) {
        try {
            this.getDefaultContext().startActivity(Intent.parseUri((String)string2, (int)0).setAction(string).addFlags(this.getDefaultIntentFlags()));
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    public void LaunchMarketPlaceForAIR(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = "market://details?id=" + Utils.getRuntimePackageName();
        }
        try {
            this.BroadcastIntent("android.intent.action.VIEW", string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String GetLibCorePath() {
        if (this.mLibCorePath == null) {
            this.mLibCorePath = Utils.GetLibCorePath((Context)this.m_application);
        }
        return this.mLibCorePath;
    }

    private void LoadRuntimeLibraries() {
        if (!sRuntimeLibrariesLoaded) {
            try {
                System.load(this.GetLibCorePath());
                sRuntimeLibrariesLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    private void showDialogUnableToListenOnPort(int n) {
        ListenErrorDialog listenErrorDialog = new ListenErrorDialog(this.m_activity, n);
        listenErrorDialog.createAndShowDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDebuggerAndLaunchDialog() {
        block39: {
            Object object;
            if (this.mIsADL) break block39;
            ResourceFileManager resourceFileManager = new ResourceFileManager((Context)this.m_activity);
            String string = null;
            DebugMode debugMode = DebugMode.None;
            if (resourceFileManager.resExists(resourceFileManager.lookupResId("raw.debuginfo"))) {
                try {
                    InputStream inputStream = resourceFileManager.getFileStreamFromRawRes(resourceFileManager.lookupResId("raw.debuginfo"));
                    object = Utils.parseKeyValuePairFile(inputStream, "=");
                    String string2 = ((HashMap)object).get("incomingDebugPort");
                    if (string2 != null) {
                        try {
                            this.debuggerPort = Integer.parseInt(string2);
                            debugMode = DebugMode.ListenMode;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if ((string2 = (String)((HashMap)object).get("outgoingDebugHost")) != null) {
                        string = string2;
                        if (debugMode == DebugMode.ListenMode) {
                            debugMode = DebugMode.ConflictMode;
                            throw new Exception("listen and connect are mutually exclusive.");
                        }
                        debugMode = DebugMode.ConnectMode;
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
            switch (debugMode) {
                case ListenMode: {
                    boolean bl = true;
                    object = null;
                    try {
                        object = new ServerSocket(this.debuggerPort, 1, InetAddress.getLocalHost());
                        ((ServerSocket)object).close();
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                    catch (SecurityException securityException) {
                        bl = false;
                    }
                    catch (Exception exception) {
                        if (exception.getClass().getName().equals("android.os.NetworkOnMainThreadException")) {
                        } else {
                            bl = false;
                        }
                    }
                    finally {
                        try {
                            if (object != null) {
                                ((ServerSocket)object).close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (bl) {
                        this.mDisplayWaitingDialog = true;
                        this.afterOnCreate();
                    } else {
                        this.showDialogUnableToListenOnPort(this.debuggerPort);
                    }
                    this.mDebuggerSettings.setListen(debugMode == DebugMode.ListenMode);
                    this.mDebuggerSettings.setDebugerPort(this.debuggerPort);
                    break;
                }
                case ConnectMode: {
                    boolean bl = Utils.nativeConnectDebuggerSocket(string);
                    if (!bl) {
                        this.showDialogforIpAddress(string);
                        break;
                    }
                    this.mDebuggerSettings.setHost(string);
                    this.afterOnCreate();
                    break;
                }
                case None: {
                    this.afterOnCreate();
                    return;
                }
                case ConflictMode: {
                    return;
                }
            }
        }
    }

    private void showDialogforIpAddress(String string) {
        Context context = this.getApplicationContext();
        RemoteDebuggerDialog remoteDebuggerDialog = new RemoteDebuggerDialog(this.m_activity);
        remoteDebuggerDialog.createAndShowDialog(string);
    }

    private void closeDialogWaitingForConnection() {
        Context context = this.getApplicationContext();
        try {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.MAIN");
            intent.addCategory("RemoteDebuggerListenerDialogClose");
            intent.putExtra("debuggerPort", this.debuggerPort);
            context.sendBroadcast(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showDialogWaitingForConnection(int n) {
        Context context = this.getApplicationContext();
        try {
            Intent intent = new Intent(this.m_runtimeContext, RemoteDebuggerListenerDialog.class);
            intent.setAction("android.intent.action.MAIN");
            intent.addCategory("RemoteDebuggerListenerDialog");
            intent.putExtra("debuggerPort", n);
            this.m_activity.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void gotResultFromDialog(boolean bl, String string) {
        boolean bl2 = false;
        if (bl) {
            if (string.length() != 0) {
                bl2 = Utils.nativeConnectDebuggerSocket(string);
            }
            if (!bl2) {
                this.showDialogforIpAddress(string);
            } else {
                this.mDebuggerSettings.setHost(string);
                this.mDebuggerSettings.setListen(false);
                this.mShowDebuggerDialog = true;
            }
        }
        if (bl2 || !bl) {
            this.afterOnCreate();
        }
    }

    public void addActivityStateChangeListner(StateChangeCallback stateChangeCallback) {
        if (this.mActivityStateListeners == null) {
            this.mActivityStateListeners = new ArrayList<StateChangeCallback>();
        }
        if (!this.mActivityStateListeners.contains(stateChangeCallback)) {
            this.mActivityStateListeners.add(stateChangeCallback);
        }
    }

    public void removeActivityStateChangeListner(StateChangeCallback stateChangeCallback) {
        if (this.mActivityStateListeners != null) {
            this.mActivityStateListeners.remove(stateChangeCallback);
        }
    }

    private void callActivityStateListeners() {
        if (this.mActivityStateListeners == null) {
            return;
        }
        try {
            int n = this.mActivityStateListeners.size();
            for (int i = 0; i < n; ++i) {
                this.mActivityStateListeners.get(i).onActivityStateChanged(this.mActivityState);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void callActivityStateListeners(Configuration configuration) {
        if (this.mActivityStateListeners == null) {
            return;
        }
        try {
            int n = this.mActivityStateListeners.size();
            for (int i = 0; i < n; ++i) {
                this.mActivityStateListeners.get(i).onConfigurationChanged(configuration);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addActivityResultListener(ActivityResultCallback activityResultCallback) {
        if (this.mActivityResultListeners == null) {
            this.mActivityResultListeners = new ArrayList<ActivityResultCallback>();
        }
        if (!this.mActivityResultListeners.contains(activityResultCallback)) {
            this.mActivityResultListeners.add(activityResultCallback);
        }
    }

    public void removeActivityResultListener(ActivityResultCallback activityResultCallback) {
        if (this.mActivityResultListeners != null) {
            this.mActivityResultListeners.remove(activityResultCallback);
        }
    }

    private void callActivityResultListeners(int n, int n2, Intent intent) {
        if (this.mActivityResultListeners == null) {
            return;
        }
        try {
            int n3 = this.mActivityResultListeners.size();
            for (int i = 0; i < n3; ++i) {
                this.mActivityResultListeners.get(i).onActivityResult(n, n2, intent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void SignalNewActivityCreated() {
        this.m_newActivityLock.lock();
        this.m_newActivityCondition.signalAll();
        this.m_newActivityLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity WaitForNewActivity() {
        this.m_newActivityLock.lock();
        try {
            if (this.m_activity == null) {
                this.m_newActivityCondition.await();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_newActivityLock.unlock();
        }
        return this.m_activity;
    }

    private void setFullScreenFromMetaData() {
        try {
            ActivityInfo activityInfo = this.m_activity.getPackageManager().getActivityInfo(this.m_activity.getComponentName(), 128);
            Bundle bundle = activityInfo.metaData;
            if (bundle == null) {
                return;
            }
            Boolean bl = (Boolean)bundle.get("fullScreen");
            if (bl != null && bl.booleanValue()) {
                this.m_mainView.setFullScreen();
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    protected void setIsFullScreen(boolean bl) {
        this.mIsFullScreen = bl;
    }

    protected boolean getIsFullScreen() {
        return this.mIsFullScreen;
    }

    public String GetAppCacheDirectory() {
        return this.m_application.getCacheDir().getAbsolutePath();
    }

    public String GetAppDataDirectory() {
        return this.m_application.getApplicationInfo().dataDir;
    }

    public String GetRuntimeDataDirectory() {
        return this.m_runtimeContext.getApplicationInfo().dataDir + "/";
    }

    public void finishActivityFromChild(Activity activity, int n) {
    }

    public void finishFromChild(Activity activity) {
    }

    public void onAttachedToWindow() {
    }

    public void onBackPressed() {
    }

    public void onContentChanged() {
    }

    public boolean onContextItemSelected(MenuItem menuItem, boolean bl) {
        return bl;
    }

    public void onContextMenuClosed(Menu menu) {
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
    }

    public CharSequence onCreateDescription(CharSequence charSequence) {
        return charSequence;
    }

    public boolean onCreateOptionsMenu(Menu menu, boolean bl) {
        return bl;
    }

    public boolean onCreatePanelMenu(int n, Menu menu, boolean bl) {
        return bl;
    }

    public View onCreatePanelView(int n, View view) {
        return view;
    }

    public boolean onCreateThumbnail(Bitmap bitmap, Canvas canvas, boolean bl) {
        return bl;
    }

    public View onCreateView(String string, Context context, AttributeSet attributeSet, View view) {
        return view;
    }

    public void onDetachedFromWindow() {
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent, boolean bl) {
        return bl;
    }

    public boolean onKeyLongPress(int n, KeyEvent keyEvent, boolean bl) {
        return bl;
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent, boolean bl) {
        return bl;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent, boolean bl) {
        return bl;
    }

    public boolean onMenuItemSelected(int n, MenuItem menuItem, boolean bl) {
        return bl;
    }

    public boolean onMenuOpened(int n, Menu menu, boolean bl) {
        return bl;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem, boolean bl) {
        return bl;
    }

    public void onOptionsMenuClosed(Menu menu) {
    }

    public void onPanelClosed(int n, Menu menu) {
    }

    public boolean onPrepareOptionsMenu(Menu menu, boolean bl) {
        return bl;
    }

    public boolean onPreparePanel(int n, View view, Menu menu, boolean bl) {
        return bl;
    }

    public Object onRetainNonConfigurationInstance(Object object) {
        return object;
    }

    public boolean onSearchRequested(boolean bl) {
        return bl;
    }

    public boolean onTouchEvent(MotionEvent motionEvent, boolean bl) {
        return bl;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent, boolean bl) {
        return bl;
    }

    public void onUserInteraction() {
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
    }

    public void onWindowFocusChanged(boolean bl) {
    }

    public void onApplyThemeResource(Resources.Theme theme, int n, boolean bl) {
    }

    public void onChildTitleChanged(Activity activity, CharSequence charSequence) {
    }

    public Dialog onCreateDialog(int n, Bundle bundle, Dialog dialog) {
        return dialog;
    }

    public Dialog onCreateDialog(int n, Dialog dialog) {
        return dialog;
    }

    public void onPostCreate(Bundle bundle) {
    }

    public void onPostResume() {
    }

    public void onPrepareDialog(int n, Dialog dialog, Bundle bundle) {
    }

    public void onPrepareDialog(int n, Dialog dialog) {
    }

    public void onRestoreInstanceState(Bundle bundle) {
    }

    public void onSaveInstanceState(Bundle bundle) {
    }

    public void onTitleChanged(CharSequence charSequence, int n) {
    }

    public void onUserLeaveHint() {
    }

    public DebuggerSettings GetDebuggerSettings() {
        return this.mDebuggerSettings;
    }

    public void applyDownloadedConfig() {
        if (sEntryPoint != null) {
            sEntryPoint.EntryApplyDownloadedConfig();
        }
    }

    static interface ActivityResultCallback {
        public void onActivityResult(int var1, int var2, Intent var3);
    }

    static interface StateChangeCallback {
        public void onActivityStateChanged(ActivityState var1);

        public void onConfigurationChanged(Configuration var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DebugMode {
        None,
        ConnectMode,
        ListenMode,
        ConflictMode;

    }

    public static class PlaneID {
        public static final int PLANE_STAGEWEBVIEW = 0;
        public static final int PLANE_STAGETEXT = 1;
        public static final int PLANE_OVERLAY = 2;
        public static final int PLANE_FLASH = 3;
        public static final int PLANE_STAGEVIDEOAUTOMATIC = 4;
        public static final int PLANE_CAMERA = 5;
        public static final int PLANE_STAGE3D = 6;
        public static final int PLANE_STAGEVIDEO = 7;
        public static final int PLANE_COUNT = 8;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActivityState {
        STARTED,
        RESTARTED,
        RESUMED,
        PAUSED,
        STOPPED,
        DESTROYED;

    }
}

