/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemClock;
import com.adobe.air.Entrypoints;
import com.adobe.air.utils.Utils;

public class AIRService
extends Service {
    public static final String INTENT_CONFIG_DOWNLOADED = "com.adobe.air.DownloadConfigComplete";
    public static final String INTENT_DOWNLOAD_CONFIG = "com.adobe.air.DownloadConfig";
    public static final String EXTRA_DOWNLOAD_TIME = "com.adobe.air.DownloadConfigCompleteTime";
    private static final String LOG_TAG = "AIRService";
    private static AIRService sServiceInstance = null;
    private Entrypoints mEntrypoints = null;
    private boolean mPlayerInitialized = false;
    private final IBinder mBinder = new DummyBinder();

    public void onCreate() {
        super.onCreate();
        this.mEntrypoints = new Entrypoints();
        sServiceInstance = this;
        Utils.setRuntimePackageName(this.getApplicationContext().getPackageName());
    }

    public void onDestroy() {
        super.onDestroy();
        sServiceInstance = null;
        if (this.mPlayerInitialized) {
            this.mEntrypoints.EntryStopRuntime();
            this.mPlayerInitialized = false;
        }
        if (!Utils.hasCaptiveRuntime()) {
            Process.killProcess((int)Process.myPid());
        }
    }

    public int onStartCommand(Intent intent, int n, int n2) {
        if (intent.getAction().equals(INTENT_DOWNLOAD_CONFIG)) {
            this.downloadConfig();
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public static AIRService getAIRService() {
        return sServiceInstance;
    }

    private Entrypoints getEntrypoints() {
        return this.mEntrypoints;
    }

    private void downloadConfig() {
        if (!this.mPlayerInitialized) {
            this.mPlayerInitialized = true;
            if (!this.mEntrypoints.EntryDownloadConfig(this.getApplicationContext(), Utils.getRuntimePackageName())) {
                this.downloadDone(false);
            }
        }
    }

    public void downloadDone(boolean bl) {
        if (bl) {
            Intent intent = new Intent(INTENT_CONFIG_DOWNLOADED);
            intent.putExtra(EXTRA_DOWNLOAD_TIME, SystemClock.uptimeMillis());
            this.sendStickyBroadcast(intent);
        }
        this.stopSelf();
    }

    public Context getContext() {
        this.getEntrypoints();
        return Entrypoints.s_context;
    }

    public static boolean IsRunningInServiceContext() {
        return AIRService.getAIRService() != null;
    }

    public class DummyBinder
    extends Binder {
        AIRService getService() {
            return AIRService.this;
        }
    }
}

