/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.air;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.BaseExpandableListAdapter;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.adobe.air.AndroidActivityWrapper;
import com.adobe.air.AndroidAlertDialog;
import com.adobe.air.FileChooserStub;
import com.adobe.air.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIRExpandableFileChooser
implements ExpandableListView.OnChildClickListener {
    public static final String TAG = AIRExpandableFileChooser.class.toString();
    private static final String TYPE = "TYPE";
    private static final String FILEINFO = "FILEINFO";
    private String mSelection = new String();
    private View mMultipleFileSelectionView = null;
    private boolean mAllowMultiple = false;
    private boolean mSave = false;
    private SparseBooleanArray mCheckedFiles = new SparseBooleanArray();
    private ArrayList<String> mFilenames = new ArrayList();
    private final String[] mFileProjection = new String[]{"_data", "_display_name"};
    private AndroidAlertDialog mFileChooserDialog = null;
    private FileChooserStub mFileChooserStub = null;
    private Resources mRuntimeResources = null;
    private LayoutInflater mRuntimeInflater = null;
    private static final String USER_ACTION_DONE = "done";
    private static final String USER_ACTION_CANCEL = "cancel";
    private EditText mFileSaveName = null;
    private List<Map<String, String>> mGroupData = new ArrayList<Map<String, String>>();
    private List<List<Map<String, FileInfo>>> mChildData = new ArrayList<List<Map<String, FileInfo>>>();
    private ExpandableListAdapter mAdapter;

    public AIRExpandableFileChooser(ArrayList<String> arrayList, boolean bl, boolean bl2, String string, FileChooserStub fileChooserStub) {
        Button button;
        String string2;
        this.mSave = bl;
        this.mAllowMultiple = bl2;
        this.mFileChooserStub = fileChooserStub;
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add("*");
        }
        int n = arrayList.size();
        for (int i = 0; !(i >= n || (string2 = arrayList.get(i)).startsWith("*") && (string2 = string2.substring(1)).length() == 0); ++i) {
            if (this.mSelection.length() != 0) {
                this.mSelection = this.mSelection + " OR ";
            }
            this.mSelection = this.mSelection + "_display_name LIKE '%" + string2 + "'";
        }
        AndroidActivityWrapper androidActivityWrapper = AndroidActivityWrapper.GetAndroidActivityWrapper();
        this.mFileChooserDialog = new AndroidAlertDialog((Context)androidActivityWrapper.getActivity());
        string2 = this.mFileChooserDialog.GetAlertDialogBuilder();
        string2.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialogInterface, int n, KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 4) {
                    AIRExpandableFileChooser.this.mFileChooserStub.SetUserAction(AIRExpandableFileChooser.USER_ACTION_CANCEL);
                }
                return false;
            }
        });
        Context context = androidActivityWrapper.getRuntimeContext();
        this.mRuntimeInflater = LayoutInflater.from((Context)context);
        this.mRuntimeResources = context.getResources();
        View view = Utils.GetLayoutViewFromRuntime("main", this.mRuntimeResources, this.mRuntimeInflater);
        string2.setView(view);
        Resources resources = view.getResources();
        ExpandableListView expandableListView = (ExpandableListView)Utils.GetWidgetInViewByName("list", resources, view);
        expandableListView.setOnChildClickListener((ExpandableListView.OnChildClickListener)this);
        expandableListView.setEmptyView(androidActivityWrapper.getActivity().findViewById(16908292));
        RelativeLayout relativeLayout = (RelativeLayout)Utils.GetWidgetInViewByName("file_save_panel", resources, view);
        if (this.mSave) {
            string2.setTitle((CharSequence)Utils.GetResourceStringFromRuntime("file_download", this.mRuntimeResources));
            relativeLayout.setVisibility(0);
            this.mFileSaveName = (EditText)Utils.GetWidgetInViewByName("file_save_name", resources, view);
            if (string != null) {
                this.mFileSaveName.setText((CharSequence)(Utils.GetExternalStorageDirectory() + "/" + string));
            }
            this.mFileSaveName.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View view, int n, KeyEvent keyEvent) {
                    if (keyEvent.getAction() == 0 && n == 66) {
                        String string = AIRExpandableFileChooser.this.mFileSaveName.getText().toString();
                        if (string.length() != 0) {
                            AIRExpandableFileChooser.this.mFilenames.clear();
                            AIRExpandableFileChooser.this.mFilenames.add(string);
                            AIRExpandableFileChooser.this.mFileChooserStub.SetUserAction(AIRExpandableFileChooser.USER_ACTION_DONE);
                            AIRExpandableFileChooser.this.HideVirtualKeyboard((View)AIRExpandableFileChooser.this.mFileSaveName);
                            AIRExpandableFileChooser.this.mFileChooserDialog.dismiss();
                        }
                        return true;
                    }
                    return false;
                }
            });
            button = (Button)Utils.GetWidgetInViewByName("file_save_button", resources, view);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    String string = AIRExpandableFileChooser.this.mFileSaveName.getText().toString();
                    if (string.length() != 0) {
                        AIRExpandableFileChooser.this.mFilenames.clear();
                        AIRExpandableFileChooser.this.mFilenames.add(string);
                        AIRExpandableFileChooser.this.mFileChooserStub.SetUserAction(AIRExpandableFileChooser.USER_ACTION_DONE);
                        AIRExpandableFileChooser.this.HideVirtualKeyboard((View)AIRExpandableFileChooser.this.mFileSaveName);
                        AIRExpandableFileChooser.this.mFileChooserDialog.dismiss();
                    }
                }
            });
        } else {
            string2.setTitle((CharSequence)Utils.GetResourceStringFromRuntime("file_upload", this.mRuntimeResources));
            relativeLayout.setVisibility(8);
        }
        this.AddMediaSubtree(Utils.GetResourceStringFromRuntime("audio_files", this.mRuntimeResources), MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
        this.AddMediaSubtree(Utils.GetResourceStringFromRuntime("image_files", this.mRuntimeResources), MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        this.AddMediaSubtree(Utils.GetResourceStringFromRuntime("video_files", this.mRuntimeResources), MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
        if (!this.mGroupData.isEmpty()) {
            this.mAdapter = new FileChooserExpandableListAdapter(this.mRuntimeInflater, this.mRuntimeResources);
            expandableListView.setAdapter(this.mAdapter);
            expandableListView.setItemsCanFocus(true);
            button = (TextView)Utils.GetWidgetInViewByName("empty", resources, view);
            button.setVisibility(8);
        } else {
            expandableListView.setVisibility(8);
        }
        if (this.mAllowMultiple) {
            this.createInvisibleMultipleFileSelectionView();
        }
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
        if (!(view instanceof FileChooserItem)) {
            return false;
        }
        FileChooserItem fileChooserItem = (FileChooserItem)view;
        if (!this.mAllowMultiple) {
            HashMap hashMap = (HashMap)this.mAdapter.getChild(n, n2);
            if (this.mSave) {
                this.mFileSaveName.setText((CharSequence)((FileInfo)hashMap.get((Object)FILEINFO)).mFilePath);
            } else {
                this.mFilenames.clear();
                this.mFilenames.add(((FileInfo)hashMap.get((Object)FILEINFO)).mFilePath);
                this.mFileChooserStub.SetUserAction(USER_ACTION_DONE);
                this.mFileChooserDialog.dismiss();
            }
        } else {
            fileChooserItem.toggle();
        }
        return true;
    }

    private int expandableListPositionToFlatPosition(int n, int n2) {
        if (n < 0 || n >= this.mChildData.size()) {
            return -1;
        }
        if (n2 < 0 || n2 >= this.mChildData.get(n).size()) {
            return -1;
        }
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this.mChildData.get(i).size();
        }
        return n3 += n2;
    }

    private void uncheckAll() {
        if (!this.mAllowMultiple) {
            return;
        }
        int n = this.mGroupData.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.mChildData.get(i).size();
            for (int j = 0; j < n2; ++j) {
                HashMap hashMap = (HashMap)this.mAdapter.getChild(i, j);
                FileChooserItem fileChooserItem = ((FileInfo)hashMap.get((Object)FILEINFO)).mParent;
                if (fileChooserItem == null) continue;
                fileChooserItem.uncheck();
            }
        }
    }

    private void createInvisibleMultipleFileSelectionView() {
        AlertDialog.Builder builder = this.mFileChooserDialog.GetAlertDialogBuilder();
        builder.setPositiveButton((CharSequence)Utils.GetResourceStringFromRuntime("button_ok", this.mRuntimeResources), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                AIRExpandableFileChooser.this.mFilenames.clear();
                int n2 = AIRExpandableFileChooser.this.mGroupData.size();
                for (int i = 0; i < n2; ++i) {
                    int n3 = ((List)AIRExpandableFileChooser.this.mChildData.get(i)).size();
                    for (int j = 0; j < n3; ++j) {
                        int n4 = AIRExpandableFileChooser.this.expandableListPositionToFlatPosition(i, j);
                        if (!AIRExpandableFileChooser.this.mCheckedFiles.get(n4)) continue;
                        HashMap hashMap = (HashMap)AIRExpandableFileChooser.this.mAdapter.getChild(i, j);
                        AIRExpandableFileChooser.this.mFilenames.add(((FileInfo)hashMap.get((Object)AIRExpandableFileChooser.FILEINFO)).mFilePath);
                    }
                }
                AIRExpandableFileChooser.this.mFileChooserStub.SetUserAction(AIRExpandableFileChooser.USER_ACTION_DONE);
            }
        });
        builder.setNegativeButton((CharSequence)Utils.GetResourceStringFromRuntime("button_cancel", this.mRuntimeResources), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                AIRExpandableFileChooser.this.uncheckAll();
                AIRExpandableFileChooser.this.mFileChooserStub.SetUserAction(AIRExpandableFileChooser.USER_ACTION_CANCEL);
            }
        });
    }

    private void AddMediaSubtree(String string, Uri uri) {
        Cursor cursor = AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity().managedQuery(uri, this.mFileProjection, this.mSelection.length() == 0 ? null : this.mSelection, null, null);
        ArrayList arrayList = new ArrayList();
        if (cursor != null && cursor.moveToFirst()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(TYPE, string);
            this.mGroupData.add(hashMap);
            do {
                FileInfo fileInfo = new FileInfo(cursor.getString(cursor.getColumnIndex("_display_name")), cursor.getString(cursor.getColumnIndex("_data")));
                HashMap<String, FileInfo> hashMap2 = new HashMap<String, FileInfo>();
                arrayList.add(hashMap2);
                hashMap2.put(FILEINFO, fileInfo);
            } while (cursor.moveToNext());
            this.mChildData.add(arrayList);
        }
    }

    private void HideVirtualKeyboard(View view) {
        InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public AndroidAlertDialog GetDialog() {
        return this.mFileChooserDialog;
    }

    public ArrayList<String> GetFileNames() {
        return this.mFilenames;
    }

    private class FileChooserExpandableListAdapter
    extends BaseExpandableListAdapter {
        private LayoutInflater mRuntimeInflater = null;
        private Resources mRuntimeResources = null;

        public FileChooserExpandableListAdapter(LayoutInflater layoutInflater, Resources resources) {
            this.mRuntimeInflater = layoutInflater;
            this.mRuntimeResources = resources;
        }

        public Object getChild(int n, int n2) {
            return ((List)AIRExpandableFileChooser.this.mChildData.get(n)).get(n2);
        }

        public long getChildId(int n, int n2) {
            return n2;
        }

        public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
            FileChooserItem fileChooserItem = view == null || !(view instanceof FileChooserItem) ? new FileChooserItem(this.mRuntimeInflater, this.mRuntimeResources, viewGroup, n, n2) : (FileChooserItem)view;
            fileChooserItem.bindToData((FileInfo)((Map)((List)AIRExpandableFileChooser.this.mChildData.get(n)).get(n2)).get(AIRExpandableFileChooser.FILEINFO), n, n2);
            return fileChooserItem;
        }

        public int getChildrenCount(int n) {
            return ((List)AIRExpandableFileChooser.this.mChildData.get(n)).size();
        }

        public Object getGroup(int n) {
            return AIRExpandableFileChooser.this.mGroupData.get(n);
        }

        public int getGroupCount() {
            return AIRExpandableFileChooser.this.mGroupData.size();
        }

        public long getGroupId(int n) {
            return n;
        }

        public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
            View view2 = view == null ? this.mRuntimeInflater.inflate(17367046, viewGroup, false) : view;
            TextView textView = (TextView)view2.findViewById(16908308);
            if (textView != null) {
                textView.setText((CharSequence)((Map)AIRExpandableFileChooser.this.mGroupData.get(n)).get(AIRExpandableFileChooser.TYPE));
            }
            return view2;
        }

        public boolean isChildSelectable(int n, int n2) {
            return true;
        }

        public boolean hasStableIds() {
            return true;
        }
    }

    private class FileChooserItem
    extends LinearLayout {
        private TextView mFileNameView;
        private TextView mFilePathView;
        private CompoundButton mFileCheckBox;
        private CompoundButton.OnCheckedChangeListener mListener;
        private int mListFlatPosition;

        FileChooserItem(LayoutInflater layoutInflater, Resources resources, ViewGroup viewGroup, int n, int n2) {
            super((Context)AndroidActivityWrapper.GetAndroidActivityWrapper().getActivity());
            this.mListFlatPosition = -1;
            if (AIRExpandableFileChooser.this.mAllowMultiple) {
                View view = Utils.GetLayoutViewFromRuntime("expandable_multiple_chooser_row", resources, layoutInflater);
                Resources resources2 = view.getResources();
                this.mFileNameView = (TextView)Utils.GetWidgetInViewByName("filename", resources2, view);
                this.mFilePathView = (TextView)Utils.GetWidgetInViewByName("filepath", resources2, view);
                this.mFileCheckBox = (CompoundButton)Utils.GetWidgetInViewByName("filecheck", resources2, view);
                if (this.mFileNameView == null || this.mFilePathView == null || this.mFileCheckBox == null) {
                    // empty if block
                }
                this.mListFlatPosition = AIRExpandableFileChooser.this.expandableListPositionToFlatPosition(n, n2);
                this.mListener = new CompoundButton.OnCheckedChangeListener(){

                    public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                        if (FileChooserItem.this.mListFlatPosition < 0) {
                            return;
                        }
                        if (bl) {
                            AIRExpandableFileChooser.this.mCheckedFiles.put(FileChooserItem.this.mListFlatPosition, bl);
                        } else {
                            AIRExpandableFileChooser.this.mCheckedFiles.delete(FileChooserItem.this.mListFlatPosition);
                        }
                    }
                };
                this.addView(view);
            } else {
                View view = Utils.GetLayoutViewFromRuntime("expandable_chooser_row", resources, layoutInflater);
                Resources resources3 = view.getResources();
                this.mFileNameView = (TextView)Utils.GetWidgetInViewByName("filename", resources3, view);
                this.mFilePathView = (TextView)Utils.GetWidgetInViewByName("filepath", resources3, view);
                if (this.mFileNameView == null || this.mFilePathView == null) {
                    // empty if block
                }
                this.addView(view);
            }
        }

        public void bindToData(FileInfo fileInfo, int n, int n2) {
            this.mFileNameView.setText((CharSequence)fileInfo.mFileName);
            this.mFilePathView.setText((CharSequence)fileInfo.mFilePath);
            if (AIRExpandableFileChooser.this.mAllowMultiple) {
                this.mListFlatPosition = AIRExpandableFileChooser.this.expandableListPositionToFlatPosition(n, n2);
                this.mFileCheckBox.setOnCheckedChangeListener(null);
                this.mFileCheckBox.setChecked(AIRExpandableFileChooser.this.mCheckedFiles.get(this.mListFlatPosition));
                this.mFileCheckBox.setOnCheckedChangeListener(this.mListener);
                fileInfo.mParent = this;
            }
        }

        public void toggle() {
            if (AIRExpandableFileChooser.this.mAllowMultiple) {
                this.mListener.onCheckedChanged(this.mFileCheckBox, !this.mFileCheckBox.isChecked());
                this.mFileCheckBox.setOnCheckedChangeListener(null);
                this.mFileCheckBox.setChecked(AIRExpandableFileChooser.this.mCheckedFiles.get(this.mListFlatPosition));
                this.mFileCheckBox.setOnCheckedChangeListener(this.mListener);
            }
        }

        public void uncheck() {
            if (AIRExpandableFileChooser.this.mAllowMultiple) {
                this.mListener.onCheckedChanged(this.mFileCheckBox, false);
                this.mFileCheckBox.setOnCheckedChangeListener(null);
                this.mFileCheckBox.setChecked(false);
                this.mFileCheckBox.setOnCheckedChangeListener(this.mListener);
            }
        }
    }

    private class FileInfo {
        public String mFileName = new String();
        public String mFilePath = new String();
        public FileChooserItem mParent = null;

        public FileInfo(String string, String string2) {
            this.mFileName = string;
            this.mFilePath = string2;
        }
    }
}

