/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fxg;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class FXGException
extends RuntimeException {
    private static final long serialVersionUID = -7393979231178285695L;
    private static final Locale DEFAULT_LOCALE;
    private static final String DEFAULT_RESOURCE_BASE_NAME = "com.adobe.fxg.FXGException";
    private static Locale locale;
    private static String resourceBaseName;
    private static ResourceBundle exceptionResourceBundle;
    private Object[] arguments;
    private String message;
    private int lineNumber;
    private int columnNumber;

    public FXGException() {
        this.arguments = null;
        this.message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(Throwable cause) {
        super(cause);
        this.arguments = null;
        this.message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(String message, Throwable cause, Object ... arguments) {
        super(message, cause);
        this.arguments = arguments;
        message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(String message, Object ... arguments) {
        super(message);
        this.arguments = arguments;
        message = null;
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public FXGException(int lineNumber, int columnNumber) {
        this.arguments = null;
        this.message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, Throwable cause) {
        super(cause);
        this.arguments = null;
        this.message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, String message, Throwable cause, Object ... arguments) {
        super(message, cause);
        this.arguments = arguments;
        message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public FXGException(int lineNumber, int columnNumber, String message, Object ... arguments) {
        super(message);
        this.arguments = arguments;
        message = null;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale loc) {
        if (loc == null) {
            loc = DEFAULT_LOCALE;
        }
        if (locale.equals(loc)) {
            return;
        }
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            locale = loc;
            FXGException.setResourceBundle();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setResourceBundle(String baseName, Locale loc) {
        if (baseName == null) {
            baseName = DEFAULT_RESOURCE_BASE_NAME;
        }
        if (loc == null) {
            loc = DEFAULT_LOCALE;
        }
        if (resourceBaseName.equals(baseName) && locale.equals(loc) && exceptionResourceBundle != null) {
            return;
        }
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            locale = loc;
            resourceBaseName = baseName;
            FXGException.setResourceBundle();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            FXGException.setResourceBundle(null, null);
            this.message = this.getLocalizedMessage();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.message;
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedMessage() {
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            if (exceptionResourceBundle == null) {
                FXGException.setResourceBundle();
            }
            String paramMsg = super.getMessage();
            if (exceptionResourceBundle != null) {
                Enumeration<String> keys = exceptionResourceBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (!key.equals(paramMsg)) continue;
                    paramMsg = exceptionResourceBundle.getString(super.getMessage());
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.substituteArguments(paramMsg, this.arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalizedMessage(Locale locale) {
        Class<FXGException> clazz = FXGException.class;
        synchronized (FXGException.class) {
            FXGException.setLocale(locale);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.getLocalizedMessage();
        }
    }

    private static void setResourceBundle() {
        try {
            exceptionResourceBundle = ResourceBundle.getBundle(resourceBaseName, locale);
        }
        catch (MissingResourceException e) {
            exceptionResourceBundle = null;
        }
    }

    private String substituteArguments(String parameterized, Object[] arguments) {
        if (parameterized == null || arguments == null) {
            return parameterized;
        }
        return MessageFormat.format(parameterized, arguments).trim();
    }

    static {
        locale = DEFAULT_LOCALE = Locale.ENGLISH;
        resourceBaseName = DEFAULT_RESOURCE_BASE_NAME;
        exceptionResourceBundle = null;
    }
}

