/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.bridge.UpdateManagerEvent;
import org.apache.batik.bridge.UpdateManagerListener;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.GVTTreeBuilderListener;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGScrollPane
extends JPanel {
    protected JSVGCanvas canvas;
    protected JPanel horizontalPanel;
    protected JScrollBar vertical;
    protected JScrollBar horizontal;
    protected Component cornerBox;
    protected SBListener hsbListener;
    protected SBListener vsbListener;
    protected Rectangle2D viewBox = null;
    protected boolean ignoreScrollChange = false;

    public JSVGScrollPane(JSVGCanvas canvas) {
        this.canvas = canvas;
        canvas.setRecenterOnResize(false);
        this.vertical = new JScrollBar(1, 0, 0, 0, 0);
        this.horizontal = new JScrollBar(0, 0, 0, 0, 0);
        this.horizontalPanel = new JPanel(new BorderLayout());
        this.horizontalPanel.add((Component)this.horizontal, "Center");
        this.cornerBox = Box.createRigidArea(new Dimension(this.vertical.getPreferredSize().width, this.horizontal.getPreferredSize().height));
        this.horizontalPanel.add(this.cornerBox, "East");
        this.hsbListener = this.createScrollBarListener(false);
        this.horizontal.getModel().addChangeListener(this.hsbListener);
        this.vsbListener = this.createScrollBarListener(true);
        this.vertical.getModel().addChangeListener(this.vsbListener);
        this.horizontalPanel.setVisible(false);
        this.vertical.setVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)canvas, "Center");
        this.add((Component)this.vertical, "East");
        this.add((Component)this.horizontalPanel, "South");
        canvas.addSVGDocumentLoaderListener(new SVGScrollDocumentLoaderListener());
        ScrollListener xlistener = new ScrollListener();
        this.addComponentListener(xlistener);
        canvas.addJGVTComponentListener(xlistener);
        canvas.addGVTTreeBuilderListener(xlistener);
        canvas.addUpdateManagerListener(xlistener);
    }

    protected SBListener createScrollBarListener(boolean isVertical) {
        return new SBListener(isVertical);
    }

    public JSVGCanvas getCanvas() {
        return this.canvas;
    }

    public void reset() {
        this.viewBox = null;
        this.horizontalPanel.setVisible(false);
        this.vertical.setVisible(false);
        this.revalidate();
    }

    protected void setScrollPosition() {
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return;
        }
        AffineTransform crt = this.canvas.getRenderingTransform();
        AffineTransform vbt = this.canvas.getViewBoxTransform();
        if (crt == null) {
            crt = new AffineTransform();
        }
        if (vbt == null) {
            vbt = new AffineTransform();
        }
        Rectangle r2d = vbt.createTransformedShape(this.viewBox).getBounds();
        int tx = 0;
        int ty = 0;
        if (r2d.x < 0) {
            tx -= r2d.x;
        }
        if (r2d.y < 0) {
            ty -= r2d.y;
        }
        int deltaX = this.horizontal.getValue() - tx;
        int deltaY = this.vertical.getValue() - ty;
        crt.preConcatenate(AffineTransform.getTranslateInstance(-deltaX, -deltaY));
        this.canvas.setRenderingTransform(crt);
    }

    protected void resizeScrollBars() {
        this.ignoreScrollChange = true;
        this.checkAndSetViewBoxRect();
        if (this.viewBox == null) {
            return;
        }
        AffineTransform vbt = this.canvas.getViewBoxTransform();
        if (vbt == null) {
            vbt = new AffineTransform();
        }
        Rectangle r2d = vbt.createTransformedShape(this.viewBox).getBounds();
        int maxW = r2d.width;
        int maxH = r2d.height;
        int tx = 0;
        int ty = 0;
        if (r2d.x > 0) {
            maxW += r2d.x;
        } else {
            tx -= r2d.x;
        }
        if (r2d.y > 0) {
            maxH += r2d.y;
        } else {
            ty -= r2d.y;
        }
        this.vertical.setValue(ty);
        this.horizontal.setValue(tx);
        Dimension vpSize = this.updateScrollbarVisibility(tx, ty, maxW, maxH);
        this.vertical.setValues(ty, vpSize.height, 0, maxH);
        this.horizontal.setValues(tx, vpSize.width, 0, maxW);
        this.vertical.setBlockIncrement((int)(0.9f * (float)vpSize.height));
        this.horizontal.setBlockIncrement((int)(0.9f * (float)vpSize.width));
        this.vertical.setUnitIncrement((int)(0.2f * (float)vpSize.height));
        this.horizontal.setUnitIncrement((int)(0.2f * (float)vpSize.width));
        this.ignoreScrollChange = false;
    }

    protected Dimension updateScrollbarVisibility(int tx, int ty, int maxW, int maxH) {
        Dimension vpSize = this.canvas.getSize();
        int maxVPW = vpSize.width;
        int minVPW = vpSize.width;
        int maxVPH = vpSize.height;
        int minVPH = vpSize.height;
        if (this.vertical.isVisible()) {
            maxVPW += this.vertical.getPreferredSize().width;
        } else {
            minVPW -= this.vertical.getPreferredSize().width;
        }
        if (this.horizontalPanel.isVisible()) {
            maxVPH += this.horizontal.getPreferredSize().height;
        } else {
            minVPH -= this.horizontal.getPreferredSize().height;
        }
        boolean vVis = maxH > maxVPH || this.vertical.getValue() != 0;
        boolean hVis = maxW > maxVPW || this.horizontal.getValue() != 0;
        Dimension ret = new Dimension();
        if (vVis) {
            if (hVis) {
                this.horizontalPanel.setVisible(true);
                this.vertical.setVisible(true);
                this.cornerBox.setVisible(true);
                ret.width = minVPW;
                ret.height = minVPH;
            } else {
                this.vertical.setVisible(true);
                ret.width = minVPW;
                if (maxW > minVPW) {
                    this.horizontalPanel.setVisible(true);
                    this.cornerBox.setVisible(true);
                    ret.height = minVPH;
                } else {
                    this.horizontalPanel.setVisible(false);
                    this.cornerBox.setVisible(false);
                    ret.height = maxVPH;
                }
            }
        } else if (hVis) {
            this.horizontalPanel.setVisible(true);
            ret.height = minVPH;
            if (maxH > minVPH) {
                this.vertical.setVisible(true);
                this.cornerBox.setVisible(true);
                ret.width = minVPW;
            } else {
                this.vertical.setVisible(false);
                this.cornerBox.setVisible(false);
                ret.width = maxVPW;
            }
        } else {
            this.vertical.setVisible(false);
            this.horizontalPanel.setVisible(false);
            this.cornerBox.setVisible(false);
            ret.width = maxVPW;
            ret.height = maxVPH;
        }
        return ret;
    }

    protected void checkAndSetViewBoxRect() {
        if (this.viewBox != null) {
            return;
        }
        this.viewBox = this.getViewBoxRect();
    }

    protected Rectangle2D getViewBoxRect() {
        SVGDocument doc = this.canvas.getSVGDocument();
        if (doc == null) {
            return null;
        }
        SVGSVGElement el = doc.getRootElement();
        if (el == null) {
            return null;
        }
        String viewBoxStr = el.getAttributeNS(null, "viewBox");
        if (viewBoxStr.length() != 0) {
            float[] rect = ViewBox.parseViewBoxAttribute(el, viewBoxStr);
            return new Rectangle2D.Float(rect[0], rect[1], rect[2], rect[3]);
        }
        GraphicsNode gn = this.canvas.getGraphicsNode();
        if (gn == null) {
            return null;
        }
        return (Rectangle2D)gn.getBounds().clone();
    }

    public void scaleChange(float scale) {
    }

    protected class ScrollListener
    extends ComponentAdapter
    implements JGVTComponentListener,
    GVTTreeBuilderListener,
    UpdateManagerListener {
        protected boolean isReady = false;

        protected ScrollListener() {
        }

        public void componentTransformChanged(ComponentEvent evt) {
            if (this.isReady) {
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void componentResized(ComponentEvent evt) {
            if (this.isReady) {
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void gvtBuildPrepare(GVTTreeBuilderEvent e) {
            this.isReady = false;
            JSVGScrollPane.this.vertical.setVisible(false);
            JSVGScrollPane.this.horizontalPanel.setVisible(false);
            JSVGScrollPane.this.cornerBox.setVisible(false);
        }

        public void gvtBuildCompleted(GVTTreeBuilderEvent e) {
            this.isReady = true;
            JSVGScrollPane.this.viewBox = null;
        }

        public void updateCompleted(UpdateManagerEvent e) {
            if (JSVGScrollPane.this.viewBox == null) {
                JSVGScrollPane.this.resizeScrollBars();
                return;
            }
            Rectangle2D newview = JSVGScrollPane.this.getViewBoxRect();
            if (newview.getX() != JSVGScrollPane.this.viewBox.getX() || newview.getY() != JSVGScrollPane.this.viewBox.getY() || newview.getWidth() != JSVGScrollPane.this.viewBox.getWidth() || newview.getHeight() != JSVGScrollPane.this.viewBox.getHeight()) {
                JSVGScrollPane.this.viewBox = newview;
                JSVGScrollPane.this.resizeScrollBars();
            }
        }

        public void gvtBuildCancelled(GVTTreeBuilderEvent e) {
        }

        public void gvtBuildFailed(GVTTreeBuilderEvent e) {
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent e) {
        }

        public void managerStarted(UpdateManagerEvent e) {
        }

        public void managerSuspended(UpdateManagerEvent e) {
        }

        public void managerResumed(UpdateManagerEvent e) {
        }

        public void managerStopped(UpdateManagerEvent e) {
        }

        public void updateStarted(UpdateManagerEvent e) {
        }

        public void updateFailed(UpdateManagerEvent e) {
        }
    }

    protected class SBListener
    implements ChangeListener {
        protected boolean inDrag = false;
        protected int startValue;
        protected boolean isVertical;

        public SBListener(boolean vertical) {
            this.isVertical = vertical;
        }

        public synchronized void stateChanged(ChangeEvent e) {
            if (JSVGScrollPane.this.ignoreScrollChange) {
                return;
            }
            Object src = e.getSource();
            if (!(src instanceof BoundedRangeModel)) {
                return;
            }
            int val = this.isVertical ? JSVGScrollPane.this.vertical.getValue() : JSVGScrollPane.this.horizontal.getValue();
            BoundedRangeModel brm = (BoundedRangeModel)src;
            if (brm.getValueIsAdjusting()) {
                if (!this.inDrag) {
                    this.inDrag = true;
                    this.startValue = val;
                } else {
                    AffineTransform at = this.isVertical ? AffineTransform.getTranslateInstance(0.0, this.startValue - val) : AffineTransform.getTranslateInstance(this.startValue - val, 0.0);
                    JSVGScrollPane.this.canvas.setPaintingTransform(at);
                }
            } else {
                if (this.inDrag) {
                    this.inDrag = false;
                    if (val == this.startValue) {
                        JSVGScrollPane.this.canvas.setPaintingTransform(new AffineTransform());
                        return;
                    }
                }
                JSVGScrollPane.this.setScrollPosition();
            }
        }
    }

    class SVGScrollDocumentLoaderListener
    extends SVGDocumentLoaderAdapter {
        SVGScrollDocumentLoaderListener() {
        }

        public void documentLoadingCompleted(SVGDocumentLoaderEvent e) {
            SVGSVGElement root = e.getSVGDocument().getRootElement();
            root.addEventListener("SVGZoom", new EventListener(this){
                private final /* synthetic */ SVGScrollDocumentLoaderListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event evt) {
                    if (!(evt.getTarget() instanceof SVGSVGElement)) {
                        return;
                    }
                    SVGSVGElement svg = (SVGSVGElement)evt.getTarget();
                    SVGScrollDocumentLoaderListener.access$000(this.this$1).scaleChange(svg.getCurrentScale());
                }
            }, false);
        }

        static /* synthetic */ JSVGScrollPane access$000(SVGScrollDocumentLoaderListener x0) {
            return x0.JSVGScrollPane.this;
        }
    }
}

