/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import java.util.HashMap;

public class FaultActions {
    HashMap<String, Integer> m_faults = new HashMap();
    HashMap<String, String> m_description = new HashMap();
    HashMap<String, Integer> m_actions = new HashMap();
    int m_nextBitForAction = 1;

    Integer get(String o) {
        return this.m_faults.get(o);
    }

    Integer getAction(String o) {
        return this.m_actions.get(o);
    }

    void put(String k, Integer v) {
        this.m_faults.put(k, v);
    }

    public void clear() {
        this.m_faults.clear();
    }

    public int size() {
        return this.m_faults.size();
    }

    public Object[] names() {
        return this.m_faults.keySet().toArray();
    }

    public Object[] actions() {
        return this.m_actions.keySet().toArray();
    }

    public boolean exists(String k) {
        return this.get(k) != null;
    }

    public void putDescription(String k, String v) {
        this.m_description.put(k, v);
    }

    public String getDescription(String k) {
        return this.m_description.get(k) == null ? "" : this.m_description.get(k);
    }

    public void add(String k) {
        this.put(k, new Integer(0));
    }

    public void addAction(String k) {
        Integer v = new Integer(this.m_nextBitForAction++);
        this.m_actions.put(k, v);
    }

    public boolean is(String fault, String action) {
        int mask = this.getAction(action);
        int bits = this.get(fault);
        boolean set = (bits & mask) == mask;
        return set;
    }

    public int action(String fault, String action) {
        Integer bit;
        Integer current = this.get(fault);
        if (current == null) {
            throw new IllegalArgumentException(fault);
        }
        boolean no = action.startsWith("no");
        if (no) {
            action = action.substring(2);
        }
        if ((bit = this.getAction(action)) == null) {
            throw new IllegalArgumentException(action);
        }
        int old = current;
        int mask = bit;
        int n = old & ~mask;
        n = no ? n : n | mask;
        this.put(fault, new Integer(n));
        return n;
    }
}

