/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.builder.ArrayBuilder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.ReparentNode;
import flex2.compiler.mxml.dom.StateNode;
import flex2.compiler.mxml.dom.VectorNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Assignable;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.Vector;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import java.util.Collection;
import java.util.Iterator;

class VectorBuilder
extends AbstractBuilder {
    private ElementNodeHandler elementNodeHandler = new ElementNodeHandler();
    private ElementBindingHandler elementBindingHandler = new ElementBindingHandler();
    private Type elementType;
    private Model parent;
    private Assignable assignableProperty;
    private boolean allowBinding;
    Vector vector;
    private static final int FLAGS = 224;

    VectorBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent, Assignable assignable, Type elementType, boolean allowBinding) {
        this(unit, typeTable, mxmlConfiguration, document, parent, assignable, allowBinding);
        this.elementType = elementType;
    }

    VectorBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, Model parent, Assignable assignable, boolean allowBinding) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.parent = parent;
        this.assignableProperty = assignable;
        this.allowBinding = allowBinding;
    }

    public void analyze(VectorNode node) {
        boolean fixed = false;
        String fixedAttribute = (String)this.getLanguageAttributeValue(node, "fixed");
        if (fixedAttribute != null) {
            Object fixedObject = this.textParser.parseValue(fixedAttribute, this.typeTable.booleanType, 224, node.beginLine, "fixed");
            if (fixedObject instanceof BindingExpression) {
                this.log(node.beginLine, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
            } else if (fixedObject != null) {
                fixed = (Boolean)fixedObject;
            }
        }
        this.createVectorModel(node.beginLine, fixed);
        this.processStateAttributes(node, this.vector);
        this.ensureId(node);
        this.processChildren(node.getChildren());
        this.registerModel(node, (Model)this.vector, this.parent == null);
    }

    public void createVectorModel(int line, boolean fixed) {
        this.vector = new Vector(this.document, this.parent, line, this.getElementType(), fixed);
        this.vector.setParentIndex(this.getName(), this.getStateName());
    }

    void createSyntheticVectorModel(int line) {
        this.createVectorModel(line, false);
    }

    private void ensureId(VectorNode node) {
        String id = (String)this.getLanguageAttributeValue(node, "id");
        if (id != null) {
            this.vector.setId(id, false);
        }
    }

    void processChildren(Collection nodes) {
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            this.processTextInitializer(cdata.image, this.typeTable.objectType, cdata.inCDATA, cdata.beginLine);
        } else {
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                this.elementNodeHandler.invoke(this.assignableProperty, (Node)iter.next(), this.document);
            }
        }
    }

    private String getName() {
        return this.assignableProperty != null ? this.assignableProperty.getName() : null;
    }

    private String getStateName() {
        return this.assignableProperty != null ? this.assignableProperty.getStateName() : null;
    }

    private Type getElementType() {
        if (this.elementType != null) {
            return this.elementType;
        }
        return this.assignableProperty != null ? this.assignableProperty.getElementType() : null;
    }

    public void processTextInitializer(String text, Type vectorElementType, boolean cdata, int line) {
        int flags = cdata ? 1 : 0;
        Object result = this.textParser.parseValue(text, this.typeTable.vectorType, vectorElementType, flags, line, this.typeTable.vectorType.getName());
        if (result != null) {
            if (result instanceof BindingExpression) {
                if (this.allowBinding) {
                    BindingExpression bindingExpression = (BindingExpression)result;
                    if (this.parent != null) {
                        bindingExpression.setDestination(this.parent);
                    } else {
                        bindingExpression.setDestination(this.vector);
                    }
                    bindingExpression.setDestinationLValue(this.getName());
                    bindingExpression.setDestinationProperty(this.getName());
                } else {
                    this.log(line, (CompilerMessage)new AbstractBuilder.BindingNotAllowed());
                }
            } else {
                assert (result instanceof Vector);
                this.vector.setEntries(((Vector)result).getEntries());
            }
        }
    }

    public static class WrongElementType
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3924881723877853113L;
        public String elementTypeName;

        public WrongElementType(String elementTypeName) {
            this.elementTypeName = elementTypeName;
        }
    }

    public static class UnknownNode
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -3924881722877853113L;
        public String image;

        public UnknownNode(String image) {
            this.image = image;
        }
    }

    public static class ElementNotSupported
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = 8466102389418978639L;
        public String image;

        public ElementNotSupported(String image) {
            this.image = image;
        }
    }

    protected class ElementBindingHandler
    implements BindingHandler {
        protected ElementBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(VectorBuilder.this.vector);
            bindingExpression.setDestinationLValue(Integer.toString(VectorBuilder.this.vector.size()));
            bindingExpression.setDestinationProperty(VectorBuilder.this.vector.size());
            return bindingExpression;
        }
    }

    protected class ElementNodeHandler
    extends ValueNodeHandler {
        protected ElementNodeHandler() {
        }

        protected void componentNode(Assignable property, Node node, MxmlDocument document) {
            ComponentBuilder builder = new ComponentBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, document, VectorBuilder.this.vector, null, null, false, VectorBuilder.this.elementBindingHandler);
            node.analyze(builder);
            if (builder.component.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                builder.component.setParentIndex(VectorBuilder.this.vector.size());
                VectorBuilder.this.vector.addEntry(builder.component);
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void arrayNode(Assignable property, ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, null, VectorBuilder.this.allowBinding);
            node.analyze(builder);
            if (builder.array.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                builder.array.setParentIndex(VectorBuilder.this.vector.size());
                VectorBuilder.this.vector.addEntry(builder.array);
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void vectorNode(Assignable property, VectorNode node) {
            String typeAttribute = (String)node.getAttribute("type").getValue();
            Type elementType = VectorBuilder.this.typeTable.getType(NameFormatter.toColon(typeAttribute));
            VectorBuilder builder = new VectorBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, null, elementType, VectorBuilder.this.allowBinding);
            node.analyze(builder);
            if (builder.vector.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                builder.vector.setParentIndex(VectorBuilder.this.vector.size());
                VectorBuilder.this.vector.addEntry(builder.vector);
            } else {
                VectorBuilder.this.log(node, (CompilerMessage)new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void primitiveNode(Assignable property, PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, false, null, VectorBuilder.this.elementBindingHandler);
            node.analyze(builder);
            if (builder.value.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                VectorBuilder.this.vector.addEntry(builder.value);
            } else {
                VectorBuilder.this.log(node, (CompilerMessage)new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void xmlNode(Assignable property, XMLNode node) {
            VectorBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void xmlListNode(Assignable property, XMLListNode node) {
            VectorBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void modelNode(Assignable property, ModelNode node) {
            VectorBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void inlineComponentNode(Assignable property, InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, false);
            node.analyze(builder);
            if (builder.getRValue().getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                VectorBuilder.this.vector.addEntry(builder.getRValue());
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void reparentNode(Assignable property, ReparentNode node) {
            ComponentBuilder builder = new ComponentBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, null, null, false, null);
            node.analyze(builder);
            if (builder.component.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                builder.component.setParentIndex(VectorBuilder.this.vector.size());
                VectorBuilder.this.vector.addEntry(builder.component);
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void cdataNode(Assignable property, CDATANode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, false, null, VectorBuilder.this.elementBindingHandler);
            node.analyze(builder);
            if (builder.value.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                VectorBuilder.this.vector.addEntry(builder.value);
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void stateNode(Assignable property, StateNode node) {
            ComponentBuilder builder = new ComponentBuilder(VectorBuilder.this.unit, VectorBuilder.this.typeTable, VectorBuilder.this.mxmlConfiguration, VectorBuilder.this.document, VectorBuilder.this.vector, null, null, false, null);
            node.analyze(builder);
            if (builder.component.getType().isAssignableTo(VectorBuilder.this.getElementType())) {
                builder.component.setParentIndex(VectorBuilder.this.vector.size());
                VectorBuilder.this.vector.addEntry(builder.component);
            } else {
                VectorBuilder.this.log(node, new WrongElementType(VectorBuilder.this.getElementType().getName()));
            }
        }

        protected void unknown(Assignable property, Node node) {
            VectorBuilder.this.log(node, new UnknownNode(node.image));
        }
    }
}

