/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.io;

import flash.util.FileUtils;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.io.ZipFileHolder;
import flex2.compiler.swc.zip.ZipEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VirtualZipFile
implements VirtualFile {
    private String mimeType;
    private String name;
    private String nameInZip;
    private byte[] bytes;
    private ZipFileHolder zipFile;

    public VirtualZipFile(ZipFileHolder zipFileHolder, String mimeType, String name, String nameInZip) {
        this.zipFile = zipFileHolder;
        this.mimeType = mimeType;
        this.name = name;
        this.nameInZip = nameInZip;
    }

    public void close() {
        this.zipFile.close();
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.toByteArray());
    }

    public byte[] toByteArray() throws IOException {
        if (this.bytes == null) {
            InputStream stream = this.zipFile.getZipFile().getInputStream(this.getEntry());
            this.bytes = FileUtils.toByteArray((InputStream)stream);
            if (this.bytes.length == 0) {
                this.zipFile.close();
                stream = this.zipFile.getZipFile().getInputStream(this.getEntry());
                this.bytes = FileUtils.toByteArray((InputStream)stream);
            }
            this.zipFile.close();
        }
        return this.bytes;
    }

    public long getLastModified() {
        return this.getEntry().getTime();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getNameForReporting() {
        return this.getName();
    }

    public String getParent() {
        return this.zipFile.getPath();
    }

    public boolean isDirectory() {
        return false;
    }

    public String getURL() {
        return "jar:file://" + this.getName().replaceAll("\\$", "!/");
    }

    public long size() {
        return this.getEntry().getSize();
    }

    public VirtualFile resolve(String relative) {
        return null;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isTextBased() {
        return false;
    }

    private ZipEntry getEntry() {
        return this.zipFile.getEntry(this.nameInZip);
    }
}

