/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.AdvancedConfigurationInfo;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;

public class MxmlConfiguration {
    private ConfigurationPathResolver configResolver;
    public static final int CURRENT_VERSION = 0x4000000;
    public static final int VERSION_4_0 = 0x4000000;
    public static final int VERSION_3_0 = 0x3000000;
    public static final int VERSION_2_0_1 = 0x2000001;
    public static final int VERSION_2_0 = 0x2000000;
    public static final int EARLIEST_MAJOR_VERSION = 3;
    public static final int LATEST_MAJOR_VERSION = 4;
    private int major = 4;
    private int minor;
    private int revision;
    private int minMajor = 3;
    private int minMinor;
    private int minRevision;
    private boolean isMinimumSupportedVersionConfigured = false;
    private boolean qualifiedTypeSelectors = true;

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public int getMajorCompatibilityVersion() {
        return this.major;
    }

    public int getMinorCompatibilityVersion() {
        return this.minor;
    }

    public int getRevisionCompatibilityVersion() {
        return this.revision;
    }

    public String getCompatibilityVersionString() {
        return this.major == 0 && this.minor == 0 && this.revision == 0 ? null : this.major + "." + this.minor + "." + this.revision;
    }

    public int getCompatibilityVersion() {
        int version = (this.major << 24) + (this.minor << 16) + this.revision;
        return version != 0 ? version : 0x4000000;
    }

    public void cfgCompatibilityVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (i == 0) {
                if (versionNum >= 3 && versionNum <= 4) {
                    this.major = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "compatibility-version");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.minor = versionNum;
                    continue;
                }
                this.revision = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "compatibility-version");
        }
        if (this.major <= 3) {
            this.qualifiedTypeSelectors = false;
        }
    }

    public static ConfigurationInfo getCompatibilityVersionInfo() {
        return new ConfigurationInfo(new String[]{"version"});
    }

    public String getMinimumSupportedVersionString() {
        return this.minMajor == 0 && this.minMinor == 0 && this.minRevision == 0 ? null : this.minMajor + "." + this.minMinor + "." + this.minRevision;
    }

    public int getMinimumSupportedVersion() {
        int version = (this.minMajor << 24) + (this.minMinor << 16) + this.minRevision;
        return version != 0 ? version : 0x3000000;
    }

    public void setMinimumSupportedVersion(int version) {
        this.minMajor = version >> 24 & 0xFF;
        this.minMinor = version >> 16 & 0xFF;
        this.minRevision = version & 0xFF;
    }

    public void cfgMinimumSupportedVersion(ConfigurationValue cv, String version) throws ConfigurationException {
        if (version == null) {
            return;
        }
        String[] results = version.split("\\.");
        if (results.length == 0) {
            throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
        }
        for (int i = 0; i < results.length; ++i) {
            int versionNum = 0;
            try {
                versionNum = Integer.parseInt(results[i]);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
            }
            if (i == 0) {
                if (versionNum >= 3 && versionNum <= 4) {
                    this.minMajor = versionNum;
                    continue;
                }
                throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
            }
            if (versionNum >= 0) {
                if (i == 1) {
                    this.minMinor = versionNum;
                    continue;
                }
                this.minRevision = versionNum;
                continue;
            }
            throw new ConfigurationException.BadVersion(version, "minimum-supported-version");
        }
        this.isMinimumSupportedVersionConfigured = true;
    }

    public boolean isMinimumSupportedVersionConfigured() {
        return this.isMinimumSupportedVersionConfigured;
    }

    public boolean getQualifiedTypeSelectors() {
        if (this.getCompatibilityVersion() < 0x4000000) {
            return false;
        }
        return this.qualifiedTypeSelectors;
    }

    public void cfgQualifiedTypeSelectors(ConfigurationValue cv, boolean b) {
        this.qualifiedTypeSelectors = b;
    }

    public static ConfigurationInfo getQualifiedTypeSelectorsInfo() {
        return new AdvancedConfigurationInfo();
    }
}

