/*
 * Decompiled with CFR 0.152.
 */
package adobe.abc;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GlobalOptimizer {
    final boolean PRESERVE_METHOD_NAMES = false;
    final boolean USE_CALLMETHOD = false;
    final boolean OUTPUT_DOT = false;
    final boolean SHOW_DFG = false;
    final boolean SHOW_CODE = false;
    boolean STRIP_DEBUG_INFO = true;
    Symtab<Type> namedTypes = new Symtab();
    Symtab<Typeref> globals = new Symtab();
    Map<Namespace, Name> namespaceNames = new HashMap<Namespace, Name>();
    static final Handler[] nohandlers = new Handler[0];
    static int rtcounter;
    static final Object UNDEFINED;
    static final Object BOTTOM;
    static final Double NAN;
    Type ANY = new Type(new Name("*"), null);
    static Namespace PUBLIC;
    static Namespace PKG_PUBLIC;
    static Namespace AS3;
    static Name AS3_TOSTRING;
    Type OBJECT;
    Type FUNCTION;
    Type CLASS;
    Type ARRAY;
    Type INT;
    Type UINT;
    Type NUMBER;
    Type BOOLEAN;
    Type STRING;
    Type NAMESPACE;
    Type XML;
    Type XMLLIST;
    Type QNAME;
    Type NULL;
    Type VOID;
    static final Metadata[] nometadata;
    List<Method> ready = new ArrayList<Method>();
    static final Expr[] noexprs;
    static final Edge[] noedges;
    static Type[] notypes;
    static Typeref[] notyperefs;
    static int[] refArgc;
    static final int OPER = 1;
    static final int EFFECT = 2;
    static final int COERCE = 4;
    static final int PX = 8;
    static final int SYNTH = 16;
    static final int SCPVAL = 32;
    static final int STKVAL = 64;
    static final int LOCVAL = 128;
    static int[] flagTable;
    static String[] opNames;

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("usage: GlobalOptimizer [-obscure_natives] [imports] -- [exports]");
            return;
        }
        GlobalOptimizer go = new GlobalOptimizer();
        ArrayList<InputAbc> a = new ArrayList<InputAbc>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        String filename = null;
        byte[] before = null;
        int split = -1;
        boolean obscure_natives = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-obscure_natives")) {
                obscure_natives = true;
                continue;
            }
            if (args[i].equals("-d")) {
                go.STRIP_DEBUG_INFO = false;
                continue;
            }
            if (args[i].equals("--")) {
                split = a.size();
                continue;
            }
            filename = args[i];
            before = GlobalOptimizer.load(filename);
            lengths.add(before.length);
            InputAbc ia = go.new InputAbc();
            ia.readAbc(before);
            a.add(ia);
            if (!obscure_natives) continue;
            ia.obscure_natives();
            obscure_natives = false;
        }
        ArrayList<Integer> initScripts = new ArrayList<Integer>();
        InputAbc first = (InputAbc)a.get(split + 1);
        int before_length = (Integer)lengths.get(split + 1);
        initScripts.add(first.scripts.length - 1);
        for (int i = split + 2; i < a.size(); ++i) {
            first.combine((InputAbc)a.get(i));
            initScripts.add(first.scripts.length - 1);
            before_length += ((Integer)lengths.get(i)).intValue();
        }
        go.optimize(first);
        byte[] after = go.emit(first, filename, initScripts);
        System.out.println();
        System.out.println("BEFORE " + before_length);
        System.out.println("AFTER  " + after.length);
        int delta = before_length - after.length;
        long percent = Math.round((double)delta / (double)before_length * 100.0);
        System.out.println("SAVED  " + delta + " " + percent + "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] load(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        try {
            byte[] before = new byte[((InputStream)in).available()];
            ((InputStream)in).read(before);
            byte[] byArray = before;
            return byArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static int match(Name a, Name b) {
        block7: {
            block6: {
                if (a == b) {
                    return 0;
                }
                int d = a.attr() - b.attr();
                if (d != 0) {
                    return d;
                }
                d = a.name.compareTo(b.name);
                if (d != 0) {
                    return d;
                }
                if (a.isQname() && b.isQname()) {
                    return a.nsset(0).compareTo(b.nsset(0));
                }
                if (!b.isQname() || b.isQname()) break block6;
                for (Namespace ns : b.nsset) {
                    if (!ns.equals(a.nsset(0))) continue;
                    return 0;
                }
                break block7;
            }
            if (!b.isQname() || a.isQname()) break block7;
            for (Namespace ns : a.nsset) {
                if (!ns.equals(b.nsset(0))) continue;
                return 0;
            }
        }
        return a.nsset.compareTo(b.nsset);
    }

    static String unique() {
        return GlobalOptimizer.unique("[]");
    }

    static String unique(String prefix) {
        return prefix + rtcounter++;
    }

    static Namespace uniqueNs() {
        return new Namespace(GlobalOptimizer.unique("ns"));
    }

    public static int deepHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            int elementHash = 0;
            if (element != null) {
                elementHash = element.hashCode();
            }
            result = 31 * result + elementHash;
        }
        return result;
    }

    public static boolean deepEquals(Object[] a1, Object[] a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            if (e1.equals(e2)) continue;
            return false;
        }
        return true;
    }

    void readyType(Type t) {
        this.ready.add(t.init);
        for (Binding b1 : t.defs.values()) {
            if (b1.method == null) continue;
            this.readyMethod(b1.method);
        }
    }

    void readyMethod(Method m) {
        if (m.entry != null) {
            this.ready.add(m);
        }
    }

    void optimize(InputAbc a) {
        for (Type t : a.scripts) {
            this.readyType(t);
        }
        while (!this.ready.isEmpty()) {
            this.optimize(this.remove(this.ready));
        }
    }

    int argc(Expr e) {
        switch (e.op) {
            case 69: 
            case 70: 
            case 74: 
            case 76: 
            case 78: 
            case 79: {
                return e.args.length - refArgc[e.ref.kind] - 1;
            }
            case 66: 
            case 67: 
            case 68: 
            case 73: {
                return e.args.length - 1;
            }
            case 65: {
                return e.args.length - 2;
            }
            case 86: {
                return e.args.length;
            }
            case 85: {
                assert (e.args.length % 2 == 0);
                return e.args.length / 2;
            }
        }
        assert (false);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] emit(InputAbc a, String filename, List<Integer> initScripts) throws IOException {
        Abc abc = new Abc();
        for (Type s : a.scripts) {
            abc.addScript(s);
        }
        abc.sort();
        String scriptname = filename.substring(0, filename.lastIndexOf(46));
        byte[] data = this.emitAbc(abc);
        FileOutputStream out = new FileOutputStream(scriptname + ".abc2");
        try {
            ((OutputStream)out).write(data);
        }
        finally {
            ((OutputStream)out).close();
        }
        if (abc.haveNatives) {
            PrintWriter out_h = new PrintWriter(new FileWriter(scriptname + ".h2"));
            IndentingPrintWriter out_c = new IndentingPrintWriter(new FileWriter(scriptname + ".cpp2"));
            try {
                this.emitSource(abc, scriptname, data, initScripts, out_h, out_c);
            }
            finally {
                out_c.close();
                out_h.close();
            }
        }
        return data;
    }

    void emitSource(Abc abc, String name, byte[] data, List<Integer> initScripts, PrintWriter out_h, IndentingPrintWriter out_c) {
        out_h.println("/* machine generated file -- do not edit */");
        out_h.println("namespace avmplus {");
        out_h.println("AVMPLUS_NATIVEMAP_DECLARE(" + name + ", " + abc.methodPool1.size() + ")");
        out_c.println("/* machine generated file -- do not edit */");
        out_c.println("namespace avmplus {");
        out_h.println("extern AvmInstance " + name + "_init(GC* gc, const AvmConfiguration& c, const uint8_t* abc_data=NULL, size_t length=0);");
        out_c.println("extern const uint8_t " + name + "_abc_data[" + data.length + "];");
        out_c.println("AvmInstance " + name + "_init(GC* gc, const AvmConfiguration& c, const uint8_t* abc_data/*=NULL*/, size_t length/*=0*/)");
        out_c.printf("{\n\tif (abc_data==NULL) { abc_data = %s_abc_data; length = %s; }\n", name, data.length);
        out_c.printf("\tAvmInstance _vm = AvmInit(gc, c, abc_data, length, %s_natives, %s_offset);\n", name, name);
        for (int i : initScripts) {
            out_c.printf("\tAvmInitScript(_vm, %d);\n", i);
        }
        out_c.printf("\treturn _vm;\n}\n", new Object[0]);
        StringWriter b = new StringWriter();
        PrintWriter out_t = new PrintWriter(b);
        TreeMap<Integer, String> impls = new TreeMap<Integer, String>();
        for (Type s : abc.scripts) {
            this.emitSourceTraits("", abc, s, out_h, impls, out_t, out_c);
        }
        out_c.print("AVMPLUS_NATIVEMAP_BEGIN(" + name + ")");
        ++out_c.indent;
        out_c.println();
        Iterator<Type> i$ = impls.keySet().iterator();
        while (i$.hasNext()) {
            int id = (Integer)((Object)i$.next());
            String s = (String)impls.get(id);
            if (s.charAt(0) == 'f') {
                out_c.println("AVMPLUS_NATIVEMAP_FORTHMETHOD(" + s.substring(1) + ")");
                continue;
            }
            out_c.println("AVMPLUS_NATIVEMAP_CMETHOD(" + s.substring(1) + ")");
        }
        --out_c.indent;
        out_c.println("AVMPLUS_NATIVEMAP_END()");
        out_c.println();
        out_t.flush();
        out_c.println(b);
        out_c.println();
        out_c.print("const uint8_t " + name + "_abc_data[" + data.length + "] = {");
        ++out_c.indent;
        out_c.println();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            int x = data[i] & 0xFF;
            if (x < 10) {
                out_c.print("  ");
            } else if (x < 100) {
                out_c.print(' ');
            }
            out_c.print(x);
            if (i + 1 < n) {
                out_c.print(", ");
            }
            if (i % 16 != 15) continue;
            out_c.println();
        }
        --out_c.indent;
        out_c.println("};");
        out_c.println("} /* namespace avmplus */");
        out_h.println("} /* namespace avmplus */");
    }

    void emitSourceTraits(String prefix, Abc abc, Type s, PrintWriter out_h, Map<Integer, String> impls, PrintWriter out_t, PrintWriter out_c) {
        out_h.println();
        assert (!s.init.isNative());
        for (Binding b : s.defs.values()) {
            Namespace ns = b.name.nsset(0);
            String id = prefix + this.propLabel(b, ns);
            boolean isNative = false;
            String ctype = null;
            if (b.md.length > 0) {
                for (Metadata md : b.md) {
                    if (!md.name.equals("native")) continue;
                    isNative = true;
                    for (Attr a : md.attrs) {
                        if (!a.name.equals("type")) continue;
                        ctype = a.value;
                    }
                }
            }
            if (b.method != null) {
                if (b.method.isNative()) {
                    this.emitSourceMethod(prefix, abc, b, ns, out_h, impls, out_t, s.obscure_natives);
                    continue;
                }
                if (!isNative || s.obscure_natives) continue;
                int scriptId = abc.scriptId(s);
                if (scriptId == -1) {
                    throw new RuntimeException("Only scripts can have native callins");
                }
                this.emitCallinMethod(b, ns, abc.scriptId(s), out_h, out_c);
                continue;
            }
            if (GlobalOptimizer.isClass(b)) {
                this.emitSourceClass(abc, out_h, out_c, impls, out_t, b, ns, s.obscure_natives);
                continue;
            }
            if (!GlobalOptimizer.isSlot(b) || !isNative) continue;
            this.emitSourceSlot(prefix, abc, b, ns, id, ctype, out_h, out_t, s.obscure_natives);
        }
    }

    void emitSourceSlot(String prefix, Abc abc, Binding b, Namespace ns, String id, String ctype, PrintWriter out_h, PrintWriter out_t, boolean obscure_natives) {
        if (obscure_natives) {
            return;
        }
        if (this.isAtom(b.type.t)) {
            if (ctype != null) {
                if (b.type.t != this.ANY || !ns.isPrivateOrInternal()) {
                    throw new RuntimeException("native field " + id + " must be private or internal and type *");
                }
                out_h.println("AVMPLUS_NATIVE_SLOT_DECL_GC(" + ctype + "," + b.offset + "," + id + ")");
            } else {
                out_h.println("AVMPLUS_NATIVE_SLOT_DECL_ATOM(" + b.offset + "," + id + ")");
            }
        } else if (b.type.t.emitAsAny()) {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_GC(" + ctype + "," + b.offset + "," + id + ")");
        } else if (b.type.t.numeric) {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_PRIM(" + ctype + "," + b.offset + "," + id + ")");
        } else {
            ctype = this.ctype(b.type);
            out_h.println("AVMPLUS_NATIVE_SLOT_DECL_RC(" + ctype + "," + b.offset + "," + id + ")");
        }
    }

    void emitSourceClass(Abc abc, PrintWriter out_h, PrintWriter out_c, Map<Integer, String> impls, PrintWriter out_t, Binding b, Namespace ns, boolean obscure_natives) {
        String label = ns.isPublic() || ns.isInternal() ? b.name.name : (ns.isProtected() ? "protected_" + b.name.name : (this.namespaceNames.containsKey(ns) ? this.namespaceNames.get(ns) + "_" + b.name.name : ns.uri.replace(' ', '_').replace('.', '_').replace('$', '_') + '_' + b.name.name));
        Type c = b.type.t;
        if (!obscure_natives) {
            out_h.println("const int abcclass_" + label + " = " + abc.classId(c) + ";");
        }
        this.emitSourceTraits(label + "_", abc, c, out_h, impls, out_t, out_c);
        this.emitSourceTraits(label + "_", abc, c.itype, out_h, impls, out_t, out_c);
    }

    String ctype(Typeref tref) {
        Type t = tref.t;
        if (t == this.VOID) {
            return "void";
        }
        if (this.isAtom(t)) {
            return "AvmBox";
        }
        if (t == this.INT) {
            return "int32_t";
        }
        if (t == this.BOOLEAN) {
            return "bool";
        }
        if (t == this.UINT) {
            return "uint32_t";
        }
        if (t == this.STRING) {
            return "AvmString";
        }
        if (t == this.NAMESPACE) {
            return "AvmNamespace";
        }
        if (t == this.NUMBER) {
            return "double";
        }
        if (t.base == null) {
            return tref.nonnull().toString() + "*";
        }
        return "AvmObject /*" + tref.toString() + "*/";
    }

    void emitSourceMethod(String prefix, Abc abc, Binding b, Namespace ns, PrintWriter out_h, Map<Integer, String> impls, PrintWriter out_t, boolean obscure_natives) {
        Method m = b.method;
        String impl = prefix + this.propLabel(b, ns);
        if (this.isGetter(b)) {
            impl = impl + "_get";
        } else if (this.isSetter(b)) {
            impl = impl + "_set";
        }
        String forthword = null;
        if (b.md.length > 0) {
            for (Metadata md : b.md) {
                if (!md.name.equals("forth")) continue;
                for (Attr a : md.attrs) {
                    if (!a.name.equals("word")) continue;
                    forthword = a.value;
                    break;
                }
                if (forthword != null) break;
                throw new RuntimeException("the forth metadata must specify the word attribute");
            }
        }
        if (forthword != null) {
            out_h.printf("AVMPLUS_FORTH_METHOD_DECL(%s, %s)\n", forthword, impl);
            impls.put(abc.methodId(m), "f" + forthword);
        } else {
            if (m.hasOptional()) {
                throw new RuntimeException("native methods may not have optional parameters: " + impl);
            }
            if (m.needsRest()) {
                throw new RuntimeException("native methods may not have rest args: " + impl);
            }
            this.createThunkArgs(out_h, impl, m, obscure_natives);
            out_h.printf("AVMPLUS_NATIVE_METHOD_DECL(%s, %s)\n", this.ctype(m.returns), impl);
            impls.put(abc.methodId(m), "n" + impl);
        }
    }

    String propLabel(Binding b, Namespace ns) {
        return ns.isPublic() || ns.isInternal() ? b.name.name : (ns.isPrivate() ? "private_" + b.name.name : (ns.isProtected() ? "protected_" + b.name.name : this.namespaceNames.get(ns) + "_" + b.name.name));
    }

    void createThunkArgs(PrintWriter out_h, String id, Method m, boolean obscure_natives) {
        if (!m.hasParamNames() && m.params.length > 1) {
            throw new RuntimeException("native method " + id + " must be generated with debug info (have no fear, it will be stripped)");
        }
        out_h.println();
        if (obscure_natives) {
            out_h.println("struct " + id + "_args;");
            return;
        }
        out_h.println("struct " + id + "_args");
        out_h.println("{");
        int n = m.params.length;
        for (int i = 0; i < n; ++i) {
            String argname;
            String string = i == 0 ? (m.params[i].toString().indexOf("$") >= 0 ? "classself" : "self") : (argname = m.paramNames[i].name);
            if (m.params[i].t == this.NUMBER) {
                out_h.printf("    public: double %s;\n", argname);
                continue;
            }
            if (m.params[i].t == this.BOOLEAN) {
                out_h.printf("    public: int32_t %s_b; private: int32_t %s_pad; public: inline bool %s() const { return %s_b != 0; }\n", argname, argname, argname, argname);
                continue;
            }
            if (m.params[i].t == this.OBJECT || m.params[i].t == this.ANY) {
                out_h.printf("    public: AvmBoxArg %s;\n", argname);
                continue;
            }
            out_h.printf("    public: %s %s; private: int32_t %s_pad; \n", this.ctype(m.params[i]), argname, argname);
        }
        out_h.printf("    public: AvmStatusOut status_out;\n", new Object[0]);
        out_h.println("};");
    }

    void emitCallinMethod(Binding b, Namespace ns, int class_id, PrintWriter out_h, PrintWriter out_c) {
        Method m = b.method;
        String impl = ns.uri.replace('.', '_') + "_" + b.name.name;
        this.writeCallin(m, class_id, impl, out_h, out_c);
    }

    String boxSetter(Type t) {
        if (t == this.INT) {
            return "Int";
        }
        if (t == this.UINT) {
            return "Uint";
        }
        if (t == this.BOOLEAN) {
            return "Bool";
        }
        if (t == this.STRING) {
            return "String";
        }
        if (t == this.NAMESPACE) {
            return "Namespace";
        }
        if (t == this.NUMBER) {
            return "Double";
        }
        if (t.base == null) {
            return "GCObject";
        }
        return "Object";
    }

    void writeCallin(Method m, int script_id, String impl, PrintWriter out_h, PrintWriter out_c) {
        StringWriter bodySW = new StringWriter();
        StringWriter declSW = new StringWriter();
        PrintWriter decl = new PrintWriter(declSW);
        PrintWriter body = new PrintWriter(bodySW);
        decl.printf("%s %s(AvmInstance vm", this.ctype(m.returns), impl);
        body.print("\n{\n");
        if (m.params.length > 1) {
            body.printf("\tAvmBox _args[%d];\n", m.params.length - 1);
        }
        int n = m.params.length;
        for (int i = 1; i < n; ++i) {
            Typeref t = m.params[i];
            decl.printf(", %s %s", this.ctype(t), m.paramNames[i]);
            body.printf("\t_args[%d] = AvmBox%s(%s);\n", i - 1, this.boxSetter(t.t), m.paramNames[i]);
        }
        decl.print(")");
        body.print("\t");
        if (m.returns.t != this.VOID) {
            body.print("const AvmBox _returnBox = ");
        }
        body.printf("\tAvmInvokeCallin(vm, %d, %d, %d, %s);\n", script_id, m.emit_id, m.params.length - 1, m.params.length > 1 ? "(AvmBox*)&_args" : "NULL");
        if (m.returns.t != this.VOID) {
            body.printf("\treturn AvmUnBox%s(_returnBox);\n", this.boxSetter(m.returns.t));
        } else {
            body.print(";\n");
        }
        body.print("}\n");
        out_h.printf("%s;\n", declSW.getBuffer());
        out_c.print(declSW.getBuffer());
        out_c.print(bodySW.getBuffer());
    }

    byte[] emitAbc(Abc abc) throws IOException {
        AbcWriter w = new AbcWriter();
        w.writeU16(16);
        w.writeU16(46);
        int pos = w.size();
        w.writeU30(abc.intPool.size());
        Iterator i$ = abc.intPool.values.iterator();
        while (i$.hasNext()) {
            int x = (Integer)i$.next();
            w.writeU30(x);
        }
        System.out.println("ints count " + abc.intPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.uintPool.size());
        i$ = abc.uintPool.values.iterator();
        while (i$.hasNext()) {
            long x = (Long)i$.next();
            w.writeU30((int)x);
        }
        System.out.println("uints count " + abc.uintPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        System.out.println("doubles " + abc.doublePool.size());
        w.writeU30(abc.doublePool.size());
        i$ = abc.doublePool.values.iterator();
        while (i$.hasNext()) {
            double x = (Double)i$.next();
            w.write64(Double.doubleToLongBits(x));
        }
        System.out.println("double count " + abc.doublePool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.stringPool.size());
        for (String s : abc.stringPool.values) {
            w.writeU30(s.length());
            w.write(s.getBytes("UTF-8"));
        }
        System.out.println("strings count " + abc.stringPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.nsPool.size());
        for (Namespace ns : abc.nsPool.values) {
            this.emitNamespace(abc, w, ns);
        }
        System.out.println("ns count " + abc.nsPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.nssetPool.size());
        for (Nsset nsset : abc.nssetPool.values) {
            w.writeU30(nsset.length);
            for (Namespace ns : nsset) {
                w.writeU30(abc.nsPool.id(ns));
            }
        }
        System.out.println("nsset count " + abc.nssetPool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.namePool.size());
        block14: for (Name n : abc.namePool.values) {
            w.write(n.kind);
            switch (n.kind) {
                case 7: 
                case 13: {
                    w.writeU30(abc.nsPool.id(n.nsset(0)));
                    w.writeU30(abc.stringPool.id(n.name));
                    continue block14;
                }
                case 9: 
                case 14: {
                    w.writeU30(abc.stringPool.id(n.name));
                    w.writeU30(abc.nssetPool.id(n.nsset));
                    continue block14;
                }
                case 15: 
                case 16: {
                    w.writeU30(abc.stringPool.id(n.name));
                    continue block14;
                }
                case 27: 
                case 28: {
                    w.writeU30(abc.nssetPool.id(n.nsset));
                    continue block14;
                }
                case 17: 
                case 18: {
                    continue block14;
                }
            }
            assert (false);
        }
        System.out.println("name count " + abc.namePool.size() + " size " + (w.size() - pos));
        pos = w.size();
        w.writeU30(abc.methodPool2.size());
        int method_id = 0;
        for (Method m : abc.methodPool1.values) {
            this.emitMethod(abc, w, method_id++, m);
        }
        for (Method m : abc.methodPool2.values) {
            this.emitMethod(abc, w, method_id++, m);
        }
        w.writeU30(abc.metaPool.size());
        for (Metadata md : abc.metaPool.values) {
            w.writeU30(abc.stringPool.id(md.name));
            w.writeU30(md.attrs.length);
            for (Attr a : md.attrs) {
                w.writeU30(abc.stringPool.id(a.name));
            }
            for (Attr a : md.attrs) {
                w.writeU30(abc.stringPool.id(a.value));
            }
        }
        w.writeU30(abc.classes.size());
        for (Type c : abc.classes) {
            Type t = c.itype;
            w.writeU30(abc.namePool.id(t.name));
            w.writeU30(abc.typeRef(t.base));
            w.write(t.flags);
            if (t.hasProtectedNs()) {
                w.writeU30(abc.nsPool.id(t.protectedNs));
            }
            w.writeU30(t.interfaces.length);
            for (Type i : t.interfaces) {
                w.writeU30(abc.typeRef(i));
            }
            w.writeU30(abc.methodId(t.init));
            this.emitTraits(w, abc, t);
        }
        for (Type c : abc.classes) {
            w.writeU30(abc.methodId(c.init));
            this.emitTraits(w, abc, c);
        }
        w.writeU30(abc.scripts.size());
        for (Type s : abc.scripts) {
            w.writeU30(abc.methodId(s.init));
            this.emitTraits(w, abc, s);
        }
        w.writeU30(abc.bodyCount);
        this.emitBodies(abc, w, abc.methodPool1);
        this.emitBodies(abc, w, abc.methodPool2);
        return w.toByteArray();
    }

    void emitNamespace(Abc emitNamespace, AbcWriter w, Namespace ns) {
        if (ns.isPrivateOrInternal()) {
            w.write(5);
            w.writeU30(0);
        } else {
            w.write(ns.kind);
            w.writeU30(emitNamespace.stringPool.id(ns.uri));
        }
    }

    void emitBodies(Abc abc, AbcWriter w, Pool<Method> pool) throws IOException {
        for (Method m : pool.values) {
            if (m.entry == null) continue;
            w.writeU30(m.emit_id);
            w.writeU30(m.max_stack);
            w.writeU30(m.local_count);
            if (m.cx != null && m.cx.scopes != null) {
                w.writeU30(m.cx.scopes.length);
                w.writeU30(m.cx.scopes.length + m.max_scope);
            } else {
                w.writeU30(0);
                w.writeU30(m.max_scope);
            }
            this.emitCode(w, abc, m);
            this.emitTraits(w, abc, m.activation.t);
        }
    }

    void emitMethod(Abc abc, AbcWriter w, int method_id, Method m) {
        m.emit_id = method_id;
        System.out.println("METHOD " + method_id + " was " + m.id);
        w.writeU30(m.params.length - 1);
        w.writeU30(abc.typeRef(m.returns));
        int n = m.params.length;
        for (int i = 1; i < n; ++i) {
            w.writeU30(abc.typeRef(m.params[i]));
        }
        w.writeU30(0);
        int flags = m.flags;
        if (this.STRIP_DEBUG_INFO) {
            flags &= 0xFFFFFF7F;
        }
        w.write(flags);
        if (m.hasOptional()) {
            int optional_count = 0;
            for (Object v : m.values) {
                if (v == null) continue;
                ++optional_count;
            }
            assert (optional_count > 0);
            w.writeU30(optional_count);
            for (int j = m.params.length - optional_count; j < m.params.length; ++j) {
                int kind = abc.constKind(m.values[j]);
                w.writeU30(abc.constId(kind, m.values[j]));
                w.write(kind);
            }
        }
        if ((flags & 0x80) != 0) {
            for (int i = 1; i < m.paramNames.length; ++i) {
                w.writeU30(abc.stringPool.id(m.paramNames[i].name));
            }
        }
    }

    int intValue(Object o) {
        return ((Number)o).intValue();
    }

    long uintValue(Object o) {
        return ((Number)o).longValue() & 0xFFFFFFFFL;
    }

    double doubleValue(Object o) {
        return o instanceof Number ? ((Number)o).doubleValue() : Double.NaN;
    }

    boolean booleanValue(Object o) {
        if (o instanceof Boolean) {
            return o == Boolean.TRUE;
        }
        if (o instanceof String || o instanceof Namespace) {
            return true;
        }
        if (o == this.NULL || o == UNDEFINED) {
            return false;
        }
        return this.doubleValue(o) != 0.0;
    }

    String stringValue(Object v0) {
        return String.valueOf(v0);
    }

    void emitBlock(AbcWriter out, Block b, Abc abc) {
        for (Expr e : b) {
            if (e.succ != null) break;
            out.write(e.op);
            switch (e.op) {
                case 50: {
                    out.writeU30(e.imm[0]);
                    out.writeU30(e.imm[1]);
                    break;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    out.writeU30(abc.namePool.id(e.ref));
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    out.writeU30(abc.namePool.id(e.ref));
                    out.writeU30(this.argc(e));
                    break;
                }
                case 65: 
                case 66: 
                case 73: 
                case 85: 
                case 86: {
                    out.writeU30(this.argc(e));
                    break;
                }
                case 98: 
                case 99: {
                    if (e.imm[0] < 4) {
                        out.rewind(1);
                        out.write((e.op == 98 ? 208 : 212) + e.imm[0]);
                        break;
                    }
                }
                case 8: 
                case 90: 
                case 108: 
                case 109: 
                case 146: 
                case 148: 
                case 194: 
                case 195: {
                    out.writeU30(e.imm[0]);
                    break;
                }
                case 88: {
                    out.writeU30(abc.classId(e.c));
                    break;
                }
                case 64: {
                    out.writeU30(abc.methodId(e.m));
                    break;
                }
                case 68: {
                    out.writeU30(abc.methodId(e.m));
                    out.writeU30(this.argc(e));
                    break;
                }
                case 37: {
                    out.writeU30(this.intValue(e.value));
                    break;
                }
                case 36: {
                    out.write(this.intValue(e.value));
                    break;
                }
                case 101: {
                    out.write(e.imm[0]);
                    break;
                }
                case 6: 
                case 44: {
                    out.writeU30(abc.stringPool.id((String)e.value));
                    break;
                }
                case 241: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(abc.stringPool.id((String)e.value));
                    break;
                }
                case 49: {
                    out.writeU30(abc.nsPool.id((Namespace)e.value));
                    break;
                }
                case 45: {
                    out.writeU30(abc.intPool.id(this.intValue(e.value)));
                    break;
                }
                case 46: {
                    out.writeU30(abc.uintPool.id(this.uintValue(e.value)));
                    break;
                }
                case 47: {
                    out.writeU30(abc.doublePool.id(this.doubleValue(e.value)));
                    break;
                }
                case 240: 
                case 242: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.writeU30(e.imm[0]);
                    break;
                }
                case 239: {
                    if (this.STRIP_DEBUG_INFO) {
                        throw new RuntimeException("impossible");
                    }
                    out.write(e.imm[0]);
                    out.writeU30(e.imm[1]);
                    out.write(e.imm[2]);
                    out.writeU30(e.imm[3]);
                }
            }
        }
    }

    void emitCode(AbcWriter out, Abc abc, Method m) throws IOException {
        HashMap<Block, Integer> padding = new HashMap<Block, Integer>();
        Deque<Block> code = this.schedule(m.entry.to);
        HashMap<Block, AbcWriter> writers = new HashMap<Block, AbcWriter>();
        BitSet labels = new BitSet();
        BitSet done = new BitSet();
        for (Block b : code) {
            done.set(b.id);
            for (Edge e : b.succ()) {
                if (!done.get(e.to.id)) continue;
                labels.set(e.to.id);
            }
        }
        HashMap<Block, Integer> pos = new HashMap<Block, Integer>();
        HashMap<Block, Integer> blockends = new HashMap<Block, Integer>();
        int code_len = 0;
        ArrayDeque<Block> work = new ArrayDeque<Block>((Collection<Block>)code);
        while (!work.isEmpty()) {
            Block b = (Block)work.removeFirst();
            pos.put(b, code_len);
            AbcWriter w = new AbcWriter();
            writers.put(b, w);
            if (labels.get(b.id)) {
                w.write(9);
            }
            this.emitBlock(w, b, abc);
            code_len += w.size();
            Expr last = b.last();
            if (last.succ.length == 0) {
                w.write(last.op);
                ++code_len;
            } else if (this.isJump(last)) {
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 4;
                    padding.put(b, 4);
                }
            } else if (this.isBranch(last)) {
                if (work.isEmpty() || last.succ[0].to != work.peekFirst()) {
                    code_len += 8;
                    padding.put(b, 8);
                } else {
                    code_len += 4;
                    padding.put(b, 4);
                }
            } else {
                assert (last.op == 27);
                assert (false);
            }
            blockends.put(b, code_len);
        }
        out.writeU30(code_len);
        int code_start = out.size();
        for (Block b : code) {
            ((AbcWriter)writers.get(b)).writeTo(out);
            if (!padding.containsKey(b)) continue;
            Expr last = b.last();
            if (this.isBranch(last)) {
                this.emitBranch(out, last.op, last.succ[1].to, code_start, pos);
                padding.put(b, (Integer)padding.get(b) - 4);
            }
            if ((Integer)padding.get(b) != 4) continue;
            this.emitBranch(out, 16, last.succ[0].to, code_start, pos);
        }
        out.writeU30(m.handlers.length);
        for (Handler h : m.handlers) {
            int from = code_len;
            int to = 0;
            for (Block b : code) {
                for (Edge x : b.xsucc) {
                    if (x.to != h.entry) continue;
                    if ((Integer)pos.get(b) < from) {
                        from = (Integer)pos.get(b);
                    }
                    if ((Integer)blockends.get(b) <= to) continue;
                    to = (Integer)blockends.get(b);
                }
            }
            out.writeU30(from);
            out.writeU30(to);
            int off = (Integer)pos.get(h.entry);
            System.out.println("handler " + h.entry + " [" + from + "," + to + ")->" + off);
            out.writeU30(off);
            out.writeU30(abc.typeRef(h.type));
            out.writeU30(abc.namePool.id(h.name));
        }
    }

    void emitBranch(AbcWriter out, int op, Block target, int code_start, Map<Block, Integer> pos) {
        out.write(op);
        int to = code_start + pos.get(target);
        int from = out.size() + 3;
        out.writeS24(to - from);
    }

    boolean defaultValueChanged(Binding b) {
        return !b.type.t.defaultValue.equals(b.value);
    }

    void emitTraits(AbcWriter out, Abc abc, Type t) {
        Symtab<Binding> defs = t.defs;
        out.writeU30(defs.size());
        block5: for (Binding b : defs.values()) {
            out.writeU30(abc.namePool.id(b.name));
            out.write(b.flags_kind & 0xFFFFFFBF);
            switch (b.kind()) {
                case 0: 
                case 6: {
                    out.writeU30(b.slot);
                    out.writeU30(abc.typeRef(b.type));
                    if (!this.defaultValueChanged(b)) {
                        out.writeU30(0);
                        break;
                    }
                    int kind = abc.constKind(b.value);
                    int id = abc.constId(kind, b.value);
                    out.writeU30(id);
                    if (id == 0) continue block5;
                    out.write(kind);
                    break;
                }
                case 4: {
                    out.writeU30(b.slot);
                    out.writeU30(abc.classId(b.type.t));
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    out.writeU30(b.slot);
                    out.writeU30(abc.methodId(b.method));
                    break;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    void optimize(Method m) {
        System.out.println("OPTIMIZE " + m.id + " " + m.name);
        if (m.entry == null) {
            return;
        }
        System.out.println("BEFORE OPT");
        System.out.println("BEFORE OPT");
        this.print(this.dfs(m.entry.to));
        this.sccp(m);
        this.dvn(m);
        if (this.cfgopt(m)) {
            System.out.println("AFTER CFGOPT");
            this.print(this.dfs(m.entry.to));
            this.sccp(m);
            this.dvn(m);
        }
        this.fold(m);
        System.out.println("AFTER FOLD");
        this.print(this.dfs(m.entry.to));
        this.insert_casts(m);
        this.remove_phi(m);
        this.printabc(this.schedule(m.entry.to));
        System.out.println();
    }

    void fold(Method m) {
        Deque<Block> code = this.dfs(m.entry.to);
        EdgeMap<Expr> uses = this.findUses(code);
        for (Block b : code) {
            for (Expr e : b) {
                switch (e.op) {
                    case 17: 
                    case 18: {
                        Expr a0 = e.args[0];
                        if (!this.containsOnly(uses.get(a0), e)) break;
                        if (a0.op == 150) {
                            this.subsume_arg(e, e.op == 17 ? 18 : 17, uses);
                            break;
                        }
                        if (a0.op == 118) {
                            this.subsume_arg(e, e.op, uses);
                            break;
                        }
                        if (a0.op == 176) {
                            this.subsume_arg(e, e.op == 17 ? 24 : 15, uses);
                            break;
                        }
                        if (a0.op == 175) {
                            this.subsume_arg(e, e.op == 17 ? 23 : 14, uses);
                            break;
                        }
                        if (a0.op == 173) {
                            this.subsume_arg(e, e.op == 17 ? 21 : 12, uses);
                            break;
                        }
                        if (a0.op == 174) {
                            this.subsume_arg(e, e.op == 17 ? 22 : 13, uses);
                            break;
                        }
                        if (a0.op != 172) break;
                        this.subsume_arg(e, e.op == 17 ? 25 : 26, uses);
                        break;
                    }
                    case 102: {
                        Expr a0 = e.args[0];
                        if (!this.containsOnly(uses.get(a0), e) || a0.op != 93 || a0.args.length != 0 || e.args.length != 1) break;
                        e.op = 96;
                        e.args = noexprs;
                        e.scopes = a0.scopes;
                        a0.setPure();
                        e.flags |= a0.flags & 8 | a0.flags & 2;
                    }
                }
            }
        }
        this.dce(m);
    }

    SetMap<Block, Edge> preds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
        }
        block2: for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) continue block2;
                TreeSet<Edge> phi_in = new TreeSet<Edge>();
                for (Edge p : e.pred) {
                    phi_in.add(p);
                }
                Set<Edge> blk_in = pred.get(b);
                assert (((Object)phi_in).equals(blk_in));
            }
        }
        return pred;
    }

    SetMap<Block, Edge> allpreds(Deque<Block> code) {
        SetMap<Block, Edge> pred = new SetMap<Block, Edge>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                pred.get(s.to).add(s);
            }
            for (Edge x : b.xsucc) {
                pred.get(x.to).add(x);
            }
        }
        return pred;
    }

    int findPhiArg(Expr phi, Edge e) {
        int n = phi.pred.length;
        for (int i = 0; i < n; ++i) {
            if (!phi.pred[i].equals(e)) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    boolean sameExScope(Block b1, Block b2) {
        if (b1 == b2) {
            return true;
        }
        Edge[] xs1 = b1.xsucc;
        Edge[] xs2 = b2.xsucc;
        if (xs1.length != xs2.length) {
            return false;
        }
        int n = xs1.length;
        for (int i = 0; i < n; ++i) {
            Edge e1 = xs1[i];
            Edge e2 = xs2[i];
            if (e1.to == e2.to && e1.handler == e2.handler) continue;
            return false;
        }
        return true;
    }

    boolean cfgopt(Method m) {
        boolean changed;
        Deque<Block> code = this.dfs(m.entry.to);
        SetMap<Block, Edge> pred = this.allpreds(code);
        boolean changedout = false;
        do {
            changed = false;
            block1: for (Block b : code) {
                Block taken;
                Expr last = b.last();
                if (this.isJump(last) && this.sameExScope(b, taken = last.succ[0].to)) {
                    Edge s = last.succ[0];
                    if (this.containsOnly(pred.get(taken), s)) {
                        assert (taken.first().op != 10);
                        System.out.println("STRAIGHTEN " + s);
                        b.remove(last);
                        b.addAll(taken);
                        for (Edge edge : taken.succ()) {
                            edge.from = b;
                        }
                        changed = true;
                        break;
                    }
                    Expr first = taken.first();
                    if (first.op == 72 || first.op == 71) {
                        Expr[] exprArray;
                        System.out.println("PRUNE " + b + "->" + s);
                        last.op = first.op;
                        if (first.op == 71) {
                            exprArray = noexprs;
                        } else {
                            Expr[] exprArray2 = new Expr[1];
                            exprArray = exprArray2;
                            exprArray2[0] = first.args[0];
                        }
                        last.args = exprArray;
                        last.succ = noedges;
                        changed = true;
                        break;
                    }
                    if (first.op == 10 && taken.size() == 2) {
                        Expr r = taken.last();
                        if (r.op == 72 && r.args[0] == first) {
                            System.out.println("PRUNE " + b + "->" + s);
                            int i = this.findPhiArg(first, last.succ[0]);
                            last.op = r.op;
                            last.args = new Expr[]{first.args[i]};
                            last.succ = noedges;
                            first.remove(i);
                            changed = true;
                            break;
                        }
                    }
                }
                if (this.isBranch(last)) {
                    Edge out = last.succ[1];
                    Expr cond = last.args[0];
                    taken = out.to;
                    if (last.args.length == 1 && taken.size() == 2) {
                        Expr phi = taken.first();
                        if (phi.op == 10) {
                            int i;
                            Expr br = taken.last();
                            if ((br.op == 17 || br.op == 18) && phi.args[i = this.findPhiArg(phi, out)] == cond) {
                                Edge before = br.op == last.op ? br.succ[1] : br.succ[0];
                                System.out.println("SKIPTEST old " + out + " new " + before);
                                phi.remove(i);
                                this.copyTargetPhi(phi, cond, before, out);
                                changed = true;
                                break;
                            }
                        }
                    }
                    if (pred.get(last.succ[0].to).size() > 1 && pred.get(taken).size() == 1) {
                        this.invert(last);
                        changed = true;
                        break;
                    }
                }
                for (Edge edge : last.succ) {
                    if (!this.skip(edge)) continue;
                    changed = true;
                    break block1;
                }
                if (!this.skip(m.entry)) continue;
                changed = true;
                break;
            }
            if (!changed) continue;
            this.dce(m);
            code = this.dfs(m.entry.to);
            pred = this.allpreds(code);
            changedout = true;
        } while (changed);
        return changedout;
    }

    boolean skip(Edge edge) {
        Block to = edge.to;
        Expr j = to.last();
        if (to.size() == 1 && this.isJump(j)) {
            System.out.println("SKIP " + j.succ[0]);
            this.copyTarget(j.succ[0], edge);
            return true;
        }
        return false;
    }

    void invert(Expr br) {
        System.out.println("INVERT " + br);
        switch (br.op) {
            case 17: {
                br.op = 18;
                break;
            }
            case 18: {
                br.op = 17;
                break;
            }
            case 12: {
                br.op = 21;
                break;
            }
            case 13: {
                br.op = 22;
                break;
            }
            case 14: {
                br.op = 23;
                break;
            }
            case 15: {
                br.op = 24;
                break;
            }
            case 19: {
                br.op = 20;
                break;
            }
            case 20: {
                br.op = 19;
                break;
            }
            case 21: {
                br.op = 12;
                break;
            }
            case 22: {
                br.op = 13;
                break;
            }
            case 23: {
                br.op = 14;
                break;
            }
            case 24: {
                br.op = 15;
                break;
            }
            case 25: {
                br.op = 26;
                break;
            }
            case 26: {
                br.op = 25;
            }
        }
        Edge e0 = br.succ[0];
        Edge e1 = br.succ[1];
        e0.label = 1;
        e1.label = 0;
        br.succ[0] = e1;
        br.succ[1] = e0;
    }

    int ifoper(int op) {
        switch (op) {
            default: {
                assert (false);
                return 0;
            }
            case 12: 
            case 21: {
                return 173;
            }
            case 13: 
            case 22: {
                return 174;
            }
            case 14: 
            case 23: {
                return 175;
            }
            case 15: 
            case 24: {
                return 176;
            }
            case 19: 
            case 20: {
                return 171;
            }
            case 25: 
            case 26: 
        }
        return 172;
    }

    void copyTarget(Edge before, Edge after) {
        after.to = before.to;
        for (Expr e : before.to) {
            if (e.op != 10) continue;
            e.append(e.args[this.findPhiArg(e, before)], after);
        }
    }

    void copyTargetPhi(Expr phi, Expr a, Edge before, Edge after) {
        after.to = before.to;
        for (Expr e : before.to) {
            if (e.op != 10) break;
            Expr phiArg = e.args[this.findPhiArg(e, before)];
            e.append(phiArg == phi ? a : phiArg, after);
        }
    }

    boolean containsOnly(Collection c, Object elem) {
        return c.size() == 1 && c.contains(elem);
    }

    boolean equiv(Name a, Name b) {
        return GlobalOptimizer.match(a, b) == 0;
    }

    boolean equiv(Expr[] a, Expr[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (this.equiv(a[i], b[i])) continue;
            return false;
        }
        return true;
    }

    boolean equiv(Expr a, Expr b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null && a.op == b.op) {
            switch (a.op) {
                case 32: 
                case 33: 
                case 38: 
                case 39: 
                case 40: 
                case 208: 
                case 209: 
                case 210: 
                case 211: {
                    return true;
                }
                case 36: 
                case 37: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: {
                    return a.value.equals(b.value);
                }
                case 0: 
                case 98: {
                    return a.imm[0] == b.imm[0];
                }
                case 100: {
                    return a.scopes.length == 0 && b.scopes.length == 0 || a.scopes.length > 0 && b.scopes.length > 0 && this.equiv(a.scopes[0], b.scopes[0]);
                }
                case 95: {
                    return this.equiv(a.ref, b.ref);
                }
            }
        }
        return false;
    }

    void makeCopy(Expr e, Expr a) {
        assert (e != a);
        e.op = 42;
        e.locals = new Expr[]{a};
        e.args = noexprs;
        e.scopes = noexprs;
        e.setPure();
    }

    void makeNop(Expr e) {
        e.op = 2;
        e.scopes = noexprs;
        e.locals = noexprs;
        e.args = e.locals;
        e.setPure();
    }

    Expr dvn_find(Expr e, Block b, Map<Block, Block> idom) {
        do {
            for (Expr a : b) {
                if (a == e) break;
                if (!this.equiv(a, e)) continue;
                return a;
            }
        } while ((b = idom.get(b)) != null);
        return null;
    }

    void dvn(Method m) {
        boolean changed;
        Deque<Block> code = this.dfs(m.entry.to);
        Map<Block, Block> idom = this.idoms(code, this.preds(code));
        do {
            changed = false;
            for (Block b : code) {
                for (Expr e : b) {
                    Expr a = this.dvn_find(e, b, idom);
                    if (a == null) continue;
                    this.makeCopy(e, a);
                    changed = true;
                }
            }
            if (!changed) continue;
            this.dce(m);
        } while (changed);
    }

    boolean constify(Expr e, Object v) {
        if (v != null && v != BOTTOM && e.value == null && !this.hasSideEffect(e)) {
            if (v instanceof Integer) {
                int i = this.intValue(v);
                e.op = i == (byte)i ? 36 : (i == (short)i ? 37 : 45);
            } else if (v instanceof Long) {
                e.op = 46;
            } else if (v instanceof Number) {
                double d = this.doubleValue(v);
                e.op = Double.isNaN(d) ? 40 : 47;
            } else if (v instanceof Boolean) {
                e.op = v == Boolean.TRUE ? 38 : 39;
            } else if (v instanceof Namespace) {
                e.op = 49;
            } else if (v == UNDEFINED) {
                e.op = 33;
            } else if (v == this.NULL) {
                assert (!e.onScope());
                e.op = 32;
            } else {
                assert (v instanceof String);
                e.op = 44;
            }
            e.pred = noedges;
            e.locals = noexprs;
            e.scopes = noexprs;
            e.args = e.scopes;
            e.value = v;
            return true;
        }
        return false;
    }

    boolean jumpify(Expr e, Set<Edge> reached) {
        Edge taken = null;
        for (Edge s : e.succ) {
            if (!reached.contains(s)) continue;
            if (taken == null) {
                taken = s;
                continue;
            }
            if (s == taken) continue;
            taken = null;
            break;
        }
        if (taken != null) {
            e.op = 16;
            e.args = noexprs;
            e.succ = new Edge[]{taken};
            return true;
        }
        return false;
    }

    boolean makeConvert(Expr e, Type t, int op, Map<Expr, Typeref> types) {
        e.op = op;
        e.args = new Expr[]{e.args[1]};
        e.flags = flagTable[op];
        if (this.type(types, (Expr)e.args[0]).primitive) {
            e.setPure();
        }
        return true;
    }

    boolean convertify(Expr e, Binding b0, Map<Expr, Typeref> types) {
        if (b0.type != null && e.args.length == 2) {
            if (b0.type.t.itype == this.NUMBER) {
                return this.makeConvert(e, this.NUMBER, 117, types);
            }
            if (b0.type.t.itype == this.INT) {
                return this.makeConvert(e, this.INT, 115, types);
            }
            if (b0.type.t.itype == this.UINT) {
                return this.makeConvert(e, this.UINT, 116, types);
            }
            if (b0.type.t.itype == this.STRING) {
                return this.makeConvert(e, this.STRING, 112, types);
            }
            if (b0.type.t.itype == this.BOOLEAN) {
                return this.makeConvert(e, this.BOOLEAN, 118, types);
            }
        }
        return false;
    }

    Expr unwrapScope(Expr e, int i) {
        assert (e.scopes[i].onScope());
        return e.scopes[i].args[0];
    }

    static Type[] copyOf(Type[] in, int newlen) {
        Type[] out = new Type[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Typeref[] copyOf(Typeref[] in, int newlen) {
        Typeref[] out = new Typeref[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Expr[] copyOf(Expr[] in, int newlen) {
        Expr[] out = new Expr[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    static Edge[] copyOf(Edge[] in, int newlen) {
        Edge[] out = new Edge[newlen];
        if (newlen > in.length) {
            newlen = in.length;
        }
        System.arraycopy(in, 0, out, 0, newlen);
        return out;
    }

    void sccp(Method m) {
        Deque<Block> code = this.dfs(m.entry.to);
        EdgeMap<Expr> uses = this.findUses(code);
        TreeMap<Expr, Object> values = new TreeMap<Expr, Object>();
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        TreeSet<Edge> reached = new TreeSet<Edge>();
        this.sccp_analyze(m, uses, values, types, reached);
        System.out.println("REACHED " + reached);
        System.out.println("TYPES " + types);
        this.sccp_cfgopt(values, types, reached);
        this.dce(m);
        code = this.dfs(m.entry.to);
        uses = this.findUses(code);
        WorkSet<Expr> work = new WorkSet<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                work.add(e);
            }
        }
        while (!work.isEmpty()) {
            Expr e = this.remove((Set<Expr>)work);
            this.sccp_modify(m, uses, values, types, e, work);
        }
        this.dce(m);
    }

    void sccp_cfgopt(Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        WorkSet<Block> blocks = new WorkSet<Block>();
        for (Edge e : reached) {
            blocks.add(e.to);
        }
        for (Block b : blocks) {
            for (Expr e : b) {
                if (e.op == 10) {
                    for (int j = e.pred.length - 1; j >= 0; --j) {
                        Edge p = e.pred[j];
                        if (reached.contains(p)) continue;
                        e.remove(j);
                    }
                    continue;
                }
                if (e.succ != null) {
                    if (e.succ.length <= 1 || this.jumpify(e, reached) || e.op != 27 || b.size() != 2) continue;
                    Expr phi = b.first();
                    if (phi.op != 10 || e.args[0] != phi) continue;
                    for (int i = phi.args.length - 1; i >= 0; --i) {
                        Object v = values.get(phi.args[i]);
                        if (!(v instanceof Number)) continue;
                        int j = this.intValue(v);
                        Edge in = phi.pred[i];
                        Edge out = e.succ[j];
                        this.copyTarget(out, in);
                        phi.remove(i);
                    }
                    continue;
                }
                if (!e.isOper() || !e.onStack()) continue;
                boolean pure = true;
                for (Expr a : e.args) {
                    if (this.type(types, (Expr)a).primitive) continue;
                    pure = false;
                }
                for (Expr a : e.locals) {
                    if (this.type(types, (Expr)a).primitive) continue;
                    pure = false;
                }
                if (pure) {
                    e.setPure();
                }
                this.constify(e, values.get(e));
            }
        }
    }

    boolean subsume_arg(Expr e, int op, EdgeMap<Expr> uses) {
        e.op = op;
        Expr a = e.args[0];
        e.flags |= a.flags & 0xA;
        a.setPure();
        uses.get(a).remove(e);
        for (Expr x : e.args = GlobalOptimizer.copyOf(a.args, a.args.length)) {
            uses.get(x).add(e);
        }
        return true;
    }

    boolean canEarlyBindMethod(Method m, Binding b) {
        return m.abc.mergedAbcs.contains(b.abc);
    }

    boolean canEarlyBindSlot(Method m, Binding b) {
        return b.slot != 0 && m.abc.mergedAbcs.contains(b.abc);
    }

    void sccp_modify(Method m, EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Expr e, WorkSet<Expr> work) {
        boolean changed;
        this.sccp_rename(uses, e, e.args);
        this.sccp_rename(uses, e, e.locals);
        do {
            changed = false;
            switch (e.op) {
                case 88: {
                    Type c = e.c;
                    c.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    int i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        c.scopes[i++] = types.get(s);
                    }
                    this.readyType(c);
                    Type t = c.itype;
                    t.scopes = GlobalOptimizer.copyOf(c.scopes, c.scopes.length + 1);
                    t.scopes[c.scopes.length] = c.ref.nonnull();
                    this.readyType(t);
                    break;
                }
                case 64: {
                    Method f = e.m;
                    Type t = new Type(m.name, this.FUNCTION);
                    t.scopes = GlobalOptimizer.copyOf(m.cx.scopes, m.cx.scopes.length + e.scopes.length);
                    int i = m.cx.scopes.length;
                    for (Expr s : e.scopes) {
                        t.scopes[i++] = types.get(s);
                    }
                    f.cx = t;
                    this.readyMethod(f);
                    break;
                }
                case 72: {
                    if (this.type(types, e.args[0]) == this.VOID) {
                        e.op = 71;
                        e.args = noexprs;
                        break;
                    }
                    Type t0 = this.type(types, e.args[0]);
                    if (!this.istype(t0, m.returns.t)) break;
                    Expr a0 = e.args[0];
                    if (m.returns.t != this.INT || a0.op != 115) break;
                    uses.get(a0).remove(e);
                    a0 = e.args[0] = a0.args[0];
                    uses.get(a0).add(e);
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length != 0) break;
                    this.makeCopy(e, this.unwrapScope(e, 0));
                    changed = true;
                    break;
                }
                case 101: {
                    this.makeCopy(e, this.unwrapScope(e, 0));
                    changed = true;
                    break;
                }
                case 179: {
                    Type t1 = this.type(types, e.args[1]);
                    if (t1.itype == null || !this.namedTypes.contains(t1.itype.name)) break;
                    e.op = 178;
                    e.ref = t1.itype.name;
                    e.args = new Expr[]{e.args[0]};
                    e.clearPx();
                    changed = true;
                    break;
                }
                case 178: {
                    if (!this.namedTypes.contains(e.ref)) break;
                    e.clearPx();
                    break;
                }
                case 28: 
                case 48: {
                    if (types.get((Object)e.args[0]).nullable) break;
                    e.clearPx();
                    break;
                }
                case 128: {
                    Expr a0 = e.args[0];
                    Typeref t = types.get(e);
                    Typeref t0 = types.get(a0);
                    if (t == t0) {
                        this.makeCopy(e, a0);
                        changed = true;
                        break;
                    }
                    Object v0 = values.get(a0);
                    if (v0 == this.NULL && t0.nullable && t0.t != this.VOID) {
                        this.makeCopy(e, a0);
                        changed = true;
                        break;
                    }
                    if (this.namedTypes.get(e.ref) != this.OBJECT) break;
                    e.op = 137;
                    e.clearEffect();
                    e.ref = null;
                    e.imm = null;
                    changed = true;
                    break;
                }
                case 93: 
                case 94: {
                    int i = this.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        this.makeCopy(e, this.unwrapScope(e, i));
                        for (Expr s : e.scopes) {
                            uses.get(s).remove(e);
                        }
                        changed = true;
                        break;
                    }
                    i = this.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        if (i == 0) {
                            e.op = 100;
                            e.scopes = noexprs;
                            e.setPure();
                            for (Expr s : e.scopes) {
                                uses.get(s).remove(e);
                            }
                            changed = true;
                            break;
                        }
                        e.setPure();
                        break;
                    }
                    if (this.globals.contains(e.ref)) {
                        e.op = 95;
                        e.flags = flagTable[e.op];
                        e.scopes = noexprs;
                        e.ref = this.globals.getName(e.ref);
                        for (Expr s : e.scopes) {
                            uses.get(s).remove(e);
                        }
                        changed = true;
                        break;
                    }
                    if (e.op != 94) break;
                    if (m.cx.scopes.length == 0) {
                        this.makeCopy(e, this.unwrapScope(e, 0));
                        for (Expr s : e.scopes) {
                            uses.get(s).remove(e);
                        }
                        changed = true;
                        break;
                    }
                    e.op = 100;
                    for (Expr s : e.scopes) {
                        uses.get(s).remove(e);
                    }
                    e.scopes = noexprs;
                    e.setPure();
                    changed = true;
                    break;
                }
                case 4: 
                case 102: {
                    Typeref t0 = types.get(e.args[0]);
                    Binding bind = t0.findGet(e.ref);
                    if (GlobalOptimizer.isSlot(bind)) {
                        e.clearEffect();
                        if (!t0.nullable) {
                            e.clearPx();
                        }
                        e.ref = bind.name;
                        if (!this.canEarlyBindSlot(m, bind) || GlobalOptimizer.isConst(bind) && this.constify(e, values.get(e))) break;
                        e.op = 108;
                        e.imm = new int[]{bind.slot};
                        changed = true;
                        break;
                    }
                    if (bind == null) break;
                    e.ref = bind.name;
                    break;
                }
                case 104: {
                    Type t0 = this.type(types, e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    Binding bind = t0.find(e.ref);
                    if (bind == null) break;
                    e.ref = bind.name;
                    if (GlobalOptimizer.isConst(bind) && bind.value != null && bind.value.equals(v1)) {
                        this.makeNop(e);
                        for (Expr a : e.args) {
                            uses.get(a).remove(e);
                        }
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(bind) || !this.canEarlyBindSlot(m, bind)) break;
                    e.op = 109;
                    e.imm = new int[]{bind.slot};
                    changed = true;
                    break;
                }
                case 5: 
                case 97: {
                    Type t0 = this.type(types, e.args[0]);
                    Binding bind = t0.find(e.ref);
                    if (GlobalOptimizer.isSlot(bind)) {
                        e.ref = bind.name;
                        if (!this.canEarlyBindSlot(m, bind)) break;
                        e.op = 109;
                        e.imm = new int[]{bind.slot};
                        changed = true;
                        break;
                    }
                    if (bind == null) break;
                    e.ref = bind.name;
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 79: {
                    Type t0 = this.type(types, e.args[0]);
                    Binding b0 = t0.findGet(e.ref);
                    if (b0 != null) {
                        e.ref = b0.name;
                        if (e.op == 70 && this.isMethod(b0)) {
                            if (t0.primitive && e.args.length == 1 && e.ref.equals(AS3_TOSTRING) && this.type(types, e) == this.STRING) {
                                e.op = 112;
                                e.setPure();
                                changed = true;
                            } else if (this.canEarlyBindMethod(m, b0) && (t0.isFinal() || b0.isFinal())) {
                                e.op = 68;
                                e.m = b0.method;
                                changed = true;
                            }
                        } else if (e.op == 70 && GlobalOptimizer.isClass(b0)) {
                            changed |= this.convertify(e, b0, types);
                        }
                    }
                    if (!uses.get(e).isEmpty()) break;
                    if (e.op == 69) {
                        e.op = 78;
                    }
                    if (e.op != 70) break;
                    e.op = 79;
                    break;
                }
                case 116: {
                    if (e.args[0].op == 115) {
                        e.args[0] = e.args[0].args[0];
                    }
                }
                case 112: 
                case 115: 
                case 117: 
                case 118: 
                case 130: 
                case 133: 
                case 137: {
                    Expr a0 = e.args[0];
                    Type t = this.type(types, e);
                    Type t0 = this.type(types, e.args[0]);
                    if (t == t0) {
                        this.makeCopy(e, e.args[0]);
                        changed = true;
                        break;
                    }
                    if (e.op != 115) break;
                    if (a0.op == 144) {
                        e.op = 196;
                        e.args = new Expr[]{a0.args[0]};
                        changed = true;
                        break;
                    }
                    if (a0.op != 147) break;
                    e.op = 193;
                    e.args = new Expr[]{a0.args[0]};
                    changed = true;
                    break;
                }
                case 161: {
                    Object v1 = values.get(e.args[1]);
                    if (this.doubleValue(v1) == 1.0) {
                        e.args = new Expr[]{e.args[0]};
                        e.op = 147;
                        changed = true;
                        break;
                    }
                    if (this.doubleValue(v1) != -1.0) break;
                    e.args = new Expr[]{e.args[0]};
                    e.op = 145;
                    changed = true;
                    break;
                }
                case 160: {
                    Type t = this.type(types, e);
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (t.numeric) {
                        if (this.doubleValue(v0) == 1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 145;
                            changed = true;
                            break;
                        }
                        if (this.doubleValue(v1) == 1.0) {
                            e.args = new Expr[]{e.args[0]};
                            e.op = 145;
                            changed = true;
                            break;
                        }
                        if (this.doubleValue(v0) == -1.0) {
                            e.args = new Expr[]{e.args[1]};
                            e.op = 147;
                            changed = true;
                            break;
                        }
                        if (this.doubleValue(v1) != -1.0) break;
                        e.args = new Expr[]{e.args[0]};
                        e.op = 147;
                        changed = true;
                        break;
                    }
                    if (t != this.STRING) break;
                    if ("".equals(v0)) {
                        e.args = new Expr[]{e.args[1]};
                        e.op = 112;
                        changed = true;
                        break;
                    }
                    if (!"".equals(v1)) break;
                    e.args = new Expr[]{e.args[0]};
                    e.op = 112;
                    changed = true;
                }
            }
            if (!changed) continue;
            work.addAll(uses.get(e));
        } while (changed);
    }

    void sccp_rename(EdgeMap<Expr> uses, Expr e, Expr[] args) {
        for (int i = args.length - 1; i >= 0; --i) {
            Expr a = args[i];
            if (a.op != 42) continue;
            uses.get(a).remove(e);
            a = args[i] = a.locals[0];
            uses.get(a).add(e);
        }
    }

    Map<Expr, Typeref> verify_types(Method m, Deque<Block> code, Map<Block, Block> idom) {
        EdgeMap<Expr> uses = this.findUses(code);
        TreeMap<Expr, Typeref> types = new TreeMap<Expr, Typeref>();
        WorkSet<Expr> work = new WorkSet<Expr>();
        for (Block b : code) {
            work.addAll(b.exprs);
        }
        do {
            Typeref tref;
            Expr e;
            if (!(e = this.remove((Set<Expr>)work)).onStack() && !e.inLocal() && !e.onScope() && e.op != 10 || (tref = this.verify_eval(m, e, types, idom)).equals(types.get(e))) continue;
            types.put(e, tref);
            work.addAll(uses.get(e));
        } while (!work.isEmpty());
        return types;
    }

    void sccp_analyze(Method m, EdgeMap<Expr> uses, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> reached) {
        WorkSet<Edge> flowWork = new WorkSet<Edge>();
        WorkSet<Expr> ssaWork = new WorkSet<Expr>();
        WorkSet<Expr> ready = new WorkSet<Expr>();
        flowWork.add(m.entry);
        block0: while (true) {
            if (!flowWork.isEmpty()) {
                Edge edge = this.remove((Set<Edge>)flowWork);
                if (reached.contains(edge)) continue;
                reached.add(edge);
                Block b = edge.to;
                ready.addAll(b.exprs);
                ssaWork.addAll(b.exprs);
                Edge[] arr$ = b.xsucc;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block0;
                    Edge x = arr$[i$];
                    flowWork.add(x);
                    ++i$;
                }
            }
            while (!ssaWork.isEmpty()) {
                Expr e = this.remove((Set<Expr>)ssaWork);
                if (!ready.contains(e)) continue;
                this.sccp_eval(m, e, values, types, flowWork, ssaWork, uses);
            }
            if (flowWork.isEmpty()) break;
        }
    }

    boolean isCopy(Expr e, Map<Expr, Type> types, Set<Expr> upcasts) {
        Type t0;
        Type t = types.get(e);
        return t == (t0 = types.get(e.args[0])) || this.isUpcast(e, types) && !upcasts.contains(e);
    }

    boolean isUpcast(Expr e, Map<Expr, Type> types) {
        if (e.isCoerce()) {
            Type t0 = types.get(e.args[0]);
            Type t = types.get(e);
            return t != t0 && this.istype(t0, t);
        }
        return false;
    }

    void insert_casts(Method m) {
        Deque<Block> code = this.dfs(m.entry.to);
        SetMap<Block, Edge> pred = this.preds(code);
        Map<Block, Block> idom = this.idoms(code, pred);
        Map<Expr, Typeref> types = this.verify_types(m, code, idom);
        block0: for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) continue block0;
                Typeref etype = types.get(e);
                for (int i = e.args.length - 1; i >= 0; --i) {
                    Expr a = e.args[i];
                    Edge p = e.pred[i];
                    Typeref atype = types.get(a);
                    if (!(this.isLoop(p, idom) ? !etype.equals(atype) : this.isAtom(etype.t) != this.isAtom(atype.t)) || etype.t == atype.t && etype.nullable) continue;
                    System.out.println("MISSING CAST " + a + " " + atype + "->" + etype + " on " + p);
                    if (this.isCritical(p, pred)) {
                        this.split(p, m, pred);
                        p = e.pred[i];
                    }
                    Expr upcast = this.upcast(a, m, etype.t);
                    this.append(p, upcast);
                    e.args[i] = upcast;
                }
            }
        }
        System.out.println("VERIFY TYPES " + types);
    }

    Expr upcast(Expr a, Method m, Type t) {
        if (t == this.ANY) {
            return new Expr(m, 130, a);
        }
        if (t == this.OBJECT) {
            return new Expr(m, 137, a);
        }
        return new Expr(m, 128, t.name, a);
    }

    boolean isAtom(Type t) {
        return t.atom;
    }

    boolean isPointer(Type t) {
        return !this.isAtom(t) && !t.numeric;
    }

    Object eval_convert_i(Object v0) {
        return v0 instanceof Number ? Integer.valueOf(this.intValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_u(Object v0) {
        return v0 instanceof Number ? Long.valueOf(this.uintValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_d(Object v0) {
        return v0 instanceof Number ? Double.valueOf(this.doubleValue(v0)) : (v0 == Boolean.TRUE ? Integer.valueOf(1) : (v0 == Boolean.FALSE ? Integer.valueOf(0) : BOTTOM));
    }

    Object eval_convert_b(Object v0) {
        return v0 == BOTTOM ? BOTTOM : (this.booleanValue(v0) ? Boolean.TRUE : Boolean.FALSE);
    }

    Object eval_convert_s(Object v0) {
        return v0 != BOTTOM ? this.stringValue(v0) : BOTTOM;
    }

    Typeref eval_coerce_s(Typeref t0) {
        if (t0.nullable) {
            return t0.t == this.VOID || t0.t == this.NULL ? this.NULL.ref : this.STRING.ref;
        }
        return this.STRING.ref.nonnull();
    }

    Object eval_coerce_s(Object v0) {
        return v0 == UNDEFINED || v0 == this.NULL ? this.NULL : (v0 != BOTTOM ? this.stringValue(v0) : BOTTOM);
    }

    Typeref eval_coerce_o(Typeref t0) {
        if (t0.nullable) {
            return this.istype(t0.t, this.OBJECT) ? t0 : (t0.t == this.VOID || t0.t == this.NULL ? this.NULL.ref : this.OBJECT.ref);
        }
        return this.istype(t0.t, this.OBJECT) ? t0 : this.OBJECT.ref.nonnull();
    }

    Object eval_coerce_o(Object v0, Type t0) {
        return this.istype(t0, this.OBJECT) ? v0 : (t0 == this.VOID || t0 == this.NULL ? this.NULL : BOTTOM);
    }

    boolean lessthan(Object v0, Object v1) {
        if (v0 instanceof String && v1 instanceof String) {
            return ((String)v0).compareTo((String)v1) < 0;
        }
        return this.doubleValue(v0) < this.doubleValue(v1);
    }

    Type type(Map<Expr, Typeref> types, Expr e) {
        return types.get((Object)e).t;
    }

    boolean nullable(Expr e, Map<Expr, Typeref> types) {
        return types.get((Object)e).nullable;
    }

    void sccp_eval(Method m, Expr e, Map<Expr, Object> values, Map<Expr, Typeref> types, Set<Edge> flowWork, Set<Expr> ssaWork, EdgeMap<Expr> uses) {
        Object v = null;
        Object tref = null;
        if (e.op == 10) {
            for (Expr a : e.args) {
                Object av = values.get(a);
                if (av == null) continue;
                if (v == null) {
                    v = av;
                } else if (!av.equals(v)) {
                    v = BOTTOM;
                }
                Typeref aref = types.get(a);
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = this.mdb((Typeref)tref, aref);
            }
        } else {
            for (Expr a : e.args) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.scopes) {
                if (values.containsKey(a)) continue;
                return;
            }
            for (Expr a : e.locals) {
                if (values.containsKey(a)) continue;
                return;
            }
            v = BOTTOM;
            tref = this.ANY.ref;
            switch (e.op) {
                default: {
                    System.err.println("unhandled op:" + e.op + ":" + opNames[e.op]);
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 69: 
                case 89: {
                    break;
                }
                case 119: {
                    tref = types.get(e.args[0]).nonnull();
                    v = values.get(e.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 90: {
                    tref = m.handlers[e.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 86: {
                    tref = this.ARRAY.ref.nonnull();
                    break;
                }
                case 87: {
                    tref = m.activation;
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    v = values.get(e.scopes[0].args[0]);
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    tref = e.c.ref.nonnull();
                    break;
                }
                case 64: {
                    tref = this.FUNCTION.ref.nonnull();
                    break;
                }
                case 95: {
                    if (this.globals.contains(e.ref)) {
                        tref = this.globals.get(e.ref);
                    }
                    break;
                }
                case 93: 
                case 94: {
                    int i = this.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        v = values.get(e.scopes[i]);
                        tref = types.get(e.scopes[i]);
                        break;
                    }
                    i = this.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        tref = m.cx.scopes[i];
                        break;
                    }
                    if (this.globals.contains(e.ref)) {
                        tref = this.globals.get(e.ref);
                        break;
                    }
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    v = values.get(e.scopes[0]);
                    tref = types.get(e.scopes[0]);
                    break;
                }
                case 96: {
                    int i = this.findInner(e.ref, e.scopes, types);
                    Typeref stref = i >= 0 ? types.get(e.scopes[i]) : ((i = this.findOuter(e.ref, m.cx.scopes)) >= 0 ? m.cx.scopes[i] : (this.globals.contains(e.ref) ? this.globals.get(e.ref) : (m.cx.scopes.length > 0 ? m.cx.scopes[0] : types.get(e.scopes[0]))));
                    Binding b = stref.t.findGet(e.ref);
                    if (GlobalOptimizer.isSlot(b)) {
                        tref = b.type;
                        if (GlobalOptimizer.isConst(b) && this.defaultValueChanged(b)) {
                            v = b.value;
                        }
                    } else {
                        if (this.isMethod(b)) {
                            tref = this.FUNCTION.ref.nonnull();
                            break;
                        }
                        if (this.isGetter(b)) {
                            tref = b.method.returns;
                        }
                    }
                    break;
                }
                case 66: {
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = this.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b != null && b.type != null && b.type.t.itype != null) {
                        tref = b.type.t.itype.ref.nonnull();
                    }
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = this.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (this.isMethod(b)) {
                        tref = b.method.returns;
                        break;
                    }
                    if (GlobalOptimizer.isSlot(b) && b.type != null) {
                        if (b.type.t.itype == this.INT) {
                            tref = this.INT.ref;
                            v = this.eval_convert_i(values.get(e.args[1]));
                            break;
                        }
                        if (b.type.t.itype == this.UINT) {
                            tref = this.UINT.ref;
                            v = this.eval_convert_u(values.get(e.args[1]));
                            break;
                        }
                        if (b.type.t.itype == this.STRING) {
                            tref = this.STRING.ref.nonnull();
                            v = this.eval_convert_s(values.get(e.args[1]));
                            break;
                        }
                        if (b.type.t.itype == this.BOOLEAN) {
                            tref = this.BOOLEAN.ref;
                            v = this.eval_convert_b(values.get(e.args[1]));
                            break;
                        }
                        if (b.type.t.itype == this.NUMBER) {
                            tref = this.NUMBER.ref;
                            v = this.eval_convert_d(values.get(e.args[1]));
                        }
                    }
                    break;
                }
                case 68: {
                    tref = e.m.returns;
                    break;
                }
                case 0: {
                    if (e.imm[0] < m.params.length) {
                        tref = m.params[e.imm[0]];
                        break;
                    }
                    if (m.needsArguments() || m.needsRest() && e.imm[0] == m.params.length) {
                        tref = this.ARRAY.ref.nonnull();
                        break;
                    }
                    tref = this.VOID.ref;
                    break;
                }
                case 11: {
                    tref = m.handlers[e.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = this.type(types, e.args[0]);
                    Binding b = ((Type)t0).findSlot(e.imm[0]);
                    if (b != null) {
                        tref = b.type;
                    }
                    break;
                }
                case 102: {
                    Object t0 = this.type(types, e.args[0]);
                    Binding b = ((Type)t0).findGet(e.ref);
                    if (GlobalOptimizer.isSlot(b)) {
                        tref = b.type;
                        if (GlobalOptimizer.isConst(b) && this.defaultValueChanged(b)) {
                            v = b.value;
                        }
                    } else {
                        if (this.isMethod(b)) {
                            tref = this.FUNCTION.ref.nonnull();
                            break;
                        }
                        if (this.isGetter(b)) {
                            tref = b.method.returns;
                        }
                    }
                    break;
                }
                case 33: {
                    v = e.value;
                    tref = this.VOID.ref;
                    break;
                }
                case 32: {
                    v = e.value;
                    tref = this.NULL.ref;
                    break;
                }
                case 38: 
                case 39: {
                    v = e.value;
                    tref = this.BOOLEAN.ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: {
                    v = e.value;
                    tref = this.INT.ref;
                    break;
                }
                case 46: {
                    v = e.value;
                    tref = this.UINT.ref;
                    break;
                }
                case 44: {
                    v = e.value;
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 40: 
                case 47: {
                    v = e.value;
                    tref = this.NUMBER.ref;
                    break;
                }
                case 49: {
                    v = e.value;
                    tref = this.NAMESPACE.ref.nonnull();
                    break;
                }
                case 16: {
                    flowWork.add(e.succ[0]);
                    return;
                }
                case 27: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == BOTTOM) {
                        for (Edge s : e.succ) {
                            flowWork.add(s);
                        }
                    } else {
                        int i = this.intValue(v1);
                        if (i < 0 || i >= e.succ.length - 1) {
                            i = e.succ.length - 1;
                        }
                        flowWork.add(e.succ[i]);
                    }
                    return;
                }
                case 17: 
                case 18: {
                    Object v1 = values.get(e.args[0]);
                    if (v1 == BOTTOM) {
                        flowWork.add(e.succ[0]);
                        flowWork.add(e.succ[1]);
                    } else if (e.op == 18) {
                        flowWork.add(e.succ[this.booleanValue(v1) ? 0 : 1]);
                    } else if (e.op == 17) {
                        flowWork.add(e.succ[this.booleanValue(v1) ? 1 : 0]);
                    }
                    return;
                }
                case 28: 
                case 48: {
                    v = values.get(e.args[0]);
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 118: {
                    tref = this.BOOLEAN.ref;
                    v = this.eval_convert_b(values.get(e.args[0]));
                    break;
                }
                case 150: {
                    tref = this.BOOLEAN.ref;
                    Object v0 = values.get(e.args[0]);
                    if (v0 != BOTTOM) {
                        v = this.booleanValue(v0) ? Boolean.FALSE : Boolean.TRUE;
                    }
                    break;
                }
                case 31: 
                case 50: 
                case 91: 
                case 106: 
                case 171: 
                case 172: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = this.BOOLEAN.ref;
                    break;
                }
                case 173: 
                case 174: 
                case 175: 
                case 176: {
                    tref = this.BOOLEAN.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0.equals(NAN) || v0 == UNDEFINED || v1.equals(NAN) || v1 == UNDEFINED) {
                        v = Boolean.FALSE;
                        break;
                    }
                    if (v0 != BOTTOM && v1 != BOTTOM) {
                        v = e.op == 173 ? this.lessthan(v0, v1) : (e.op == 174 ? !this.lessthan(v1, v0) : (e.op == 175 ? this.lessthan(v1, v0) : !this.lessthan(v0, v1)));
                    }
                    break;
                }
                case 112: {
                    tref = this.STRING.ref.nonnull();
                    v = this.eval_convert_s(values.get(e.args[0]));
                    break;
                }
                case 133: {
                    tref = this.eval_coerce_s(types.get(e.args[0]));
                    v = this.eval_coerce_s(values.get(e.args[0]));
                    break;
                }
                case 137: {
                    Object t0 = types.get(e.args[0]);
                    tref = this.eval_coerce_o((Typeref)t0);
                    v = this.eval_coerce_o(values.get(e.args[0]), ((Typeref)t0).t);
                    break;
                }
                case 130: {
                    v = values.get(e.args[0]);
                    tref = types.get(e.args[0]);
                    break;
                }
                case 128: {
                    Object t0 = types.get(e.args[0]);
                    Object v0 = values.get(e.args[0]);
                    Type t = this.namedTypes.get(e.ref);
                    if (t == this.STRING) {
                        tref = this.eval_coerce_s((Typeref)t0);
                        v = this.eval_coerce_s(v0);
                        break;
                    }
                    if (t == this.OBJECT) {
                        tref = this.eval_coerce_o((Typeref)t0);
                        v = this.eval_coerce_o(v0, ((Typeref)t0).t);
                        break;
                    }
                    if (t == this.INT) {
                        tref = t.ref;
                        v = this.eval_convert_i(v0);
                        break;
                    }
                    if (t == this.UINT) {
                        tref = t.ref;
                        v = this.eval_convert_u(v0);
                        break;
                    }
                    if (t == this.NUMBER) {
                        tref = t.ref;
                        v = this.eval_convert_d(v0);
                        break;
                    }
                    if (t == this.BOOLEAN) {
                        tref = t.ref;
                        v = this.eval_convert_b(v0);
                        break;
                    }
                    if (this.istype(((Typeref)t0).t, t)) {
                        tref = t0;
                        v = v0;
                        break;
                    }
                    if (((Typeref)t0).t == this.NULL || ((Typeref)t0).t == this.VOID) {
                        tref = this.NULL.ref;
                        break;
                    }
                    tref = t.ref;
                    break;
                }
                case 134: {
                    tref = this.namedTypes.get((Name)e.ref).ref;
                    break;
                }
                case 149: {
                    Object t0 = this.type(types, e.args[0]);
                    if (t0 == this.INT || t0 == this.UINT || t0 == this.NUMBER) {
                        v = "number";
                    } else if (t0 == this.STRING) {
                        v = "string";
                    } else if (this.istype((Type)t0, this.XML) || this.istype((Type)t0, this.XMLLIST)) {
                        v = "xml";
                    } else if (t0 == this.VOID) {
                        v = "undefined";
                    } else if (t0 == this.BOOLEAN) {
                        v = "boolean";
                    } else if (this.istype((Type)t0, this.FUNCTION)) {
                        v = "function";
                    } else if (t0 != this.OBJECT && this.istype((Type)t0, this.OBJECT)) {
                        v = "object";
                    }
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 160: {
                    Expr a0 = e.args[0];
                    Expr a1 = e.args[1];
                    Typeref t0 = types.get(a0);
                    Typeref t1 = types.get(a1);
                    Object v0 = values.get(a0);
                    Object v1 = values.get(a1);
                    if (t0.t == this.STRING && !t0.nullable || t1.t == this.STRING && !t1.nullable) {
                        tref = this.STRING.ref.nonnull();
                        if (v0 != BOTTOM && v1 != BOTTOM) {
                            v = this.stringValue(v0) + this.stringValue(v1);
                        }
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = this.NUMBER.ref;
                        if (v0 instanceof Number && v1 instanceof Number) {
                            v = this.doubleValue(v0) + this.doubleValue(v1);
                        }
                        break;
                    }
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 163: {
                    tref = this.NUMBER.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = this.doubleValue(v0) / this.doubleValue(v1);
                    }
                    break;
                }
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 164: {
                    tref = this.NUMBER.ref;
                    break;
                }
                case 117: {
                    tref = this.NUMBER.ref;
                    v = this.eval_convert_d(values.get(e.args[0]));
                    break;
                }
                case 115: {
                    tref = this.INT.ref;
                    v = this.eval_convert_i(values.get(e.args[0]));
                    break;
                }
                case 116: {
                    tref = this.UINT.ref;
                    v = this.eval_convert_u(values.get(e.args[0]));
                    break;
                }
                case 169: {
                    tref = this.INT.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = this.intValue(v0) | this.intValue(v1);
                    }
                    break;
                }
                case 168: {
                    tref = this.INT.ref;
                    Object v0 = values.get(e.args[0]);
                    Object v1 = values.get(e.args[1]);
                    if (v0 instanceof Number && v1 instanceof Number) {
                        v = this.intValue(v0) & this.intValue(v1);
                    }
                    break;
                }
                case 51: 
                case 151: 
                case 165: 
                case 166: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    tref = this.INT.ref;
                    break;
                }
                case 167: {
                    tref = this.UINT.ref;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 29: 
                case 71: 
                case 72: 
                case 73: 
                case 78: 
                case 79: 
                case 97: 
                case 104: 
                case 109: 
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    return;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        if (((Typeref)tref).t == this.VOID) {
            v = UNDEFINED;
        } else if (((Typeref)tref).t == this.NULL) {
            v = this.NULL;
        }
        if (v != null && !v.equals(values.get(e))) {
            values.put(e, v);
            ssaWork.addAll(uses.get(e));
        }
        if (!((Typeref)tref).equals(types.get(e))) {
            types.put(e, (Typeref)tref);
            ssaWork.addAll(uses.get(e));
        }
    }

    Typeref verify_eval(Method m, Expr e, Map<Expr, Typeref> types, Map<Block, Block> idom) {
        Object tref = null;
        if (e.op == 10) {
            boolean loop = false;
            for (int i = e.args.length - 1; i >= 0; --i) {
                Expr a = e.args[i];
                loop |= this.isLoop(e.pred[i], idom);
                Typeref aref = types.get(a);
                if (aref == null) continue;
                if (tref == null) {
                    tref = aref;
                    continue;
                }
                if (((Typeref)tref).equals(aref)) continue;
                tref = this.mdb((Typeref)tref, aref);
            }
            if (loop) {
                tref = ((Typeref)tref).t.ref;
            }
        } else {
            tref = this.ANY.ref;
            for (Expr a : e.args) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e.scopes) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            for (Expr a : e.locals) {
                if (types.containsKey(a)) continue;
                return tref;
            }
            switch (e.op) {
                default: {
                    assert (false);
                }
                case 4: 
                case 30: 
                case 35: 
                case 52: 
                case 65: 
                case 89: {
                    tref = this.ANY.ref;
                    break;
                }
                case 119: {
                    tref = types.get(e.args[0]);
                    break;
                }
                case 113: 
                case 114: {
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 90: {
                    tref = m.handlers[e.imm[0]].activation;
                    break;
                }
                case 85: {
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 86: {
                    tref = this.ARRAY.ref.nonnull();
                    break;
                }
                case 87: {
                    tref = m.activation;
                    break;
                }
                case 100: {
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 101: {
                    tref = types.get(e.scopes[0].args[0]);
                    break;
                }
                case 88: {
                    tref = e.c.ref.nonnull();
                    break;
                }
                case 64: {
                    tref = this.FUNCTION.ref.nonnull();
                    break;
                }
                case 95: {
                    if (!this.globals.contains(e.ref)) break;
                    tref = this.globals.get(e.ref);
                    break;
                }
                case 93: 
                case 94: {
                    int i = this.findInner(e.ref, e.scopes, types);
                    if (i >= 0) {
                        tref = types.get(e.scopes[i]);
                        break;
                    }
                    i = this.findOuter(e.ref, m.cx.scopes);
                    if (i >= 0) {
                        tref = m.cx.scopes[i];
                        break;
                    }
                    if (this.globals.contains(e.ref)) {
                        tref = this.globals.get(e.ref);
                        break;
                    }
                    if (m.cx.scopes.length > 0) {
                        tref = m.cx.scopes[0];
                        break;
                    }
                    tref = types.get(e.scopes[0]);
                    break;
                }
                case 96: {
                    int i = this.findInner(e.ref, e.scopes, types);
                    Typeref stref = i >= 0 ? types.get(e.scopes[i]) : ((i = this.findOuter(e.ref, m.cx.scopes)) >= 0 ? m.cx.scopes[i] : (this.globals.contains(e.ref) ? this.globals.get(e.ref) : (m.cx.scopes.length > 0 ? m.cx.scopes[0] : types.get(e.scopes[0]))));
                    Binding b = stref.t.findGet(e.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b);
                    break;
                }
                case 66: {
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 74: {
                    Type ot = this.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (b == null || b.type == null || b.type.t.itype == null) break;
                    tref = b.type.t.itype.ref.nonnull();
                    break;
                }
                case 70: 
                case 76: {
                    Type ot = this.type(types, e.args[0]);
                    Binding b = ot.findGet(e.ref);
                    if (this.isMethod(b)) {
                        tref = b.method.returns;
                        break;
                    }
                    if (!GlobalOptimizer.isSlot(b) || b.type == null || b.type.t.itype == null) break;
                    tref = b.type.t.itype.ref;
                    break;
                }
                case 69: {
                    Type ot = m.cx.base;
                    Binding b = ot.findGet(e.ref);
                    if (!this.isMethod(b)) break;
                    tref = b.method.returns;
                    break;
                }
                case 68: {
                    tref = e.m.returns;
                    break;
                }
                case 0: {
                    if (e.imm[0] < m.params.length) {
                        tref = m.params[e.imm[0]];
                        break;
                    }
                    if (m.needsArguments() || m.needsRest() && e.imm[0] == m.params.length) {
                        tref = this.ARRAY.ref.nonnull();
                        break;
                    }
                    tref = this.VOID.ref;
                    break;
                }
                case 11: {
                    tref = m.handlers[e.imm[0]].type;
                    break;
                }
                case 108: {
                    Object t0 = this.type(types, e.args[0]);
                    Binding b = ((Type)t0).findSlot(e.imm[0]);
                    if (b == null) break;
                    tref = b.type;
                    break;
                }
                case 102: {
                    Object t0 = this.type(types, e.args[0]);
                    Binding b = ((Type)t0).findGet(e.ref);
                    tref = this.verify_eval_getproperty((Typeref)tref, b);
                    break;
                }
                case 8: {
                    tref = this.ANY.ref;
                    break;
                }
                case 33: {
                    tref = this.VOID.ref;
                    break;
                }
                case 32: {
                    tref = this.NULL.ref;
                    break;
                }
                case 49: {
                    tref = this.NAMESPACE.ref.nonnull();
                    break;
                }
                case 28: 
                case 48: {
                    tref = types.get(e.args[0]).nonnull();
                    break;
                }
                case 31: 
                case 38: 
                case 39: 
                case 50: 
                case 91: 
                case 106: 
                case 118: 
                case 150: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: {
                    tref = this.BOOLEAN.ref;
                    break;
                }
                case 44: 
                case 112: {
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 133: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.STRING, ((Typeref)t0).nullable);
                    break;
                }
                case 137: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.OBJECT, ((Typeref)t0).nullable);
                    break;
                }
                case 130: {
                    Object t0 = types.get(e.args[0]);
                    tref = new Typeref(this.ANY, ((Typeref)t0).nullable);
                    break;
                }
                case 128: {
                    tref = this.namedTypes.get((Name)e.ref).ref;
                    break;
                }
                case 134: {
                    Object t0 = types.get(e.args[0]);
                    Type t = this.namedTypes.get(e.ref);
                    if (!this.istype(((Typeref)t0).t, t) || this.isAtom(((Typeref)t0).t) != this.isAtom(t)) {
                        tref = t.ref;
                        break;
                    }
                    tref = t0;
                    break;
                }
                case 135: {
                    Typeref t1 = types.get(e.args[1]);
                    if (t1.t.itype != null) {
                        if (t1.t.itype.atom || t1.t.itype.numeric) {
                            tref = this.OBJECT.ref;
                            break;
                        }
                        tref = t1.t.itype.ref;
                        break;
                    }
                    tref = this.ANY.ref;
                    break;
                }
                case 149: {
                    tref = this.STRING.ref.nonnull();
                    break;
                }
                case 160: {
                    Expr a0 = e.args[0];
                    Expr a1 = e.args[1];
                    Typeref t0 = types.get(a0);
                    Typeref t1 = types.get(a1);
                    if (t0.t == this.STRING && !t0.nullable || t1.t == this.STRING && !t1.nullable) {
                        tref = this.STRING.ref.nonnull();
                        break;
                    }
                    if (t0.t.numeric && t1.t.numeric) {
                        tref = this.NUMBER.ref;
                        break;
                    }
                    tref = this.OBJECT.ref.nonnull();
                    break;
                }
                case 40: 
                case 47: 
                case 117: 
                case 144: 
                case 145: 
                case 147: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    tref = this.NUMBER.ref;
                    break;
                }
                case 36: 
                case 37: 
                case 45: 
                case 51: 
                case 115: 
                case 151: 
                case 165: 
                case 166: 
                case 168: 
                case 169: 
                case 170: 
                case 192: 
                case 193: 
                case 196: 
                case 197: 
                case 198: 
                case 199: {
                    tref = this.INT.ref;
                    break;
                }
                case 46: 
                case 116: 
                case 167: {
                    tref = this.UINT.ref;
                }
            }
        }
        assert (tref != null && ((Typeref)tref).t != null);
        return tref;
    }

    private Typeref verify_eval_getproperty(Typeref tref, Binding b) {
        if (GlobalOptimizer.isSlot(b)) {
            tref = b.type;
        } else if (this.isMethod(b)) {
            tref = this.ANY.ref;
        } else if (this.isGetter(b)) {
            tref = b.method.returns;
        }
        return tref;
    }

    EdgeMap<Expr> findUses(Deque<Block> code) {
        EdgeMap<Expr> uses = new EdgeMap<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                for (Expr a : e.args) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.locals) {
                    uses.get(a).add(e);
                }
                for (Expr a : e.scopes) {
                    uses.get(a).add(e);
                }
            }
        }
        return uses;
    }

    Typeref mdb(Typeref a, Typeref b) {
        assert (a != b && a != null && b != null);
        if (a.t == this.NULL && this.isPointer(b.t)) {
            return b;
        }
        if (b.t == this.NULL && this.isPointer(a.t)) {
            return a;
        }
        HashSet<Type> bases = new HashSet<Type>();
        Type t = a.t;
        while (t != null) {
            bases.add(t);
            t = t.base;
        }
        t = b.t;
        while (t != null) {
            if (bases.contains(t)) {
                return new Typeref(t, a.nullable | b.nullable);
            }
            t = t.base;
        }
        return new Typeref(this.ANY, a.nullable | b.nullable);
    }

    int findInner(Name ref, Expr[] scopes, Map<Expr, Typeref> types) {
        for (int i = scopes.length - 1; i >= 0; --i) {
            Type st = this.type(types, scopes[i]);
            Binding b = st.find(ref);
            if (b == null) continue;
            return i;
        }
        return -1;
    }

    int findOuter(Name ref, Typeref[] scopes) {
        for (int i = scopes.length - 1; i >= 1; --i) {
            Type st = scopes[i].t;
            Binding b = st.find(ref);
            if (b == null) continue;
            return i;
        }
        Typeref st = this.globals.get(ref);
        if (st != null) {
            return -1;
        }
        if (scopes.length > 0 && scopes[0].t.find(ref) != null) {
            return 0;
        }
        return -1;
    }

    boolean istype(Type t, Type c) {
        while (t != null) {
            if (t == c) {
                return true;
            }
            t = t.base;
        }
        return false;
    }

    boolean isCritical(Edge e, SetMap<Block, Edge> pred) {
        return e.from.succ().length > 1 && pred.get(e.to).size() > 1;
    }

    void split(Edge e, Method m, SetMap<Block, Edge> pred) {
        assert (e.handler == null);
        System.out.println("SPLIT " + e);
        Expr j = new Expr(m, 16);
        Block d = new Block(m);
        Block to = e.to;
        Edge e2 = new Edge(m, d, 0, to);
        j.succ = new Edge[]{e2};
        d.add(j);
        e.to = d;
        pred.get(d).add(e);
        pred.get(to).remove(e);
        pred.get(to).add(e2);
        this.replacePred(to, e, e2);
    }

    void replacePred(Block b, Edge before, Edge after) {
        for (Expr e : b) {
            if (e.op != 10) continue;
            int n = e.pred.length;
            for (int i = 0; i < n; ++i) {
                if (e.pred[i] != before) continue;
                e.pred[i] = after;
            }
        }
    }

    Expr append(Edge edge, Expr e) {
        Deque<Expr> exprs = edge.from.exprs;
        Expr last = exprs.removeLast();
        exprs.add(e);
        exprs.add(last);
        return e;
    }

    Expr prepend(Edge edge, Expr e) {
        Deque<Expr> exprs = edge.from.exprs;
        exprs.addFirst(e);
        return e;
    }

    Expr setlocal(Method m, int i, Expr a) {
        return new Expr(m, 99, i, new Expr[]{a}, 1, 1);
    }

    Expr getlocal(Method m, int i) {
        return new Expr(m, 98, i);
    }

    Expr dup(Method m, Expr e) {
        Expr dup = new Expr(m, 42);
        dup.locals = new Expr[]{e};
        return dup;
    }

    void remove_phi(Method m) {
        ConflictGraph conflicts;
        TreeMap<Block, Deque<Expr>> exprs;
        TreeMap<Integer, Integer> locals;
        SetMap<Block, Edge> pred;
        Deque<Block> code;
        block21: {
            code = this.dfs(m.entry.to);
            pred = this.preds(code);
            locals = new TreeMap<Integer, Integer>();
            exprs = new TreeMap<Block, Deque<Expr>>();
            conflicts = new ConflictGraph();
            System.out.println("BEFORE SCHED");
            this.print(code);
            if (m.needsArguments() || m.needsRest()) {
                int rest = m.params.length;
                for (Expr e : m.entry.to) {
                    if (e.op != 0 || e.imm[0] != rest) continue;
                    break block21;
                }
                m.flags &= 0xFFFFFFFA;
                m.flags |= 0x10;
                System.out.println("IGNORE_REST for " + m.name);
            }
        }
        this.sched_greedy(m, code, locals, pred, exprs, conflicts);
        this.alloc_locals(code, locals, conflicts);
        int max_local = m.params.length - 1;
        int max_stack = 0;
        int max_scope = 0;
        TreeMap<Block, Integer> stkin = new TreeMap<Block, Integer>();
        TreeMap<Block, Integer> scpin = new TreeMap<Block, Integer>();
        stkin.put(m.entry.to, 0);
        scpin.put(m.entry.to, 0);
        TreeSet<Edge> splits = new TreeSet<Edge>();
        for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10) break;
                if (!locals.containsKey(e.id)) continue;
                int lhs = (Integer)locals.get(e.id);
                for (int i = e.args.length - 1; i >= 0; --i) {
                    int rhs = (Integer)locals.get(e.args[i].id);
                    if (lhs == rhs) continue;
                    Edge p = e.pred[i];
                    if (!splits.contains(p)) {
                        this.split(p, m, pred);
                        p = e.pred[i];
                        splits.add(p);
                    }
                    Expr get = this.getlocal(m, rhs);
                    this.prepend(p, get);
                    this.append(p, this.setlocal(m, lhs, get));
                }
            }
            b.exprs = (Deque)exprs.get(b);
            int stkdepth = (Integer)stkin.get(b);
            int scpdepth = (Integer)scpin.get(b);
            for (Expr e : b) {
                assert (!e.isSynthetic());
                assert (stkdepth >= e.args.length);
                stkdepth -= e.args.length;
                if (e.onStack()) {
                    ++stkdepth;
                }
                if (stkdepth > max_stack) {
                    max_stack = stkdepth;
                }
                assert (scpdepth >= e.scopes.length);
                if (e.op == 29) {
                    --scpdepth;
                } else if (e.onScope()) {
                    ++scpdepth;
                }
                if (scpdepth > max_scope) {
                    max_scope = scpdepth;
                }
                int loc = max_local;
                if (e.op == 98 || e.op == 99) {
                    loc = e.imm[0] = ((Integer)locals.get(e.imm[0])).intValue();
                } else if (e.op == 50) {
                    int loc0 = (Integer)locals.get(e.locals[0].id);
                    int loc1 = (Integer)locals.get(e.locals[1].id);
                    e.imm = new int[]{loc0, loc1};
                    int n = loc = loc0 > loc1 ? loc0 : loc1;
                }
                if (loc <= max_local) continue;
                max_local = loc;
            }
            for (Edge s : b.succ()) {
                this.update_depth(s.to, stkdepth, stkin, scpdepth, scpin);
            }
            for (Edge s : b.xsucc) {
                this.update_depth(s.to, 1, stkin, 0, scpin);
            }
        }
        m.local_count = max_local + 1;
        m.max_stack = max_stack;
        m.max_scope = max_scope;
        System.out.println("AFTER SCHED " + m.name + " local_count=" + m.local_count + " max_stack=" + max_stack + " max_scope=" + max_scope);
        this.cfgopt(m);
    }

    void alloc_locals(Deque<Block> code, Map<Integer, Integer> locals, ConflictGraph conflicts) {
        for (Block b : code) {
            for (Expr e : b) {
                if (!locals.containsKey(e.id)) continue;
                this.alloc1(e, conflicts, locals);
            }
        }
        for (Block b : code) {
            for (Expr e : b) {
                if (!locals.containsKey(e.id)) continue;
                this.alloc2(e, conflicts, locals);
            }
        }
        System.out.println("CONFLICTS " + conflicts);
        System.out.println("LOCALS " + locals);
    }

    void update_depth(Block b, int stkdepth, Map<Block, Integer> stkin, int scpdepth, Map<Block, Integer> scpin) {
        if (stkin.containsKey(b)) {
            assert (stkin.get(b) == stkdepth);
        } else {
            stkin.put(b, stkdepth);
        }
        if (!scpin.containsKey(b)) {
            scpin.put(b, scpdepth);
        }
    }

    void allocate(int id, int loc, Map<Integer, Integer> locals, ConflictGraph conflicts) {
        assert (locals.get(id) == -1 && loc != -1);
        locals.put(id, loc);
        for (int j : conflicts.get(id)) {
            assert (locals.get(j) != loc);
        }
    }

    void alloc1(Expr e, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        if (locals.get(e.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i : conflicts.get(e.id)) {
            if (locals.get(i) == -1) continue;
            used.set(locals.get(i));
        }
        int loc = -1;
        if (e.locals.length == 1 && e.inLocal() && locals.containsKey(e.locals[0].id) && (loc = locals.get(e.locals[0].id).intValue()) != -1) {
            assert (!used.get(loc));
            this.allocate(e.id, loc, locals, conflicts);
        }
        if (e.op != 10) {
            return;
        }
        for (Expr a : e.args) {
            if (!locals.containsKey(a.id) || (loc = locals.get(a.id).intValue()) == -1 || used.get(loc)) continue;
            this.allocate(e.id, loc, locals, conflicts);
            break;
        }
        if (loc == -1) {
            loc = 0;
            while (used.get(loc)) {
                ++loc;
            }
            this.allocate(e.id, loc, locals, conflicts);
        }
        block3: for (Expr a : e.args) {
            if (locals.get(a.id) != -1) continue;
            for (int j : conflicts.get(a.id)) {
                if (locals.get(j) != loc) continue;
                continue block3;
            }
            this.allocate(a.id, loc, locals, conflicts);
        }
    }

    void alloc2(Expr e, ConflictGraph conflicts, Map<Integer, Integer> locals) {
        int loc;
        if (locals.get(e.id) != -1) {
            return;
        }
        BitSet used = new BitSet();
        for (int i : conflicts.get(e.id)) {
            if (locals.get(i) == -1) continue;
            used.set(locals.get(i));
        }
        if (e.locals.length == 1 && e.inLocal() && locals.containsKey(e.locals[0].id) && (loc = locals.get(e.locals[0].id).intValue()) != -1) {
            assert (!used.get(loc));
            this.allocate(e.id, loc, locals, conflicts);
        }
        if (e.args.length != 0 && locals.containsKey(e.args[0].id) && (loc = locals.get(e.args[0].id).intValue()) != -1 && !used.get(loc)) {
            this.allocate(e.id, loc, locals, conflicts);
            return;
        }
        loc = 0;
        while (used.get(loc)) {
            ++loc;
        }
        this.allocate(e.id, loc, locals, conflicts);
    }

    boolean hasStackEffect(Expr e) {
        if (e == null || e.op == 0) {
            return true;
        }
        return e.onStack() || e.args.length > 0;
    }

    ConflictGraph sched_greedy(Method m, Deque<Block> code, Map<Integer, Integer> locals, SetMap<Block, Edge> pred, Map<Block, Deque<Expr>> exprs, ConflictGraph cg) {
        SetMap<Block, Expr> liveout = new SetMap<Block, Expr>();
        TreeMap<Block, Deque<Expr>> stkout = new TreeMap<Block, Deque<Expr>>();
        TreeMap<Block, Deque<Expr>> scpout = new TreeMap<Block, Deque<Expr>>();
        HashMap<Block, LinkedDeque<Object>> listings = new HashMap<Block, LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                return b1.postorder - b2.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b = (Block)work.remove();
            while (work.peek() == b) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            ArrayDeque<Expr> in = new ArrayDeque<Expr>((Collection<Expr>)b.exprs);
            ArrayDeque<Expr> stk = new ArrayDeque<Expr>();
            ArrayDeque<Expr> scp = new ArrayDeque<Expr>();
            LinkedDeque<Object> verbose = new LinkedDeque<Object>();
            LinkedDeque<Expr> out = new LinkedDeque<Expr>();
            live.addAll(liveout.get(b));
            for (Expr l : live) {
                locals.put(l.id, l.op == 0 ? l.imm[0] : -1);
            }
            exprs.put(b, out);
            listings.put(b, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty() || !stk.isEmpty()) {
                Expr e;
                while (!stk.isEmpty() && this.hasStackEffect((Expr)in.peekLast())) {
                    this.showstate(live, stk, scp, verbose);
                    e = this.remove_dup(stk, m, out, verbose);
                    if (e.inLocal() || e.op == 10 || e != in.peekLast() || stk.contains(e)) {
                        this.issue_load(e, m, out, verbose, live, locals);
                        continue;
                    }
                    if (live.contains(e)) {
                        this.define(e, live, cg);
                        this.issue_store(e, m, out, verbose, stk);
                        stk.add(e);
                        continue;
                    }
                    if (e.op == 11) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                        verbose.addFirst(in.removeLast());
                        continue;
                    }
                    this.issue_expr((Expr)in.removeLast(), m, out, verbose, stk, scp, live, locals);
                }
                if (in.isEmpty()) continue;
                this.showstate(live, stk, scp, verbose);
                e = (Expr)in.removeLast();
                if (e.op == 10) {
                    this.issue_phi(e, verbose, phis, live, cg);
                    continue;
                }
                if (e.op == 0) {
                    verbose.addFirst(e);
                    if (!live.contains(e)) continue;
                    this.define(e, live, cg);
                    continue;
                }
                if (live.contains(e)) {
                    this.define(e, live, cg);
                    if (e.onStack()) {
                        this.issue_store(e, m, out, verbose, stk);
                        in.add(e);
                        continue;
                    }
                    if (!e.inLocal()) continue;
                    this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
                    continue;
                }
                if (e.op == 11) {
                    this.issue_pop(m, out, verbose, e);
                    verbose.addFirst(e);
                    continue;
                }
                if (e.onStack()) {
                    this.issue_pop(m, out, verbose, e);
                }
                this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
            }
            this.fwd_state(m, locals, pred, liveout, stkout, scpout, work, b, live, stk, scp, verbose, out, phis);
        }
        System.out.println("STK_LIVEOUT " + liveout);
        System.out.println("CONFLICTS " + cg);
        for (Block b : code) {
            System.out.println("");
            System.out.println(b);
            for (Object o : (Deque)listings.get(b)) {
                if (o instanceof Expr) {
                    this.print((Expr)o);
                    continue;
                }
                System.out.println(o);
            }
        }
        return cg;
    }

    void showstate(Set<Expr> live, Deque<Expr> stk, Deque<Expr> scp, Deque<Object> verbose) {
        verbose.addFirst("              live " + live + " stk " + stk);
        if (!scp.isEmpty()) {
            verbose.addFirst("              scp  " + scp);
        }
    }

    Expr remove_dup(Deque<Expr> stk, Method m, Deque<Expr> out, Deque<Object> verbose) {
        Expr e = stk.removeLast();
        while (e == stk.peekLast()) {
            this.issue_dup(stk.removeLast(), m, out, verbose);
        }
        return e;
    }

    void try_dup(Deque<Expr> stk, Method m, Deque<Expr> out, Deque<Object> verbose) {
        if (stk.size() > 2) {
            Expr e = stk.removeLast();
            while (e == stk.peekLast()) {
                this.issue_dup(stk.removeLast(), m, out, verbose);
            }
            stk.add(e);
        }
    }

    void issue_phi(Expr e, Deque<Object> verbose, Set<Expr> phis, Set<Expr> live, ConflictGraph cg) {
        verbose.addFirst(e);
        phis.add(e);
        if (live.contains(e)) {
            for (Expr l : live) {
                if (l == e) continue;
                cg.add(l, e);
            }
        }
    }

    ConflictGraph sched_lazy(Method m, Deque<Block> code, Map<Integer, Integer> locals, SetMap<Block, Edge> pred, Map<Block, Deque<Expr>> exprs, ConflictGraph cg) {
        SetMap<Block, Expr> liveout = new SetMap<Block, Expr>();
        TreeMap<Block, Deque<Expr>> stkout = new TreeMap<Block, Deque<Expr>>();
        TreeMap<Block, Deque<Expr>> scpout = new TreeMap<Block, Deque<Expr>>();
        HashMap<Block, LinkedDeque<Object>> listings = new HashMap<Block, LinkedDeque<Object>>();
        PriorityQueue<Block> work = new PriorityQueue<Block>(code.size(), new Comparator<Block>(){

            @Override
            public int compare(Block b1, Block b2) {
                return b1.postorder - b2.postorder;
            }
        });
        work.addAll(code);
        while (!work.isEmpty()) {
            Block b = (Block)work.remove();
            while (work.peek() == b) {
                work.remove();
            }
            TreeSet<Expr> live = new TreeSet<Expr>();
            ArrayDeque<Expr> in = new ArrayDeque<Expr>((Collection<Expr>)b.exprs);
            ArrayDeque<Expr> stk = new ArrayDeque<Expr>();
            ArrayDeque<Expr> scp = new ArrayDeque<Expr>();
            LinkedDeque<Object> verbose = new LinkedDeque<Object>();
            LinkedDeque<Expr> out = new LinkedDeque<Expr>();
            if (stkout.containsKey(b)) {
                stk.addAll((Collection)stkout.get(b));
            }
            live.addAll(liveout.get(b));
            for (Expr l : live) {
                locals.put(l.id, l.op == 0 ? l.imm[0] : -1);
            }
            exprs.put(b, out);
            listings.put(b, verbose);
            TreeSet<Expr> phis = new TreeSet<Expr>();
            while (!in.isEmpty()) {
                this.showstate(live, stk, scp, verbose);
                Expr e = (Expr)in.removeLast();
                if (e.op == 10) {
                    this.issue_phi(e, verbose, phis, live, cg);
                    continue;
                }
                assert (phis.isEmpty());
                boolean onstack = false;
                while (stk.contains(e)) {
                    onstack = true;
                    Expr f = this.remove_dup(stk, m, out, verbose);
                    if (f == e && !stk.contains(e)) continue;
                    this.issue_load(f, m, out, verbose, live, locals);
                }
                if (e.op == 0) {
                    if (onstack) {
                        this.issue_load(e, m, out, verbose, live, locals);
                    }
                    verbose.addFirst(e);
                    if (!live.contains(e)) continue;
                    this.define(e, live, cg);
                    continue;
                }
                if (live.contains(e)) {
                    if (e.op == 11) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                    }
                    this.define(e, live, cg);
                    if (onstack) {
                        stk.add(e);
                    }
                    this.issue_store(e, m, out, verbose, stk);
                    in.add(e);
                    continue;
                }
                if (e.op == 11) {
                    if (!stk.isEmpty()) {
                        while (!stk.isEmpty()) {
                            this.loadTOS(m, stk, scp, out, verbose, live, locals);
                        }
                        in.add(e);
                        if (!onstack) continue;
                        stk.add(e);
                        continue;
                    }
                    if (!onstack) {
                        this.issue_pop(m, out, verbose, e);
                    }
                    verbose.addFirst(e);
                    continue;
                }
                if (!onstack && e.onStack()) {
                    this.issue_pop(m, out, verbose, e);
                }
                this.issue_expr(e, m, out, verbose, stk, scp, live, locals);
            }
            this.fwd_state(m, locals, pred, liveout, stkout, scpout, work, b, live, stk, scp, verbose, out, phis);
        }
        System.out.println("SCHED LIVEOUT " + liveout);
        System.out.println("SCHED STKOUT " + stkout);
        System.out.println("SCHED CONFLICTS " + cg);
        for (Block b : code) {
            System.out.println("");
            System.out.println(b);
            for (Object o : (Deque)listings.get(b)) {
                if (o instanceof Expr) {
                    this.print((Expr)o);
                    continue;
                }
                System.out.println(o);
            }
        }
        return cg;
    }

    static boolean isThrowEdge(Edge e) {
        return e.handler != null;
    }

    void loadTOS(Method m, Deque<Expr> stk, Deque<Expr> scp, Deque<Expr> out, Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.showstate(live, stk, scp, verbose);
        Expr e = stk.removeLast();
        if (e == stk.peekLast()) {
            this.issue_dup(e, m, out, verbose);
        } else {
            this.issue_load(e, m, out, verbose, live, locals);
        }
    }

    void fwd_state(Method m, Map<Integer, Integer> locals, SetMap<Block, Edge> pred, SetMap<Block, Expr> liveout, Map<Block, Deque<Expr>> stkout, Map<Block, Deque<Expr>> scpout, PriorityQueue<Block> work, Block b, Set<Expr> live, Deque<Expr> stk, Deque<Expr> scp, Deque<Object> verbose, Deque<Expr> out, Set<Expr> phis) {
        Block f;
        TreeMap<Block, Deque<Expr>> stkout2 = new TreeMap<Block, Deque<Expr>>(stkout);
        for (Edge p : pred.get(b)) {
            f = p.from;
            Deque<Expr> stk2 = this.clone_stk(phis, stk, p);
            if (!stkout2.containsKey(f)) {
                stkout2.put(f, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout2.get(f));
            assert (stk.size() >= prefix);
            while (stk.size() > prefix) {
                this.loadTOS(m, stk, scp, out, verbose, live, locals);
            }
        }
        this.showstate(live, stk, scp, verbose);
        for (Edge p : pred.get(b)) {
            f = p.from;
            Set<Expr> live2 = this.clone_live(phis, live, p);
            if (liveout.get(f).addAll(live2)) {
                work.add(f);
            }
            Deque<Expr> stk2 = this.clone_stk(phis, stk, p);
            if (!stkout.containsKey(f)) {
                stkout.put(f, stk2);
                continue;
            }
            int prefix = this.stacks_equal(stk2, stkout.get(f));
            assert (stk2.size() == prefix && stkout.get(f).size() >= prefix);
            if (stkout.get(f).size() <= prefix) continue;
            stkout.put(f, stk2);
            work.add(f);
            for (Edge s : f.succ()) {
                if (s.to == b) continue;
                work.add(s.to);
            }
        }
    }

    Set<Expr> clone_live(Set<Expr> phis, Set<Expr> live, Edge p) {
        if (phis.isEmpty() || live.isEmpty()) {
            return live;
        }
        TreeSet<Expr> copy = new TreeSet<Expr>();
        for (Expr e : live) {
            copy.add(phis.contains(e) ? e.args[this.findPhiArg(e, p)] : e);
        }
        return copy;
    }

    Deque<Expr> clone_stk(Set<Expr> phis, Deque<Expr> stk, Edge p) {
        if (phis.isEmpty() || stk.isEmpty()) {
            return stk;
        }
        ArrayDeque<Expr> copy = new ArrayDeque<Expr>();
        for (Expr e : stk) {
            copy.add(phis.contains(e) ? e.args[this.findPhiArg(e, p)] : e);
        }
        return copy;
    }

    int stacks_equal(Deque<Expr> stk1, Deque<Expr> stk2) {
        int i = 0;
        Iterator i1 = stk1.iterator();
        Iterator i2 = stk2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() != i2.next()) {
                return i;
            }
            ++i;
        }
        return i;
    }

    void define(Expr e, Set<Expr> live, ConflictGraph cg) {
        live.remove(e);
        for (Expr l : live) {
            cg.add(e, l);
        }
    }

    void issue_expr(Expr e, Method m, Deque<Expr> out, Deque<Object> verbose, Deque<Expr> stk, Deque<Expr> scp, Set<Expr> live, Map<Integer, Integer> locals) {
        if (!e.isSynthetic()) {
            out.addFirst(e);
        }
        verbose.addFirst(e);
        for (Expr a : e.args) {
            stk.add(a);
        }
        for (Expr a : e.locals) {
            this.use(a, live, locals);
        }
        this.try_dup(stk, m, out, verbose);
    }

    void issue_store(Expr e, Method m, Deque<Expr> out, Deque<Object> verbose, Deque<Expr> stk) {
        Expr set = this.setlocal(m, e.id, e);
        out.addFirst(set);
        verbose.addFirst(set);
        stk.add(e);
    }

    void issue_dup(Expr e, Method m, Deque<Expr> out, Deque<Object> verbose) {
        Expr dup = this.dup(m, e);
        out.addFirst(dup);
        verbose.addFirst(dup);
    }

    void issue_pop(Method m, Deque<Expr> out, Deque<Object> verbose, Expr a) {
        Expr pop = new Expr(m, 41, a);
        out.addFirst(pop);
        verbose.addFirst(pop);
    }

    void issue_load(Expr e, Method m, Deque<Expr> out, Deque<Object> verbose, Set<Expr> live, Map<Integer, Integer> locals) {
        this.use(e, live, locals);
        Expr get = this.getlocal(m, e.id);
        out.addFirst(get);
        verbose.addFirst(get);
    }

    void use(Expr e, Set<Expr> live, Map<Integer, Integer> locals) {
        live.add(e);
        locals.put(e.id, e.op == 0 ? e.imm[0] : -1);
    }

    void rename(Expr e, Expr[] args, Map<Expr, Expr> map, EdgeMap<Expr> ssaSucc) {
        for (Expr a : args) {
            while (map.containsKey(a)) {
                ssaSucc.get(a).remove(e);
                a = args[i] = map.get(a);
                ssaSucc.get(a).add(e);
            }
        }
    }

    void cp(Deque<Block> code) {
        EdgeMap<Expr> uses = this.findUses(code);
        HashMap<Expr, Expr> map = new HashMap<Expr, Expr>();
        WorkSet<Expr> work = new WorkSet<Expr>();
        for (Block b : code) {
            for (Expr e : b) {
                if (e.op != 10 && e.op != 42) continue;
                work.add(e);
            }
        }
        while (!work.isEmpty()) {
            Expr e = this.remove((Set<Expr>)work);
            this.rename(e, e.args, map, uses);
            this.rename(e, e.scopes, map, uses);
            this.rename(e, e.locals, map, uses);
            if (e.op == 42) {
                map.put(e, e.locals[0]);
                work.addAll(uses.get(e));
                continue;
            }
            if (e.op != 10) continue;
            assert (e.args.length == e.pred.length);
            for (int j = e.pred.length - 1; j >= 0; --j) {
                if (code.contains(e.pred[j].from)) continue;
                e.remove(j);
            }
            Expr a = null;
            for (int j = e.pred.length - 1; j >= 0; --j) {
                if (e.args[j] == e || e.args[j] == a) continue;
                if (a == null) {
                    a = e.args[j];
                    continue;
                }
                a = null;
                break;
            }
            if (a == null || map.get(e) == a) continue;
            map.put(e, a);
            work.addAll(uses.get(e));
            e.clearEffect();
        }
    }

    boolean hasSideEffect(Expr e) {
        return e.isPx() || e.hasEffect();
    }

    void dfs_visit_el(Edge[] el, BitSet visited, Deque<Block> list) {
        for (int i = el.length - 1; i >= 0; --i) {
            this.dfs_visit(el[i].to, visited, list);
        }
    }

    Deque<Block> dfs_visit(Block b, BitSet visited, Deque<Block> list) {
        if (!visited.get(b.id)) {
            visited.set(b.id);
            this.dfs_visit_el(b.xsucc, visited, list);
            this.dfs_visit_el(b.succ(), visited, list);
            b.postorder = list.size();
            list.addFirst(b);
        }
        return list;
    }

    Deque<Block> dfs(Block entry) {
        return this.dfs_visit(entry, new BitSet(), new LinkedDeque<Block>());
    }

    void schedule_loop(Block b, EdgeMap<Block> loops, Deque<Block> done) {
        Set<Block> loop = loops.get(b);
        for (Block lb : this.dfs(b)) {
            if (done.contains(lb) || !loop.contains(lb)) continue;
            done.add(lb);
            if (!loops.containsKey(lb)) continue;
            this.schedule_loop(lb, loops, done);
        }
    }

    Deque<Block> schedule(Block entry) {
        Deque<Block> code = this.dfs(entry);
        ArrayDeque<Block> done = new ArrayDeque<Block>();
        SetMap<Block, Edge> pred = this.preds(code);
        Map<Block, Block> idom = this.idoms(code, pred);
        EdgeMap<Block> loops = this.findLoops(code, idom, pred);
        if (!loops.isEmpty()) {
            System.out.println("LOOPS " + loops);
        }
        for (Block b : code) {
            if (!done.contains(b)) {
                done.add(b);
            }
            if (!loops.containsKey(b)) continue;
            this.schedule_loop(b, loops, done);
        }
        code.clear();
        code.addAll(done);
        while (code.size() > 1) {
            Block b = code.removeFirst();
            Expr last = b.last();
            Block next = code.peekFirst();
            if (!this.isBranch(last) || last.succ[0].to == next || last.succ[1].to != next) continue;
            this.invert(last);
        }
        return done;
    }

    boolean isJump(Expr e) {
        return e.op == 16;
    }

    boolean isBranch(Expr e) {
        return e.succ != null && e.succ.length == 2 && e.op != 27;
    }

    Block intersect(Block b1, Block b2, Block[] doms) {
        while (b1 != b2) {
            while (b1.postorder < b2.postorder) {
                b1 = doms[b1.postorder];
            }
            while (b2.postorder < b1.postorder) {
                b2 = doms[b2.postorder];
            }
        }
        return b1;
    }

    Map<Block, Block> idoms(Deque<Block> all, SetMap<Block, Edge> pred) {
        boolean changed;
        Block entry = all.peekFirst();
        Block[] doms = new Block[entry.postorder + 1];
        doms[entry.postorder] = entry;
        do {
            changed = false;
            for (Block b : all) {
                Block p;
                if (b == entry) continue;
                Block new_idom = null;
                for (Edge e : pred.get(b)) {
                    p = e.from;
                    if (doms[p.postorder] == null) continue;
                    new_idom = p;
                    break;
                }
                for (Edge e : pred.get(b)) {
                    p = e.from;
                    if (p == new_idom || doms[p.postorder] == null) continue;
                    new_idom = this.intersect(p, new_idom, doms);
                }
                if (doms[b.postorder] == new_idom) continue;
                doms[b.postorder] = new_idom;
                changed = true;
            }
        } while (changed);
        TreeMap<Block, Block> map = new TreeMap<Block, Block>();
        for (Block b : all) {
            if (b == entry) continue;
            map.put(b, doms[b.postorder]);
        }
        return map;
    }

    boolean dominates(Block p, Block s, Map<Block, Block> idom) {
        Block b = s;
        while (b != null) {
            if (b == p) {
                return true;
            }
            b = idom.get(b);
        }
        return false;
    }

    boolean isLoop(Edge e, Map<Block, Block> idom) {
        return e.from.postorder < e.to.postorder && this.dominates(e.to, e.from, idom);
    }

    Block remove(Set<Block> work) {
        Iterator<Block> i = work.iterator();
        Block b = i.next();
        i.remove();
        return b;
    }

    Expr remove(Set<Expr> work) {
        Iterator<Expr> i = work.iterator();
        Expr e = i.next();
        i.remove();
        return e;
    }

    Edge remove(Set<Edge> work) {
        Iterator<Edge> i = work.iterator();
        Edge e = i.next();
        i.remove();
        return e;
    }

    Method remove(List<Method> list) {
        return list.remove(list.size() - 1);
    }

    EdgeMap<Block> findLoops(Deque<Block> code) {
        SetMap<Block, Edge> pred = this.preds(code);
        return this.findLoops(code, this.idoms(code, pred), pred);
    }

    EdgeMap<Block> findLoops(Deque<Block> code, Map<Block, Block> idom, SetMap<Block, Edge> pred) {
        EdgeMap<Block> loops = new EdgeMap<Block>();
        for (Block b : code) {
            for (Edge s : b.succ()) {
                if (!this.isLoop(s, idom)) continue;
                System.out.println("backedge " + s);
                Block h = s.to;
                Set<Block> loop = loops.get(h);
                WorkSet<Block> work = new WorkSet<Block>();
                for (Edge p : pred.get(h)) {
                    if (!this.isLoop(p, idom) || loop.contains(p.from) || p.from == h) continue;
                    loop.add(p.from);
                    work.add(p.from);
                }
                while (!work.isEmpty()) {
                    Block x = this.remove((Set<Block>)work);
                    for (Edge p : pred.get(x)) {
                        if (p.from == h || loop.contains(p.from)) continue;
                        loop.add(p.from);
                        work.add(p.from);
                    }
                }
            }
        }
        return loops;
    }

    void dce_mark(BitSet used, Expr e) {
        if (used.get(e.id)) {
            return;
        }
        used.set(e.id);
        for (Expr a : e.args) {
            this.dce_mark(used, a);
        }
        for (Expr a : e.scopes) {
            this.dce_mark(used, a);
        }
        for (Expr a : e.locals) {
            this.dce_mark(used, a);
        }
    }

    void dce(Method m) {
        Deque<Block> code = this.dfs(m.entry.to);
        this.cp(code);
        BitSet marked = new BitSet();
        for (Block b : code) {
            for (Expr e : b) {
                if (!this.hasSideEffect(e)) continue;
                this.dce_mark(marked, e);
            }
        }
        for (Block b : code) {
            Iterator<Expr> i = b.iterator();
            while (i.hasNext()) {
                if (marked.get(i.next().id)) continue;
                i.remove();
            }
        }
    }

    String format(char op, Object[] a, char cp) {
        if (a == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(op);
        for (Object o : a) {
            s.append(o).append(' ');
        }
        if (a.length > 0) {
            s.setCharAt(s.length() - 1, cp);
        } else {
            s.append(cp);
        }
        return s.toString();
    }

    static boolean isSlot(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 0 || tk == 6 || tk == 4;
    }

    static boolean isConst(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 6 || tk == 2;
    }

    static boolean isClass(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 4;
    }

    boolean isMethod(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 1;
    }

    boolean isGetter(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 2;
    }

    boolean isSetter(Binding b) {
        if (b == null) {
            return false;
        }
        int tk = b.kind();
        return tk == 3;
    }

    static boolean isLive(int i, Method m, int scopep) {
        return i < scopep || i >= m.local_count + m.max_scope;
    }

    Block createBlock(Method m, Edge edge, Map<Block, FrameState> states, Expr[] frame, int sp, int scopep) {
        Block b = new Block(m);
        FrameState state = new FrameState(frame, sp, scopep);
        if (edge != null) {
            edge.to = b;
        }
        for (int i = 0; i < sp; ++i) {
            if (!GlobalOptimizer.isLive(i, m, scopep) || frame[i] == null) continue;
            Expr e = new Expr(m, 10);
            if (edge != null) {
                e.args = new Expr[]{frame[i]};
                e.pred = new Edge[]{edge};
            }
            state.frame[i] = e;
            b.add(state.frame[i]);
        }
        states.put(b, state);
        return b;
    }

    void merge(Method m, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        if (!blocks.containsKey(pos)) {
            Block b = this.createBlock(m, edge, states, frame, sp, scopep);
            blocks.put(pos, b);
        } else if (edge != null) {
            edge.to = blocks.get(pos);
            this.merge(m, edge, states, frame, sp, scopep);
        }
    }

    void merge(Method m, Edge edge, Map<Block, FrameState> states, Expr[] frame, int sp, int scopep) {
        FrameState target = states.get(edge.to);
        assert (target.sp == sp);
        assert (target.scopep == scopep);
        for (int i = 0; i < sp; ++i) {
            if (!GlobalOptimizer.isLive(i, m, scopep) || frame[i] == target.frame[i]) continue;
            assert (frame[i] != null && target.frame[i].op == 10);
            target.frame[i].append(frame[i], edge);
        }
    }

    void xmerge(Method m, Edge edge, Map<Integer, Block> blocks, Map<Block, FrameState> states, int pos, Expr[] frame, int sp, int scopep) {
        scopep = m.local_count;
        sp = scopep + m.max_scope;
        Handler h = edge.handler;
        if (h.entry == null) {
            Block hb = h.entry = this.createBlock(m, edge, states, frame, sp, scopep);
            Expr xarg = new Expr(m, 11, edge.label);
            hb.add(xarg);
            Expr jump = new Expr(m, 16);
            hb.add(jump);
            jump.succ = new Edge[]{new Edge(m, hb, 0, blocks.get(pos))};
            Expr save = frame[sp];
            frame[sp] = xarg;
            this.merge(m, jump.succ[0], blocks, states, pos, frame, sp + 1, scopep);
            frame[sp] = save;
        } else {
            edge.to = h.entry;
            this.merge(m, edge, states, frame, sp, scopep);
        }
    }

    static Expr[] capture(Expr[] frame, int top, int len) {
        Expr[] args = new Expr[len];
        System.arraycopy(frame, top - len, args, 0, len);
        return args;
    }

    boolean isPx(int op) {
        return (flagTable[op] & 8) != 0;
    }

    void print(Expr e) {
        PrintWriter pw = new PrintWriter(System.out);
        this.printssa(e, pw);
        pw.flush();
    }

    void printabc(Expr e, PrintWriter out) {
        out.print("    " + opNames[e.op]);
        if (e.imm != null) {
            StringBuilder s = new StringBuilder();
            s.append('<');
            for (int i : e.imm) {
                s.append(i).append(',');
            }
            s.setCharAt(s.length() - 1, '>');
            out.print(s);
        }
        if (e.succ != null) {
            out.print(this.format('[', e.succ, ']'));
        }
        if (e.value != null) {
            out.print(" ");
            this.print(e.value, out);
        }
        if (e.ref != null) {
            out.print(" " + e.ref);
        }
        out.println();
    }

    void printssa(Expr e, PrintWriter out) {
        out.print(e);
        if (e.onStack() || e.inLocal() || e.onScope()) {
            out.print(" =");
        } else {
            out.print("  ");
        }
        if (e.value == null) {
            out.print(" " + opNames[e.op]);
        }
        if (e.imm != null) {
            StringBuilder s = new StringBuilder();
            s.append('<');
            for (int i : e.imm) {
                s.append(i).append(',');
            }
            s.setCharAt(s.length() - 1, '>');
            out.print(s);
        }
        if (e.args.length > 0) {
            out.print(this.format('(', e.args, ')'));
        }
        if (e.locals.length > 0) {
            out.print(this.format('(', e.locals, ')'));
        }
        if (e.scopes.length > 0) {
            out.print(this.format('{', e.scopes, '}'));
        }
        if (e.pred.length > 0) {
            out.print(this.format('[', e.pred, ']'));
        }
        if (e.succ != null) {
            out.print(this.format('[', e.succ, ']'));
        }
        if (e.value != null) {
            this.print(e.value, out);
        }
        if (e.ref != null) {
            out.print(" " + e.ref);
        }
        out.println();
    }

    void print(Object value, PrintWriter out) {
        if (value instanceof String) {
            out.print(" \"" + ((String)value).replace("\n", "\\n").replace("\r", "\\r") + "\"");
        } else {
            out.print(" " + value);
        }
    }

    void print(Deque<Block> blocks) {
        System.out.println(blocks);
        PrintWriter pw = new PrintWriter(System.out);
        for (Block b : blocks) {
            this.print(b, pw);
        }
        pw.flush();
    }

    void printabc(Deque<Block> blocks) {
        System.out.println(blocks);
        PrintWriter pw = new PrintWriter(System.out);
        for (Block b : blocks) {
            this.printabc(b, pw);
        }
        pw.flush();
    }

    void print(Block b, PrintWriter pw) {
        pw.println();
        this.printssa(b, pw);
    }

    void printabc(Block b, PrintWriter out) {
        out.println();
        out.println(b);
        if (b.xsucc.length > 0) {
            out.println(Arrays.toString(b.xsucc));
        }
        for (Expr s : b) {
            this.printabc(s, out);
        }
    }

    void printssa(Block b, PrintWriter out) {
        out.println(b);
        if (b.xsucc.length > 0) {
            out.println(Arrays.toString(b.xsucc));
        }
        for (Expr s : b) {
            this.printssa(s, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dot(String suffix, Method m) {
        if (m.entry.to.succ().length == 0) {
            return;
        }
        try {
            PrintWriter out = new PrintWriter(new FileWriter(m.name + suffix + ".dot"));
            try {
                Deque<Block> code = this.dfs(m.entry.to);
                out.println("digraph {");
                out.println("compound=true;");
                out.println("label=\"" + m.name + suffix + "\";");
                out.println("labelloc=top;");
                out.println("fontsize=10;");
                out.println("ranksep=.25; nodesep=.25;");
                out.println("node [shape=box,width=.1,height=.1,fontsize=7];");
                out.println("edge [arrowsize=.5,fontsize=8,labelfontsize=8];");
                for (Block b : code) {
                    this.dot(b, out);
                }
                Map<Block, Block> doms = this.idoms(code, this.allpreds(code));
                out.println("node [shape=box];");
                out.println("subgraph cluster1 { label=\"Dominators\"; color=white; ");
                for (Block b : this.dfs(m.entry.to)) {
                    out.println("D" + b + " [label=" + b + "];");
                    if (!doms.containsKey(b)) continue;
                    out.println("D" + doms.get(b) + " -> D" + b);
                }
                out.println("}");
                out.println("}");
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void dot(Block b, PrintWriter out) {
        LabelWriter w = new LabelWriter(new StringWriter());
        w.print(b);
        String attr = "label=\"" + w + "\"";
        out.println(b + " [" + attr + "];");
        for (Edge e : b.succ()) {
            this.dot(e, out);
        }
        for (Edge e : b.xsucc) {
            this.dot(e, out);
        }
    }

    void dot_dfg(Block b, PrintWriter out) {
        LabelWriter w = new LabelWriter(new StringWriter());
        w.print(b);
        String attr = "label=\"" + w + "\"; labeljust=l";
        out.println("subgraph cluster" + b + " { " + attr + ";");
        Expr n = null;
        Iterator<Expr> i = b.iterator();
        if (i.hasNext()) {
            n = i.next();
        }
        while (n != null) {
            Expr e = n;
            w = new LabelWriter(new StringWriter());
            this.printssa(e, (PrintWriter)w);
            out.print("E" + e.id + " [label=\"" + w + "\"];");
            if (i.hasNext()) {
                n = i.next();
                out.print("E" + e.id + " -> E" + n.id + " [style=invisible,arrowhead=none,weight=4];");
                continue;
            }
            n = null;
        }
        out.println("}");
        for (Expr e : b) {
            for (Expr expr : e.args) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=green];");
            }
            for (Expr expr : e.locals) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=green];");
            }
            for (Expr expr : e.scopes) {
                out.print("E" + expr.id + " -> E" + e.id + " [color=grey,style=dashed];");
            }
            if (!e.isPx()) continue;
            for (Comparable<Expr> comparable : b.xsucc) {
                out.print("E" + e.id + " -> E" + ((Edge)comparable).to.first().id + " [weight=2,style=dashed,color=red];");
            }
        }
        for (Edge s : b.succ()) {
            Expr e = b.last();
            int n2 = s == b.last().succ[0] ? 4 : 2;
            out.print("E" + e.id + " -> E" + s.to.first().id + " [weight=" + n2 + "];");
        }
    }

    void dot(Edge e, PrintWriter out) {
        ArrayList<String> attrs = new ArrayList<String>();
        if (GlobalOptimizer.isThrowEdge(e)) {
            attrs.add("style=dashed");
        } else {
            if (e.from.postorder < e.to.postorder) {
                attrs.add("tailport=w,headport=w");
            }
            if (e.label == 0) {
                attrs.add("weight=2");
            } else {
                attrs.add("taillabel=\"" + e.label + "\"");
            }
        }
        out.println(e.from + " -> " + e.to + " " + attrs + ";");
    }

    static {
        UNDEFINED = new Object(){

            public String toString() {
                return "undefined";
            }
        };
        BOTTOM = new Object(){

            public String toString() {
                return "?";
            }
        };
        NAN = Double.NaN;
        PUBLIC = new Namespace("");
        PKG_PUBLIC = new Namespace(22, "");
        AS3 = new Namespace("http://adobe.com/AS3/2006/builtin");
        AS3_TOSTRING = new Name(AS3, "toString");
        nometadata = new Metadata[0];
        noexprs = new Expr[0];
        noedges = new Edge[0];
        notypes = new Type[0];
        notyperefs = new Typeref[0];
        refArgc = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1};
        flagTable = new int[]{144, 2, 0, 8, 74, 10, 10, 10, 128, 2, 16, 80, 10, 10, 10, 10, 2, 2, 2, 10, 10, 10, 10, 10, 10, 2, 2, 10, 40, 2, 72, 72, 64, 64, 0, 72, 64, 64, 64, 64, 64, 2, 66, 2, 64, 64, 64, 64, 40, 64, 72, 144, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 74, 74, 74, 74, 74, 74, 10, 10, 10, 74, 0, 74, 0, 10, 10, 0, 0, 0, 0, 0, 64, 64, 64, 74, 72, 64, 0, 0, 72, 74, 64, 74, 10, 66, 2, 64, 64, 74, 0, 10, 0, 74, 0, 72, 10, 72, 10, 75, 75, 75, 75, 75, 75, 65, 73, 8, 0, 0, 0, 0, 0, 0, 0, 79, 69, 69, 79, 79, 79, 75, 75, 79, 77, 0, 0, 0, 0, 0, 0, 75, 75, 139, 75, 139, 65, 65, 75, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 65, 75, 75, 75, 75, 75, 75, 73, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75, 139, 139, 75, 75, 75, 75, 0, 0, 0, 0, 0, 0, 0, 0, 66, 66, 66, 66, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 2, 2, 2, 2, 16, 0, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
        opNames = new String[]{"arg", "bkpt", "nop", "throw", "getsuper", "setsuper", "dxns", "dxnslate", "kill", "label", "phi", "xarg", "ifnlt", "ifnle", "ifngt", "ifnge", "jump", "iftrue", "iffalse", "ifeq", "ifne", "iflt", "ifle", "ifgt", "ifge", "ifstricteq", "ifstrictne", "lookupswitch", "pushwith", "popscope", "nextname", "hasnext", "pushnull", "pushundefined", "OP_0x22", "nextvalue", "pushbyte", "pushshort", "pushtrue", "pushfalse", "pushnan", "pop", "dup", "swap", "pushstring", "pushint", "pushuint", "pushdouble", "pushscope", "pushnamespace", "hasnext2", "hasnext2_i", "hasnext2_o", "OP_0x35", "OP_0x36", "OP_0x37", "OP_0x38", "OP_0x39", "OP_0x3A", "OP_0x3B", "OP_0x3C", "OP_0x3D", "OP_0x3E", "OP_0x3F", "newfunction", "call", "construct", "callmethod", "callstatic", "callsuper", "callproperty", "returnvoid", "returnvalue", "constructsuper", "constructprop", "OP_0x4B", "callproplex", "OP_0x4D", "callsupervoid", "callpropvoid", "OP_0x50", "OP_0x51", "OP_0x52", "OP_0x53", "OP_0x54", "newobject", "newarray", "newactivation", "newclass", "getdescendants", "newcatch", "OP_0x5B", "OP_0x5C", "findpropstrict", "findproperty", "finddef", "getlex", "setproperty", "getlocal", "setlocal", "getglobalscope", "getscopeobject", "getproperty", "OP_0x67", "initproperty", "OP_0x69", "deleteproperty", "OP_0x6B", "getslot", "setslot", "getglobalslot", "setglobalslot", "convert_s", "esc_xelem", "esc_xattr", "convert_i", "convert_u", "convert_d", "convert_b", "convert_o", "checkfilter", "OP_0x79", "OP_0x7A", "OP_0x7B", "OP_0x7C", "OP_0x7D", "OP_0x7E", "OP_0x7F", "coerce", "coerce_b", "coerce_a", "coerce_i", "coerce_d", "coerce_s", "astype", "astypelate", "coerce_u", "coerce_o", "OP_0x8A", "OP_0x8B", "OP_0x8C", "OP_0x8D", "OP_0x8E", "OP_0x8F", "negate", "increment", "inclocal", "decrement", "declocal", "typeof", "not", "bitnot", "OP_0x98", "OP_0x99", "OP_0x9A", "OP_0x9B", "OP_0x9C", "OP_0x9D", "OP_0x9E", "OP_0x9F", "add", "subtract", "multiply", "divide", "modulo", "lshift", "rshift", "urshift", "bitand", "bitor", "bitxor", "equals", "strictequals", "lessthan", "lessequals", "greaterthan", "greaterequals", "instanceof", "istype", "istypelate", "in", "OP_0xB5", "OP_0xB6", "OP_0xB7", "OP_0xB8", "OP_0xB9", "OP_0xBA", "OP_0xBB", "OP_0xBC", "OP_0xBD", "OP_0xBE", "OP_0xBF", "increment_i", "decrement_i", "inclocal_i", "declocal_i", "negate_i", "add_i", "subtract_i", "multiply_i", "OP_0xC8", "OP_0xC9", "OP_0xCA", "OP_0xCB", "OP_0xCC", "OP_0xCD", "OP_0xCE", "OP_0xCF", "getlocal0", "getlocal1", "getlocal2", "getlocal3", "setlocal0", "setlocal1", "setlocal2", "setlocal3", "OP_0xD8", "OP_0xD9", "OP_0xDA", "OP_0xDB", "OP_0xDC", "OP_0xDD", "OP_0xDE", "OP_0xDF", "OP_0xE0", "OP_0xE1", "OP_0xE2", "OP_0xE3", "OP_0xE4", "OP_0xE5", "OP_0xE6", "OP_0xE7", "OP_0xE8", "OP_0xE9", "OP_0xEA", "OP_0xEB", "OP_0xEC", "OP_0xED", "OP_0xEE", "debug", "debugline", "debugfile", "bkptline", "timestamp", "OP_0xF4", "OP_0xF5", "OP_0xF6", "OP_0xF7", "OP_0xF8", "OP_0xF9", "OP_0xFA", "OP_0xFB", "OP_0xFC", "OP_0xFD", "OP_0xFE", "OP_0xFF"};
    }

    class AbcWriter
    extends ByteArrayOutputStream {
        AbcWriter() {
        }

        void rewind(int n) {
            this.count -= n;
        }

        void writeU16(int i) {
            this.write(i);
            this.write(i >> 8);
        }

        void writeS24(int i) {
            this.writeU16(i);
            this.write(i >> 16);
        }

        void write64(long i) {
            this.writeS24((int)i);
            this.writeS24((int)(i >> 24));
            this.writeU16((int)(i >> 48));
        }

        void writeU30(int v) {
            if (v < 128 && v >= 0) {
                this.write(v);
            } else if (v < 16384 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7);
            } else if (v < 0x200000 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14);
            } else if (v < 0x10000000 && v >= 0) {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14 | 0x80);
                this.write(v >> 21);
            } else {
                this.write(v & 0x7F | 0x80);
                this.write(v >> 7 | 0x80);
                this.write(v >> 14 | 0x80);
                this.write(v >> 21 | 0x80);
                this.write(v >> 28);
            }
        }
    }

    class Reader {
        int pos;
        byte[] abc;

        Reader(int pos, byte[] abc) {
            this.pos = pos;
            this.abc = abc;
        }

        Reader(Reader r) {
            this(r.pos, r.abc);
        }

        int readU8() {
            return 0xFF & this.abc[this.pos++];
        }

        int readU16() {
            return this.readU8() | this.readU8() << 8;
        }

        int readS24() {
            return this.readU16() | (byte)this.readU8() << 16;
        }

        int readU30() {
            int result = this.readU8();
            if (0 == (result & 0x80)) {
                return result;
            }
            if (0 == ((result = result & 0x7F | this.readU8() << 7) & 0x4000)) {
                return result;
            }
            if (0 == ((result = result & 0x3FFF | this.readU8() << 14) & 0x200000)) {
                return result;
            }
            if (0 == ((result = result & 0x1FFFFF | this.readU8() << 21) & 0x10000000)) {
                return result;
            }
            return result & 0xFFFFFFF | this.readU8() << 28;
        }

        double readDouble() {
            return Double.longBitsToDouble((long)this.readU16() | (long)this.readU16() << 16 | (long)this.readU16() << 32 | (long)this.readU16() << 48);
        }
    }

    static class LabelWriter
    extends PrintWriter {
        StringWriter w;

        LabelWriter(StringWriter w) {
            super(w);
            this.w = w;
        }

        public void println() {
            this.print("\\l");
            this.flush();
        }

        public void print(String s) {
            super.print(s.replace("\"", "''").replace("\u0278", "&phi;"));
        }

        public String toString() {
            return this.w.toString();
        }
    }

    static class FrameState {
        Expr[] frame;
        int sp;
        int scopep;

        public FrameState(Expr[] frame, int sp, int scopep) {
            this.frame = new Expr[frame.length];
            this.sp = sp;
            this.scopep = scopep;
        }
    }

    class Type {
        Name name;
        Type base;
        Type[] interfaces = notypes;
        Symtab<Binding> defs;
        Method init;
        Type itype;
        int flags;
        Namespace protectedNs;
        Typeref[] scopes = notyperefs;
        boolean numeric;
        boolean primitive;
        boolean atom;
        Object defaultValue;
        Typeref ref;
        int size;
        int slotCount;
        boolean obscure_natives;

        Type() {
            this.defaultValue = GlobalOptimizer.this.NULL;
            this.ref = new Typeref(this, true);
            this.obscure_natives = false;
        }

        Type(Name name, Type base) {
            this();
            this.name = name;
            this.base = base;
            this.defs = new Symtab();
            this.obscure_natives = false;
        }

        boolean emitAsAny() {
            return this.base == null && this != GlobalOptimizer.this.VOID && this.defs.size() == 0;
        }

        public String toString() {
            return String.valueOf(this.name);
        }

        boolean isFinal() {
            return (this.flags & 2) != 0;
        }

        void setFinal() {
            this.flags |= 2;
        }

        Binding find(Name n) {
            Type t = this;
            while (t != null) {
                Binding b = t.defs.get(n);
                if (b != null) {
                    return b;
                }
                t = t.base;
            }
            return null;
        }

        Binding findGet(Name n) {
            Binding first = this.find(n);
            if (first != null && GlobalOptimizer.this.isSetter(first)) {
                Binding second;
                if (first.peer != null) {
                    return first.peer;
                }
                if (this.base != null && GlobalOptimizer.this.isGetter(second = this.base.findGet(n))) {
                    return second;
                }
            }
            return first;
        }

        Binding findSlot(int slot) {
            for (Binding b : this.defs.values()) {
                if (!GlobalOptimizer.isSlot(b) || b.slot != slot) continue;
                return b;
            }
            return null;
        }

        boolean hasProtectedNs() {
            return (this.flags & 8) != 0;
        }
    }

    class Typeref {
        final Type t;
        final boolean nullable;

        Typeref(Type t, boolean nullable) {
            assert (t != null);
            this.t = t;
            this.nullable = nullable;
        }

        Typeref nonnull() {
            return this.nullable ? new Typeref(this.t, false) : this;
        }

        public boolean equals(Object o) {
            return o instanceof Typeref && ((Typeref)o).t == this.t && ((Typeref)o).nullable == this.nullable;
        }

        Binding find(Name n) {
            return this.t.find(n);
        }

        Binding findGet(Name n) {
            return this.t.findGet(n);
        }

        public String toString() {
            return !this.t.ref.nullable || this.t == GlobalOptimizer.this.NULL || this.t == GlobalOptimizer.this.VOID || this.t == GlobalOptimizer.this.ANY ? this.t.toString() : (this.nullable ? this.t.toString() + "?" : this.t.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Expr
    implements Comparable<Expr>,
    Indexable {
        int op;
        Expr[] args = noexprs;
        Expr[] scopes = noexprs;
        Expr[] locals = noexprs;
        int[] imm;
        Edge[] pred = noedges;
        Edge[] succ;
        int id;
        int flags;
        Name ref;
        Object value;
        Type c;
        Method m;

        Expr(Method m, int op) {
            this.op = op;
            this.flags = flagTable[op];
            this.id = m.exprId++;
        }

        Expr(Method m, int op, int imm1) {
            this(m, op);
            this.imm = new int[]{imm1};
        }

        Expr(Method m, int op, Object value) {
            this(m, op);
            this.value = value;
        }

        Expr(Method m, int op, Expr arg) {
            this(m, op);
            this.args = new Expr[]{arg};
        }

        Expr(Method m, int op, Expr[] frame, int sp, int argc) {
            this(m, op);
            this.args = GlobalOptimizer.capture(frame, sp, argc);
        }

        Expr(Method m, int op, int imm1, Expr[] frame, int sp, int argc) {
            this(m, op, frame, sp, argc);
            this.imm = new int[]{imm1};
        }

        Expr(Method m, int op, Name ref, Expr[] frame, int sp, int argc) {
            this(m, op, frame, sp, argc);
            this.ref = ref;
        }

        Expr(Method m, int op, Name ref, Expr arg) {
            this(m, op);
            this.ref = ref;
            this.args = new Expr[]{arg};
        }

        @Override
        public int id() {
            return this.id;
        }

        void append(Expr a, Edge p) {
            this.args = GlobalOptimizer.copyOf(this.args, this.args.length + 1);
            this.args[this.args.length - 1] = a;
            this.pred = GlobalOptimizer.copyOf(this.pred, this.pred.length + 1);
            this.pred[this.pred.length - 1] = p;
        }

        void remove(int j) {
            Expr[] a = new Expr[this.args.length - 1];
            System.arraycopy(this.args, 0, a, 0, j);
            System.arraycopy(this.args, j + 1, a, j, this.args.length - j - 1);
            this.args = a;
            Edge[] ed = new Edge[this.pred.length - 1];
            System.arraycopy(this.pred, 0, ed, 0, j);
            System.arraycopy(this.pred, j + 1, ed, j, this.pred.length - j - 1);
            this.pred = ed;
        }

        public String toString() {
            return (this.onStack() ? "t" : (this.onScope() ? "s" : (this.inLocal() ? "l" : "i"))) + this.id;
        }

        void clearEffect() {
            this.flags &= 0xFFFFFFFD;
        }

        void clearPx() {
            this.flags &= 0xFFFFFFF7;
        }

        void setPure() {
            this.clearEffect();
            this.clearPx();
        }

        boolean hasEffect() {
            return (this.flags & 2) != 0;
        }

        boolean isPx() {
            return (this.flags & 8) != 0;
        }

        boolean isSynthetic() {
            return (this.flags & 0x10) != 0;
        }

        boolean onStack() {
            return (flagTable[this.op] & 0x40) != 0;
        }

        boolean isOper() {
            return (flagTable[this.op] & 1) != 0;
        }

        boolean onScope() {
            return (flagTable[this.op] & 0x20) != 0;
        }

        boolean inLocal() {
            return (flagTable[this.op] & 0x80) != 0;
        }

        boolean isCoerce() {
            return (flagTable[this.op] & 4) != 0;
        }

        @Override
        public int compareTo(Expr other) {
            assert (this.id != other.id || this == other);
            return this.id - other.id;
        }
    }

    static interface Indexable {
        public int id();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Block
    implements Iterable<Expr>,
    Comparable<Block>,
    Indexable {
        Deque<Expr> exprs = new ArrayDeque<Expr>();
        int id;
        int postorder;
        Edge[] xsucc = noedges;

        Block(Method m) {
            this.id = m.blockId++;
        }

        @Override
        public int id() {
            return this.id;
        }

        public String toString() {
            return 'B' + String.valueOf(this.id);
        }

        Expr first() {
            return this.exprs.peekFirst();
        }

        Expr last() {
            return this.exprs.peekLast();
        }

        Edge[] succ() {
            return this.last().succ;
        }

        @Override
        public Iterator<Expr> iterator() {
            return this.exprs.iterator();
        }

        void add(Expr e) {
            this.exprs.add(e);
        }

        void addAll(Block b) {
            this.exprs.addAll(b.exprs);
        }

        boolean isEmpty() {
            return this.exprs.isEmpty();
        }

        int size() {
            return this.exprs.size();
        }

        void remove(Expr e) {
            this.exprs.remove(e);
        }

        @Override
        public int compareTo(Block b) {
            return this.id - b.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGraph {
        Map<Integer, Set<Integer>> conflicts = new TreeMap<Integer, Set<Integer>>();

        ConflictGraph() {
        }

        void add(Expr e1, Expr e2) {
            this.get(e1.id).add(e2.id);
            this.get(e2.id).add(e1.id);
        }

        boolean contains(Expr a, Expr b) {
            return this.conflicts.containsKey(a.id) && this.conflicts.get(a.id).contains(b.id);
        }

        public String toString() {
            return String.valueOf(this.conflicts);
        }

        Set<Integer> get(int i) {
            Set<Integer> s = this.conflicts.get(i);
            if (s == null) {
                s = new TreeSet<Integer>();
                this.conflicts.put(i, s);
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LinkedDeque<E>
    extends LinkedList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        LinkedDeque() {
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.getFirst();
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.getLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayDeque<E>
    extends ArrayList<E>
    implements Deque<E> {
        public static final long serialVersionUID = 0L;

        ArrayDeque() {
        }

        ArrayDeque(Collection<E> c) {
            this.addAll(c);
        }

        @Override
        public void addFirst(E e) {
            this.add(0, e);
        }

        @Override
        public E removeFirst() {
            return this.remove(0);
        }

        @Override
        public E peekFirst() {
            return this.isEmpty() ? null : (E)this.get(0);
        }

        @Override
        public E removeLast() {
            return this.remove(this.size() - 1);
        }

        @Override
        public E peekLast() {
            return this.isEmpty() ? null : (E)this.get(this.size() - 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Deque<E>
    extends List<E> {
        @Override
        public E removeFirst();

        public E peekFirst();

        @Override
        public E removeLast();

        public E peekLast();

        @Override
        public void addFirst(E var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WorkSet<E extends Indexable>
    extends TreeSet<E> {
        static final long serialVersionUID = 0L;

        WorkSet() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EdgeMap<E extends Indexable>
    extends SetMap<E, E> {
        static final long serialVersionUID = 0L;

        EdgeMap() {
        }

        @Override
        public Set<E> get(E e) {
            return super.get(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SetMap<K, V extends Indexable>
    extends TreeMap<K, Set<V>> {
        static final long serialVersionUID = 0L;

        SetMap() {
        }

        @Override
        public Set<V> get(K e) {
            TreeSet s = (TreeSet)super.get(e);
            if (s == null) {
                s = new TreeSet();
                this.put(e, s);
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Edge
    implements Comparable<Edge>,
    Indexable {
        Block from;
        Block to;
        int label;
        int id;
        Handler handler;

        Edge(Method m, Block f, int i) {
            this.from = f;
            this.label = i;
            this.id = m.edgeId++;
        }

        Edge(Method m, Block f, int i, Block t) {
            this(m, f, i);
            this.to = t;
        }

        Edge(Method m, Block f, int i, Handler h) {
            this(m, f, i);
            this.handler = h;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int hashCode() {
            return this.label ^ this.to.hashCode() ^ (this.from != null ? this.from.hashCode() : 0);
        }

        public boolean equals(Object o) {
            return o instanceof Edge && ((Edge)o).from == this.from && ((Edge)o).to == this.to && ((Edge)o).label == this.label;
        }

        public String toString() {
            return (GlobalOptimizer.isThrowEdge(this) ? this.handler.toString() + " " : "") + (this.from != null ? this.label + ":" + this.from : "") + "->" + this.to;
        }

        @Override
        public int compareTo(Edge e) {
            int d = this.label - e.label;
            if (d != 0) {
                return d;
            }
            if (this.from != null && e.from == null) {
                return 1;
            }
            if (this.from == null && e.from != null) {
                return -1;
            }
            if (this.from != null && (d = this.from.compareTo(e.from)) != 0) {
                return d;
            }
            return this.to.compareTo(e.to);
        }
    }

    static class IndentingPrintWriter
    extends PrintWriter {
        int indent;

        IndentingPrintWriter(Writer w) {
            super(w);
        }

        public void println() {
            super.println();
            for (int i = 0; i < this.indent; ++i) {
                this.print("    ");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Abc {
        Pool<Integer> intPool = new Pool(1);
        Pool<Long> uintPool = new Pool(1);
        Pool<Double> doublePool = new Pool(1);
        Pool<String> stringPool = new Pool(1);
        Pool<Namespace> nsPool = new Pool(1);
        Pool<Nsset> nssetPool = new Pool(1);
        Pool<Name> namePool = new Pool(1);
        Pool<Method> methodPool1 = new Pool(0);
        Pool<Method> methodPool2 = new Pool(0);
        Pool<Metadata> metaPool = new Pool(0);
        int bodyCount;
        boolean haveNatives;
        List<Type> scripts = new ArrayList<Type>();
        List<Type> classes = new ArrayList<Type>();

        Abc() {
        }

        int typeRef(Typeref tref) {
            return this.typeRef(tref.t);
        }

        int typeRef(Type t) {
            if (t == GlobalOptimizer.this.ANY) {
                return 0;
            }
            if (t.emitAsAny()) {
                System.out.println("Emitting: " + t + " as any");
                return 0;
            }
            return this.namePool.id(t.name);
        }

        Pool<Method> poolFor(Method m) {
            return m.isNative() ? this.methodPool2 : this.methodPool1;
        }

        int methodId(Method m) {
            return this.poolFor(m).id(m);
        }

        void addScript(Type s) {
            this.addMethod(s.init);
            this.addTraits(s.defs);
            this.scripts.add(s);
        }

        void addClass(Type c) {
            Type t = c.itype;
            this.addName(t.name);
            if (t.base != GlobalOptimizer.this.NULL) {
                this.addTypeRef(t.base);
            }
            if (t.hasProtectedNs()) {
                this.addNamespace(t.protectedNs);
            }
            for (Type i : t.interfaces) {
                this.addTypeRef(i);
            }
            this.addMethod(t.init);
            this.addTraits(t.defs);
            this.addMethod(c.init);
            this.addTraits(c.defs);
            this.classes.add(c);
        }

        int classId(Type c) {
            return this.classes.indexOf(c);
        }

        int scriptId(Type c) {
            return this.scripts.indexOf(c);
        }

        void addTraits(Symtab<Binding> defs) {
            for (Binding b : defs.values()) {
                this.addName(b.name);
                switch (b.kind()) {
                    case 4: {
                        this.addClass(b.type.t);
                        break;
                    }
                    case 0: 
                    case 6: {
                        this.addTypeRef(b.type);
                        if (b.value == null) break;
                        this.addConst(b.value);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addMethod(b.method);
                    }
                }
            }
        }

        void addMetadata(Metadata md) {
            if (this.metaPool.add(md) == 1) {
                this.stringPool.add(md.name);
                for (Attr a : md.attrs) {
                    this.stringPool.add(a.name);
                    this.stringPool.add(a.value);
                }
            }
        }

        void addConst(Object value) {
            if (value instanceof Integer) {
                this.intPool.add(GlobalOptimizer.this.intValue(value));
            } else if (value instanceof Long) {
                this.uintPool.add(GlobalOptimizer.this.uintValue(value));
            } else if (value instanceof Double) {
                this.doublePool.add(GlobalOptimizer.this.doubleValue(value));
            } else if (value instanceof String) {
                this.stringPool.add((String)value);
            } else if (value instanceof Namespace) {
                this.addNamespace((Namespace)value);
            }
        }

        int constId(int kind, Object value) {
            switch (kind) {
                case 3: {
                    return this.intPool.id(GlobalOptimizer.this.intValue(value));
                }
                case 4: {
                    return this.uintPool.id(GlobalOptimizer.this.uintValue(value));
                }
                case 1: {
                    return this.stringPool.id((String)value);
                }
                case 6: {
                    return this.doublePool.id(GlobalOptimizer.this.doubleValue(value));
                }
                case 8: {
                    return this.nsPool.id((Namespace)value);
                }
            }
            return 0;
        }

        int constKind(Object value) {
            if (value instanceof Integer) {
                return 3;
            }
            if (value instanceof Long) {
                return 4;
            }
            if (value instanceof Double) {
                return 6;
            }
            if (value instanceof String) {
                return 1;
            }
            if (value instanceof Namespace) {
                return ((Namespace)value).kind;
            }
            if (value == Boolean.TRUE) {
                return 11;
            }
            if (value == Boolean.FALSE) {
                return 10;
            }
            if (value == UNDEFINED) {
                return 0;
            }
            if (value == GlobalOptimizer.this.NULL) {
                return 12;
            }
            return 0;
        }

        void addNamespace(Namespace ns) {
            if (this.nsPool.add(ns) == 1 && !ns.isPrivateOrInternal()) {
                this.stringPool.add(ns.uri);
            }
        }

        void addNsset(Nsset nsset) {
            if (this.nssetPool.add(nsset) == 1) {
                for (Namespace ns : nsset) {
                    this.addNamespace(ns);
                }
            }
        }

        void addName(Name n) {
            if (this.namePool.add(n) == 1) {
                switch (n.kind) {
                    case 9: 
                    case 14: {
                        this.addNsset(n.nsset);
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 7: 
                    case 13: {
                        this.addNamespace(n.nsset(0));
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 15: 
                    case 16: {
                        this.stringPool.add(n.name);
                        break;
                    }
                    case 27: 
                    case 28: {
                        this.addNsset(n.nsset);
                    }
                }
            }
        }

        void addTypeRef(Typeref tref) {
            this.addTypeRef(tref.t);
        }

        void addTypeRef(Type t) {
            if (t != GlobalOptimizer.this.ANY && !t.emitAsAny()) {
                this.addName(t.name);
            }
        }

        void addMethod(Method m) {
            int i;
            if (this.poolFor(m).add(m) > 1) {
                return;
            }
            if (m.entry != null) {
                ++this.bodyCount;
            }
            this.addTypeRef(m.returns.t);
            int n = m.params.length;
            for (i = 1; i < n; ++i) {
                this.addTypeRef(m.params[i]);
            }
            if (m.hasOptional()) {
                for (Object v : m.values) {
                    if (v == null) continue;
                    this.addConst(v);
                }
            }
            if (!GlobalOptimizer.this.STRIP_DEBUG_INFO && m.hasParamNames()) {
                for (i = 1; i < m.paramNames.length; ++i) {
                    this.addName(m.paramNames[i]);
                }
            }
            for (Handler t : m.handlers) {
                this.addName(t.name);
                this.addTypeRef(t.type);
            }
            this.haveNatives |= m.isNative();
            if (m.entry == null) {
                return;
            }
            for (Block b : GlobalOptimizer.this.dfs(m.entry.to)) {
                for (Expr e : b) {
                    switch (e.op) {
                        case 241: {
                            if (GlobalOptimizer.this.STRIP_DEBUG_INFO) break;
                            this.addConst(e.value);
                            break;
                        }
                        case 6: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 49: {
                            this.addConst(e.value);
                            break;
                        }
                        case 69: 
                        case 70: 
                        case 74: 
                        case 76: 
                        case 78: 
                        case 79: 
                        case 89: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 102: 
                        case 104: 
                        case 106: 
                        case 128: 
                        case 134: 
                        case 178: {
                            this.addName(e.ref);
                            break;
                        }
                        case 64: 
                        case 68: {
                            this.addMethod(e.m);
                        }
                    }
                }
            }
            this.addTraits(m.activation.t.defs);
        }

        void sort() {
            System.out.println("NAMES RANK " + this.namePool.refs);
            this.intPool.sort();
            this.uintPool.sort();
            this.doublePool.sort();
            this.stringPool.sort();
            this.nsPool.sort();
            this.nssetPool.sort();
            this.namePool.sort();
            this.metaPool.sort();
            this.methodPool1.sort();
            this.methodPool2.countFrom = this.methodPool1.size();
            this.methodPool2.sort();
            System.out.println("NAMES " + this.namePool.values);
            TreeSet<Type> cs = new TreeSet<Type>(new Comparator<Type>(){

                @Override
                public int compare(Type a, Type b) {
                    if (a == b) {
                        return 0;
                    }
                    if (GlobalOptimizer.this.istype(b.itype, a.itype)) {
                        return -1;
                    }
                    return 1;
                }
            });
            cs.addAll(this.classes);
            this.classes.clear();
            this.classes.addAll(cs);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pool<T extends Comparable> {
        Map<T, Integer> refs = new HashMap<T, Integer>();
        ArrayList<T> values;
        int countFrom;

        Pool(int countFrom) {
            this.countFrom = countFrom;
        }

        int add(T e) {
            int n = !this.refs.containsKey(e) ? 1 : this.refs.get(e) + 1;
            this.refs.put(e, n);
            return n;
        }

        void sort() {
            Object[] arr = new Ranker[this.refs.size()];
            int i = 0;
            for (Comparable e : this.refs.keySet()) {
                arr[i++] = new Ranker<Comparable>(e, this.refs.get(e));
            }
            assert (i == this.refs.size());
            Arrays.sort(arr);
            this.values = new ArrayList();
            i = this.countFrom;
            for (Object r : arr) {
                this.values.add(((Ranker)r).value);
                this.refs.put(((Ranker)r).value, i++);
            }
        }

        int id(T e) {
            assert (this.refs.containsKey(e));
            return this.refs.get(e);
        }

        public String toString() {
            return String.valueOf(this.refs);
        }

        int size() {
            return this.countFrom + this.refs.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Ranker<T>
    implements Comparable {
        T value;
        int rank;

        Ranker(T value, int rank) {
            this.value = value;
            this.rank = rank;
        }

        public int compareTo(Object o) {
            return ((Ranker)o).rank - this.rank;
        }
    }

    static class Attr
    implements Comparable {
        String name;
        String value;

        Attr(String name) {
            this.name = name;
        }

        public int compareTo(Object o) {
            Attr a = (Attr)o;
            if (this == a) {
                return 0;
            }
            int d = this.name.compareTo(a.name);
            if (d != 0) {
                return d;
            }
            d = this.value.compareTo(a.value);
            if (d != 0) {
                return d;
            }
            return 0;
        }
    }

    static class Metadata
    implements Comparable {
        String name;
        Attr[] attrs;

        Metadata() {
        }

        public int compareTo(Object o) {
            Metadata md = (Metadata)o;
            if (this == md) {
                return 0;
            }
            int d = md.name.compareTo(this.name);
            if (d != 0) {
                return d;
            }
            d = this.attrs.length - md.attrs.length;
            if (d != 0) {
                return d;
            }
            int n = this.attrs.length;
            for (int i = 0; i < n; ++i) {
                d = this.attrs[i].compareTo(md.attrs[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Name
    implements Comparable<Name> {
        final int kind;
        private final Nsset nsset;
        final String name;

        Name(int kind) {
            this(kind, GlobalOptimizer.uniqueNs(), GlobalOptimizer.unique());
        }

        Name(Namespace ns, String name) {
            this(7, ns, name);
        }

        Name(int kind, Namespace ns, String name) {
            this(kind, name, new Nsset(new Namespace[]{ns}));
        }

        Name(int kind, String name, Nsset nsset) {
            assert (nsset != null);
            this.kind = kind;
            this.nsset = nsset;
            this.name = name;
        }

        Name(String name) {
            this(7, PUBLIC, name);
        }

        Namespace nsset(int i) {
            return this.nsset.nsset[i];
        }

        public String toString() {
            return this.name;
        }

        public String format() {
            if (this.nsset.length == 1) {
                return this.nsset(0) + "::" + this.name;
            }
            ArrayList<Namespace> list = new ArrayList<Namespace>();
            for (Namespace n : this.nsset) {
                list.add(n);
            }
            return list + "::" + this.name;
        }

        public Name append(String s) {
            return new Name(this.kind, this.name + s, this.nsset);
        }

        public Name prepend(String s) {
            return new Name(this.kind, s + this.name, this.nsset);
        }

        int hc(Object o) {
            return o != null ? o.hashCode() : 0;
        }

        public int hashCode() {
            return this.kind ^ this.hc(this.nsset) ^ this.hc(this.name);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Name)) {
                return false;
            }
            Name o = (Name)other;
            return this.kind == o.kind && this.name.equals(o.name) && this.nsset.equals(o.nsset);
        }

        @Override
        public int compareTo(Name other) {
            int d = this.kind - other.kind;
            if (d != 0) {
                return d;
            }
            d = this.name.compareTo(other.name);
            if (d != 0) {
                return d;
            }
            return this.nsset.compareTo(other.nsset);
        }

        int attr() {
            return this.kind == 14 || this.kind == 13 || this.kind == 16 || this.kind == 18 || this.kind == 28 ? 1 : 0;
        }

        boolean isQname() {
            return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 18;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Nsset
    implements Comparable<Nsset>,
    Iterable<Namespace> {
        final Namespace[] nsset;
        final int length;

        Nsset(Namespace[] nsset) {
            this.nsset = nsset;
            this.length = nsset.length;
        }

        public int hashCode() {
            int h = GlobalOptimizer.deepHashCode(this.nsset);
            return h;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Nsset)) {
                return false;
            }
            Object[] s2 = ((Nsset)other).nsset;
            Object[] s1 = this.nsset;
            return GlobalOptimizer.deepEquals(s1, s2);
        }

        @Override
        public int compareTo(Nsset other) {
            Namespace[] s1 = this.nsset;
            Namespace[] s2 = other.nsset;
            int d = s1.length - s2.length;
            if (d != 0) {
                return d;
            }
            int n = s1.length;
            for (int i = 0; i < n; ++i) {
                d = s1[i].compareTo(s2[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        @Override
        public Iterator<Namespace> iterator() {
            return Arrays.asList(this.nsset).iterator();
        }

        public String toString() {
            return Arrays.toString(this.nsset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Namespace
    implements Comparable<Namespace> {
        final int kind;
        final String uri;
        private final String comparableUri;

        Namespace(String uri) {
            this(8, uri);
        }

        Namespace(int kind, String uri) {
            this.kind = kind;
            this.uri = uri;
            this.comparableUri = this.isPrivate() ? GlobalOptimizer.unique() : uri;
        }

        boolean isPublic() {
            return (this.kind == 8 || this.kind == 22) && "".equals(this.uri);
        }

        boolean isInternal() {
            return this.kind == 23;
        }

        boolean isPrivate() {
            return this.kind == 5;
        }

        boolean isPrivateOrInternal() {
            return this.isPrivate() || this.isInternal();
        }

        boolean isProtected() {
            return this.kind == 24 || this.kind == 26;
        }

        public String toString() {
            return this.uri.length() > 0 ? this.uri : "public";
        }

        public int hashCode() {
            return this.kind ^ this.uri.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Namespace)) {
                return false;
            }
            Namespace other = (Namespace)o;
            return this.kind == other.kind && this.comparableUri.equals(this.comparableUri);
        }

        @Override
        public int compareTo(Namespace other) {
            if (other == null) {
                return 1;
            }
            int i = this.kind - other.kind;
            if (i != 0) {
                return i;
            }
            return this.comparableUri.compareTo(other.comparableUri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Symtab<E> {
        private List<Name> names = new ArrayList<Name>();
        private List<E> values = new ArrayList();

        Symtab() {
        }

        E get(Name name) {
            block4: {
                if (name.nsset == null || name.name == null) break block4;
                if (((Name)name).nsset.length == 1) {
                    int n = this.names.size();
                    for (int i = 0; i < n; ++i) {
                        if (0 != GlobalOptimizer.match(name, this.names.get(i))) continue;
                        return this.values.get(i);
                    }
                } else {
                    for (Namespace ns : name.nsset) {
                        E e = this.get(new Name(name.kind, ns, name.name));
                        if (e == null) continue;
                        return e;
                    }
                }
            }
            return null;
        }

        Name getName(Name n) {
            if (((Name)n).nsset.length > 1) {
                for (Namespace ns : n.nsset) {
                    Name k = new Name(n.kind, ns, n.name);
                    if (!this.names.contains(k)) continue;
                    return k;
                }
            }
            return n;
        }

        boolean contains(Name n) {
            return n != null && this.get(n) != null;
        }

        void put(Name n, E e) {
            assert (((Name)n).nsset.length == 1);
            this.names.add(n);
            this.values.add(e);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('[');
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                b.append(this.names.get(i)).append('=').append(this.values.get(i));
                if (i + 1 >= n) continue;
                b.append(", ");
            }
            b.append(']');
            return b.toString();
        }

        public Collection<E> values() {
            return this.values;
        }

        int size() {
            return this.names.size();
        }
    }

    static class Binding {
        final InputAbc abc;
        final Name name;
        private final int flags_kind;
        int slot;
        int id;
        int offset;
        Object value;
        Typeref type;
        Method method;
        Metadata[] md = nometadata;
        Binding peer = null;

        Binding(int kind, Name name, InputAbc abc) {
            this.name = name;
            this.flags_kind = kind;
            this.abc = abc;
        }

        int kind() {
            return this.flags_kind & 0xF;
        }

        boolean isFinal() {
            return (this.flags_kind >> 4 & 1) != 0;
        }

        boolean isOverride() {
            return (this.flags_kind >> 4 & 2) != 0;
        }

        boolean hasMetadata() {
            return (this.flags_kind >> 4 & 4) != 0;
        }

        public String toString() {
            switch (this.kind()) {
                case 4: {
                    return "[" + this.slot + "] class";
                }
                case 0: {
                    return "[" + this.slot + "] var";
                }
                case 6: {
                    return "[" + this.slot + "] const";
                }
                case 1: {
                    return "[" + this.slot + "] method";
                }
                case 2: {
                    return "[" + this.slot + "] get";
                }
                case 3: {
                    return "[" + this.slot + "] set";
                }
            }
            assert (false);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Method
    implements Comparable<Method> {
        InputAbc abc;
        final int id;
        int emit_id;
        Edge entry;
        Typeref[] params;
        Object[] values;
        Typeref returns;
        Name name;
        Name debugName;
        Name[] paramNames;
        int flags;
        Type cx;
        int blockId;
        int exprId;
        int edgeId;
        String kind;
        int max_stack;
        int local_count;
        int max_scope;
        int code_len;
        Typeref activation;
        Handler[] handlers = nohandlers;

        Method(int id, InputAbc abc) {
            this.id = id;
            this.abc = abc;
        }

        boolean needsRest() {
            return (this.flags & 4) != 0;
        }

        boolean needsArguments() {
            return (this.flags & 1) != 0;
        }

        boolean hasParamNames() {
            return (this.flags & 0x80) != 0;
        }

        boolean hasOptional() {
            return (this.flags & 8) != 0;
        }

        boolean isNative() {
            return (this.flags & 0x20) != 0;
        }

        @Override
        public int compareTo(Method m) {
            return this.id - m.id;
        }

        public String toString() {
            return this.kind + " " + String.valueOf(this.name);
        }
    }

    static class Handler {
        Typeref type;
        Block entry;
        Typeref activation;
        Name name;

        Handler() {
        }

        public String toString() {
            return "catch " + this.type;
        }
    }

    class InputAbc {
        String[] strings;
        int[] ints;
        long[] uints;
        double[] doubles;
        Namespace[] namespaces;
        Nsset[] nssets;
        Name[] names;
        Method[] methods;
        Metadata[] metadata;
        Type[] classes;
        Type[] scripts;
        boolean containsObject;
        Set<Type> toResolve;
        List<InputAbc> mergedAbcs = new ArrayList<InputAbc>();

        InputAbc() {
            this.mergedAbcs.add(this);
        }

        Type lookup(String name, Type base) {
            Name n2;
            Name n = new Name(name);
            Type t = GlobalOptimizer.this.namedTypes.get(n);
            if (t == null && (t = GlobalOptimizer.this.namedTypes.get(n2 = new Name(7, new Namespace(22, ""), name))) == null) {
                t = new Type(n2, base);
                GlobalOptimizer.this.namedTypes.put(n2, t);
            }
            return t;
        }

        Type lookup(String name) {
            return this.lookup(name, GlobalOptimizer.this.OBJECT);
        }

        void lookupBuiltins() {
            assert (this.containsObject);
            GlobalOptimizer.this.CLASS = this.lookup("Class");
            GlobalOptimizer.this.FUNCTION = this.lookup("Function");
            GlobalOptimizer.this.ARRAY = this.lookup("Array");
            GlobalOptimizer.this.INT = this.lookup("int");
            GlobalOptimizer.this.UINT = this.lookup("uint");
            GlobalOptimizer.this.NUMBER = this.lookup("Number");
            GlobalOptimizer.this.BOOLEAN = this.lookup("Boolean");
            GlobalOptimizer.this.STRING = this.lookup("String");
            GlobalOptimizer.this.NAMESPACE = this.lookup("Namespace");
            GlobalOptimizer.this.XML = this.lookup("XML");
            GlobalOptimizer.this.XMLLIST = this.lookup("XMLList");
            GlobalOptimizer.this.QNAME = this.lookup("QName");
            GlobalOptimizer.this.VOID = this.lookup("void", null);
            GlobalOptimizer.this.BOOLEAN.numeric = true;
            GlobalOptimizer.this.UINT.numeric = true;
            GlobalOptimizer.this.NUMBER.numeric = true;
            GlobalOptimizer.this.INT.numeric = true;
            GlobalOptimizer.this.BOOLEAN.primitive = true;
            GlobalOptimizer.this.STRING.primitive = true;
            GlobalOptimizer.this.UINT.primitive = true;
            GlobalOptimizer.this.NUMBER.primitive = true;
            GlobalOptimizer.this.INT.primitive = true;
            GlobalOptimizer.this.NULL.primitive = true;
            GlobalOptimizer.this.VOID.primitive = true;
            GlobalOptimizer.this.VOID.atom = true;
            GlobalOptimizer.this.OBJECT.atom = true;
            GlobalOptimizer.this.ANY.atom = true;
            GlobalOptimizer.this.INT.ref = GlobalOptimizer.this.INT.ref.nonnull();
            GlobalOptimizer.this.NUMBER.ref = GlobalOptimizer.this.NUMBER.ref.nonnull();
            GlobalOptimizer.this.UINT.ref = GlobalOptimizer.this.UINT.ref.nonnull();
            GlobalOptimizer.this.BOOLEAN.ref = GlobalOptimizer.this.BOOLEAN.ref.nonnull();
            GlobalOptimizer.this.OBJECT.defaultValue = GlobalOptimizer.this.NULL;
            GlobalOptimizer.this.NULL.defaultValue = GlobalOptimizer.this.NULL;
            GlobalOptimizer.this.ANY.defaultValue = UNDEFINED;
            GlobalOptimizer.this.VOID.defaultValue = UNDEFINED;
            GlobalOptimizer.this.BOOLEAN.defaultValue = Boolean.FALSE;
            GlobalOptimizer.this.NUMBER.defaultValue = Double.NaN;
            GlobalOptimizer.this.INT.defaultValue = 0;
            GlobalOptimizer.this.UINT.defaultValue = 0;
        }

        Type lookup(int id) {
            if (id == 0) {
                return GlobalOptimizer.this.ANY;
            }
            if (!GlobalOptimizer.this.namedTypes.contains(this.names[id])) {
                Name n = new Name(7, this.names[id].nsset(0), this.names[id].name);
                GlobalOptimizer.this.namedTypes.put(n, new Type(n, null));
            }
            return GlobalOptimizer.this.namedTypes.get(this.names[id]);
        }

        void readAbc(byte[] abc) throws IOException {
            int i;
            int i2;
            int i3;
            Reader p = new Reader(0, abc);
            if (p.readU16() != 16 || p.readU16() != 46) {
                throw new RuntimeException("not an abc file");
            }
            this.ints = new int[p.readU30() + 1];
            int n = this.ints.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.ints[i3] = p.readU30();
            }
            this.uints = new long[p.readU30() + 1];
            n = this.uints.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.uints[i3] = 0xFFFFFFFFL & (long)p.readU30();
            }
            this.doubles = new double[p.readU30() + 1];
            n = this.doubles.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.doubles[i3] = p.readDouble();
            }
            this.strings = new String[p.readU30() + 1];
            this.strings[0] = "";
            n = this.strings.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                int len = p.readU30();
                this.strings[i3] = new String(abc, p.pos, len, "UTF-8");
                p.pos += len;
            }
            this.namespaces = new Namespace[p.readU30() + 1];
            this.namespaces[0] = PUBLIC;
            n = this.namespaces.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.namespaces[i3] = new Namespace(p.readU8(), this.strings[p.readU30()]);
            }
            this.nssets = new Nsset[p.readU30() + 1];
            n = this.nssets.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.nssets[i3] = new Nsset(new Namespace[p.readU30()]);
                int m = this.nssets[i3].length;
                for (int j = 0; j < m; ++j) {
                    this.nssets[i3].nsset[j] = this.namespaces[p.readU30()];
                }
            }
            this.names = new Name[p.readU30() + 1];
            n = this.names.length - 1;
            for (i3 = 1; i3 < n; ++i3) {
                this.names[i3] = this.readName(p);
            }
            this.methods = new Method[p.readU30()];
            int[] methodpos = new int[this.methods.length];
            int n2 = this.methods.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.methods[i2] = this.readMethod(p, methodpos, i2);
            }
            this.metadata = new Metadata[p.readU30()];
            n2 = this.metadata.length;
            for (i2 = 0; i2 < n2; ++i2) {
                this.metadata[i2] = this.readMetadata(p);
            }
            this.toResolve = new HashSet<Type>();
            Type[] instances = new Type[p.readU30()];
            int n3 = instances.length;
            for (i = 0; i < n3; ++i) {
                instances[i] = this.readInstance(p);
            }
            if (this.containsObject) {
                this.lookupBuiltins();
            }
            n3 = this.methods.length;
            for (i = 0; i < n3; ++i) {
                this.resolveSignatureType(new Reader(methodpos[i], p.abc), i, this.methods[i]);
            }
            this.classes = new Type[instances.length];
            n3 = this.classes.length;
            for (i = 0; i < n3; ++i) {
                this.classes[i] = this.readClass(p, instances[i]);
            }
            this.scripts = new Type[p.readU30()];
            n3 = this.scripts.length;
            for (i = 0; i < n3; ++i) {
                this.scripts[i] = this.readScript(p, i);
            }
            n3 = p.readU30();
            for (i = 0; i < n3; ++i) {
                this.readBody(p);
            }
            for (Type t : this.toResolve) {
                this.resolveType(t);
            }
            this.toResolve = null;
        }

        void obscure_natives() {
            for (Type t : this.classes) {
                t.obscure_natives = true;
                if (t.itype == null) continue;
                t.itype.obscure_natives = true;
            }
            for (Type t : this.scripts) {
                t.obscure_natives = true;
                if (t.itype == null) continue;
                t.itype.obscure_natives = true;
            }
        }

        void combine(InputAbc abc) {
            int[] newInts = new int[this.ints.length + abc.ints.length];
            System.arraycopy(this.ints, 0, newInts, 0, this.ints.length);
            System.arraycopy(abc.ints, 0, newInts, this.ints.length, abc.ints.length);
            this.ints = newInts;
            long[] newUints = new long[this.uints.length + abc.uints.length];
            System.arraycopy(this.uints, 0, newUints, 0, this.uints.length);
            System.arraycopy(abc.uints, 0, newUints, this.uints.length, abc.uints.length);
            this.uints = newUints;
            double[] newDoubles = new double[this.doubles.length + abc.doubles.length];
            System.arraycopy(this.doubles, 0, newDoubles, 0, this.doubles.length);
            System.arraycopy(abc.doubles, 0, newDoubles, this.doubles.length, abc.doubles.length);
            this.doubles = newDoubles;
            String[] newStrings = new String[this.strings.length + abc.strings.length];
            System.arraycopy(this.strings, 0, newStrings, 0, this.strings.length);
            System.arraycopy(abc.strings, 0, newStrings, this.strings.length, abc.strings.length);
            this.strings = newStrings;
            Namespace[] newNamespaces = new Namespace[this.namespaces.length + abc.namespaces.length];
            System.arraycopy(this.namespaces, 0, newNamespaces, 0, this.namespaces.length);
            System.arraycopy(abc.namespaces, 0, newNamespaces, this.namespaces.length, abc.namespaces.length);
            this.namespaces = newNamespaces;
            Nsset[] newNssets = new Nsset[this.nssets.length + abc.nssets.length];
            System.arraycopy(this.nssets, 0, newNssets, 0, this.nssets.length);
            System.arraycopy(abc.nssets, 0, newNssets, this.nssets.length, abc.nssets.length);
            this.nssets = newNssets;
            Name[] newNames = new Name[this.names.length + abc.names.length];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            System.arraycopy(abc.names, 0, newNames, this.names.length, abc.names.length);
            this.names = newNames;
            Method[] newMethods = new Method[this.methods.length + abc.methods.length];
            System.arraycopy(this.methods, 0, newMethods, 0, this.methods.length);
            System.arraycopy(abc.methods, 0, newMethods, this.methods.length, abc.methods.length);
            this.methods = newMethods;
            for (Method m : abc.methods) {
                m.abc = this;
            }
            Metadata[] newMetadata = new Metadata[this.metadata.length + abc.metadata.length];
            System.arraycopy(this.metadata, 0, newMetadata, 0, this.metadata.length);
            System.arraycopy(abc.metadata, 0, newMetadata, this.metadata.length, abc.metadata.length);
            this.metadata = newMetadata;
            Type[] newClasses = new Type[this.classes.length + abc.classes.length];
            System.arraycopy(this.classes, 0, newClasses, 0, this.classes.length);
            System.arraycopy(abc.classes, 0, newClasses, this.classes.length, abc.classes.length);
            this.classes = newClasses;
            Type[] newScripts = new Type[this.scripts.length + abc.scripts.length];
            System.arraycopy(this.scripts, 0, newScripts, 0, this.scripts.length);
            System.arraycopy(abc.scripts, 0, newScripts, this.scripts.length, abc.scripts.length);
            this.scripts = newScripts;
            this.mergedAbcs.add(abc);
        }

        void resolveType(Type t) {
            if (t.size != 0) {
                return;
            }
            int size = 0;
            if (t.base != null) {
                this.resolveType(t.base);
                size = t.base.size;
            }
            int hole = -1;
            for (Binding b : t.defs.values()) {
                if (!GlobalOptimizer.isSlot(b)) continue;
                if (!GlobalOptimizer.isClass(b)) {
                    this.resolveSlotType(b);
                }
                if (b.type.t == GlobalOptimizer.this.NUMBER) {
                    if (size % 8 != 0) {
                        hole = size;
                        size += 4;
                    }
                    b.offset = size;
                    size += 8;
                    continue;
                }
                if (hole != -1) {
                    b.offset = hole;
                    hole = -1;
                    continue;
                }
                b.offset = size;
                size += 4;
            }
            if (size > 0) {
                System.out.println("sizeof " + t + " " + size);
            }
            t.size = size;
        }

        Metadata readMetadata(Reader p) {
            int j;
            Metadata md = new Metadata();
            md.name = this.strings[p.readU30()];
            md.attrs = new Attr[p.readU30()];
            Attr[] attrs = md.attrs;
            int n = attrs.length;
            for (j = 0; j < n; ++j) {
                attrs[j] = new Attr(this.strings[p.readU30()]);
            }
            n = attrs.length;
            for (j = 0; j < n; ++j) {
                attrs[j].value = this.strings[p.readU30()];
            }
            return md;
        }

        void resolveSignatureType(Reader p, int i, Method m) {
            m.returns = this.lookup((int)p.readU30()).ref;
            for (int j = 1; j < m.params.length; ++j) {
                m.params[j] = this.lookup((int)p.readU30()).ref;
            }
            p.readU30();
            p.readU8();
            if (m.hasOptional()) {
                int optional_count = p.readU30();
                m.values = new Object[m.params.length];
                int param_count = m.params.length - 1;
                for (int j = param_count - optional_count + 1; j <= param_count; ++j) {
                    m.values[j] = this.readArgDefault(p);
                    assert (m.values[j] != null);
                }
            }
        }

        void readBody(Reader p) {
            Method m = this.methods[p.readU30()];
            m.max_stack = p.readU30();
            m.local_count = p.readU30();
            m.max_scope = -(p.readU30() - p.readU30());
            m.code_len = p.readU30();
            Reader pcode = new Reader(p);
            p.pos += m.code_len;
            this.readCode(m, pcode, p);
            Type act = new Type();
            m.activation = act.ref.nonnull();
            act.base = GlobalOptimizer.this.ANY;
            if (m.name != null) {
                act.name = m.name.append(" activation");
            }
            this.readTraits(p, act);
        }

        Method readMethod(Reader p, int[] methodpos, int i) {
            int j;
            Method m = new Method(i, this);
            int param_count = p.readU30();
            m.params = new Typeref[param_count + 1];
            m.params[0] = GlobalOptimizer.this.ANY.ref;
            methodpos[i] = p.pos;
            p.readU30();
            for (j = 1; j <= param_count; ++j) {
                p.readU30();
            }
            m.name = m.debugName = new Name(this.strings[p.readU30()]);
            m.flags = p.readU8();
            if (m.hasOptional()) {
                int optional_count = p.readU30();
                assert (optional_count > 0);
                while (optional_count-- > 0) {
                    this.readArgDefault(p);
                }
                m.values = new Object[m.params.length];
                for (int j2 = param_count - optional_count + 1; j2 <= param_count; ++j2) {
                    m.values[j2] = this.readArgDefault(p);
                }
            }
            if (m.hasParamNames()) {
                m.paramNames = new Name[param_count + 1];
                for (j = 1; j <= param_count; ++j) {
                    m.paramNames[j] = new Name(this.strings[p.readU30()]);
                }
            }
            return m;
        }

        Name readName(Reader p) {
            int kind = p.readU8();
            switch (kind) {
                default: {
                    assert (false);
                }
                case 7: 
                case 13: {
                    return new Name(kind, this.namespaces[p.readU30()], this.strings[p.readU30()]);
                }
                case 9: 
                case 14: {
                    return new Name(kind, this.strings[p.readU30()], this.nssets[p.readU30()]);
                }
                case 15: 
                case 16: {
                    return new Name(kind, GlobalOptimizer.uniqueNs(), this.strings[p.readU30()]);
                }
                case 27: 
                case 28: {
                    return new Name(kind, GlobalOptimizer.unique(), this.nssets[p.readU30()]);
                }
                case 17: 
                case 18: 
            }
            return new Name(kind);
        }

        void readTraits(Reader p, Type t) {
            this.toResolve.add(t);
            t.defs = new Symtab();
            int slot_id = 0;
            if (t.base != null) {
                slot_id = t.base.slotCount;
            }
            int count = p.readU30();
            for (int i = 0; i < count; ++i) {
                Name name = this.names[p.readU30()];
                Binding b = new Binding(p.readU8(), name, this);
                Binding old = t.defs.get(name);
                while (old != null && old.peer != null) {
                    old = old.peer;
                }
                if (old != null) {
                    old.peer = b;
                }
                t.defs.put(name, b);
                int slot = p.readU30();
                b.id = p.readU30();
                switch (b.kind()) {
                    case 0: 
                    case 4: 
                    case 6: {
                        if (GlobalOptimizer.isClass(b)) {
                            b.type = this.classes[b.id].ref.nonnull();
                            b.value = GlobalOptimizer.this.NULL;
                        } else {
                            b.value = this.readSlotDefault(p);
                            b.type = GlobalOptimizer.this.ANY.ref;
                            if (b.value instanceof Namespace) {
                                GlobalOptimizer.this.namespaceNames.put((Namespace)b.value, name);
                            }
                        }
                        if (slot == 0) {
                            slot = ++slot_id;
                        } else if (slot > slot_id) {
                            slot_id = slot;
                        }
                        b.slot = slot;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        b.slot = 0;
                        Method m = b.method = this.methods[b.id];
                        m.cx = t;
                        m.params[0] = t.ref.nonnull();
                        m.kind = GlobalOptimizer.this.isMethod(b) ? "function" : (GlobalOptimizer.this.isGetter(b) ? "get" : "set");
                        m.name = name;
                        break;
                    }
                    default: {
                        System.err.println("illegal trait kind " + b.kind() + " at offset " + p.pos);
                        assert (false);
                        break;
                    }
                }
                if (!b.hasMetadata()) continue;
                b.md = new Metadata[p.readU30()];
                int m = b.md.length;
                for (int j = 0; j < m; ++j) {
                    b.md[j] = this.metadata[p.readU30()];
                }
            }
            t.slotCount = slot_id;
        }

        Object readSlotDefault(Reader p) {
            int i = p.readU30();
            if (i != 0) {
                int kind = p.readU8();
                return this.defaultValue(kind, i);
            }
            return null;
        }

        Object readArgDefault(Reader p) {
            int i = p.readU30();
            int kind = p.readU8();
            Object v = this.defaultValue(kind, i);
            return v;
        }

        Object defaultValue(int kind, int i) {
            switch (kind) {
                case 10: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return Boolean.TRUE;
                }
                case 12: {
                    return GlobalOptimizer.this.NULL;
                }
                case 0: {
                    return UNDEFINED;
                }
                case 1: {
                    return this.strings[i];
                }
                case 3: {
                    return this.ints[i];
                }
                case 4: {
                    return this.uints[i];
                }
                case 6: {
                    return this.doubles[i];
                }
                case 5: 
                case 8: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    return this.namespaces[i];
                }
            }
            assert (false);
            return null;
        }

        void resolveSlotType(Binding b) {
            b.type = this.lookup((int)b.id).ref;
            if (b.value == null) {
                b.value = b.type.t.defaultValue;
            }
        }

        Type readScript(Reader p, int i) {
            Typeref sref;
            Type s = new Type();
            assert (GlobalOptimizer.this.OBJECT != null);
            s.base = GlobalOptimizer.this.OBJECT;
            s.name = new Name("global" + i);
            Method init = s.init = this.methods[p.readU30()];
            init.cx = s;
            init.params[0] = sref = s.ref.nonnull();
            init.name = s.name;
            init.kind = "init";
            this.readTraits(p, s);
            for (Binding b : s.defs.values()) {
                GlobalOptimizer.this.globals.put(b.name, sref);
            }
            s.setFinal();
            return s;
        }

        Type readClass(Reader p, Type it) {
            Type c = new Type();
            assert (GlobalOptimizer.this.CLASS != null);
            c.base = GlobalOptimizer.this.CLASS;
            c.itype = it;
            c.name = it.name.append("$");
            Method init = c.init = this.methods[p.readU30()];
            init.cx = c;
            init.params[0] = c.ref.nonnull();
            init.name = c.name;
            init.kind = "init";
            this.readTraits(p, c);
            c.setFinal();
            return c;
        }

        Type readInstance(Reader p) {
            Type t = new Type();
            t.name = this.names[p.readU30()];
            t.base = this.lookup(p.readU30());
            t.flags = p.readU8();
            if (t.hasProtectedNs()) {
                t.protectedNs = this.namespaces[p.readU30()];
            }
            t.interfaces = new Type[p.readU30()];
            int n = t.interfaces.length;
            for (int j = 0; j < n; ++j) {
                t.interfaces[j] = this.lookup(p.readU30());
            }
            t.init = this.methods[p.readU30()];
            if (t.init.isNative()) {
                throw new RuntimeException("Constructors can't be native: " + t);
            }
            t.init.cx = t;
            t.init.params[0] = t.ref.nonnull();
            t.init.kind = "init";
            t.init.name = t.name;
            this.readTraits(p, t);
            GlobalOptimizer.this.namedTypes.put(t.name, t);
            if (t.name.equals(new Name(PKG_PUBLIC, "Object"))) {
                this.containsObject = true;
                GlobalOptimizer.this.OBJECT = t;
                GlobalOptimizer.this.NULL = this.lookup("null", GlobalOptimizer.this.OBJECT);
            }
            return t;
        }

        void readCode(Method m, Reader p, Reader ptry) {
            Expr e;
            int i;
            int local_count = m.local_count;
            int end_pos = p.pos + m.code_len;
            Expr[] frame = new Expr[local_count + m.max_scope + m.max_stack];
            TreeMap<Integer, Block> blocks = new TreeMap<Integer, Block>();
            TreeMap<Block, FrameState> states = new TreeMap<Block, FrameState>();
            int scopep = local_count;
            int sp = local_count + m.max_scope;
            m.entry = new Edge(m, null, 0);
            Block b = GlobalOptimizer.this.createBlock(m, m.entry, states, frame, sp, scopep);
            for (i = 0; i < m.params.length; ++i) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = i == 0 ? new Name("this") : (m.paramNames != null ? m.paramNames[i] : new Name("arg" + i));
            }
            if (m.needsArguments() || m.needsRest()) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = new Name(m.needsArguments() ? "arguments" : "rest");
                ++i;
            }
            while (i < local_count) {
                e = frame[i] = new Expr(m, 0, i);
                b.add(frame[i]);
                e.ref = new Name("local" + i);
                ++i;
            }
            BitSet trylabels = new BitSet();
            BitSet catchlabels = new BitSet();
            int code_start = p.pos;
            int try_start = ptry.pos;
            m.handlers = new Handler[ptry.readU30()];
            Handler[] handlers = m.handlers;
            int n = handlers.length;
            for (int j = 0; j < n; ++j) {
                Handler h = handlers[j] = new Handler();
                int from = ptry.readU30();
                int to = ptry.readU30();
                int target = ptry.readU30();
                h.type = this.lookup((int)ptry.readU30()).ref.nonnull();
                Name name = h.name = this.names[ptry.readU30()];
                Type a = new Type(name, GlobalOptimizer.this.ANY);
                h.activation = a.ref.nonnull();
                Binding bind = new Binding(0, name, this);
                bind.type = h.type;
                a.defs.put(name, bind);
                trylabels.set(from);
                trylabels.set(to);
                catchlabels.set(target);
            }
            boolean reachable = true;
            block74: while (p.pos < end_pos) {
                int pos = p.pos;
                int op = p.readU8();
                if (op == 9 || blocks.containsKey(p.pos - 1) || trylabels.get(pos - code_start) || catchlabels.get(pos - code_start)) {
                    Edge edge = null;
                    if (reachable) {
                        assert (!catchlabels.get(pos - code_start));
                        Edge[] succ = b.succ();
                        if (succ == null) {
                            e = new Expr(m, 16);
                            b.add(e);
                            edge = new Edge(m, b, 0, (Block)blocks.get(pos));
                            e.succ = new Edge[]{edge};
                        } else {
                            edge = succ[0];
                        }
                    } else if (catchlabels.get(pos - code_start)) {
                        scopep = local_count;
                        sp = local_count + m.max_scope + 1;
                    }
                    GlobalOptimizer.this.merge(m, edge, blocks, states, pos, frame, sp, scopep);
                    b = (Block)blocks.get(pos);
                    FrameState state = (FrameState)states.get(b);
                    System.arraycopy(state.frame, 0, frame, 0, frame.length);
                    sp = state.sp;
                    scopep = state.scopep;
                    reachable = true;
                }
                if (handlers.length > 0 && b.xsucc == noedges) {
                    ArrayList<Edge> xsucc = new ArrayList<Edge>();
                    ptry.pos = try_start;
                    int n2 = ptry.readU30();
                    for (int j = 0; j < n2; ++j) {
                        int from = code_start + ptry.readU30();
                        int to = code_start + ptry.readU30();
                        int target = code_start + ptry.readU30();
                        if (pos >= from && pos < to) {
                            Edge edge = new Edge(m, b, j, handlers[j]);
                            GlobalOptimizer.this.xmerge(m, edge, blocks, states, target, frame, sp, scopep);
                            xsucc.add(edge);
                        }
                        ptry.readU30();
                        ptry.readU30();
                    }
                    b.xsucc = xsucc.toArray(new Edge[xsucc.size()]);
                }
                switch (op) {
                    case 9: {
                        continue block74;
                    }
                    case 3: 
                    case 72: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        e.succ = noedges;
                        reachable = false;
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        continue block74;
                    }
                    case 7: {
                        b.add(new Expr(m, op, frame, sp--, 1));
                        continue block74;
                    }
                    case 28: 
                    case 48: {
                        frame[scopep++] = e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        continue block74;
                    }
                    case 29: {
                        e = new Expr(m, op);
                        b.add(e);
                        e.scopes = new Expr[]{frame[--scopep]};
                        frame[scopep] = null;
                        continue block74;
                    }
                    case 30: 
                    case 31: 
                    case 35: {
                        e = new Expr(m, op, frame, sp, 2);
                        b.add(e);
                        sp -= 2;
                        frame[sp++] = e;
                        continue block74;
                    }
                    case 32: {
                        int n3 = sp++;
                        Expr expr = new Expr(m, op, GlobalOptimizer.this.NULL);
                        frame[n3] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 33: {
                        int n4 = sp++;
                        Expr expr = new Expr(m, op, UNDEFINED);
                        frame[n4] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 38: {
                        int n5 = sp++;
                        Expr expr = new Expr(m, op, Boolean.TRUE);
                        frame[n5] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 39: {
                        int n6 = sp++;
                        Expr expr = new Expr(m, op, Boolean.FALSE);
                        frame[n6] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 40: {
                        int n7 = sp++;
                        Expr expr = new Expr(m, op, Double.NaN);
                        frame[n7] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 87: {
                        int n8 = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n8] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 100: {
                        int n9 = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n9] = expr;
                        e = expr;
                        b.add(expr);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        continue block74;
                    }
                    case 101: {
                        int n10 = sp++;
                        Expr expr = new Expr(m, op);
                        frame[n10] = expr;
                        e = expr;
                        b.add(expr);
                        e.scopes = GlobalOptimizer.capture(frame, local_count + p.readU8() + 1, 1);
                        continue block74;
                    }
                    case 41: {
                        --sp;
                        continue block74;
                    }
                    case 42: {
                        frame[sp] = frame[sp - 1];
                        ++sp;
                        continue block74;
                    }
                    case 43: {
                        e = frame[sp - 1];
                        frame[sp - 1] = frame[sp - 2];
                        frame[sp - 2] = e;
                        continue block74;
                    }
                    case 71: {
                        e = new Expr(m, op);
                        b.add(e);
                        e.succ = noedges;
                        reachable = false;
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        continue block74;
                    }
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 130: 
                    case 133: 
                    case 137: 
                    case 144: 
                    case 145: 
                    case 147: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 192: 
                    case 193: 
                    case 196: {
                        Expr expr = new Expr(m, op, frame, sp, 1);
                        frame[sp - 1] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 120: {
                        b.add(new Expr(m, op, frame, sp, 1));
                        continue block74;
                    }
                    case 135: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 197: 
                    case 198: 
                    case 199: {
                        Expr expr = new Expr(m, op, frame, sp, 2);
                        frame[sp - 2] = expr;
                        b.add(expr);
                        --sp;
                        continue block74;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        frame[sp++] = frame[op - 208];
                        continue block74;
                    }
                    case 212: 
                    case 213: 
                    case 214: 
                    case 215: {
                        frame[op - 212] = frame[--sp];
                        continue block74;
                    }
                    case 8: {
                        Expr expr = new Expr(m, 33, UNDEFINED);
                        frame[p.readU30()] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 37: {
                        int n11 = sp++;
                        Expr expr = new Expr(m, op, new Integer((short)p.readU30()));
                        frame[n11] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 44: {
                        int n12 = sp++;
                        Expr expr = new Expr(m, op, this.strings[p.readU30()]);
                        frame[n12] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 45: {
                        int n13 = sp++;
                        Expr expr = new Expr(m, op, new Integer(this.ints[p.readU30()]));
                        frame[n13] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 46: {
                        int n14 = sp++;
                        Expr expr = new Expr(m, op, new Long(this.uints[p.readU30()]));
                        frame[n14] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 47: {
                        int n15 = sp++;
                        Expr expr = new Expr(m, op, new Double(this.doubles[p.readU30()]));
                        frame[n15] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 49: {
                        int n16 = sp++;
                        Expr expr = new Expr(m, op, this.namespaces[p.readU30()]);
                        frame[n16] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 98: {
                        frame[sp++] = frame[p.readU30()];
                        continue block74;
                    }
                    case 99: {
                        frame[p.readU30()] = frame[--sp];
                        continue block74;
                    }
                    case 128: 
                    case 134: 
                    case 178: {
                        Expr expr = new Expr(m, op, this.names[p.readU30()], frame, sp, 1);
                        frame[sp - 1] = expr;
                        e = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 6: {
                        b.add(new Expr(m, op, this.strings[p.readU30()]));
                        continue block74;
                    }
                    case 146: 
                    case 148: 
                    case 194: 
                    case 195: {
                        int i2 = p.readU30();
                        op = op == 194 ? 192 : (op == 146 ? 145 : (op == 195 ? 193 : 147));
                        e = frame[i2] = new Expr(m, op, i2, frame, i2 + 1, 1);
                        b.add(frame[i2]);
                        continue block74;
                    }
                    case 64: {
                        e = new Expr(m, op);
                        e.m = this.methods[p.readU30()];
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        int n17 = sp++;
                        Expr expr = e;
                        frame[n17] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 88: {
                        e = new Expr(m, op, frame, sp, 1);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        e.c = this.classes[p.readU30()];
                        Expr expr = e;
                        frame[sp - 1] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 85: {
                        int argc = 2 * p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n18 = sp++;
                        Expr expr = e;
                        frame[n18] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 86: {
                        int argc = p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n19 = sp++;
                        Expr expr = e;
                        frame[n19] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 90: {
                        e = new Expr(m, op, p.readU30());
                        int n20 = sp++;
                        Expr expr = e;
                        frame[n20] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 4: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n21 = sp++;
                        Expr expr = e;
                        frame[n21] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 5: {
                        Name ref = this.names[p.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        b.add(e);
                        sp -= argc;
                        continue block74;
                    }
                    case 65: {
                        int argc = 2 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n22 = sp++;
                        Expr expr = e;
                        frame[n22] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 66: {
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        int n23 = sp++;
                        Expr expr = e;
                        frame[n23] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 89: 
                    case 91: 
                    case 102: 
                    case 106: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n24 = sp++;
                        Expr expr = e;
                        frame[n24] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 96: {
                        Name ref = this.names[p.readU30()];
                        assert (refArgc[ref.kind] == 0);
                        e = new Expr(m, 93, ref, frame, sp, 0);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        b.add(e);
                        e = new Expr(m, 102, ref, new Expr[]{e}, 1, 1);
                        int n25 = sp++;
                        Expr expr = e;
                        frame[n25] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 93: 
                    case 94: {
                        Name ref = this.names[p.readU30()];
                        int argc = refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        e.scopes = GlobalOptimizer.capture(frame, scopep, scopep - local_count);
                        sp -= argc;
                        int n26 = sp++;
                        Expr expr = e;
                        frame[n26] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 95: {
                        Name ref = this.names[p.readU30()];
                        int argc = refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n27 = sp++;
                        Expr expr = e;
                        frame[n27] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 97: 
                    case 104: {
                        Name ref = this.names[p.readU30()];
                        int argc = 2 + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        continue block74;
                    }
                    case 108: {
                        e = new Expr(m, op, p.readU30(), frame, sp, 1);
                        b.add(e);
                        frame[sp - 1] = e;
                        continue block74;
                    }
                    case 109: {
                        e = new Expr(m, op, p.readU30(), frame, sp, 2);
                        b.add(e);
                        sp -= 2;
                        continue block74;
                    }
                    case 16: {
                        int offset = p.readS24();
                        if (!reachable) continue block74;
                        e = new Expr(m, op);
                        b.add(e);
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[0], blocks, states, p.pos + offset, frame, sp, scopep);
                        reachable = false;
                        continue block74;
                    }
                    case 17: 
                    case 18: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        continue block74;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 26: {
                        e = new Expr(m, GlobalOptimizer.this.ifoper(op), frame, sp, 2);
                        b.add(e);
                        e = new Expr(m, 18, new Expr[]{e}, 1, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        continue block74;
                    }
                    case 19: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        e = new Expr(m, GlobalOptimizer.this.ifoper(op), frame, sp, 2);
                        b.add(e);
                        e = new Expr(m, 17, new Expr[]{e}, 1, 1);
                        b.add(e);
                        int offset = p.readS24();
                        e.succ = new Edge[]{new Edge(m, b, 0, (Block)blocks.get(p.pos)), new Edge(m, b, 1, (Block)blocks.get(p.pos + offset))};
                        GlobalOptimizer.this.merge(m, null, blocks, states, p.pos, frame, sp -= 2, scopep);
                        GlobalOptimizer.this.merge(m, e.succ[1], blocks, states, p.pos + offset, frame, sp, scopep);
                        continue block74;
                    }
                    case 27: {
                        e = new Expr(m, op, frame, sp--, 1);
                        b.add(e);
                        int target = pos + p.readS24();
                        int n28 = 1 + p.readU30();
                        e.succ = new Edge[n28 + 1];
                        e.succ[n28] = new Edge(m, b, n28, (Block)blocks.get(target));
                        GlobalOptimizer.this.merge(m, e.succ[n28], blocks, states, target, frame, sp, scopep);
                        for (int i3 = 0; i3 < n28; ++i3) {
                            target = pos + p.readS24();
                            e.succ[i3] = new Edge(m, b, i3, (Block)blocks.get(target));
                            GlobalOptimizer.this.merge(m, e.succ[i3], blocks, states, target, frame, sp, scopep);
                        }
                        reachable = false;
                        continue block74;
                    }
                    case 36: {
                        int n29 = sp++;
                        Expr expr = new Expr(m, op, new Integer((byte)p.readU8()));
                        frame[n29] = expr;
                        e = expr;
                        b.add(e);
                        continue block74;
                    }
                    case 50: {
                        int oloc = p.readU30();
                        int iloc = p.readU30();
                        Expr index = frame[iloc];
                        Expr obj = frame[oloc];
                        e = frame[sp] = new Expr(m, op);
                        b.add(frame[sp]);
                        e.locals = new Expr[]{obj, index};
                        e = frame[oloc] = new Expr(m, 52);
                        b.add(frame[oloc]);
                        e.locals = new Expr[]{obj};
                        e = frame[iloc] = new Expr(m, 51);
                        b.add(frame[iloc]);
                        e.locals = new Expr[]{index};
                        ++sp;
                        continue block74;
                    }
                    case 67: {
                        int id = p.readU30();
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, id, frame, sp, argc);
                        sp -= argc;
                        int n30 = sp++;
                        Expr expr = e;
                        frame[n30] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 68: {
                        int id = p.readU30();
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        e.m = this.methods[id];
                        sp -= argc;
                        int n31 = sp++;
                        Expr expr = e;
                        frame[n31] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 73: {
                        int argc = 1 + p.readU30();
                        e = new Expr(m, op, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        continue block74;
                    }
                    case 69: 
                    case 70: 
                    case 74: 
                    case 76: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + p.readU30() + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        int n32 = sp++;
                        Expr expr = e;
                        frame[n32] = expr;
                        b.add(expr);
                        continue block74;
                    }
                    case 78: 
                    case 79: {
                        Name ref = this.names[p.readU30()];
                        int argc = 1 + p.readU30() + refArgc[ref.kind];
                        e = new Expr(m, op, ref, frame, sp, argc);
                        sp -= argc;
                        b.add(e);
                        continue block74;
                    }
                    case 241: {
                        int ii = p.readU30();
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block74;
                        e = new Expr(m, op, this.strings[ii]);
                        b.add(e);
                        continue block74;
                    }
                    case 240: 
                    case 242: {
                        int ii = p.readU30();
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block74;
                        e = new Expr(m, op, ii);
                        b.add(e);
                        continue block74;
                    }
                    case 239: {
                        int i1 = p.readU8();
                        int i2 = p.readU30();
                        int i3 = p.readU8();
                        int i4 = p.readU30();
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block74;
                        e = new Expr(m, op);
                        e.imm = new int[]{i1, i2, i3, i4};
                        b.add(e);
                        continue block74;
                    }
                    case 1: {
                        if (GlobalOptimizer.this.STRIP_DEBUG_INFO) continue block74;
                        b.add(new Expr(m, op));
                        continue block74;
                    }
                    case 243: {
                        b.add(new Expr(m, op));
                        continue block74;
                    }
                    case 2: {
                        continue block74;
                    }
                }
                assert (false);
            }
            GlobalOptimizer.this.dce(m);
        }
    }
}

