/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;

public class DOMViewer
extends JFrame
implements ActionMap {
    protected static final String RESOURCE = "org.apache.batik.util.gui.resources.DOMViewerMessages";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.DOMViewerMessages", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Map listeners = new HashMap();
    protected Panel panel = new Panel();
    protected boolean showWhitespace = true;

    public DOMViewer() {
        super(resources.getString("Frame.title"));
        this.setSize(resources.getInteger("Frame.width"), resources.getInteger("Frame.height"));
        this.listeners.put("CloseButtonAction", new CloseButtonAction());
        this.getContentPane().add(this.panel);
        JPanel p = new JPanel(new BorderLayout());
        JCheckBox cb = new JCheckBox("Show Whitespace Text Nodes");
        cb.setSelected(this.showWhitespace);
        cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent ie) {
                DOMViewer.this.setShowWhitespace(ie.getStateChange() == 1);
            }
        });
        p.add((Component)cb, "West");
        ButtonFactory bf = new ButtonFactory(bundle, this);
        p.add((Component)bf.createJButton("CloseButton"), "East");
        this.getContentPane().add("South", p);
    }

    public void setShowWhitespace(boolean state) {
        this.showWhitespace = state;
        if (this.panel.document != null) {
            this.panel.setDocument(this.panel.document);
        }
    }

    public void setDocument(Document doc) {
        this.panel.setDocument(doc);
    }

    public void setDocument(Document doc, ViewCSS view) {
        this.panel.setDocument(doc, view);
    }

    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    protected static class NodeInfo {
        protected Node node;

        public NodeInfo(Node n) {
            this.node = n;
        }

        public Node getNode() {
            return this.node;
        }

        public String toString() {
            String id;
            if (this.node instanceof Element && (id = ((Element)this.node).getAttribute("id")).length() != 0) {
                return this.node.getNodeName() + " \"" + id + "\"";
            }
            return this.node.getNodeName();
        }
    }

    public class Panel
    extends JPanel {
        protected Document document;
        protected ViewCSS viewCSS;
        protected JTree tree;
        protected JSplitPane splitPane;
        protected JPanel rightPanel = new JPanel(new BorderLayout());
        protected JTable attributesTable = new JTable();
        protected JTable propertiesTable = new JTable();
        protected JPanel elementPanel = new JPanel(new GridLayout(2, 1));
        protected JTextArea characterData;
        protected JPanel characterDataPanel;
        protected JTextArea documentInfo;
        protected JPanel documentInfoPanel;

        public Panel() {
            super(new BorderLayout());
            JScrollPane pane = new JScrollPane();
            pane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("AttributesPanel.title")), BorderFactory.createLoweredBevelBorder())));
            pane.getViewport().add(this.attributesTable);
            JScrollPane pane2 = new JScrollPane();
            pane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CSSValuesPanel.title")), BorderFactory.createLoweredBevelBorder())));
            pane2.getViewport().add(this.propertiesTable);
            this.elementPanel.add(pane);
            this.elementPanel.add(pane2);
            this.characterData = new JTextArea();
            this.characterDataPanel = new JPanel(new BorderLayout());
            this.characterDataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("CDataPanel.title")), BorderFactory.createLoweredBevelBorder())));
            pane = new JScrollPane();
            pane.getViewport().add(this.characterData);
            this.characterDataPanel.add(pane);
            this.characterData.setEditable(false);
            this.documentInfo = new JTextArea();
            this.documentInfoPanel = new JPanel(new BorderLayout());
            this.documentInfoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DocumentInfoPanel.title")), BorderFactory.createLoweredBevelBorder())));
            pane = new JScrollPane();
            pane.getViewport().add(this.documentInfo);
            this.documentInfoPanel.add(pane);
            this.documentInfo.setEditable(false);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewerPanel.title")));
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(resources.getString("EmptyDocument.text"));
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new NodeRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            JScrollPane treePane = new JScrollPane();
            treePane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), resources.getString("DOMViewer.title")), BorderFactory.createLoweredBevelBorder())));
            treePane.getViewport().add(this.tree);
            this.splitPane = new JSplitPane(1, true, treePane, this.rightPanel);
            int loc = resources.getInteger("SplitPane.dividerLocation");
            this.splitPane.setDividerLocation(loc);
            this.add(this.splitPane);
            this.tree.addTreeSelectionListener(new DOMTreeSelectionListener());
        }

        public void setDocument(Document doc) {
            this.setDocument(doc, null);
        }

        public void setDocument(Document doc, ViewCSS view) {
            this.document = doc;
            this.viewCSS = view;
            MutableTreeNode root = this.createTree(doc, DOMViewer.this.showWhitespace);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(root);
            if (this.rightPanel.getComponentCount() != 0) {
                this.rightPanel.remove(0);
                this.splitPane.revalidate();
                this.splitPane.repaint();
            }
        }

        protected MutableTreeNode createTree(Node node, boolean showWhitespace) {
            DefaultMutableTreeNode result = new DefaultMutableTreeNode(new NodeInfo(node));
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                String txt;
                if (!showWhitespace && n instanceof Text && (txt = n.getNodeValue()).trim().length() == 0) continue;
                result.add(this.createTree(n, showWhitespace));
            }
            return result;
        }

        protected class NodeCSSValuesModel
        extends AbstractTableModel {
            protected Node node;
            protected CSSStyleDeclaration style;
            protected List propertyNames;

            public NodeCSSValuesModel(Node n) {
                this.node = n;
                if (Panel.this.viewCSS != null) {
                    this.style = Panel.this.viewCSS.getComputedStyle((Element)n, null);
                    this.propertyNames = new ArrayList();
                    if (this.style != null) {
                        for (int i = 0; i < this.style.getLength(); ++i) {
                            this.propertyNames.add(this.style.item(i));
                        }
                        Collections.sort(this.propertyNames);
                    }
                }
            }

            public String getColumnName(int col) {
                if (col == 0) {
                    return resources.getString("CSSValuesTable.column1");
                }
                return resources.getString("CSSValuesTable.column2");
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                if (this.style == null) {
                    return 0;
                }
                return this.style.getLength();
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public Object getValueAt(int row, int col) {
                String prop = (String)this.propertyNames.get(row);
                if (col == 0) {
                    return prop;
                }
                return this.style.getPropertyValue(prop);
            }
        }

        protected class NodeAttributesModel
        extends AbstractTableModel {
            protected Node node;

            public NodeAttributesModel(Node n) {
                this.node = n;
            }

            public String getColumnName(int col) {
                if (col == 0) {
                    return resources.getString("AttributesTable.column1");
                }
                return resources.getString("AttributesTable.column2");
            }

            public int getColumnCount() {
                return 2;
            }

            public int getRowCount() {
                return this.node.getAttributes().getLength();
            }

            public boolean isCellEditable(int row, int col) {
                return false;
            }

            public Object getValueAt(int row, int col) {
                NamedNodeMap map = this.node.getAttributes();
                Node n = map.item(row);
                if (col == 0) {
                    return n.getNodeName();
                }
                return n.getNodeValue();
            }
        }

        protected class NodeRenderer
        extends DefaultTreeCellRenderer {
            ImageIcon elementIcon;
            ImageIcon commentIcon;
            ImageIcon piIcon;
            ImageIcon textIcon;

            public NodeRenderer() {
                String s = resources.getString("Element.icon");
                this.elementIcon = new ImageIcon(this.getClass().getResource(s));
                s = resources.getString("Comment.icon");
                this.commentIcon = new ImageIcon(this.getClass().getResource(s));
                s = resources.getString("PI.icon");
                this.piIcon = new ImageIcon(this.getClass().getResource(s));
                s = resources.getString("Text.icon");
                this.textIcon = new ImageIcon(this.getClass().getResource(s));
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                switch (this.getNodeType(value)) {
                    case 1: {
                        this.setIcon(this.elementIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(this.commentIcon);
                        break;
                    }
                    case 7: {
                        this.setIcon(this.piIcon);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.setIcon(this.textIcon);
                    }
                }
                return this;
            }

            protected short getNodeType(Object value) {
                DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)value;
                Object obj = mtn.getUserObject();
                if (obj instanceof NodeInfo) {
                    Node node = ((NodeInfo)obj).getNode();
                    return node.getNodeType();
                }
                return -1;
            }
        }

        protected class DOMTreeSelectionListener
        implements TreeSelectionListener {
            protected DOMTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent ev) {
                Object nodeInfo;
                DefaultMutableTreeNode mtn = (DefaultMutableTreeNode)Panel.this.tree.getLastSelectedPathComponent();
                if (mtn == null) {
                    return;
                }
                if (Panel.this.rightPanel.getComponentCount() != 0) {
                    Panel.this.rightPanel.remove(0);
                }
                if ((nodeInfo = mtn.getUserObject()) instanceof NodeInfo) {
                    Node node = ((NodeInfo)nodeInfo).getNode();
                    switch (node.getNodeType()) {
                        case 9: {
                            Panel.this.documentInfo.setText(this.createDocumentText((Document)node));
                            Panel.this.rightPanel.add(Panel.this.documentInfoPanel);
                            break;
                        }
                        case 1: {
                            Panel.this.attributesTable.setModel(new NodeAttributesModel(node));
                            Panel.this.propertiesTable.setModel(new NodeCSSValuesModel(node));
                            Panel.this.rightPanel.add(Panel.this.elementPanel);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 8: {
                            Panel.this.characterData.setText(node.getNodeValue());
                            Panel.this.rightPanel.add(Panel.this.characterDataPanel);
                        }
                    }
                }
                Panel.this.splitPane.revalidate();
                Panel.this.splitPane.repaint();
            }

            protected String createDocumentText(Document doc) {
                StringBuffer sb = new StringBuffer();
                sb.append("Nodes: ");
                sb.append(this.nodeCount(doc));
                return sb.toString();
            }

            protected int nodeCount(Node node) {
                int result = 1;
                for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                    result += this.nodeCount(n);
                }
                return result;
            }
        }
    }

    protected class CloseButtonAction
    extends AbstractAction {
        protected CloseButtonAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DOMViewer.this.dispose();
        }
    }
}

