/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.wmf.tosvg;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.BufferedInputStream;
import java.io.Serializable;
import java.util.Stack;
import org.apache.batik.transcoder.wmf.tosvg.GdiObject;
import org.apache.batik.transcoder.wmf.tosvg.MetaRecord;
import org.apache.batik.transcoder.wmf.tosvg.StringRecord;
import org.apache.batik.transcoder.wmf.tosvg.WMFRecordStore;

public class WMFPainter {
    private static final String WMF_FILE_EXTENSION = ".wmf";
    private static final int INPUT_BUFFER_SIZE = 30720;
    private static BasicStroke solid = new BasicStroke(1.0f, 0, 1);
    public static final int PEN = 1;
    public static final int BRUSH = 2;
    public static final int FONT = 3;
    public static final int NULL_PEN = 4;
    public static final int NULL_BRUSH = 5;
    public static final int PALETTE = 6;
    private WMFRecordStore currentStore;
    private transient boolean bReadingWMF = true;
    private transient BufferedInputStream bufStream = null;

    public WMFPainter(WMFRecordStore currentStore) {
        this.setRecordStore(currentStore);
    }

    public void paint(Graphics g) {
        int fontHeight = 10;
        boolean fontAngle = false;
        int penWidth = 0;
        int startX = 0;
        int startY = 0;
        int brushObject = -1;
        int penObject = -1;
        int fontObject = -1;
        Font font = null;
        Stack<Serializable> dcStack = new Stack<Serializable>();
        int numRecords = this.currentStore.getNumRecords();
        int numObjects = this.currentStore.getNumObjects();
        int vpX = this.currentStore.getVpX();
        int vpY = this.currentStore.getVpY();
        int vpW = this.currentStore.getVpW();
        int vpH = this.currentStore.getVpH();
        if (!this.currentStore.isReading()) {
            GdiObject gdiObj;
            g.setPaintMode();
            brushObject = -1;
            penObject = -1;
            fontObject = -1;
            Color frgdColor = null;
            Color bkgdColor = null;
            for (int i = 0; i < numObjects; ++i) {
                gdiObj = this.currentStore.getObject(i);
                gdiObj.Clear();
            }
            int w = vpW;
            int h = vpH;
            g.setColor(Color.white);
            g.fillRect(0, 0, w, h);
            g.setColor(Color.black);
            double scaleX = (double)w / (double)vpW;
            double scaleY = (double)h / (double)vpH;
            block51: for (int iRec = 0; iRec < numRecords; ++iRec) {
                MetaRecord mr = this.currentStore.getRecord(iRec);
                switch (mr.functionId) {
                    case 523: {
                        vpX = -mr.ElementAt(0).intValue();
                        this.currentStore.setVpX(vpX);
                        vpY = -mr.ElementAt(1).intValue();
                        this.currentStore.setVpY(vpY);
                        continue block51;
                    }
                    case 0: 
                    case 524: {
                        vpW = mr.ElementAt(0);
                        this.currentStore.setVpW(vpW);
                        vpH = mr.ElementAt(1);
                        this.currentStore.setVpH(vpH);
                        scaleX = (double)w / (double)vpW;
                        scaleY = (double)h / (double)vpH;
                        continue block51;
                    }
                    case 525: 
                    case 526: 
                    case 527: 
                    case 529: 
                    case 1040: 
                    case 1042: {
                        continue block51;
                    }
                    case 262: {
                        continue block51;
                    }
                    case 762: {
                        Color newClr;
                        int objIndex = 0;
                        try {
                            objIndex = mr.ElementAt(5);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        int penStyle = mr.ElementAt(0);
                        if (penStyle == 5) {
                            newClr = new Color(255, 255, 255);
                            objIndex = numObjects + 8;
                            this.addObjectAt(this.currentStore, 4, newClr, objIndex);
                        } else {
                            newClr = new Color(mr.ElementAt(1), mr.ElementAt(2), mr.ElementAt(3));
                            this.addObjectAt(this.currentStore, 1, newClr, objIndex);
                        }
                        penWidth = mr.ElementAt(4);
                        continue block51;
                    }
                    case 764: {
                        int objIndex = 0;
                        try {
                            objIndex = mr.ElementAt(5);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        int brushStyle = mr.ElementAt(0);
                        if (brushStyle == 0) {
                            this.addObjectAt(this.currentStore, 2, new Color(mr.ElementAt(1), mr.ElementAt(2), mr.ElementAt(3)), objIndex);
                            continue block51;
                        }
                        this.addObjectAt(this.currentStore, 5, new Color(0, 0, 0), objIndex);
                        continue block51;
                    }
                    case 763: {
                        int style = mr.ElementAt(1) > 0 ? 2 : 0;
                        style |= mr.ElementAt(2) > 400 ? 1 : 0;
                        int size = (int)(scaleY * (double)mr.ElementAt(0).intValue());
                        String face = ((StringRecord)mr).text;
                        if (size < 0) {
                            size = (int)((double)size * -1.3);
                        }
                        int objIndex = 0;
                        try {
                            objIndex = mr.ElementAt(3);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        fontHeight = size;
                        font = new Font(face, style, size);
                        this.addObjectAt(this.currentStore, 3, font, objIndex);
                        continue block51;
                    }
                    case 247: 
                    case 248: 
                    case 322: 
                    case 505: 
                    case 765: 
                    case 1790: 
                    case 1791: {
                        this.addObjectAt(this.currentStore, 6, new Integer(0), 0);
                        continue block51;
                    }
                    case 53: 
                    case 55: 
                    case 313: 
                    case 564: 
                    case 1078: {
                        continue block51;
                    }
                    case 301: {
                        int gdiIndex = mr.ElementAt(0);
                        if ((gdiIndex & Integer.MIN_VALUE) != 0) continue block51;
                        if (gdiIndex >= numObjects) {
                            switch (gdiIndex -= numObjects) {
                                case 5: {
                                    brushObject = -1;
                                    continue block51;
                                }
                                case 8: {
                                    penObject = -1;
                                    continue block51;
                                }
                            }
                            continue block51;
                        }
                        gdiObj = this.currentStore.getObject(gdiIndex);
                        if (!gdiObj.used) continue block51;
                        switch (gdiObj.type) {
                            case 1: {
                                g.setColor((Color)gdiObj.obj);
                                penObject = gdiIndex;
                                break;
                            }
                            case 2: {
                                g.setColor((Color)gdiObj.obj);
                                brushObject = gdiIndex;
                                break;
                            }
                            case 3: {
                                font = (Font)gdiObj.obj;
                                g.setFont(font);
                                fontObject = gdiIndex;
                                break;
                            }
                            case 4: {
                                penObject = -1;
                                break;
                            }
                            case 5: {
                                brushObject = -1;
                            }
                        }
                        continue block51;
                    }
                    case 496: {
                        int gdiIndex = mr.ElementAt(0);
                        gdiObj = this.currentStore.getObject(gdiIndex);
                        if (gdiIndex == brushObject) {
                            brushObject = -1;
                        } else if (gdiIndex == penObject) {
                            penObject = -1;
                        } else if (gdiIndex == fontObject) {
                            fontObject = -1;
                        }
                        gdiObj.Clear();
                        continue block51;
                    }
                    case 1336: {
                        int numPolygons = mr.ElementAt(0);
                        int[] pts = new int[numPolygons];
                        for (int ip = 0; ip < numPolygons; ++ip) {
                            pts[ip] = mr.ElementAt(ip + 1);
                        }
                        GeneralPath gp = new GeneralPath();
                        int offset = numPolygons + 1;
                        for (int j = 0; j < numPolygons; ++j) {
                            int count = pts[j];
                            int[] xpts = new int[count];
                            int[] ypts = new int[count];
                            for (int k = 0; k < count; ++k) {
                                xpts[k] = (int)(scaleX * (double)(vpX + mr.ElementAt(offset + k * 2)));
                                ypts[k] = (int)(scaleY * (double)(vpY + mr.ElementAt(offset + k * 2 + 1)));
                            }
                            offset += count;
                            Polygon p = new Polygon(xpts, ypts, count);
                            gp.append(p, true);
                        }
                        if (brushObject >= 0) {
                            this.setBrushColor(this.currentStore, g, brushObject);
                            ((Graphics2D)g).fill(gp);
                        }
                        this.setPenColor(this.currentStore, g, penObject);
                        ((Graphics2D)g).draw(gp);
                        continue block51;
                    }
                    case 804: {
                        int count = mr.ElementAt(0);
                        int[] _xpts = new int[count + 1];
                        int[] _ypts = new int[count + 1];
                        for (int k = 0; k < count; ++k) {
                            _xpts[k] = (int)(scaleX * (double)(vpX + mr.ElementAt(k * 2 + 1)));
                            _ypts[k] = (int)(scaleY * (double)(vpY + mr.ElementAt(k * 2 + 2)));
                        }
                        _xpts[count] = _xpts[0];
                        _ypts[count] = _ypts[0];
                        if (brushObject >= 0) {
                            this.setBrushColor(this.currentStore, g, brushObject);
                            g.fillPolygon(_xpts, _ypts, count);
                        }
                        this.setPenColor(this.currentStore, g, penObject);
                        g.drawPolygon(_xpts, _ypts, count + 1);
                        continue block51;
                    }
                    case 532: {
                        startX = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        startY = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        continue block51;
                    }
                    case 531: {
                        int endX = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        int endY = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        this.setPenColor(this.currentStore, g, penObject);
                        g.drawLine(startX, startY, endX, endY);
                        startX = endX;
                        startY = endY;
                        continue block51;
                    }
                    case 805: {
                        this.setPenColor(this.currentStore, g, penObject);
                        int count = mr.ElementAt(0);
                        int _startX = (int)(scaleX * (double)(vpX + mr.ElementAt(1)));
                        int _startY = (int)(scaleY * (double)(vpY + mr.ElementAt(2)));
                        for (int j = 1; j < count; ++j) {
                            int endX = (int)(scaleX * (double)(vpX + mr.ElementAt(j * 2 + 1)));
                            int endY = (int)(scaleY * (double)(vpY + mr.ElementAt(j * 2 + 2)));
                            g.drawLine(_startX, _startY, endX, endY);
                            _startX = endX;
                            _startY = endY;
                        }
                        continue block51;
                    }
                    case 1051: {
                        int x1 = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        int x2 = (int)(scaleX * (double)(vpX + mr.ElementAt(2)));
                        int y1 = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        int y2 = (int)(scaleY * (double)(vpY + mr.ElementAt(3)));
                        if (brushObject >= 0) {
                            this.setBrushColor(this.currentStore, g, brushObject);
                            g.fillRect(x1, y1, x2 - x1 - 1, y2 - y1 - 1);
                        }
                        this.setPenColor(this.currentStore, g, penObject);
                        g.drawRect(x1, y1, x2 - x1 - 1, y2 - y1 - 1);
                        continue block51;
                    }
                    case 1564: {
                        int x1 = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        int x2 = (int)(scaleX * (double)(vpX + mr.ElementAt(2)));
                        int x3 = (int)(scaleX * (double)mr.ElementAt(4).intValue());
                        int y1 = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        int y2 = (int)(scaleY * (double)(vpY + mr.ElementAt(3)));
                        int y3 = (int)(scaleY * (double)mr.ElementAt(5).intValue());
                        if (brushObject >= 0) {
                            this.setBrushColor(this.currentStore, g, brushObject);
                            g.fillRoundRect(x1, y1, x2 - x1, y2 - y1, x3, y3);
                        }
                        this.setPenColor(this.currentStore, g, penObject);
                        g.drawRoundRect(x1, y1, x2 - x1, y2 - y1, x3, y3);
                        continue block51;
                    }
                    case 1048: {
                        int x1 = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        int x2 = (int)(scaleX * (double)(vpX + mr.ElementAt(2)));
                        int y1 = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        int y2 = (int)(scaleY * (double)(vpY + mr.ElementAt(3)));
                        if (brushObject >= 0) {
                            this.setBrushColor(this.currentStore, g, brushObject);
                            g.fillOval(x1, y1, x2 - x1, y2 - y1);
                        }
                        this.setPenColor(this.currentStore, g, penObject);
                        g.drawOval(x1, y1, x2 - x1 - 1, y2 - y1 - 1);
                        continue block51;
                    }
                    case 521: {
                        frgdColor = new Color(mr.ElementAt(0), mr.ElementAt(1), mr.ElementAt(2));
                        continue block51;
                    }
                    case 513: {
                        bkgdColor = new Color(mr.ElementAt(0), mr.ElementAt(1), mr.ElementAt(2));
                        continue block51;
                    }
                    case 1313: 
                    case 1583: 
                    case 2610: {
                        try {
                            Graphics2D g2 = (Graphics2D)g;
                            int x = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                            int y = (int)((double)fontHeight + scaleY * (double)(vpY + mr.ElementAt(1)));
                            if (frgdColor != null) {
                                g.setColor(frgdColor);
                            } else {
                                g.setColor(Color.black);
                            }
                            StringRecord sr = (StringRecord)mr;
                            FontRenderContext frc = g2.getFontRenderContext();
                            Point2D.Double pen = new Point2D.Double(0.0, 0.0);
                            GeneralPath gp = new GeneralPath(1);
                            TextLayout layout = new TextLayout(sr.text, font, frc);
                            pen.y += (double)layout.getAscent();
                            if (fontAngle || sr.text.startsWith("Sono una scala verticale di prevalenza")) {
                                AffineTransform at = new AffineTransform();
                                float height = (float)layout.getBounds().getHeight();
                                AffineTransform textAt = new AffineTransform();
                                textAt.translate(x, y);
                                textAt.rotate(Math.toRadians(270.0));
                                textAt.translate(0.0, height);
                                Shape shape = layout.getOutline(textAt);
                                gp.append(at.createTransformedShape(shape), false);
                                g2.draw(shape);
                                continue block51;
                            }
                            g.drawString(sr.text, x, y);
                        }
                        catch (Exception e) {}
                        continue block51;
                    }
                    case 2071: 
                    case 2074: {
                        int x1 = (int)(scaleX * (double)(vpX + mr.ElementAt(0)));
                        int x2 = (int)(scaleX * (double)(vpX + mr.ElementAt(2)));
                        int x3 = (int)(scaleX * (double)mr.ElementAt(4).intValue());
                        int x4 = (int)(scaleX * (double)mr.ElementAt(6).intValue());
                        int y1 = (int)(scaleY * (double)(vpY + mr.ElementAt(1)));
                        int y2 = (int)(scaleY * (double)(vpY + mr.ElementAt(3)));
                        int y3 = (int)(scaleY * (double)mr.ElementAt(5).intValue());
                        int y4 = (int)(scaleY * (double)mr.ElementAt(7).intValue());
                        this.setBrushColor(this.currentStore, g, brushObject);
                        int mx = x1 + (x2 - x1) / 2;
                        int my = y1 + (y2 - y1) / 2;
                        int startAngle = (int)Math.atan((y3 - my) / (x3 - mx));
                        int endAngle = (int)Math.atan((y4 - my) / (x4 - mx));
                        if (mr.functionId == 2071) {
                            g.drawArc(x1, y1, x2 - x1, y2 - y1, startAngle, endAngle);
                            continue block51;
                        }
                        g.fillArc(x1, y1, x2 - x1, y2 - y1, startAngle, endAngle);
                        continue block51;
                    }
                    case 2096: {
                        continue block51;
                    }
                    case 30: {
                        dcStack.push(new Integer(penWidth));
                        dcStack.push(new Integer(startX));
                        dcStack.push(new Integer(startY));
                        dcStack.push(new Integer(brushObject));
                        dcStack.push(new Integer(penObject));
                        dcStack.push(new Integer(fontObject));
                        dcStack.push(frgdColor);
                        dcStack.push(bkgdColor);
                        continue block51;
                    }
                    case 295: {
                        bkgdColor = (Color)dcStack.pop();
                        frgdColor = (Color)dcStack.pop();
                        fontObject = (Integer)dcStack.pop();
                        penObject = (Integer)dcStack.pop();
                        brushObject = (Integer)dcStack.pop();
                        startY = (Integer)dcStack.pop();
                        startX = (Integer)dcStack.pop();
                        penWidth = (Integer)dcStack.pop();
                        continue block51;
                    }
                    case 4096: {
                        try {
                            Graphics2D g2 = (Graphics2D)g;
                            this.setPenColor(this.currentStore, g, penObject);
                            int pointCount = mr.ElementAt(0);
                            int bezierCount = (pointCount - 1) / 3;
                            float _startX = (float)(scaleX * (double)(vpX + mr.ElementAt(1)));
                            float _startY = (float)(scaleY * (double)(vpY + mr.ElementAt(2)));
                            GeneralPath gp = new GeneralPath(1);
                            gp.moveTo(_startX, _startY);
                            for (int j = 0; j < bezierCount; ++j) {
                                float cp1X = (float)(scaleX * (double)(vpX + mr.ElementAt(j * 6 + 3)));
                                float cp1Y = (float)(scaleY * (double)(vpY + mr.ElementAt(j * 6 + 4)));
                                float cp2X = (float)(scaleX * (double)(vpX + mr.ElementAt(j * 6 + 5)));
                                float cp2Y = (float)(scaleY * (double)(vpY + mr.ElementAt(j * 6 + 6)));
                                float endX = (float)(scaleX * (double)(vpX + mr.ElementAt(j * 6 + 7)));
                                float endY = (float)(scaleY * (double)(vpY + mr.ElementAt(j * 6 + 8)));
                                gp.curveTo(cp1X, cp1Y, cp2X, cp2Y, endX, endY);
                                _startX = endX;
                                _startY = endY;
                            }
                            g2.setStroke(solid);
                            g2.draw(gp);
                        }
                        catch (Exception e) {
                            System.out.println("Unable to draw static text as a 2D graphics context is required");
                        }
                        continue block51;
                    }
                }
            }
        }
    }

    private void setPenColor(WMFRecordStore currentStore, Graphics g, int penObject) {
        if (penObject >= 0) {
            GdiObject gdiObj = currentStore.getObject(penObject);
            g.setColor((Color)gdiObj.obj);
            penObject = -1;
        }
    }

    private void setBrushColor(WMFRecordStore currentStore, Graphics g, int brushObject) {
        if (brushObject >= 0) {
            GdiObject gdiObj = currentStore.getObject(brushObject);
            g.setColor((Color)gdiObj.obj);
            brushObject = -1;
        }
    }

    public void setRecordStore(WMFRecordStore currentStore) {
        if (currentStore == null) {
            throw new IllegalArgumentException();
        }
        this.currentStore = currentStore;
    }

    public WMFRecordStore getRecordStore() {
        return this.currentStore;
    }

    private void addObject(WMFRecordStore currentStore, int type, Object obj) {
        currentStore.addObject(type, obj);
    }

    private void addObjectAt(WMFRecordStore currentStore, int type, Object obj, int idx) {
        currentStore.addObjectAt(type, obj, idx);
    }
}

