/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.util.DoublyIndexedTable;

public class AttributeInitializer {
    protected String[] keys;
    protected int length;
    protected DoublyIndexedTable values = new DoublyIndexedTable();

    public AttributeInitializer(int capacity) {
        this.keys = new String[capacity * 3];
    }

    public void addAttribute(String ns, String prefix, String ln, String val) {
        int len = this.keys.length;
        if (this.length == len) {
            String[] t = new String[len * 2];
            for (int i = len - 1; i >= 0; --i) {
                t[i] = this.keys[i];
            }
            this.keys = t;
        }
        this.keys[this.length++] = ns;
        this.keys[this.length++] = prefix;
        this.keys[this.length++] = ln;
        this.values.put(ns, ln, val);
    }

    public void initializeAttributes(AbstractElement elt) {
        for (int i = this.length - 1; i >= 2; i -= 3) {
            this.resetAttribute(elt, this.keys[i - 2], this.keys[i - 1], this.keys[i]);
        }
    }

    public boolean resetAttribute(AbstractElement elt, String ns, String prefix, String ln) {
        String val = (String)this.values.get(ns, ln);
        if (val == null) {
            return false;
        }
        if (prefix != null) {
            StringBuffer sb = new StringBuffer(prefix.length() + ln.length() + 1);
            sb.append(prefix).append(':').append(ln);
            ln = sb.toString();
        }
        elt.setUnspecifiedAttribute(ns, ln, val);
        return true;
    }
}

