/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.i18n;

import flash.util.StringJoiner;
import flex2.compiler.CompilerException;
import flex2.compiler.CompilerSwcContext;
import flex2.compiler.ResourceBundlePath;
import flex2.compiler.Source;
import flex2.compiler.SourcePath;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.CommandLineConfiguration;
import flex2.tools.oem.internal.ApplicationCompilerConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class I18nUtils {
    public static String CLASS_SUFFIX = "_properties";
    public static String COMPILED_RESOURCE_BUNDLE_INFO = "_CompiledResourceBundleInfo";

    public static String codegenCompiledResourceBundleInfo(String[] locales, SortedSet bundleNames) {
        String packageName = "";
        String className = COMPILED_RESOURCE_BUNDLE_INFO;
        String lineSep = System.getProperty("line.separator");
        Object[] codePieces = new String[]{"package ", packageName, lineSep, "{", lineSep, lineSep, "[ExcludeClass]", lineSep, lineSep, "public class ", className, lineSep, "{", lineSep, "    public static function get compiledLocales():Array /* of String */", lineSep, "    {", lineSep, "        return ", I18nUtils.codegenCompiledLocales(locales), ";", lineSep, "    }", lineSep, lineSep, "    public static function get compiledResourceBundleNames():Array /* of String */", lineSep, "    {", lineSep, "        return ", I18nUtils.codegenCompiledResourceBundleNames(bundleNames), ";", lineSep, "    }", lineSep, "}", lineSep, lineSep, "}", lineSep};
        return StringJoiner.join((Object[])codePieces, null);
    }

    private static String codegenCompiledLocales(String[] locales) {
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "[ " + StringJoiner.join((Object[])locales, (String)", ", (StringJoiner.ItemStringer)itemStringer) + " ]";
    }

    private static String codegenCompiledResourceBundleNames(SortedSet bundleNames) {
        if (bundleNames == null) {
            return "[]";
        }
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "[ " + StringJoiner.join((Collection)bundleNames, (String)", ", (StringJoiner.ItemStringer)itemStringer) + " ]";
    }

    public static File getGeneratedResourceModule(ApplicationCompilerConfiguration configuration) {
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        List bundleNames = configuration.getIncludeResourceBundles();
        return I18nUtils.getGeneratedResourceModule(locales, bundleNames);
    }

    public static File getGeneratedResourceModule(CommandLineConfiguration configuration) {
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        List bundleNames = configuration.getIncludeResourceBundles();
        return I18nUtils.getGeneratedResourceModule(locales, bundleNames);
    }

    public static File getGeneratedResourceModule(String[] locales, List bundleNames) {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        File tempDir = new File(tempDirPath, "Adobe");
        tempDir = new File(tempDir, "Flex");
        tempDir = new File(tempDir, "GeneratedResourceModules");
        tempDir.mkdirs();
        File resourceModuleFile = null;
        try {
            resourceModuleFile = File.createTempFile("GeneratedResourceModule", ".as", tempDir);
        }
        catch (Exception e) {
            return null;
        }
        resourceModuleFile.deleteOnExit();
        return I18nUtils.codegenResourceModule(resourceModuleFile, locales, bundleNames);
    }

    private static File codegenResourceModule(File resourceModuleFile, String[] locales, List bundleNames) {
        String fileName = resourceModuleFile.getName();
        String className = fileName.substring(0, fileName.length() - 3);
        String lineSep = System.getProperty("line.separator");
        Object[] codePieces = new String[]{"package ", lineSep, "{", lineSep, lineSep, "import flash.utils.getDefinitionByName", lineSep, "import mx.modules.ModuleBase;", lineSep, "import mx.resources.IResourceModule;", lineSep, "import mx.resources.ResourceBundle;", lineSep, lineSep, "[ExcludeClass]", lineSep, lineSep, I18nUtils.codegenResourceBundleMetadata(bundleNames), lineSep, "public class ", className, " extends ModuleBase", lineSep, "    implements IResourceModule", lineSep, "{", lineSep, "    private static var resourceBundleClassNames:Array /* of String */ =", lineSep, "    [", lineSep, I18nUtils.codegenResourceBundleClassNames(locales, bundleNames), lineSep, "    ];", lineSep, lineSep, "    public function ", className, "()", lineSep, "    {", lineSep, "        super();", lineSep, "    }", lineSep, lineSep, "    private var _resourceBundles:Array /* of ResourceBundle */;", lineSep, lineSep, "    public function get resourceBundles():Array /* of ResourceBundle */", lineSep, "    {", lineSep, "        if (!_resourceBundles)", lineSep, "        {", lineSep, "            _resourceBundles = [];", lineSep, "            var n:int = resourceBundleClassNames.length;", lineSep, "            for (var i:int = 0; i < n; i++)", lineSep, "            {", lineSep, "                var resourceBundleClass:Class =", lineSep, "                    Class(getDefinitionByName(resourceBundleClassNames[i]));", lineSep, "                var resourceBundle:ResourceBundle = new resourceBundleClass();", lineSep, "                _resourceBundles.push(resourceBundle);", lineSep, "            }", lineSep, "        }", lineSep, lineSep, "        return _resourceBundles;", lineSep, "    }", lineSep, "}", lineSep, lineSep, "}", lineSep};
        String code = StringJoiner.join((Object[])codePieces, null);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resourceModuleFile), "UTF8"));
            bufferedWriter.write(code);
            bufferedWriter.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return resourceModuleFile;
    }

    public static File regenerateResourceModule(ApplicationCompilerConfiguration configuration) {
        File resourceModuleFile = new File(configuration.getTargetFile());
        String[] locales = configuration.getCompilerConfiguration().getLocales();
        List bundleNames = configuration.getIncludeResourceBundles();
        return I18nUtils.codegenResourceModule(resourceModuleFile, locales, bundleNames);
    }

    private static String codegenResourceBundleMetadata(List bundleNames) {
        String lineSep = System.getProperty("line.separator");
        StringJoiner.ItemStringer itemStringer = new StringJoiner.ItemStringer(){

            public String itemToString(Object obj) {
                return "[ResourceBundle(\"" + (String)obj + "\")]";
            }
        };
        return StringJoiner.join((Collection)bundleNames, (String)lineSep, (StringJoiner.ItemStringer)itemStringer) + lineSep;
    }

    private static String codegenResourceBundleClassNames(String[] locales, List bundleNames) {
        String lineSep = System.getProperty("line.separator");
        ArrayList<String> classNames = new ArrayList<String>();
        for (int i = 0; i < locales.length; ++i) {
            String locale = locales[i];
            Iterator iter = bundleNames.iterator();
            while (iter.hasNext()) {
                String bundleName = (String)iter.next();
                String className = I18nUtils.getClassName(locale, bundleName);
                classNames.add(className);
            }
        }
        StringJoiner.ItemQuoter itemStringer = new StringJoiner.ItemQuoter();
        return "        " + StringJoiner.join(classNames, (String)("," + lineSep + "        "), (StringJoiner.ItemStringer)itemStringer);
    }

    public static String getClassName(String locale, String bundleName) {
        return locale + "$" + bundleName + CLASS_SUFFIX;
    }

    public static Source getResourceBundleSource(String packageName, String className, ResourceBundlePath bundlePath, SourcePath sourcePath, CompilerSwcContext swcContext) throws CompilerException {
        Source s = bundlePath.findSource(packageName, className);
        if (s == null && (s = swcContext.getSource(packageName, className + CLASS_SUFFIX)) == null && (s = sourcePath.findSource(packageName, className)) == null) {
            s = swcContext.getSource(packageName, className);
        }
        return s;
    }

    public static TranslationFormat getTranslationFormat(CompilerConfiguration config) {
        TranslationFormat format = null;
        try {
            Class<?> formatCls = Class.forName(config.getTranslationFormat(), true, Thread.currentThread().getContextClassLoader());
            format = (TranslationFormat)formatCls.newInstance();
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            ThreadLocalToolkit.logError(stringWriter.toString());
        }
        return format;
    }

    public static String localeFromClassName(String className) {
        return className.substring(0, className.indexOf("$"));
    }

    public static String bundleNameFromClassName(String className) {
        return className.substring(className.indexOf("$") + 1, className.length() - CLASS_SUFFIX.length());
    }
}

