/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.binding;

import flex2.compiler.as3.binding.ChangeEvent;
import flex2.compiler.as3.binding.PropertyWatcher;
import flex2.compiler.util.NameFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class Watcher {
    public static final String CURRENT_INDEX = "currentIndex";
    public static final String CURRENT_ITEM = "currentItem";
    public static final String DATA_PROVIDER = "dataProvider";
    public static final String REPEATER_ITEM = "repeaterItem";
    protected Map childWatchers;
    private int id;
    private Watcher parent;
    private boolean isPartOfAnonObjectGraph;
    private Set changeEvents;
    private boolean shouldWriteChildren;
    private boolean operation;
    private String className;
    protected static final ChangeEvent NO_CHANGE_EVENT = new ChangeEvent("__NoChangeEvent__", true);

    public Watcher(int id) {
        this.id = id;
        this.childWatchers = new HashMap();
        this.isPartOfAnonObjectGraph = false;
        this.changeEvents = new HashSet();
        this.shouldWriteChildren = true;
    }

    public Set getChangeEvents() {
        return this.changeEvents;
    }

    public String getClassName() {
        return this.className;
    }

    public int getId() {
        return this.id;
    }

    public Watcher getParent() {
        return this.parent;
    }

    public boolean getShouldWriteChildren() {
        return this.shouldWriteChildren;
    }

    public boolean isPartOfAnonObjectGraph() {
        return this.isPartOfAnonObjectGraph;
    }

    public void setPartOfAnonObjectGraph(boolean isPartOfAnonObjectGraph) {
        this.isPartOfAnonObjectGraph = isPartOfAnonObjectGraph;
    }

    public void setShouldWriteChildren(boolean shouldWriteChildren) {
        this.shouldWriteChildren = shouldWriteChildren;
    }

    public boolean shouldWriteSelf() {
        return true;
    }

    public void addChild(Watcher child) {
        if (child instanceof PropertyWatcher) {
            this.childWatchers.put(((PropertyWatcher)child).getProperty(), child);
        } else {
            this.childWatchers.put(new Integer(child.id), child);
        }
        child.parent = this;
    }

    public PropertyWatcher getChild(String property) {
        if (this.childWatchers.containsKey(property)) {
            return (PropertyWatcher)this.childWatchers.get(property);
        }
        return null;
    }

    public Collection getChildren() {
        return this.childWatchers.values();
    }

    public void addChangeEvent(String name) {
        this.addChangeEvent(name, true);
    }

    public void addChangeEvent(String name, boolean validate) {
        this.changeEvents.add(new ChangeEvent(name, validate));
    }

    public void addNoChangeEvent() {
        this.changeEvents.add(NO_CHANGE_EVENT);
    }

    public boolean isOperation() {
        return this.operation;
    }

    public void setClassName(String className) {
        this.className = NameFormatter.toDot(className);
    }

    public void setOperation(boolean operation) {
        this.operation = operation;
    }
}

