/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class IntList {
    private int[] a;
    private int size;

    public IntList(IntList list) {
        this(list.size());
        System.arraycopy(list.a, 0, this.a, 0, list.size());
        this.size = list.size;
    }

    public IntList() {
        this(10);
    }

    public IntList(int size) {
        this.a = new int[size];
        this.size = 0;
    }

    public void add(int value) {
        this.resize();
        this.a[this.size++] = value;
    }

    public void push_back(int value) {
        this.add(value);
    }

    public void addAll(int[] numbers) {
        this.addAll(numbers, numbers.length);
    }

    public void addAll(IntList list) {
        this.addAll(list.a, list.size);
    }

    private void addAll(int[] array, int length) {
        this.resize(this.size + length);
        System.arraycopy(array, 0, this.a, this.size, length);
        this.size += length;
    }

    public void set(int index, int value) {
        this.resize();
        this.a[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public void resize(int s) {
        if (s > this.a.length) {
            int newSize = this.a.length * 3 / 2 + 1;
            if (newSize < s) {
                newSize = s;
            }
            int[] temp = new int[newSize];
            System.arraycopy(this.a, 0, temp, 0, this.size);
            this.a = temp;
        }
    }

    private void resize() {
        if (this.size == this.a.length) {
            this.resize(this.size * 3 / 2 + 1);
        }
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.a[index];
    }

    public int at(int index) {
        return this.get(index);
    }

    public int first() {
        return this.size == 0 ? 0 : this.a[0];
    }

    public int last() {
        return this.size == 0 ? 0 : this.a[this.size - 1];
    }

    public int back() {
        return this.last();
    }

    public int remove(int index) {
        int value = this.get(index);
        if (index != this.size - 1) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - 1 - index);
        }
        --this.size;
        return value;
    }

    public int removeLast() {
        return this.size == 0 ? 0 : this.remove(this.size - 1);
    }

    public void remove(int start, int end) {
        if (start == end) {
            this.remove(start);
        } else if (start <= end) {
            start = start < 0 ? 0 : start;
            end = end > this.size ? this.size : end;
            int[] temp = new int[this.size];
            System.arraycopy(this.a, 0, temp, 0, start);
            System.arraycopy(this.a, end, temp, start, this.size - end);
            this.a = temp;
            this.size -= end - start;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int pop_back() {
        int e = this.get(this.size() - 1);
        this.remove(this.size() - 1);
        return e;
    }

    public int[] toArray() {
        int[] temp = new int[this.size];
        System.arraycopy(this.a, 0, temp, 0, this.size);
        return temp;
    }
}

