/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.DocCommentNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.LiteralBooleanNode;
import macromedia.asc.parser.LiteralNullNode;
import macromedia.asc.parser.LiteralNumberNode;
import macromedia.asc.parser.LiteralStringNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.ParameterNode;
import macromedia.asc.parser.RestParameterNode;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ParameterListNode
extends Node {
    public ObjectList<ParameterNode> items = new ObjectList();
    public ObjectList<TypeInfo> types = new ObjectList(1);
    public ByteList decl_styles = new ByteList(1);
    public int count = -1;

    public ParameterListNode(ParameterListNode list, ParameterNode item, int pos) {
        this.items.add(item);
    }

    public Value evaluate(Context cx, Evaluator evaluator) {
        if (evaluator.checkFeature(cx, this)) {
            return evaluator.evaluate(cx, this);
        }
        return null;
    }

    public int size() {
        if (this.count < 0) {
            this.count = 0;
            Iterator i$ = this.items.iterator();
            while (i$.hasNext()) {
                ParameterNode item = (ParameterNode)i$.next();
                this.count += item.size();
            }
        }
        return this.count;
    }

    public String toString() {
        return "ParameterList";
    }

    public StringBuffer toCanonicalString(Context cx, StringBuffer buf) {
        ParameterNode item;
        buf.append(" param_names='");
        ParameterNode firstItem = (ParameterNode)this.items.get(0);
        Iterator i$ = this.items.iterator();
        while (i$.hasNext()) {
            item = (ParameterNode)i$.next();
            if (item != firstItem) {
                buf.append(";");
            }
            buf.append(item.ref != null ? item.ref.name : "");
        }
        buf.append("'");
        buf.append(" param_types='");
        firstItem = (ParameterNode)this.items.get(0);
        i$ = this.items.iterator();
        while (i$.hasNext()) {
            item = (ParameterNode)i$.next();
            if (item != firstItem) {
                buf.append(";");
            }
            if (item instanceof RestParameterNode) {
                buf.append("restParam");
                continue;
            }
            if (item.typeref == null) continue;
            buf.append(DocCommentNode.getRefName(cx, item.typeref));
        }
        buf.append("'");
        buf.append(" param_defaults='");
        firstItem = (ParameterNode)this.items.get(0);
        i$ = this.items.iterator();
        while (i$.hasNext()) {
            item = (ParameterNode)i$.next();
            if (item != firstItem) {
                buf.append(";");
            }
            if (item.init == null) {
                buf.append("undefined");
                continue;
            }
            if (item.init instanceof LiteralNumberNode) {
                buf.append(((LiteralNumberNode)item.init).value);
                continue;
            }
            if (item.init instanceof LiteralStringNode) {
                buf.append(DocCommentNode.escapeXml(((LiteralStringNode)item.init).value));
                continue;
            }
            if (item.init instanceof LiteralNullNode) {
                buf.append("null");
                continue;
            }
            if (item.init instanceof LiteralBooleanNode) {
                buf.append(((LiteralBooleanNode)item.init).value ? "true" : "false");
                continue;
            }
            buf.append("unknown");
        }
        buf.append("'");
        return buf;
    }
}

