/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.builder.tags;

import flash.fonts.FSType;
import flash.fonts.FontFace;
import flash.fonts.FontManager;
import flash.swf.builder.tags.TagBuilder;
import flash.swf.builder.types.ZoneRecordBuilder;
import flash.swf.tags.DefineFont2;
import flash.swf.tags.DefineFont3;
import flash.swf.tags.DefineFontAlignZones;
import flash.swf.tags.DefineFontName;
import flash.swf.tags.DefineTag;
import flash.swf.tags.ZoneRecord;
import flash.swf.types.GlyphEntry;
import flash.swf.types.KerningRecord;
import flash.swf.types.Rect;
import flash.swf.types.Shape;
import flash.util.IntMap;
import flash.util.Trace;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;

public final class FontBuilder
implements TagBuilder {
    public DefineFont2 tag;
    private boolean flashType;
    private IntMap glyphEntryMap;
    private FontFace defaultFace;
    private double fontHeight;
    private ZoneRecordBuilder zoneRecordBuilder;
    private static final Rect IDENTITY_RECT = new Rect();
    private static boolean useLicenseTag = true;

    private FontBuilder(int code, boolean hasLayout, boolean useFlashType) {
        if (code == 48) {
            this.tag = new DefineFont2();
        } else if (code == 75) {
            this.tag = new DefineFont3();
        } else {
            throw new SWFFontNotSupportedException("Cannot build DefineFont for SWF tag code " + code);
        }
        this.tag.hasLayout = hasLayout;
        this.glyphEntryMap = new IntMap(100);
        this.flashType = useFlashType;
    }

    public FontBuilder(int code, FontFace fontFace, String alias) {
        this(code, true, false);
        this.defaultFace = fontFace;
        this.init(alias);
    }

    public FontBuilder(int code, FontManager manager, String alias, String fontFamily, int style, boolean hasLayout, boolean flashType) {
        this(code, hasLayout, flashType);
        boolean useTwips;
        FontFace fontFace;
        if (manager == null) {
            throw new NoFontManagerException();
        }
        if (Trace.font) {
            Trace.trace("Locating font using FontManager '" + manager.getClass().getName() + "'");
        }
        if ((fontFace = manager.getEntryFromSystem(fontFamily, style, useTwips = code != 10 && code != 48)) == null) {
            this.throwFontNotFound(alias, fontFamily, style, null);
        }
        if (Trace.font) {
            Trace.trace("Initializing font '" + fontFamily + "' as '" + alias + "'");
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    public FontBuilder(int code, FontManager manager, String alias, URL location, int style, boolean hasLayout, boolean flashType) {
        this(code, hasLayout, flashType);
        boolean useTwips;
        FontFace fontFace;
        if (manager == null) {
            throw new NoFontManagerException();
        }
        if (Trace.font) {
            Trace.trace("Locating font using FontManager '" + manager.getClass().getName() + "'");
        }
        if ((fontFace = manager.getEntryFromLocation(location, style, useTwips = code != 10 && code != 48)) == null) {
            this.throwFontNotFound(alias, null, style, location.toString());
        }
        if (Trace.font) {
            Trace.trace("Initializing font at '" + location.toString() + "' as '" + alias + "'");
        }
        this.defaultFace = fontFace;
        this.init(alias);
    }

    private void init(String alias) {
        this.fontHeight = this.defaultFace.getPointSize();
        if (this.tag.code != 10) {
            this.tag.fontName = alias;
            this.tag.bold = this.defaultFace.isBold();
            this.tag.italic = this.defaultFace.isItalic();
            if (this.tag.hasLayout) {
                this.tag.ascent = this.defaultFace.getAscent();
                this.tag.descent = this.defaultFace.getDescent();
                this.tag.leading = this.defaultFace.getLineGap();
                if (Trace.font) {
                    Trace.trace("\tBold: " + this.tag.bold);
                    Trace.trace("\tItalic: " + this.tag.italic);
                    Trace.trace("\tAscent: " + this.tag.ascent);
                    Trace.trace("\tDescent: " + this.tag.descent);
                    Trace.trace("\tLeading: " + this.tag.leading);
                }
            }
        }
        if (this.flashType) {
            GlyphEntry adfGE = this.defaultFace.getGlyphEntry('z');
            if (adfGE == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('Z')) == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('l')) == null) {
                this.flashType = false;
            }
            if ((adfGE = this.defaultFace.getGlyphEntry('L')) == null) {
                this.flashType = false;
            }
        }
        if (this.flashType) {
            this.zoneRecordBuilder = ZoneRecordBuilder.createInstance();
            if (this.zoneRecordBuilder != null) {
                this.zoneRecordBuilder.setFontAlias(alias);
                this.zoneRecordBuilder.setFontBuilder(this);
                this.zoneRecordBuilder.setFontFace(this.defaultFace);
            } else {
                this.flashType = false;
            }
        }
        this.addChar(' ');
    }

    public DefineTag build() {
        int count = this.glyphEntryMap.size();
        if (Trace.font) {
            Trace.trace("Building font '" + this.tag.fontName + "' with " + count + " characters.");
        }
        if (this.flashType && this.tag instanceof DefineFont3) {
            DefineFont3 df3 = (DefineFont3)this.tag;
            df3.zones = new DefineFontAlignZones();
            df3.zones.font = df3;
            df3.zones.zoneTable = new ZoneRecord[count];
            df3.zones.csmTableHint = 1;
        }
        this.tag.glyphShapeTable = new Shape[count];
        if (this.tag.code != 10) {
            this.tag.codeTable = new char[count];
            if (this.tag.hasLayout) {
                this.tag.advanceTable = new short[count];
                this.tag.boundsTable = new Rect[count];
            }
        }
        Iterator it = this.glyphEntryMap.iterator();
        for (int i = 0; it.hasNext() && i < count; ++i) {
            GlyphEntry ge = (GlyphEntry)((Map.Entry)it.next()).getValue();
            if (this.flashType && this.tag instanceof DefineFont3) {
                ((DefineFont3)this.tag).zones.zoneTable[i] = ge.zoneRecord;
            }
            this.tag.glyphShapeTable[i] = ge.shape;
            ge.setIndex(i);
            if (this.tag.code == 10) continue;
            this.tag.codeTable[i] = ge.character;
            if (this.tag.hasLayout) {
                this.tag.advanceTable[i] = (short)ge.advance;
                this.tag.boundsTable[i] = IDENTITY_RECT;
                continue;
            }
            if (!Trace.font) continue;
            Trace.trace("Warning: font tag created without layout information.");
        }
        if (this.tag.hasLayout) {
            this.tag.kerningTable = new KerningRecord[0];
        }
        if (useLicenseTag && (this.getFSType() != null && !this.getFSType().installable || this.getCopyright() != null || this.getName() != null)) {
            this.tag.license = new DefineFontName();
            this.tag.license.font = this.tag;
            this.tag.license.fontName = this.getName();
            this.tag.license.copyright = this.getCopyright();
        }
        return this.tag;
    }

    public void addAllChars() {
        this.addAllChars(this.defaultFace);
    }

    public void addAllChars(FontFace face) {
        int min = face.getFirstChar();
        int count = face.getNumGlyphs();
        if (Trace.font) {
            Trace.trace("\tAdding " + count + " chars, starting from " + min);
        }
        this.addCharset(min, count);
    }

    public void addCharset(int fromChar, int count) {
        this.addCharset(this.defaultFace, fromChar, count);
    }

    public void addCharset(FontFace face, int fromChar, int count) {
        int remaining = count;
        for (int i = fromChar; remaining > 0 && i < 65535; ++i) {
            char c = (char)i;
            GlyphEntry ge = this.addChar(face, c);
            if (ge == null) continue;
            --remaining;
        }
    }

    public void addCharset(char[] chars) {
        this.addCharset(this.defaultFace, chars);
    }

    public void addCharset(FontFace face, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            this.addChar(face, c);
        }
    }

    public void addChar(char c) {
        this.addChar(this.defaultFace, c);
    }

    public GlyphEntry addChar(FontFace face, char c) {
        GlyphEntry ge = (GlyphEntry)this.glyphEntryMap.get(c);
        if (ge == null && (ge = face.getGlyphEntry(c)) != null) {
            this.glyphEntryMap.put(c, ge);
        }
        if (this.flashType && ge != null && ge.zoneRecord == null && this.zoneRecordBuilder != null) {
            ge.zoneRecord = this.zoneRecordBuilder.build(c);
        }
        return ge;
    }

    public String getCopyright() {
        return this.defaultFace.getCopyright();
    }

    public String getName() {
        return this.defaultFace.getFamily();
    }

    public FSType getFSType() {
        return this.defaultFace.getFSType();
    }

    public void setLangcode(int code) {
        if (code >= 0 && code < 6) {
            this.tag.langCode = code;
        }
    }

    public GlyphEntry getGlyph(char c) {
        return (GlyphEntry)this.glyphEntryMap.get(c);
    }

    public double getFontHeight() {
        return this.fontHeight;
    }

    public int size() {
        return this.glyphEntryMap.size();
    }

    private void throwFontNotFound(String alias, String fontFamily, int style, String location) {
        StringBuffer message = new StringBuffer("Font for alias '");
        message.append(alias).append("' ");
        if (style == 1) {
            message.append("with bold weight ");
        } else if (style == 2) {
            message.append("with italic style ");
        } else if (style == 3) {
            message.append("with bold weight and italic style ");
        } else {
            message.append("with plain weight and style ");
        }
        if (location != null) {
            message.append("was not found at: ").append(location.toString());
        } else {
            message.append("was not found by family name '").append(fontFamily).append("'");
        }
        throw new FontNotFoundException(message.toString());
    }

    public static final class SWFFontNotSupportedException
    extends RuntimeException {
        private static final long serialVersionUID = -7381079883711386211L;

        public SWFFontNotSupportedException(String message) {
            super(message);
        }
    }

    public static final class NoFontManagerException
    extends RuntimeException {
        private static final long serialVersionUID = 755054716704678420L;

        public NoFontManagerException() {
            super("No FontManager provided. Cannot build font.");
        }
    }

    public static final class FontNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = -2385779348825570473L;

        public FontNotFoundException(String message) {
            super(message);
        }
    }
}

