/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;
import primitives.StrokeStyle;

public final class PrimitivePolygon
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private int dashStyle;
    private Polygon p;
    static final int N_POINTS = 256;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private Stroke stroke;
    private float w;

    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitivePolygon() {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = new Polygon();
        this.initPrimitive(256);
    }

    public PrimitivePolygon(boolean f, int layer, int dashSt) {
        this.p = new Polygon();
        this.initPrimitive(256);
        this.nPoints = 0;
        this.isFilled = f;
        this.dashStyle = dashSt;
        this.setLayer(layer);
    }

    public void addPoint(int x, int y) {
        if (this.nPoints + 2 >= 256) {
            return;
        }
        this.virtualPoint[this.nPoints].x = x;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = y;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y + 10;
        this.changed = true;
    }

    public final void createPolygon(MapCoordinates coordSys) {
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymax = -2147483647;
        this.p.reset();
        for (int j = 0; j < this.nPoints; ++j) {
            int x = coordSys.mapX(this.virtualPoint[j].x, this.virtualPoint[j].y);
            int y = coordSys.mapY(this.virtualPoint[j].x, this.virtualPoint[j].y);
            this.p.addPoint(x, y);
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y <= ymax) continue;
            ymax = y;
        }
        this.width = xmax - this.xmin;
        this.height = ymax - this.ymin;
    }

    public final void draw(Graphics2D g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.createPolygon(coordSys);
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
            if (strokeStyle == null) {
                strokeStyle = new StrokeStyle();
            }
            this.stroke = strokeStyle.getStroke(this.w, this.dashStyle);
        }
        if (!g.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        if (!this.stroke.equals(g.getStroke())) {
            g.setStroke(this.stroke);
        }
        if (this.isFilled && this.width >= 2 && this.height >= 2) {
            g.fillPolygon(this.p);
        }
        for (int i = 0; i < this.nPoints - 1; ++i) {
            g.drawLine(this.p.xpoints[i], this.p.ypoints[i], this.p.xpoints[i + 1], this.p.ypoints[i + 1]);
        }
        g.drawLine(this.p.xpoints[this.nPoints - 1], this.p.ypoints[this.nPoints - 1], this.p.xpoints[0], this.p.ypoints[0]);
    }

    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("PP") || tokens[0].equals("PV")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on PP/PV");
                throw E;
            }
            int j = 1;
            int i = 0;
            int x1 = 0;
            int y1 = 0;
            while (!(j >= N - 1 || j + 1 < N - 1 && tokens[j + 1].equals("FCJ"))) {
                x1 = this.virtualPoint[i].x = Integer.parseInt(tokens[j++]);
                y1 = this.virtualPoint[i++].y = Integer.parseInt(tokens[j++]);
            }
            this.nPoints = i;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > j) {
                this.parseLayer(tokens[j++]);
                if (j < N - 1 && tokens[j++].equals("FCJ")) {
                    this.dashStyle = Integer.parseInt(tokens[j++]);
                    if (this.dashStyle >= 5) {
                        this.dashStyle = 4;
                    }
                    if (this.dashStyle < 0) {
                        this.dashStyle = 0;
                    }
                }
            }
            this.isFilled = tokens[0].equals("PP");
        } else {
            IOException E = new IOException("PP/PV: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    public Vector getControls() {
        Vector v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = new Boolean(this.isFilled);
        pd.description = Globals.messages.getString("ctrl_filled");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    public int setControls(Vector v) {
        int i = super.setControls(v);
        ParameterDescription pd = (ParameterDescription)v.get(i);
        ++i;
        if (pd.parameter instanceof Boolean) {
            this.isFilled = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int[] xp = new int[256];
        int[] yp = new int[256];
        for (int k = 0; k < this.nPoints; ++k) {
            xp[k] = this.virtualPoint[k].x;
            yp[k] = this.virtualPoint[k].y;
        }
        int distance = (int)Math.sqrt((px - xp[0]) * (px - xp[0]) + (py - yp[0]) * (py - yp[0]));
        if (this.isFilled && GeometricDistances.pointInPolygon(xp, yp, this.nPoints, px, py)) {
            return 1;
        }
        for (int i = 0; i < this.nPoints; ++i) {
            int d;
            int j = i;
            if (j == this.nPoints - 1) {
                j = -1;
            }
            if ((d = GeometricDistances.pointToSegment(xp[i], yp[i], xp[j + 1], yp[j + 1], px, py)) >= distance) continue;
            distance = d;
        }
        return distance;
    }

    public String toString(boolean extensions) {
        String cmd = this.isFilled ? "PP " : "PV ";
        for (int i = 0; i < this.nPoints; ++i) {
            cmd = cmd + this.virtualPoint[i].x + " " + this.virtualPoint[i].y + " ";
        }
        cmd = cmd + this.getLayer() + "\n";
        if (extensions && (this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            cmd = cmd + "FCJ " + this.dashStyle + " " + text + "\n";
        }
        cmd = cmd + this.saveText(false);
        return cmd;
    }

    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        Point2D.Double[] vertices = new Point2D.Double[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            vertices[i] = new Point2D.Double();
            vertices[i].x = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y);
            vertices[i].y = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        exp.exportPolygon(vertices, this.nPoints, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
    }

    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

