/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.ArrowInfo;
import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Vector;
import primitives.Arrow;
import primitives.Cubic;
import primitives.GraphicPrimitive;
import primitives.StrokeStyle;

public final class PrimitiveComplexCurve
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private boolean isClosed;
    private boolean arrowStart;
    private boolean arrowEnd;
    private int arrowLength;
    private int arrowHalfWidth;
    private int arrowStyle;
    private int dashStyle;
    private Polygon p;
    private Polygon q;
    static final int N_POINTS = 100;
    static final int STEPS = 24;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private Stroke stroke;
    private float w;

    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitiveComplexCurve() {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = new Polygon();
        this.initPrimitive(100);
    }

    public PrimitiveComplexCurve(boolean f, boolean c, int layer, boolean arrowS, boolean arrowE, int arrowSt, int arrowLe, int arrowWi, int dashSt) {
        this.arrowLength = arrowLe;
        this.arrowHalfWidth = arrowWi;
        this.arrowStart = arrowS;
        this.arrowEnd = arrowE;
        this.arrowStyle = arrowSt;
        this.dashStyle = dashSt;
        this.p = new Polygon();
        this.initPrimitive(100);
        this.nPoints = 0;
        this.isFilled = f;
        this.isClosed = c;
        this.dashStyle = dashSt;
        this.setLayer(layer);
    }

    public void addPoint(int x, int y) {
        if (this.nPoints + 2 >= 100) {
            return;
        }
        this.virtualPoint[this.nPoints].x = x;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = y;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y + 10;
        this.changed = true;
    }

    public final Polygon createComplexCurve(MapCoordinates coordSys) {
        Cubic[] Y;
        Cubic[] X;
        int i;
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymax = -2147483647;
        int np = this.nPoints;
        double[] xPoints = new double[np];
        double[] yPoints = new double[np];
        for (i = 0; i < this.nPoints; ++i) {
            xPoints[i] = coordSys.mapXr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            yPoints[i] = coordSys.mapYr(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        if (this.isClosed) {
            X = this.calcNaturalCubicClosed(np - 1, xPoints);
            Y = this.calcNaturalCubicClosed(np - 1, yPoints);
        } else {
            X = this.calcNaturalCubic(np - 1, xPoints);
            Y = this.calcNaturalCubic(np - 1, yPoints);
        }
        if (X == null || Y == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint((int)Math.round(X[0].eval(0.0)), (int)Math.round(Y[0].eval(0.0)));
        for (i = 0; i < X.length; ++i) {
            for (int j = 1; j <= 24; ++j) {
                double u = (double)j / 24.0;
                int x = (int)Math.round(X[i].eval(u));
                int y = (int)Math.round(Y[i].eval(u));
                poly.addPoint(x, y);
                coordSys.trackPoint(x, y);
                if (x < this.xmin) {
                    this.xmin = x;
                }
                if (x > xmax) {
                    xmax = x;
                }
                if (y < this.ymin) {
                    this.ymin = y;
                }
                if (y <= ymax) continue;
                ymax = y;
            }
        }
        this.width = xmax - this.xmin;
        this.height = ymax - this.ymin;
        return poly;
    }

    Cubic[] calcNaturalCubic(int n, double[] x) {
        int i;
        if (n < 1) {
            return null;
        }
        double[] gamma = new double[n + 1];
        double[] delta = new double[n + 1];
        double[] D = new double[n + 1];
        gamma[0] = 0.5;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0 / (4.0 - gamma[i - 1]);
        }
        gamma[n] = 1.0 / (2.0 - gamma[n - 1]);
        delta[0] = 3.0 * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0 * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0 * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Cubic[] C = new Cubic[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Cubic(x[i], D[i], 3.0 * (x[i + 1] - x[i]) - 2.0 * D[i] - D[i + 1], 2.0 * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }

    Cubic[] calcNaturalCubicClosed(int n, double[] x) {
        int k;
        if (n < 1) {
            return null;
        }
        double[] w = new double[n + 1];
        double[] v = new double[n + 1];
        double[] y = new double[n + 1];
        double[] D = new double[n + 1];
        double z = 0.25;
        v[1] = 0.25;
        w[1] = 0.25;
        y[0] = z * 3.0 * (x[1] - x[n]);
        double H = 4.0;
        double F = 3.0 * (x[0] - x[n - 1]);
        double G = 1.0;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0 / (4.0 - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * (3.0 * (x[k + 1] - x[k - 1]) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        Cubic[] C = new Cubic[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new Cubic((float)x[k], D[k], 3.0 * (x[k + 1] - x[k]) - 2.0 * D[k] - D[k + 1], 2.0 * (x[k] - x[k + 1]) + D[k] + D[k + 1]);
        }
        C[n] = new Cubic((float)x[n], D[n], 3.0 * (x[0] - x[n]) - 2.0 * D[n] - D[0], 2.0 * (x[n] - x[0]) + D[n] + D[0]);
        return C;
    }

    public final void draw(Graphics2D g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.q = this.createComplexCurve(new MapCoordinates());
            this.p = this.createComplexCurve(coordSys);
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
            if (strokeStyle == null) {
                strokeStyle = new StrokeStyle();
            }
            this.stroke = strokeStyle.getStroke(this.w, this.dashStyle);
        }
        if (this.p == null) {
            return;
        }
        if (!g.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        if (!this.stroke.equals(g.getStroke())) {
            g.setStroke(this.stroke);
        }
        if (this.isFilled) {
            g.fillPolygon(this.p);
        }
        for (int i = 0; i < this.p.npoints - 1; ++i) {
            g.drawLine(this.p.xpoints[i], this.p.ypoints[i], this.p.xpoints[i + 1], this.p.ypoints[i + 1]);
        }
        if (this.isClosed) {
            g.drawLine(this.p.xpoints[this.p.npoints - 1], this.p.ypoints[this.p.npoints - 1], this.p.xpoints[0], this.p.ypoints[0]);
        }
        if (this.p.npoints < 2) {
            return;
        }
        if (this.arrowStart || this.arrowEnd) {
            int h = coordSys.mapXi(this.arrowHalfWidth, this.arrowHalfWidth, false) - coordSys.mapXi(0.0, 0.0, false);
            int l = coordSys.mapXi(this.arrowLength, this.arrowLength, false) - coordSys.mapXi(0.0, 0.0, false);
            if (this.arrowStart && !this.isClosed) {
                Arrow.drawArrow(g, this.p.xpoints[0], this.p.ypoints[0], this.p.xpoints[1], this.p.ypoints[1], l, h, this.arrowStyle);
            }
            if (this.arrowEnd && !this.isClosed) {
                Arrow.drawArrow(g, this.p.xpoints[this.p.npoints - 1], this.p.ypoints[this.p.npoints - 1], this.p.xpoints[this.p.npoints - 2], this.p.ypoints[this.p.npoints - 2], l, h, this.arrowStyle);
            }
        }
    }

    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("CP") || tokens[0].equals("CV")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on CP/CV");
                throw E;
            }
            int j = 1;
            int i = 0;
            int x1 = 0;
            int y1 = 0;
            this.isClosed = tokens[j++].equals("1");
            while (!(j >= N - 1 || j + 1 < N - 1 && tokens[j + 1].equals("FCJ"))) {
                x1 = this.virtualPoint[i].x = Integer.parseInt(tokens[j++]);
                y1 = this.virtualPoint[i++].y = Integer.parseInt(tokens[j++]);
            }
            this.nPoints = i;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > j) {
                this.parseLayer(tokens[j++]);
                if (N > j && tokens[j++].equals("FCJ")) {
                    int arrows;
                    this.arrowStart = ((arrows = Integer.parseInt(tokens[j++])) & 1) != 0;
                    this.arrowEnd = (arrows & 2) != 0;
                    this.arrowStyle = Integer.parseInt(tokens[j++]);
                    this.arrowLength = Integer.parseInt(tokens[j++]);
                    this.arrowHalfWidth = Integer.parseInt(tokens[j++]);
                    this.dashStyle = Integer.parseInt(tokens[j++]);
                    if (this.dashStyle >= 5) {
                        this.dashStyle = 4;
                    }
                    if (this.dashStyle < 0) {
                        this.dashStyle = 0;
                    }
                }
            }
            this.isFilled = tokens[0].equals("CP");
        } else {
            IOException E = new IOException("CP/CV: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    public Vector getControls() {
        Vector v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = new Boolean(this.isFilled);
        pd.description = Globals.messages.getString("ctrl_filled");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean(this.isClosed);
        pd.description = Globals.messages.getString("ctrl_closed_curve");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean(this.arrowStart);
        pd.description = Globals.messages.getString("ctrl_arrow_start");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Boolean(this.arrowEnd);
        pd.description = Globals.messages.getString("ctrl_arrow_end");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.arrowLength);
        pd.description = Globals.messages.getString("ctrl_arrow_length");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new Integer(this.arrowHalfWidth);
        pd.description = Globals.messages.getString("ctrl_arrow_half_width");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new ArrowInfo(this.arrowStyle);
        pd.description = Globals.messages.getString("ctrl_arrow_style");
        pd.isExtension = true;
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    public int setControls(Vector v) {
        int i = super.setControls(v);
        ParameterDescription pd = (ParameterDescription)v.get(i);
        ++i;
        if (pd.parameter instanceof Boolean) {
            this.isFilled = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.isClosed = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowStart = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 1!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.arrowEnd = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 2!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowLength = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 3!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof Integer) {
            this.arrowHalfWidth = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter 4!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof ArrowInfo) {
            this.arrowStyle = ((ArrowInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 5!" + pd);
        }
        pd = (ParameterDescription)v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter 6!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int distance = 100;
        if (this.p == null) {
            return GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, px, py);
        }
        if (this.isFilled && this.q.contains(px, py)) {
            return 1;
        }
        for (int i = 0; i < this.q.npoints - 1; ++i) {
            int d = GeometricDistances.pointToSegment(this.q.xpoints[i], this.q.ypoints[i], this.q.xpoints[i + 1], this.q.ypoints[i + 1], px, py);
            if (d >= distance) continue;
            distance = d;
        }
        return distance;
    }

    public String toString(boolean extensions) {
        int arrows;
        String cmd = this.isFilled ? "CP " : "CV ";
        cmd = this.isClosed ? cmd + "1 " : cmd + "0 ";
        for (int i = 0; i < this.nPoints; ++i) {
            cmd = cmd + this.virtualPoint[i].x + " " + this.virtualPoint[i].y + " ";
        }
        cmd = cmd + this.getLayer() + "\n";
        if (extensions && ((arrows = (this.arrowStart ? 1 : 0) | (this.arrowEnd ? 2 : 0)) > 0 || this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            cmd = cmd + "FCJ " + arrows + " " + this.arrowStyle + " " + this.arrowLength + " " + this.arrowHalfWidth + " " + this.dashStyle + " " + text + "\n";
        }
        cmd = cmd + this.saveText(false);
        return cmd;
    }

    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        double[] xPoints = new double[this.nPoints];
        double[] yPoints = new double[this.nPoints];
        Point2D.Double[] vertices = new Point2D.Double[this.nPoints * 24 + 1];
        for (int i = 0; i < this.nPoints; ++i) {
            xPoints[i] = cs.mapXr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            yPoints[i] = cs.mapYr(this.virtualPoint[i].x, this.virtualPoint[i].y);
            vertices[i] = new Point2D.Double();
            vertices[i].x = xPoints[i];
            vertices[i].y = yPoints[i];
        }
        if (!exp.exportCurve(vertices, this.nPoints, this.isFilled, this.isClosed, this.getLayer(), this.arrowStart, this.arrowEnd, this.arrowStyle, (int)((double)this.arrowLength * cs.getXMagnitude()), (int)((double)this.arrowHalfWidth * cs.getXMagnitude()), this.dashStyle, Globals.lineWidth * cs.getXMagnitude())) {
            this.exportAsPolygon(xPoints, yPoints, vertices, exp, cs);
            if (this.q.npoints > 2) {
                if (this.arrowStart && !this.isClosed) {
                    exp.exportArrow(vertices[0].x, vertices[0].y, vertices[1].x, vertices[1].y, (double)this.arrowLength * cs.getXMagnitude(), (double)this.arrowHalfWidth * cs.getXMagnitude(), this.arrowStyle);
                }
                if (this.arrowEnd && !this.isClosed) {
                    exp.exportArrow(vertices[this.q.npoints - 1].x, vertices[this.q.npoints - 1].y, vertices[this.q.npoints - 2].x, vertices[this.q.npoints - 2].y, (double)this.arrowLength * cs.getXMagnitude(), (double)this.arrowHalfWidth * cs.getXMagnitude(), this.arrowStyle);
                }
            }
        }
        this.exportText(exp, cs, -1);
    }

    private void exportAsPolygon(double[] xPoints, double[] yPoints, Point2D.Double[] vertices, ExportInterface exp, MapCoordinates cs) throws IOException {
        int i;
        Cubic[] Y;
        Cubic[] X;
        if (this.isClosed) {
            X = this.calcNaturalCubicClosed(this.nPoints - 1, xPoints);
            Y = this.calcNaturalCubicClosed(this.nPoints - 1, yPoints);
        } else {
            X = this.calcNaturalCubic(this.nPoints - 1, xPoints);
            Y = this.calcNaturalCubic(this.nPoints - 1, yPoints);
        }
        if (X == null || Y == null) {
            return;
        }
        vertices[0] = new Point2D.Double();
        vertices[0].x = X[0].eval(0.0);
        vertices[0].y = Y[0].eval(0.0);
        for (i = 0; i < X.length; ++i) {
            for (int j = 1; j <= 24; ++j) {
                double u = (double)j / 24.0;
                vertices[i * 24 + j] = new Point2D.Double();
                vertices[i * 24 + j].x = X[i].eval(u);
                vertices[i * 24 + j].y = Y[i].eval(u);
            }
        }
        if (this.isClosed) {
            exp.exportPolygon(vertices, this.q.npoints, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
        } else {
            for (i = 1; i < this.q.npoints; ++i) {
                exp.exportLine(vertices[i - 1].x, vertices[i - 1].y, vertices[i].x, vertices[i].y, this.getLayer(), false, false, 0, 0, 0, this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
            }
        }
    }

    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

