/*
 * Decompiled with CFR 0.152.
 */
import globals.Globals;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

class OpenFile
implements Runnable {
    private FidoFrame parent;

    OpenFile() {
    }

    public void setParam(FidoFrame tparent) {
        this.parent = tparent;
    }

    public void run() {
        String din;
        String fin;
        if (Globals.useNativeFileDialogs) {
            FileDialog fd = new FileDialog((Frame)this.parent, Globals.messages.getString("Open"));
            fd.setDirectory(this.parent.openFileDirectory);
            fd.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".fcd");
                }
            });
            fd.setVisible(true);
            fin = fd.getFile();
            din = fd.getDirectory();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.parent.openFileDirectory));
            fc.setDialogTitle(Globals.messages.getString("Open"));
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".fcd") || f.isDirectory();
                }

                public String getDescription() {
                    return "FidoCadJ (.fcd)";
                }
            });
            if (fc.showOpenDialog(this.parent) != 0) {
                return;
            }
            fin = fc.getSelectedFile().getName();
            din = fc.getSelectedFile().getParentFile().getPath();
        }
        if (fin != null) {
            try {
                FidoFrame popFrame;
                if (this.parent.CC.P.getModified() || !this.parent.CC.P.isEmpty()) {
                    popFrame = new FidoFrame(FidoFrame.runsAsApplication);
                    popFrame.init();
                    popFrame.setBounds(this.parent.getX() + 20, this.parent.getY() + 20, popFrame.getWidth(), popFrame.getHeight());
                    popFrame.loadLibraries();
                    popFrame.setVisible(true);
                } else {
                    popFrame = this.parent;
                }
                popFrame.CC.P.openFileName = Globals.createCompleteFileName(din, fin);
                if (FidoFrame.runsAsApplication) {
                    this.parent.prefs.put("OPEN_DIR", din);
                }
                popFrame.openFileDirectory = din;
                popFrame.openFile();
                popFrame.CC.P.saveUndoState();
                popFrame.CC.P.setModified(false);
                System.gc();
            }
            catch (IOException fnfex) {
                JOptionPane.showMessageDialog(this.parent, Globals.messages.getString("Open_error") + fnfex);
            }
        }
    }
}

