/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.helpers.LogLog;

public class NDC {
    static Hashtable ht = new Hashtable();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    public static void clear() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static Stack cloneStack() {
        Object v = ht.get(Thread.currentThread());
        if (v == null) {
            return null;
        }
        Stack stack = (Stack)v;
        return (Stack)stack.clone();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            ht.put(Thread.currentThread(), stack);
        }
    }

    public static String get() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    private static void lazyRemove() {
        Thread thread;
        Vector<Thread> vector;
        int n;
        Hashtable hashtable = ht;
        synchronized (hashtable) {
            if (++pushCounter >= 5) {
                Object var2_1 = null;
                return;
            }
            pushCounter = 0;
            n = 0;
            vector = new Vector<Thread>();
            Enumeration enumeration = ht.keys();
            while (enumeration.hasMoreElements() && n <= 4) {
                thread = (Thread)enumeration.nextElement();
                if (thread.isAlive()) {
                    ++n;
                    continue;
                }
                n = 0;
                vector.addElement(thread);
            }
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            thread = (Thread)vector.elementAt(n2);
            LogLog.debug("Lazy NDC removal for thread [" + thread.getName() + "] (" + ht.size() + ").");
            ht.remove(thread);
            ++n2;
        }
    }

    public static String pop() {
        Thread thread = Thread.currentThread();
        Stack stack = (Stack)ht.get(thread);
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static void push(String string) {
        Thread thread = Thread.currentThread();
        Stack<DiagnosticContext> stack = (Stack<DiagnosticContext>)ht.get(thread);
        if (stack == null) {
            DiagnosticContext diagnosticContext = new DiagnosticContext(string, null);
            stack = new Stack<DiagnosticContext>();
            ht.put(thread, stack);
            stack.push(diagnosticContext);
        } else if (stack.isEmpty()) {
            DiagnosticContext diagnosticContext = new DiagnosticContext(string, null);
            stack.push(diagnosticContext);
        } else {
            DiagnosticContext diagnosticContext = (DiagnosticContext)stack.peek();
            stack.push(new DiagnosticContext(string, diagnosticContext));
        }
    }

    public static void remove() {
        ht.remove(Thread.currentThread());
        NDC.lazyRemove();
    }

    public static void setMaxDepth(int n) {
        Stack stack = (Stack)ht.get(Thread.currentThread());
        if (stack != null && n < stack.size()) {
            stack.setSize(n);
        }
    }

    private NDC() {
    }

    private static class DiagnosticContext {
        String fullMessage;
        String message;

        DiagnosticContext(String string, DiagnosticContext diagnosticContext) {
            this.message = string;
            this.fullMessage = diagnosticContext != null ? diagnosticContext.fullMessage + " " + string : string;
        }
    }
}

